/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.format.NormalizeLineBreaks;
import org.openrewrite.java.format.NormalizeLineBreaksTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/format/NormalizeLineBreaksTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "doNotChangeLinuxJavadoc", "", "jp", "Lorg/openrewrite/java/JavaParser;", "doNotChangeWindowsJavadoc", "linuxToWindows", "linuxToWindowsJavadoc", "preservesExistingLinuxEndingsByDefault", "preservesExistingWindowsEndingsByDefault", "trimKeepCRLF", "windowsToLinux", "windowsToLinuxJavadoc", "Companion", "rewrite-java-tck"})
public interface NormalizeLineBreaksTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.format.NormalizeLineBreaksTest$Companion.$$INSTANCE;
    @NotNull
    public static final String windows = "class Test {\r\n    // some comment\r\n    public void test() {\r\n        System.out.println();\r\n    }\r\n}";
    @NotNull
    public static final String linux = "class Test {\n    // some comment\n    public void test() {\n        System.out.println();\n    }\n}";
    @NotNull
    public static final String windowsJavadoc = "/**\r\n *\r\n */\r\nclass Test {\r\n}";
    @NotNull
    public static final String linuxJavadoc = "/**\n *\n */\nclass Test {\n}";

    @Test
    public void trimKeepCRLF();

    @Test
    public void windowsToLinux(@NotNull JavaParser var1);

    @Test
    public void linuxToWindows(@NotNull JavaParser var1);

    @Test
    public void doNotChangeWindowsJavadoc(@NotNull JavaParser var1);

    @Test
    public void doNotChangeLinuxJavadoc(@NotNull JavaParser var1);

    @Test
    public void windowsToLinuxJavadoc(@NotNull JavaParser var1);

    @Test
    public void linuxToWindowsJavadoc(@NotNull JavaParser var1);

    @Test
    public void preservesExistingWindowsEndingsByDefault(@NotNull JavaParser var1);

    @Test
    public void preservesExistingLinuxEndingsByDefault(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/format/NormalizeLineBreaksTest$Companion;", "", "()V", "linux", "", "linuxJavadoc", "windows", "windowsJavadoc", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String windows = "class Test {\r\n    // some comment\r\n    public void test() {\r\n        System.out.println();\r\n    }\r\n}";
        @NotNull
        public static final String linux = "class Test {\n    // some comment\n    public void test() {\n        System.out.println();\n    }\n}";
        @NotNull
        public static final String windowsJavadoc = "/**\r\n *\r\n */\r\nclass Test {\r\n}";
        @NotNull
        public static final String linuxJavadoc = "/**\n *\n */\nclass Test {\n}";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void trimKeepCRLF(@NotNull NormalizeLineBreaksTest $this) {
            Assertions.assertThat((String)StringsKt.replace$default((String)StringsKt.trimIndent((String)StringsKt.replace$default((String)"\n  test\r\n  test", (char)'\r', (char)'\u23ce', (boolean)false, (int)4, null)), (char)'\u23ce', (char)'\r', (boolean)false, (int)4, null)).isEqualTo("test\r\ntest");
        }

        @Test
        public static void windowsToLinux(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, $this.toRecipe(windowsToLinux.1.INSTANCE), null, NormalizeLineBreaksTest.windows, null, NormalizeLineBreaksTest.linux, 0, 0, null, null, 981, null);
        }

        @Test
        public static void linuxToWindows(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, $this.toRecipe(linuxToWindows.1.INSTANCE), null, NormalizeLineBreaksTest.linux, null, NormalizeLineBreaksTest.windows, 0, 0, null, null, 981, null);
        }

        @Test
        public static void doNotChangeWindowsJavadoc(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, $this.toRecipe(doNotChangeWindowsJavadoc.1.INSTANCE), null, NormalizeLineBreaksTest.windowsJavadoc, null, 21, null);
        }

        @Test
        public static void doNotChangeLinuxJavadoc(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, $this.toRecipe(doNotChangeLinuxJavadoc.1.INSTANCE), null, NormalizeLineBreaksTest.linuxJavadoc, null, 21, null);
        }

        @Test
        public static void windowsToLinuxJavadoc(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, $this.toRecipe(windowsToLinuxJavadoc.1.INSTANCE), null, NormalizeLineBreaksTest.windowsJavadoc, null, NormalizeLineBreaksTest.linuxJavadoc, 0, 0, null, null, 981, null);
        }

        @Test
        public static void linuxToWindowsJavadoc(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, $this.toRecipe(linuxToWindowsJavadoc.1.INSTANCE), null, NormalizeLineBreaksTest.linuxJavadoc, null, NormalizeLineBreaksTest.windowsJavadoc, 0, 0, null, null, 981, null);
        }

        @Test
        public static void preservesExistingWindowsEndingsByDefault(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, (Recipe)new NormalizeLineBreaks(), null, NormalizeLineBreaksTest.windows, null, 21, null);
        }

        @Test
        public static void preservesExistingLinuxEndingsByDefault(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, (Recipe)new NormalizeLineBreaks(), null, NormalizeLineBreaksTest.linux, null, 21, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NormalizeLineBreaksTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NormalizeLineBreaksTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NormalizeLineBreaksTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull NormalizeLineBreaksTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NormalizeLineBreaksTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull NormalizeLineBreaksTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull NormalizeLineBreaksTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NormalizeLineBreaksTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull NormalizeLineBreaksTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NormalizeLineBreaksTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull NormalizeLineBreaksTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NormalizeLineBreaksTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

