/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.format.NormalizeTabsOrSpaces;
import org.openrewrite.java.format.NormalizeTabsOrSpacesTest;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0018\u0010\f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u0018\u0010\u000e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0019\b\u0002\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\b\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/format/NormalizeTabsOrSpacesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "doNotReplaceSpacesBeforeAsterisks", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "mixedToSpaces", "Lorg/openrewrite/java/JavaParser;", "mixedToTabs", "normalizeJavaDocSuffix", "normalizeLastWhitespace", "tabsAndIndents", "", "Lorg/openrewrite/style/NamedStyles;", "with", "Lkotlin/Function1;", "Lorg/openrewrite/java/style/TabsAndIndentsStyle;", "Lkotlin/ExtensionFunctionType;", "tabsReplacedWithSpaces", "rewrite-java-tck"})
public interface NormalizeTabsOrSpacesTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @NotNull
    public List<NamedStyles> tabsAndIndents(@NotNull Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle> var1);

    @Test
    public void mixedToTabs(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void mixedToSpaces(@NotNull JavaParser var1);

    @Test
    public void tabsReplacedWithSpaces(@NotNull JavaParser var1);

    @Test
    public void doNotReplaceSpacesBeforeAsterisks(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void normalizeJavaDocSuffix(@NotNull JavaParser var1);

    @Test
    public void normalizeLastWhitespace(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull NormalizeTabsOrSpacesTest $this) {
            return (Recipe)new NormalizeTabsOrSpaces();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<NamedStyles> tabsAndIndents(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle> with) {
            void $this$tabsAndIndents_u24lambda_u240;
            Intrinsics.checkNotNullParameter(with, (String)"with");
            TabsAndIndentsStyle tabsAndIndentsStyle = IntelliJ.tabsAndIndents();
            Set set = SetsKt.emptySet();
            String string = "test";
            String string2 = "test";
            String string3 = "test";
            UUID uUID = Tree.randomId();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$tabsAndIndents_u24lambda_u240, (String)"this");
            TabsAndIndentsStyle tabsAndIndentsStyle2 = (TabsAndIndentsStyle)with.invoke((Object)$this$tabsAndIndents_u24lambda_u240);
            Collection collection = CollectionsKt.listOf((Object)tabsAndIndentsStyle2);
            Set set2 = set;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            UUID uUID2 = uUID;
            return CollectionsKt.listOf((Object)new NamedStyles(uUID2, string6, string5, string4, set2, collection));
        }

        public static /* synthetic */ List tabsAndIndents$default(NormalizeTabsOrSpacesTest normalizeTabsOrSpacesTest, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tabsAndIndents");
            }
            if ((n & 1) != 0) {
                function1 = tabsAndIndents.1.INSTANCE;
            }
            return normalizeTabsOrSpacesTest.tabsAndIndents((Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle>)function1);
        }

        @Test
        public static void mixedToTabs(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.tabsAndIndents((Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle>)((Function1)mixedToTabs.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(tabsAndIndents\u2026haracter(true) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n            \tpublic void test() {\n                    int n = 1;\n            \t}\n            }\n        ", null, "\n            public class Test {\n            \tpublic void test() {\n            \t\tint n = 1;\n            \t}\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void mixedToSpaces(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class Test {\n                public void test() {\n                \tint n = 1;\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test() {\n                    int n = 1;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void tabsReplacedWithSpaces(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class Test {\n            \tint a;\n             \tint b;\n              \tint c;\n               \tint d;\n            \n                /*\n            \t *\n             \t *\n              \t *\n               \t *\n                 */\n            \t\n             \t\n              \t\n               \t\n                /**\n            \t *\n             \t *\n              \t *\n               \t *\n                 */\n                void test() {\n                }\n            }\n        ", null, "\n            public class Test {\n                int a;\n                int b;\n                int c;\n                int d;\n            \n                /*\n                 *\n                 *\n                 *\n                 *\n                 */\n                \n                \n                \n                \n                /**\n                 *\n                 *\n                 *\n                 *\n                 */\n                void test() {\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void doNotReplaceSpacesBeforeAsterisks(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.tabsAndIndents((Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle>)((Function1)doNotReplaceSpacesBeforeAsterisks.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(tabsAndIndents\u2026haracter(true) }).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, null, "\n            /**\n             * \n             */\n            public class Test {\n            \t/*\n            \t * Preserve `*`'s on\n            \t * each new line.\n            \t */\n            \tpublic class Inner {\n            \t}\n            }\n        ", null, 22, null);
        }

        @Test
        public static void normalizeJavaDocSuffix(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class Test {\n            \t/** Test\n            \t */\n            \tpublic class Inner {\n            \t}\n            }\n        ", null, "\n            public class Test {\n                /** Test\n                 */\n                public class Inner {\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void normalizeLastWhitespace(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.tabsAndIndents((Function1<? super TabsAndIndentsStyle, TabsAndIndentsStyle>)((Function1)normalizeLastWhitespace.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(tabsAndIndents\u2026haracter(true) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n            \tpublic void test() {\n            \t\tint n = 1;\n             }\n            }\n        ", null, "\n            public class Test {\n            \tpublic void test() {\n            \t\tint n = 1;\n            \t}\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NormalizeTabsOrSpacesTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NormalizeTabsOrSpacesTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NormalizeTabsOrSpacesTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull NormalizeTabsOrSpacesTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NormalizeTabsOrSpacesTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

