/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.DefaultComesLast;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u000f\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/DefaultComesLastTest;", "Lorg/openrewrite/test/RewriteTest;", "allCasesGroupedWithDefault", "", "jp", "Lorg/openrewrite/java/JavaParser;", "defaultIsLastAndReturnsNonVoid", "defaultIsLastAndThrows", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "dontAddBreaksIfCasesArentMoving", "dontRemoveExtraneousDefaultCaseBreaks", "moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary", "moveDefaultToLastWhenSharedWithAnotherCaseStatement", "skipIfLastAndSharedWithCase", "Lorg/openrewrite/java/JavaParser$Builder;", "rewrite-java-tck"})
public interface DefaultComesLastTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary(@NotNull JavaParser var1);

    @Test
    public void moveDefaultToLastWhenSharedWithAnotherCaseStatement(@NotNull JavaParser var1);

    @Test
    public void skipIfLastAndSharedWithCase(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void defaultIsLastAndThrows(@NotNull JavaParser var1);

    @Test
    public void defaultIsLastAndReturnsNonVoid(@NotNull JavaParser var1);

    @Test
    public void dontAddBreaksIfCasesArentMoving(@NotNull JavaParser var1);

    @Test
    public void dontRemoveExtraneousDefaultCaseBreaks(@NotNull JavaParser var1);

    @Test
    public void allCasesGroupedWithDefault(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull DefaultComesLastTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new DefaultComesLast());
        }

        @Test
        public static void moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        default:\n                            System.out.println(\"default\");\n                            break;\n                        case 3:\n                            System.out.println(\"case3\");\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 3:\n                            System.out.println(\"case3\");\n                            break;\n                        default:\n                            System.out.println(\"default\");\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void moveDefaultToLastWhenSharedWithAnotherCaseStatement(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 3:\n                        default:\n                            break;\n                        case 4:\n                        case 5:\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 4:\n                        case 5:\n                            break;\n                        case 3:\n                        default:\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void skipIfLastAndSharedWithCase(@NotNull DefaultComesLastTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                        default:\n                            break;\n                        case 3:\n                            break;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.skipIfLastAndSharedWithCase$lambda$0(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void defaultIsLastAndThrows(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        default:\n                            throw new RuntimeException(\"unexpected value\");\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void defaultIsLastAndReturnsNonVoid(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public int foo(int n) {\n                    switch (n) {\n                        case 1:\n                            return 1;\n                        default:\n                            return 2;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void dontAddBreaksIfCasesArentMoving(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                boolean foo() {\n                    switch (n) {\n                        case 1:\n                        case 2:\n                            System.out.println(\"side effect\");\n                        default:\n                            return true;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void dontRemoveExtraneousDefaultCaseBreaks(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                void foo() {\n                    switch (n) {\n                        default:\n                            break;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void allCasesGroupedWithDefault(@NotNull DefaultComesLastTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                boolean foo() {\n                    switch (n) {\n                        case 1:\n                        case 2:\n                        default:\n                            return true;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static void skipIfLastAndSharedWithCase$lambda$0(JavaParser.Builder $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser.Builder)$jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new DefaultComesLastStyle(Boolean.valueOf(true)))))));
        }
    }
}

