/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/TypeTreeTest;", "", "buildFullyQualifiedClassName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "buildFullyQualifiedClassNameWithSpacing", "buildFullyQualifiedInnerClassName", "buildStaticImport", "rewrite-java-tck"})
public interface TypeTreeTest {
    @Test
    public void buildFullyQualifiedClassName(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedClassNameWithSpacing(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedInnerClassName(@NotNull JavaParser var1);

    @Test
    public void buildStaticImport(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void buildFullyQualifiedClassName(@NotNull TypeTreeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TypeTree.build((String)"java.util.List");
            Intrinsics.checkNotNull((Object)typeTree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"java.util.List", (Object)name.toString());
            Assertions.assertEquals((Object)"List", (Object)name.getSimpleName());
        }

        @Test
        public static void buildFullyQualifiedClassNameWithSpacing(@NotNull TypeTreeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TypeTree.build((String)"java . util . List");
            Intrinsics.checkNotNull((Object)typeTree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"java . util . List", (Object)name.toString());
        }

        @Test
        public static void buildFullyQualifiedInnerClassName(@NotNull TypeTreeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TypeTree.build((String)"a.Outer.Inner");
            Intrinsics.checkNotNull((Object)typeTree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"a.Outer.Inner", (Object)name.toString());
            Assertions.assertEquals((Object)"Inner", (Object)name.getSimpleName());
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(name.getType());
            Assertions.assertEquals((Object)"a.Outer.Inner", (Object)(fullyQualified != null ? fullyQualified.getFullyQualifiedName() : null));
            Expression expression = name.getTarget();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            J.FieldAccess outer = (J.FieldAccess)expression;
            Assertions.assertEquals((Object)"Outer", (Object)outer.getSimpleName());
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified(outer.getType());
            Assertions.assertEquals((Object)"a.Outer", (Object)(fullyQualified2 != null ? fullyQualified2.getFullyQualifiedName() : null));
        }

        @Test
        public static void buildStaticImport(@NotNull TypeTreeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TypeTree.build((String)"a.A.*");
            Intrinsics.checkNotNull((Object)typeTree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"a.A.*", (Object)name.toString());
            Assertions.assertEquals((Object)"*", (Object)name.getSimpleName());
        }
    }
}

