/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/search/UsesTypeTest;", "Lorg/openrewrite/test/RewriteTest;", "emptyConstructor", "", "primitiveTypes", "usesFullyQualifiedReference", "usesTypeFindsImports", "usesTypeFindsInheritedTypes", "usesTypeWildcardFindsImports", "rewrite-java-tck"})
public interface UsesTypeTest
extends RewriteTest {
    @Test
    public void primitiveTypes();

    @Test
    public void emptyConstructor();

    @Test
    public void usesTypeFindsImports();

    @Test
    public void usesTypeWildcardFindsImports();

    @Test
    public void usesFullyQualifiedReference();

    @Test
    public void usesTypeFindsInheritedTypes();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void primitiveTypes(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                double d = 1d;\n            }\n            ", (String)"\n            /*~~>*/class Test {\n                double d = 1d;\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::primitiveTypes$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void emptyConstructor(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                List<String> l = new ArrayList<>();\n            }\n        ", (String)"\n            /*~~>*/import java.util.ArrayList;\n            import java.util.List;\n            \n            class Test {\n                List<String> l = new ArrayList<>();\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::emptyConstructor$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void usesTypeFindsImports(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            import java.util.Collections;\n            \n            class Test {\n            }\n        ", (String)"\n            /*~~>*/import java.io.File;\n            import java.util.Collections;\n            \n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::usesTypeFindsImports$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void usesTypeWildcardFindsImports(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            import static java.util.Collections.singleton;\n            \n            class Test {\n            }\n        ", (String)"\n            /*~~>*/import java.io.File;\n            import static java.util.Collections.singleton;\n            \n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::usesTypeWildcardFindsImports$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void usesFullyQualifiedReference(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Set;\n            class Test {\n                void test() {\n                    Set<String> s = java.util.Collections.singleton(\"test\");\n                }\n            }\n        ", (String)"\n            /*~~>*/import java.util.Set;\n            class Test {\n                void test() {\n                    Set<String> s = java.util.Collections.singleton(\"test\");\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::usesFullyQualifiedReference$lambda$9, sourceSpecsArray);
        }

        @Test
        public static void usesTypeFindsInheritedTypes(@NotNull UsesTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            \n            class Test {\n            }\n        ", (String)"\n            /*~~>*/import java.util.List;\n            \n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::usesTypeFindsInheritedTypes$lambda$11, sourceSpecsArray);
        }

        private static TreeVisitor primitiveTypes$lambda$1$lambda$0() {
            return (TreeVisitor)new UsesType("double");
        }

        private static void primitiveTypes$lambda$1(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::primitiveTypes$lambda$1$lambda$0));
        }

        private static TreeVisitor emptyConstructor$lambda$3$lambda$2() {
            return (TreeVisitor)new UsesType("java.util.ArrayList");
        }

        private static void emptyConstructor$lambda$3(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::emptyConstructor$lambda$3$lambda$2));
        }

        private static TreeVisitor usesTypeFindsImports$lambda$5$lambda$4() {
            return (TreeVisitor)new UsesType("java.util.Collections");
        }

        private static void usesTypeFindsImports$lambda$5(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesTypeFindsImports$lambda$5$lambda$4));
        }

        private static TreeVisitor usesTypeWildcardFindsImports$lambda$7$lambda$6() {
            return (TreeVisitor)new UsesType("java.util.*");
        }

        private static void usesTypeWildcardFindsImports$lambda$7(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesTypeWildcardFindsImports$lambda$7$lambda$6));
        }

        private static TreeVisitor usesFullyQualifiedReference$lambda$9$lambda$8() {
            return (TreeVisitor)new UsesType("java.util.*");
        }

        private static void usesFullyQualifiedReference$lambda$9(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesFullyQualifiedReference$lambda$9$lambda$8));
        }

        private static TreeVisitor usesTypeFindsInheritedTypes$lambda$11$lambda$10() {
            return (TreeVisitor)new UsesType("java.util.Collection");
        }

        private static void usesTypeFindsInheritedTypes$lambda$11(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesTypeFindsInheritedTypes$lambda$11$lambda$10));
        }
    }
}

