/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesAllMethods;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/search/UsesAllMethodsTest;", "Lorg/openrewrite/test/RewriteTest;", "matchesMultipleMethods", "", "usesBothExitEarlyMethods", "usesBothMethods", "usesNeitherMethods", "usesOneMethod", "rewrite-java-tck"})
public interface UsesAllMethodsTest
extends RewriteTest {
    @Test
    public void usesBothMethods();

    @Test
    public void usesNeitherMethods();

    @Test
    public void usesOneMethod();

    @Test
    public void usesBothExitEarlyMethods();

    @Test
    public void matchesMultipleMethods();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void usesBothMethods(@NotNull UsesAllMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                }\n            }\n            ", (String)"\n            /*~~>*/import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::usesBothMethods$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void usesNeitherMethods(@NotNull UsesAllMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::usesNeitherMethods$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void usesOneMethod(@NotNull UsesAllMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::usesOneMethod$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void usesBothExitEarlyMethods(@NotNull UsesAllMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                    System.out.println(\"Hello\");\n                }\n            }\n            ", (String)"\n            /*~~>*/import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                    System.out.println(\"Hello\");\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::usesBothExitEarlyMethods$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void matchesMultipleMethods(@NotNull UsesAllMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                }\n            }\n            ", (String)"\n            /*~~>*/import java.util.Collections;\n            class Test {\n                {\n                    Collections.emptyList();\n                    Collections.emptySet();\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::matchesMultipleMethods$lambda$9, sourceSpecsArray);
        }

        private static TreeVisitor usesBothMethods$lambda$1$lambda$0() {
            MethodMatcher[] methodMatcherArray = new MethodMatcher[]{new MethodMatcher("java.util.Collections emptyList()"), new MethodMatcher("java.util.Collections emptySet()")};
            return (TreeVisitor)new UsesAllMethods(methodMatcherArray);
        }

        private static void usesBothMethods$lambda$1(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesBothMethods$lambda$1$lambda$0));
        }

        private static TreeVisitor usesNeitherMethods$lambda$3$lambda$2() {
            MethodMatcher[] methodMatcherArray = new MethodMatcher[]{new MethodMatcher("java.util.Collections emptyList()"), new MethodMatcher("java.util.Collections emptySet()")};
            return (TreeVisitor)new UsesAllMethods(methodMatcherArray);
        }

        private static void usesNeitherMethods$lambda$3(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesNeitherMethods$lambda$3$lambda$2));
        }

        private static TreeVisitor usesOneMethod$lambda$5$lambda$4() {
            MethodMatcher[] methodMatcherArray = new MethodMatcher[]{new MethodMatcher("java.util.Collections emptyList()"), new MethodMatcher("java.util.Collections emptySet()")};
            return (TreeVisitor)new UsesAllMethods(methodMatcherArray);
        }

        private static void usesOneMethod$lambda$5(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesOneMethod$lambda$5$lambda$4));
        }

        private static TreeVisitor usesBothExitEarlyMethods$lambda$7$lambda$6() {
            MethodMatcher[] methodMatcherArray = new MethodMatcher[]{new MethodMatcher("java.util.Collections emptyList()"), new MethodMatcher("java.util.Collections emptySet()")};
            return (TreeVisitor)new UsesAllMethods(methodMatcherArray);
        }

        private static void usesBothExitEarlyMethods$lambda$7(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::usesBothExitEarlyMethods$lambda$7$lambda$6));
        }

        private static TreeVisitor matchesMultipleMethods$lambda$9$lambda$8() {
            MethodMatcher[] methodMatcherArray = new MethodMatcher[]{new MethodMatcher("java.util.Collections emptyList()"), new MethodMatcher("java.util.Collections *()"), new MethodMatcher("java.util.Collections emptySet()")};
            return (TreeVisitor)new UsesAllMethods(methodMatcherArray);
        }

        private static void matchesMultipleMethods$lambda$9(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::matchesMultipleMethods$lambda$9$lambda$8));
        }
    }
}

