/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ChangeTypeTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b-\bf\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JJ\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\bH\u0017J\b\u0010\u000b\u001a\u00020\bH\u0017J\b\u0010\f\u001a\u00020\bH\u0017J\b\u0010\r\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\bH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0017J\b\u0010\u0010\u001a\u00020\bH\u0017J\u0012\u0010\u0011\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\bH\u0017J\b\u0010\u0015\u001a\u00020\bH\u0017J\b\u0010\u0016\u001a\u00020\bH\u0017J\b\u0010\u0017\u001a\u00020\bH\u0017J\b\u0010\u0018\u001a\u00020\bH\u0017J\b\u0010\u0019\u001a\u00020\bH\u0017J\b\u0010\u001a\u001a\u00020\bH\u0017J\b\u0010\u001b\u001a\u00020\bH\u0017J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0017J\b\u0010 \u001a\u00020\bH\u0017J\b\u0010!\u001a\u00020\bH\u0017J\u0012\u0010\"\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010#\u001a\u00020\bH\u0017J\b\u0010$\u001a\u00020\bH\u0017J\b\u0010%\u001a\u00020\bH\u0017J\b\u0010&\u001a\u00020\bH\u0017J\b\u0010'\u001a\u00020\bH\u0017J\b\u0010(\u001a\u00020\bH\u0017J\b\u0010)\u001a\u00020\bH\u0017J\b\u0010*\u001a\u00020\bH\u0017J\b\u0010+\u001a\u00020\bH\u0017J\b\u0010,\u001a\u00020\bH\u0017J\u0012\u0010-\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010.\u001a\u00020\bH\u0017J\u0012\u0010/\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u0012\u00100\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u00101\u001a\u00020\bH\u0017J\b\u00102\u001a\u00020\bH\u0017J\b\u00103\u001a\u00020\bH\u0017J\b\u00104\u001a\u00020\bH\u0017J\u0012\u00105\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u00106\u001a\u00020\bH\u0017J\b\u00107\u001a\u00020\bH\u0017J\u0012\u00108\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u0012\u00109\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010:\u001a\u00020\bH\u0017J\b\u0010;\u001a\u00020\bH\u0017J\b\u0010<\u001a\u00020\bH\u0017J\b\u0010=\u001a\u00020\bH\u0017J\b\u0010>\u001a\u00020\bH\u0017J\b\u0010?\u001a\u00020\bH\u0017J\b\u0010@\u001a\u00020\bH\u0017J\b\u0010A\u001a\u00020\bH\u0017J\b\u0010B\u001a\u00020\bH\u0017J\b\u0010C\u001a\u00020\bH\u0017J\b\u0010D\u001a\u00020\bH\u0017J\b\u0010E\u001a\u00020\bH\u0017J\b\u0010F\u001a\u00020\bH\u0017J\b\u0010G\u001a\u00020\bH\u0017J\b\u0010H\u001a\u00020\bH\u0017J\b\u0010I\u001a\u00020\bH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006K"}, d2={"Lorg/openrewrite/java/ChangeTypeTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "Lorg/openrewrite/test/RewriteTest;", "recipe", "Lorg/openrewrite/java/ChangeType;", "getRecipe", "()Lorg/openrewrite/java/ChangeType;", "allowJavaLangSubpackages", "", "annotation", "array", "array2", "assignment", "boundedGenericType", "changeConstructor", "changeInnerClassToOuterClass", "changeJavaTypeClassKindEnum", "changePathOfNonPublicClass", "tempDir", "Ljava/nio/file/Path;", "changeStaticFieldAccess", "changeTypeInTypeDeclaration", "changeTypeWithInnerClass", "checkValidation", "classDecl", "classReference", "classToPrimitive", "deeplyNestedInnerClass", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotAddJavaLangWrapperImports", "doNotChangeTypeInTypeDeclaration", "dontAddImportWhenNoChangesWereMade", "filePathMatchWithNoMatchedClassFqn", "fullyQualifiedName", "importOrdering", "javadocs", "lambda", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "multiCatch", "multiDimensionalArray", "multiVariable", "multipleLevelsOfInnerClasses", "newClass", "onlyChangeTypeMissingPublicModifier", "onlyChangeTypeWithoutMatchedFilePath", "onlyUpdateApplicableImport", "parameterizedType", "primitiveToClass", "renameClass", "renameClassAndFilePath", "renameInnerClass", "renamePackage", "renamePackageAndFilePath", "renamePackageAndInnerClassName", "replacePrivateNestedType", "replaceWithNestedType", "simpleName", "staticConstant", "staticImport", "staticImports2", "ternary", "typeCast", "unnecessaryImport", "updateAssignments", "updateClassPrefixWithEmptyPackage", "updateImportPrefixWithEmptyPackage", "updateJavaTypeClassKindAnnotation", "updateMethodType", "updateVariableType", "uppercaseInPackage", "Companion", "rewrite-java-tck"})
public interface ChangeTypeTest
extends JavaRecipeTest,
RewriteTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeTypeTest$Companion.$$INSTANCE;

    @NotNull
    public ChangeType getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotAddJavaLangWrapperImports();

    @Test
    public void allowJavaLangSubpackages();

    @Test
    public void unnecessaryImport();

    @Test
    public void changeInnerClassToOuterClass();

    @Test
    public void changeStaticFieldAccess();

    @Test
    public void dontAddImportWhenNoChangesWereMade();

    @Test
    public void replaceWithNestedType();

    @Test
    public void replacePrivateNestedType();

    @Test
    public void deeplyNestedInnerClass();

    @Test
    public void simpleName();

    @Test
    public void fullyQualifiedName();

    @Test
    public void annotation();

    @Test
    public void array2();

    @Test
    public void array();

    @Test
    public void multiDimensionalArray();

    @Test
    public void classDecl();

    @Test
    public void method();

    @Test
    public void methodInvocationTypeParametersAndWildcard();

    @Test
    public void multiCatch();

    @Test
    public void multiVariable();

    @Test
    public void newClass();

    @Test
    public void updateAssignments();

    @Test
    public void parameterizedType();

    @Test
    public void typeCast();

    @Test
    public void classReference();

    @Test
    public void methodSelect();

    @Test
    public void staticImport();

    @Test
    public void staticImports2();

    @Test
    public void staticConstant();

    @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
    @Test
    public void primitiveToClass();

    @Test
    public void classToPrimitive();

    @Test
    public void importOrdering();

    @Test
    public void changeTypeWithInnerClass();

    @Test
    public void uppercaseInPackage();

    @Test
    public void lambda();

    @Test
    public void assignment();

    @Test
    public void ternary();

    @Test
    public void changeTypeInTypeDeclaration();

    @Test
    public void doNotChangeTypeInTypeDeclaration();

    @Test
    public void javadocs();

    @Test
    public void onlyUpdateApplicableImport();

    @Test
    public void filePathMatchWithNoMatchedClassFqn(@TempDir @NotNull Path var1);

    @Test
    public void onlyChangeTypeMissingPublicModifier(@TempDir @NotNull Path var1);

    @Test
    public void onlyChangeTypeWithoutMatchedFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renameClassAndFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renamePackageAndFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renamePackageAndInnerClassName(@TempDir @NotNull Path var1);

    @Test
    public void updateImportPrefixWithEmptyPackage();

    @Test
    public void updateClassPrefixWithEmptyPackage();

    @Test
    public void renameInnerClass();

    @Test
    public void multipleLevelsOfInnerClasses(@TempDir @NotNull Path var1);

    @Test
    public void changePathOfNonPublicClass(@TempDir @NotNull Path var1);

    @Test
    public void renamePackage();

    @Test
    public void renameClass();

    @Test
    public void updateMethodType();

    @Test
    public void updateVariableType();

    @Test
    public void boundedGenericType();

    @Test
    public void changeConstructor();

    @Disabled(value="requires correct Kind.")
    @Test
    public void updateJavaTypeClassKindAnnotation();

    @Disabled(value="requires correct Kind.")
    @Test
    public void changeJavaTypeClassKindEnum();

    @Test
    public void checkValidation();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangeTypeTest$Companion;", "", "()V", "a1", "", "a2", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String a1 = "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        ";
        @NotNull
        private static final String a2 = "\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ChangeType getRecipe(@NotNull ChangeTypeTest $this) {
            return new ChangeType("a.A1", "a.A2", Boolean.valueOf(true));
        }

        public static void defaults(@NotNull ChangeTypeTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)$this.getRecipe());
        }

        @Test
        public static void doNotAddJavaLangWrapperImports(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"public class ThinkPositive { private Integer fred = 1;}", (String)"public class ThinkPositive { private Long fred = 1;}")};
            $this.rewriteRun(DefaultImpls::doNotAddJavaLangWrapperImports$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void allowJavaLangSubpackages(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.logging.LoggingMXBean;\n\n            class Test {\n                static void method() {\n                    LoggingMXBean loggingBean = null;\n                }\n            }\n        ", (String)"\n            import java.lang.management.PlatformLoggingMXBean;\n\n            class Test {\n                static void method() {\n                    PlatformLoggingMXBean loggingBean = null;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::allowJavaLangSubpackages$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void unnecessaryImport(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import test.Outer;\n            \n            class Test {\n                private Outer p = Outer.of();\n                private Outer p2 = test.Outer.of();\n            }\n        "), Assertions.java((String)"\n            package test;\n            \n            public class Outer {\n                public static Outer of() {\n                    return new Outer();\n                }\n            \n                public static class Inner {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::unnecessaryImport$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void changeInnerClassToOuterClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Map;\n            import java.util.Map.Entry;\n            \n            class Test {\n                Entry p;\n                Map.Entry p2;\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Test {\n                List p;\n                List p2;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::changeInnerClassToOuterClass$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void changeStaticFieldAccess(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            \n            class Test {\n                String p = File.separator;\n            }\n        ", (String)"\n            import my.pkg.List;\n            \n            class Test {\n                String p = List.separator;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::changeStaticFieldAccess$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"public class B {}")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceWithNestedType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            \n            class Test {\n                File p;\n            }\n        ", (String)"\n            import java.util.Map;\n            \n            class Test {\n                Map.Entry p;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::replaceWithNestedType$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void replacePrivateNestedType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            \n            class A {\n                private static class B1 {}\n            }\n        ", (String)"\n            package a;\n            \n            class A {\n                private static class B2 {}\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::replacePrivateNestedType$lambda$6, sourceSpecsArray);
        }

        @Test
        public static void deeplyNestedInnerClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            \n            class A {\n                public static class B {\n                    public static class C {\n                    }\n                }\n            }\n        ", (String)"\n            package a;\n            \n            class A {\n                public static class B {\n                    public static class C2 {\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::deeplyNestedInnerClass$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void simpleName(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B extends A1 {}\n        ", (String)"\n            import a.A2;\n            \n            public class B extends A2 {}\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fullyQualifiedName(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"public class B extends a.A1 {}", (String)"public class B extends a.A2 {}")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotation(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"package a.b.c;\npublic @interface A1 {}"), Assertions.java((String)"package a.b.d;\npublic @interface A2 {}"), Assertions.java((String)"@a.b.c.A1 public class B {}", (String)"@a.b.d.A2 public class B {}")};
            $this.rewriteRun(DefaultImpls::annotation$lambda$8, sourceSpecsArray);
        }

        @Test
        public static void array2(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n            \n            public class Pojo {\n            }\n        "), Assertions.java((String)"\n            package com.acme.project.impl;\n            \n            import com.acme.product.Pojo;\n            \n            public class UsePojo2 {\n                Pojo[] p;\n            \n                void run() {\n                    p[0] = null;\n                }\n            }\n        ", (String)"\n            package com.acme.project.impl;\n            \n            import com.acme.product.v2.Pojo;\n            \n            public class UsePojo2 {\n                Pojo[] p;\n            \n                void run() {\n                    p[0] = null;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::array2$lambda$9, sourceSpecsArray);
        }

        @Test
        public static void array(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               A2[] a = new A2[0];\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiDimensionalArray(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class A {\n                A1[][] multiDimensionalArray;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class A {\n                A2[][] multiDimensionalArray;\n            }\n        ", DefaultImpls::multiDimensionalArray$lambda$11)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classDecl(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"public interface I1 {}"), Assertions.java((String)"public interface I2 {}"), Assertions.java((String)"\n            import a.A1;\n            \n            public class B extends A1 implements I1 {}\n        ", (String)"\n            import a.A2;\n            \n            public class B extends A2 implements I2 {}\n        ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.classDecl$lambda$12($this, arg_0), sourceSpecsArray);
        }

        @Test
        public static void method(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               public A2 foo() throws A2 { return null; }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) {\n               \n               }\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, true);\n               }\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               public <T extends A2> T generic(T n, List<? super A2> in) {\n               \n               }\n               public void test() {\n                   A2.stat();\n                   this.<A2>generic(null, true);\n               }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiCatch(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               public void test() {\n                   try {}\n                   catch(A2 | RuntimeException e) {}\n               }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiVariable(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               A1 f1, f2;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               A2 f1, f2;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               A1 a = new A1();\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               A2 a = new A2();\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void updateAssignments(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n\n            class B {\n                void method(A1 param) {\n                    A1 a = param;\n                }\n            }\n        ", (String)"\n            import a.A2;\n\n            class B {\n                void method(A2 param) {\n                    A2 a = param;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void parameterizedType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               Map<A1, A1> m;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               Map<A2, A2> m;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typeCast(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               A1 a = (A1) null;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               A2 a = (A2) null;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classReference(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class A {\n                Class<?> clazz = A1.class;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class A {\n                Class<?> clazz = A2.class;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodSelect(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class B {\n               A1 a = null;\n               public void test() { a.foo(); }\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class B {\n               A2 a = null;\n               public void test() { a.foo(); }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void staticImport(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import static a.A1.stat;\n            \n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", (String)"\n            import static a.A2.stat;\n            \n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void staticImports2(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n            \n            public class RunnableFactory {\n                public static String getString() {\n                    return \"hello\";\n                }\n            }\n        "), Assertions.java((String)"\n            package com.acme.project.impl;\n            \n            import static com.acme.product.RunnableFactory.getString;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    getString().toLowerCase();\n                }\n            }\n        ", (String)"\n            package com.acme.project.impl;\n            \n            import static com.acme.product.v2.RunnableFactory.getString;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    getString().toLowerCase();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::staticImports2$lambda$13, sourceSpecsArray);
        }

        @Test
        public static void staticConstant(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n            \n            public class RunnableFactory {\n                public static final String CONSTANT = \"hello\";\n            }\n        "), Assertions.java((String)"\n            package com.acme.project.impl;\n            \n            import static com.acme.product.RunnableFactory.CONSTANT;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    System.out.println(CONSTANT + \" fred.\");\n                }\n            }\n        ", (String)"\n            package com.acme.project.impl;\n            \n            import static com.acme.product.v2.RunnableFactory.CONSTANT;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    System.out.println(CONSTANT + \" fred.\");\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::staticConstant$lambda$14, sourceSpecsArray);
        }

        @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
        @Test
        public static void primitiveToClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", (String)"\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::primitiveToClass$lambda$15, sourceSpecsArray);
        }

        @Test
        public static void classToPrimitive(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", (String)"\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::classToPrimitive$lambda$16, sourceSpecsArray);
        }

        @Test
        public static void importOrdering(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.yourorg.a;\n            public class A {}\n        "), Assertions.java((String)"\n            package com.myorg.b;\n            public class B {}\n        "), Assertions.java((String)"\n            package com.myorg;\n\n            import java.util.ArrayList;\n            import com.yourorg.a.A;\n            import java.util.List;\n            \n            public class Foo {\n                List<A> a = new ArrayList<>();\n            }\n        ", (String)"\n            package com.myorg;\n\n            import com.myorg.b.B;\n\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            public class Foo {\n                List<B> a = new ArrayList<>();\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::importOrdering$lambda$17, sourceSpecsArray);
        }

        @Test
        public static void changeTypeWithInnerClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package com.acme.product;\n                \n                public class OuterClass {\n                    public static class InnerClass {\n                \n                    }\n                }\n        "), Assertions.java((String)"\n            package de;\n            \n            import com.acme.product.OuterClass.InnerClass;\n            import com.acme.product.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", (String)"\n            package de;\n\n            import com.acme.product.v2.OuterClass.InnerClass;\n            import com.acme.product.v2.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::changeTypeWithInnerClass$lambda$18, sourceSpecsArray);
        }

        @Test
        public static void uppercaseInPackage(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package com.acme.product.util.accessDecision;\n                \n                public enum AccessVote {\n                    ABSTAIN\n                }\n        "), Assertions.java((String)"\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote() {\n                    return AccessVote.ABSTAIN;\n                }\n            }\n        ", (String)"\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote() {\n                    return AccessVote.ABSTAIN;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::uppercaseInPackage$lambda$19, sourceSpecsArray);
        }

        @Test
        public static void lambda(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n            public interface Procedure {\n                void execute();\n            }\n        "), Assertions.java((String)"\n            import com.acme.product.Procedure;\n            \n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {\n                    });\n                }\n                abstract void worker(Procedure callback);\n            }\n        ", (String)"\n            import com.acme.product.Procedure2;\n            \n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {\n                    });\n                }\n                abstract void worker(Procedure2 callback);\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::lambda$lambda$20, sourceSpecsArray);
        }

        @Test
        public static void assignment(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product.util.accessDecision;\n            \n            public enum AccessVote {\n                ABSTAIN,\n                GRANT\n            }\n        "), Assertions.java((String)"\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    AccessVote fred;\n                    fred = (AccessVote) input;\n                    return fred;\n                }\n            }\n        ", (String)"\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    AccessVote fred;\n                    fred = (AccessVote) input;\n                    return fred;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::assignment$lambda$21, sourceSpecsArray);
        }

        @Test
        public static void ternary(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product.util.accessDecision;\n            \n            public enum AccessVote {\n                ABSTAIN,\n                GRANT\n            }\n        "), Assertions.java((String)"\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    return input == null ? AccessVote.GRANT : AccessVote.ABSTAIN;\n                }\n            }\n        ", (String)"\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    return input == null ? AccessVote.GRANT : AccessVote.ABSTAIN;\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::ternary$lambda$22, sourceSpecsArray);
        }

        @Test
        public static void changeTypeInTypeDeclaration(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package de;\n            public class Class2 {}\n        ", (String)"\n            package de;\n            public class Class1 {}\n        ")};
            $this.rewriteRun(DefaultImpls::changeTypeInTypeDeclaration$lambda$23, sourceSpecsArray);
        }

        @Test
        public static void doNotChangeTypeInTypeDeclaration(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package de;\n            public class Class2 {}\n        ")};
            $this.rewriteRun(DefaultImpls::doNotChangeTypeInTypeDeclaration$lambda$24, sourceSpecsArray);
        }

        @Test
        public static void javadocs(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            \n            /**\n             * {@link List} here\n             */\n            class Test {\n                int n;\n            }\n        ", (String)"\n            import java.util.Collection;\n            \n            /**\n             * {@link Collection} here\n             */\n            class Test {\n                int n;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::javadocs$lambda$25, sourceSpecsArray);
        }

        @Test
        public static void onlyUpdateApplicableImport(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product.factory;\n\n            public class V1Factory {\n                public static String getItem() {\n                    return \"V1Factory\";\n                }\n            }\n        "), Assertions.java((String)"\n            package com.acme.product.factory;\n\n            public class V2Factory {\n                public static String getItem() {\n                    return \"V2Factory\";\n                }\n            }\n        "), Assertions.java((String)"\n            import com.acme.product.factory.V1Factory;\n\n            import static com.acme.product.factory.V2Factory.getItem;\n\n            public class UseFactories {\n                static class MyV1Factory extends V1Factory {\n                    static String getMyItemInherited() {\n                        return getItem();\n                    }\n                }\n\n                static String getMyItemStaticImport() {\n                    return getItem();\n                }\n            }\n        ", (String)"\n            import com.acme.product.factory.V1FactoryA;\n\n            import static com.acme.product.factory.V2Factory.getItem;\n\n            public class UseFactories {\n                static class MyV1Factory extends V1FactoryA {\n                    static String getMyItemInherited() {\n                        return getItem();\n                    }\n                }\n\n                static String getMyItemStaticImport() {\n                    return getItem();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::onlyUpdateApplicableImport$lambda$26, sourceSpecsArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void filePathMatchWithNoMatchedClassFqn(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2427;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            Parser parser = null;
            RecipeTest recipeTest = $this;
            boolean bl = false;
            $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2427.toFile().getParentFile().mkdirs();
            File file = $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2427.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a;\npublic class NoMatch {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/Ori\u2026ent())\n        }.toFile()");
            RecipeTest.DefaultImpls.assertUnchangedBase$default((RecipeTest)recipeTest, parser, (Recipe)recipe2, executionContext, (File)file2, null, null, (int)53, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void onlyChangeTypeMissingPublicModifier(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2428;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            JavaParser javaParser = null;
            JavaRecipeTest javaRecipeTest = $this;
            boolean bl = false;
            $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2428.toFile().getParentFile().mkdirs();
            File file = $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2428.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\nclass Original {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/Ori\u2026ent())\n        }.toFile()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, recipe2, executionContext, file2, null, null, "package x.y;\nclass Target {\n}", 0, 0, null, onlyChangeTypeMissingPublicModifier.2.INSTANCE, 949, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void onlyChangeTypeWithoutMatchedFilePath(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2429;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/NoMatch.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            JavaParser javaParser = null;
            JavaRecipeTest javaRecipeTest = $this;
            boolean bl = false;
            $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2429.toFile().getParentFile().mkdirs();
            File file = $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2429.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/NoM\u2026ent())\n        }.toFile()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, recipe2, executionContext, file2, null, null, "package x.y;\npublic class Target {\n}", 0, 0, null, onlyChangeTypeWithoutMatchedFilePath.2.INSTANCE, 949, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renameClassAndFilePath(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$renameClassAndFilePath_u24lambda_u2430;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            boolean bl = false;
            $this$renameClassAndFilePath_u24lambda_u2430.toFile().getParentFile().mkdirs();
            File file = $this$renameClassAndFilePath_u24lambda_u2430.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            org.assertj.core.api.Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renameClassAndFilePath.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/Original.java b/x/y/Target.java\nsimilarity index 0%\nrename from a/b/Original.java\nrename to x/y/Target.java\nindex 49dd697..65e689d 100644\n--- a/a/b/Original.java\n+++ b/x/y/Target.java\n@@ -1,3 +1,3 @@ org.openrewrite.java.ChangeType\n-package a.b;\n-public class Original {\n+package x.y;\n+public class Target {\n }\n\\ No newline at end of file\n");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renamePackageAndFilePath(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$renamePackageAndFilePath_u24lambda_u2431;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            boolean bl = false;
            $this$renamePackageAndFilePath_u24lambda_u2431.toFile().getParentFile().mkdirs();
            File file = $this$renamePackageAndFilePath_u24lambda_u2431.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.Original", "x.y.Original", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            org.assertj.core.api.Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renamePackageAndFilePath.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/Original.java b/x/y/Original.java\nsimilarity index 0%\nrename from a/b/Original.java\nrename to x/y/Original.java\nindex 49dd697..02e6a06 100644\n--- a/a/b/Original.java\n+++ b/x/y/Original.java\n@@ -1,3 +1,3 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class Original {\n }\n\\ No newline at end of file\n");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renamePackageAndInnerClassName(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$renamePackageAndInnerClassName_u24lambda_u2432;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/C.java");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            boolean bl = false;
            $this$renamePackageAndInnerClassName_u24lambda_u2432.toFile().getParentFile().mkdirs();
            File file = $this$renamePackageAndInnerClassName_u24lambda_u2432.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class C {\n    public static class Original {\n    }\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.C$Original", "x.y.C$Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            org.assertj.core.api.Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renamePackageAndInnerClassName.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/C.java b/x/y/C.java\nsimilarity index 0%\nrename from a/b/C.java\nrename to x/y/C.java\nindex 7b428dc..56a5c53 100644\n--- a/a/b/C.java\n+++ b/x/y/C.java\n@@ -1,5 +1,5 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class C {\n-    public static class Original {\n+    public static class Target {\n     }\n }\n\\ No newline at end of file\n");
        }

        @Test
        public static void updateImportPrefixWithEmptyPackage(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            import java.util.List;\n            \n            class Original {\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Target {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::updateImportPrefixWithEmptyPackage$lambda$33, sourceSpecsArray);
        }

        @Test
        public static void updateClassPrefixWithEmptyPackage(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            class Original {\n            }\n        ", (String)"\n            class Target {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::updateClassPrefixWithEmptyPackage$lambda$34, sourceSpecsArray);
        }

        @Test
        public static void renameInnerClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            public class C {\n                public static class Original {\n                }\n            }\n        ", (String)"\n            package a.b;\n            public class C {\n                public static class Target {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::renameInnerClass$lambda$35, sourceSpecsArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void multipleLevelsOfInnerClasses(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$multipleLevelsOfInnerClasses_u24lambda_u2436;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/C.java");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            boolean bl = false;
            $this$multipleLevelsOfInnerClasses_u24lambda_u2436.toFile().getParentFile().mkdirs();
            File file = $this$multipleLevelsOfInnerClasses_u24lambda_u2436.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class C {\n    public static class D {\n        public static class Original {\n        }\n    }\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.C$D$Original", "x.y.C$D$Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            org.assertj.core.api.Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)multipleLevelsOfInnerClasses.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/C.java b/x/y/C.java\nsimilarity index 0%\nrename from a/b/C.java\nrename to x/y/C.java\nindex 22bd92f..816d6b1 100644\n--- a/a/b/C.java\n+++ b/x/y/C.java\n@@ -1,7 +1,7 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class C {\n     public static class D {\n-        public static class Original {\n+        public static class Target {\n         }\n     }\n }\n\\ No newline at end of file\n");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void changePathOfNonPublicClass(@NotNull ChangeTypeTest $this, @TempDir @NotNull Path tempDir) {
            void $this$changePathOfNonPublicClass_u24lambda_u2437;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/C.java");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            boolean bl = false;
            $this$changePathOfNonPublicClass_u24lambda_u2437.toFile().getParentFile().mkdirs();
            File file = $this$changePathOfNonPublicClass_u24lambda_u2437.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\nclass C {\n}\nclass D {\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.C", "x.y.Z", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            org.assertj.core.api.Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)changePathOfNonPublicClass.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/C.java b/x/y/Z.java\nsimilarity index 0%\nrename from a/b/C.java\nrename to x/y/Z.java\nindex 1ef60ec..3b77cb3 100644\n--- a/a/b/C.java\n+++ b/x/y/Z.java\n@@ -1,5 +1,5 @@ org.openrewrite.java.ChangeType\n-package a.b;\n-class C {\n+package x.y;\n+class Z {\n }\n class D {\n }\n\\ No newline at end of file\n");
        }

        @Test
        public static void renamePackage(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            class Original {\n            }\n        ", (String)"\n            package x.y;\n            class Original {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::renamePackage$lambda$38, sourceSpecsArray);
        }

        @Test
        public static void renameClass(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            class Original {\n            }\n        ", (String)"\n            package a.b;\n            class Target {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::renameClass$lambda$39, sourceSpecsArray);
        }

        @Test
        public static void updateMethodType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 {\n            }\n        ", (String)"\n            package a;\n            public class A2 {\n            }\n        "), Assertions.java((String)"\n            package org.foo;\n            \n            import a.A1;\n            \n            public class Example {\n                public A1 method(A1 a1) {\n                    return a1;\n                }\n            }\n        ", (String)"\n            package org.foo;\n            \n            import a.A2;\n            \n            public class Example {\n                public A2 method(A2 a1) {\n                    return a1;\n                }\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            import org.foo.Example;\n            \n            public class Test {\n                A1 local = new Example().method(null);\n            }\n        ", (String)"\n            import a.A2;\n            import org.foo.Example;\n            \n            public class Test {\n                A2 local = new Example().method(null);\n            }\n        ", DefaultImpls::updateMethodType$lambda$43)};
            $this.rewriteRun(DefaultImpls::updateMethodType$lambda$40, sourceSpecsArray);
        }

        @Test
        public static void updateVariableType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class Test {\n                A1 a;\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class Test {\n                A2 a;\n            }\n        ", DefaultImpls::updateVariableType$lambda$45)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void boundedGenericType(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            package a;\n            public class A2 extends Exception {\n                public static void stat() {}\n                public void foo() {}\n            }\n        "), Assertions.java((String)"\n            import a.A1;\n            \n            public class Test {\n                <T extends A1> T method(T t) {\n                    return t;\n                }\n            }\n        ", (String)"\n            import a.A2;\n            \n            public class Test {\n                <T extends A2> T method(T t) {\n                    return t;\n                }\n            }\n        ", DefaultImpls::boundedGenericType$lambda$47)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeConstructor(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a;\n            \n            public class A1 {\n                public A1() {\n                }\n            }\n        ", (String)"\n            package a;\n            \n            public class A2 {\n                public A2() {\n                }\n            }\n        ", DefaultImpls::changeConstructor$lambda$50)};
            $this.rewriteRun(DefaultImpls::changeConstructor$lambda$48, sourceSpecsArray);
        }

        @Disabled(value="requires correct Kind.")
        @Test
        public static void updateJavaTypeClassKindAnnotation(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            \n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n            \n            @Target({ElementType.TYPE, ElementType.METHOD})\n            @Retention(RetentionPolicy.RUNTIME)\n            public @interface Test1 {}\n        ", (String)"\n            package org.openrewrite;\n            \n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n            \n            @Target({ElementType.TYPE, ElementType.METHOD})\n            @Retention(RetentionPolicy.RUNTIME)\n            public @interface Test2 {}\n        "), Assertions.java((String)"\n            import org.openrewrite.Test1;\n            \n            public class A {\n                @Test1\n                void method() {}\n            }\n        ", (String)"\n            import org.openrewrite.Test2;\n            \n            public class A {\n                @Test2\n                void method() {}\n            }\n        ", DefaultImpls::updateJavaTypeClassKindAnnotation$lambda$53)};
            $this.rewriteRun(DefaultImpls::updateJavaTypeClassKindAnnotation$lambda$51, sourceSpecsArray);
        }

        @Disabled(value="requires correct Kind.")
        @Test
        public static void changeJavaTypeClassKindEnum(@NotNull ChangeTypeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public enum MyEnum1 {\n                A,\n                B\n            }\n        ", (String)"\n            package org.openrewrite;\n            public enum MyEnum2 {\n                A,\n                B\n            }\n        "), Assertions.java((String)"\n            package org.openrewrite;\n            import static org.openrewrite.MyEnum1.A;\n            import static org.openrewrite.MyEnum1.B;\n            public class App {\n                public void test(String s) {\n                    if (s.equals(\" \" + A + B)) {\n                    }\n                }\n            }\n        ", (String)"\n            package org.openrewrite;\n            import static org.openrewrite.MyEnum2.A;\n            import static org.openrewrite.MyEnum2.B;\n            public class App {\n                public void test(String s) {\n                    if (s.equals(\" \" + A + B)) {\n                    }\n                }\n            }\n        ", DefaultImpls::changeJavaTypeClassKindEnum$lambda$56)};
            $this.rewriteRun(DefaultImpls::changeJavaTypeClassKindEnum$lambda$54, sourceSpecsArray);
        }

        @Test
        public static void checkValidation(@NotNull ChangeTypeTest $this) {
            ChangeType recipe2 = new ChangeType(null, null, Boolean.valueOf(true));
            Validated valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(2);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType(null, "java.lang.String", Boolean.valueOf(true));
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType("java.lang.String", null, Boolean.valueOf(true));
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangeTypeTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangeTypeTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangeTypeTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangeTypeTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull ChangeTypeTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeTypeTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ChangeTypeTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangeTypeTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangeTypeTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangeTypeTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangeTypeTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangeTypeTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }

        private static void doNotAddJavaLangWrapperImports$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.lang.Integer", "java.lang.Long", Boolean.valueOf(true)));
        }

        private static void allowJavaLangSubpackages$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.util.logging.LoggingMXBean", "java.lang.management.PlatformLoggingMXBean", Boolean.valueOf(true)));
        }

        private static void unnecessaryImport$lambda$2(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("test.Outer.Inner", "java.util.ArrayList", Boolean.valueOf(true)));
        }

        private static void changeInnerClassToOuterClass$lambda$3(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.util.Map$Entry", "java.util.List", Boolean.valueOf(true)));
        }

        private static void changeStaticFieldAccess$lambda$4(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.io.File", "my.pkg.List", Boolean.valueOf(true)));
        }

        private static void replaceWithNestedType$lambda$5(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.io.File", "java.util.Map$Entry", Boolean.valueOf(true)));
        }

        private static void replacePrivateNestedType$lambda$6(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.A.B1", "a.A.B2", Boolean.valueOf(false)));
        }

        private static void deeplyNestedInnerClass$lambda$7(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.A.B.C", "a.A.B.C2", Boolean.valueOf(false)));
        }

        private static void annotation$lambda$8(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.c.A1", "a.b.d.A2", Boolean.valueOf(true)));
        }

        private static void array2$lambda$9(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.Pojo", "com.acme.product.v2.Pojo", Boolean.valueOf(true)));
        }

        private static void multiDimensionalArray$lambda$11$lambda$10(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A2")).isNotEmpty();
        }

        private static void multiDimensionalArray$lambda$11(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::multiDimensionalArray$lambda$11$lambda$10);
        }

        private static void classDecl$lambda$12(ChangeTypeTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(new CompositeRecipe().doNext((Recipe)this$0.getRecipe()).doNext((Recipe)new ChangeType("I1", "I2", Boolean.valueOf(true))));
        }

        private static void staticImports2$lambda$13(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.RunnableFactory", "com.acme.product.v2.RunnableFactory", Boolean.valueOf(true)));
        }

        private static void staticConstant$lambda$14(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.RunnableFactory", "com.acme.product.v2.RunnableFactory", Boolean.valueOf(true)));
        }

        private static void primitiveToClass$lambda$15(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("int", "java.lang.Integer", Boolean.valueOf(true)));
        }

        private static void classToPrimitive$lambda$16(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.lang.Integer", "int", Boolean.valueOf(true)));
        }

        private static void importOrdering$lambda$17(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.yourorg.a.A", "com.myorg.b.B", Boolean.valueOf(true)));
        }

        private static void changeTypeWithInnerClass$lambda$18(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.OuterClass", "com.acme.product.v2.OuterClass", Boolean.valueOf(true)));
        }

        private static void uppercaseInPackage$lambda$19(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true)));
        }

        private static void lambda$lambda$20(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.Procedure", "com.acme.product.Procedure2", Boolean.valueOf(true)));
        }

        private static void assignment$lambda$21(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true)));
        }

        private static void ternary$lambda$22(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true)));
        }

        private static void changeTypeInTypeDeclaration$lambda$23(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("de.Class2", "de.Class1", Boolean.valueOf(false)));
        }

        private static void doNotChangeTypeInTypeDeclaration$lambda$24(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("de.Class2", "de.Class1", Boolean.valueOf(true)));
        }

        private static void javadocs$lambda$25(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("java.util.List", "java.util.Collection", Boolean.valueOf(true)));
        }

        private static void onlyUpdateApplicableImport$lambda$26(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("com.acme.product.factory.V1Factory", "com.acme.product.factory.V1FactoryA", Boolean.valueOf(true)));
        }

        private static void updateImportPrefixWithEmptyPackage$lambda$33(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.Original", "Target", Boolean.valueOf(false)));
        }

        private static void updateClassPrefixWithEmptyPackage$lambda$34(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.Original", "Target", Boolean.valueOf(false)));
        }

        private static void renameInnerClass$lambda$35(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.C$Original", "a.b.C$Target", Boolean.valueOf(false)));
        }

        private static void renamePackage$lambda$38(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.Original", "x.y.Original", Boolean.valueOf(false)));
        }

        private static void renameClass$lambda$39(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.b.Original", "a.b.Target", Boolean.valueOf(false)));
        }

        private static void updateMethodType$lambda$40(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.A1", "a.A2", Boolean.valueOf(false)));
        }

        /*
         * WARNING - void declaration
         */
        private static void updateMethodType$lambda$43$lambda$42(J.CompilationUnit cu) {
            void $this$filterTo$iv$iv;
            Set set = cu.getTypesInUse().getUsedMethods();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cu.typesInUse.usedMethods");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JavaType.Method it = (JavaType.Method)element$iv$iv;
                boolean bl = false;
                JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(it.getReturnType());
                Intrinsics.checkNotNull((Object)fullyQualified);
                if (!Intrinsics.areEqual((Object)"a.A2", (Object)fullyQualified.getFullyQualifiedName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methodType = (List)destination$iv$iv;
            org.assertj.core.api.Assertions.assertThat((List)methodType).hasSize(1);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(((JavaType.Method)methodType.get(0)).getReturnType());
            Intrinsics.checkNotNull((Object)fullyQualified);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("a.A2");
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)((JavaType.Method)methodType.get(0)).getParameterTypes().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified2);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified2.getFullyQualifiedName()).isEqualTo("a.A2");
        }

        private static void updateMethodType$lambda$43(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::updateMethodType$lambda$43$lambda$42);
        }

        private static void updateVariableType$lambda$45$lambda$44(J.CompilationUnit cu) {
            Set set = cu.getTypesInUse().getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cu.typesInUse.variables");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(thisCollection$iv.toArray(new JavaType.Variable[0])[0].getType());
            Intrinsics.checkNotNull((Object)fullyQualified);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("a.A2");
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A2")).isNotEmpty();
        }

        private static void updateVariableType$lambda$45(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::updateVariableType$lambda$45$lambda$44);
        }

        private static void boundedGenericType$lambda$47$lambda$46(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A2")).isNotEmpty();
        }

        private static void boundedGenericType$lambda$47(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::boundedGenericType$lambda$47$lambda$46);
        }

        private static void changeConstructor$lambda$48(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("a.A1", "a.A2", Boolean.valueOf(false)));
        }

        private static void changeConstructor$lambda$50$lambda$49(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("a.A2")).isNotEmpty();
        }

        private static void changeConstructor$lambda$50(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::changeConstructor$lambda$50$lambda$49);
        }

        private static void updateJavaTypeClassKindAnnotation$lambda$51(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("org.openrewrite.Test1", "org.openrewrite.Test2", Boolean.valueOf(false)));
        }

        private static void updateJavaTypeClassKindAnnotation$lambda$53$lambda$52(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test2")).isNotEmpty();
        }

        private static void updateJavaTypeClassKindAnnotation$lambda$53(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::updateJavaTypeClassKindAnnotation$lambda$53$lambda$52);
        }

        private static void changeJavaTypeClassKindEnum$lambda$54(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangeType("org.openrewrite.MyEnum1", "org.openrewrite.MyEnum2", Boolean.valueOf(false)));
        }

        private static void changeJavaTypeClassKindEnum$lambda$56$lambda$55(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.MyEnum1")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.MyEnum2")).isNotEmpty();
        }

        private static void changeJavaTypeClassKindEnum$lambda$56(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::changeJavaTypeClassKindEnum$lambda$56$lambda$55);
        }
    }
}

