/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.MultipleVariableDeclarations;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/cleanup/MultipleVariableDeclarationsTest;", "Lorg/openrewrite/test/RewriteTest;", "arrayDimensionsBeforeName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "arrayTypes", "blockCommentPreserved", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "removeNewlinesFromMultivariablePrefix", "replaceWithIndividualVariableDeclarations", "singleLineCommentPreserved", "rewrite-java-tck"})
public interface MultipleVariableDeclarationsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void arrayDimensionsBeforeName();

    @Test
    public void arrayDimensionsBeforeName(@NotNull JavaParser var1);

    @Test
    public void replaceWithIndividualVariableDeclarations();

    @Test
    public void arrayTypes(@NotNull JavaParser var1);

    @Test
    public void singleLineCommentPreserved(@NotNull JavaParser var1);

    @Test
    public void blockCommentPreserved(@NotNull JavaParser var1);

    @Test
    public void removeNewlinesFromMultivariablePrefix();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull MultipleVariableDeclarationsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new MultipleVariableDeclarations());
        }

        @Test
        public static void arrayDimensionsBeforeName(@NotNull MultipleVariableDeclarationsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    int[] m, n;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    int[] m;\n                    int[] n;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void arrayDimensionsBeforeName(@NotNull MultipleVariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    int[] m, n;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    int[] m;\n                    int[] n;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceWithIndividualVariableDeclarations(@NotNull MultipleVariableDeclarationsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n = 0, m = 0;\n                int o = 0, p;\n                int s, t = 0;\n\n                public void method() {\n                    for (int i = 0, j = 0; ; ) ;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n = 0;\n                int m = 0;\n                int o = 0;\n                int p;\n                int s;\n                int t = 0;\n\n                public void method() {\n                    for (int i = 0, j = 0; ; ) ;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void arrayTypes(@NotNull MultipleVariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public void method() {\n                    Integer[] q = {0}, r[] = {{0}};\n                }\n            }\n        ", (String)"\n            class Test {\n                public void method() {\n                    Integer[] q = {0};\n                    Integer[][] r = {{0}};\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void singleLineCommentPreserved(@NotNull MultipleVariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                // a before-statement example\n                int a = 0, b = 0;\n                int n = 0, m = 0; // an end-of-line example\n            }\n        ", (String)"\n            class Test {\n                // a before-statement example\n                int a = 0;\n                int b = 0;\n                int n = 0;\n                int m = 0; // an end-of-line example\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blockCommentPreserved(@NotNull MultipleVariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int a = 0;\n\n                /**\n                 * An example minimum and maximum.\n                 */\n                private int max = Integer.MAX_VALUE, min = Integer.MIN_VALUE;\n            }\n        ", (String)"\n            class Test {\n                int a = 0;\n\n                /**\n                 * An example minimum and maximum.\n                 */\n                private int max = Integer.MAX_VALUE;\n                private int min = Integer.MIN_VALUE;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeNewlinesFromMultivariablePrefix(@NotNull MultipleVariableDeclarationsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    int a = 1,\n                        b = 2;\n                }\n            }\n        ", (String)"\n            class A {\n                {\n                    int a = 1;\n                    int b = 2;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

