/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.HiddenField;
import org.openrewrite.java.cleanup.HiddenFieldTest;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.HiddenFieldStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0017J)\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0012\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\u0018\u0010\u0017\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0018\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\b\u0010\u001f\u001a\u00020\u0003H\u0017J\b\u0010 \u001a\u00020\u0003H\u0017J\u0018\u0010!\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017J\u0018\u0010#\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017\u00a8\u0006$"}, d2={"Lorg/openrewrite/java/cleanup/HiddenFieldTest;", "Lorg/openrewrite/test/RewriteTest;", "constructorParameter", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "forLoops", "hiddenFieldStyle", "", "Lorg/openrewrite/style/NamedStyles;", "with", "Lkotlin/Function1;", "Lorg/openrewrite/java/style/HiddenFieldStyle;", "Lkotlin/ExtensionFunctionType;", "ignoreAbstractMethodParameters", "ignoreConstructorParameter", "ignoreEnums", "ignoreInterfaces", "ignoreStaticMethodsAndInitializers", "ignoreUnaffectedVariables", "ignoreVoidSettersAndChangeSettersThatReturnItsClass", "ignoreVoidSettersAndSettersThatReturnItsClass", "incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse", "incrementRenamedVariableNameUntilUnique", "lambdaWithTypedParameterHides", "methodBodyLocalVariable", "methodParameter", "nestedClasses", "renameHiddenFields", "renamesAbstractMethodParameters", "renamesSetters", "renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount", "updateJavaDocParamName", "rewrite-java-tck"})
public interface HiddenFieldTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @NotNull
    public List<NamedStyles> hiddenFieldStyle(@NotNull Function1<? super HiddenFieldStyle, HiddenFieldStyle> var1);

    @Test
    public void ignoreUnaffectedVariables();

    @Test
    public void renameHiddenFields();

    @Test
    public void constructorParameter(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void ignoreConstructorParameter(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void methodParameter();

    @Test
    public void methodBodyLocalVariable();

    @Test
    public void forLoops();

    @Test
    public void lambdaWithTypedParameterHides();

    @Test
    public void nestedClasses();

    @Test
    public void incrementRenamedVariableNameUntilUnique();

    @Test
    public void incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse();

    @Test
    public void ignoreEnums();

    @Test
    public void ignoreStaticMethodsAndInitializers();

    @Test
    public void ignoreInterfaces();

    @Test
    public void renamesSetters(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void ignoreVoidSettersAndChangeSettersThatReturnItsClass(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void ignoreVoidSettersAndSettersThatReturnItsClass(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void renamesAbstractMethodParameters();

    @Test
    public void ignoreAbstractMethodParameters(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void updateJavaDocParamName(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull HiddenFieldTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new HiddenField());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<NamedStyles> hiddenFieldStyle(@NotNull HiddenFieldTest this_, @NotNull Function1<? super HiddenFieldStyle, HiddenFieldStyle> with) {
            void $this$hiddenFieldStyle_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter(with, (String)"with");
            HiddenFieldStyle hiddenFieldStyle2 = Checkstyle.hiddenFieldStyle();
            Set set = SetsKt.emptySet();
            String string = "test";
            String string2 = "test";
            String string3 = "test";
            UUID uUID = Tree.randomId();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$hiddenFieldStyle_u24lambda_u2d0, (String)"this");
            HiddenFieldStyle hiddenFieldStyle3 = (HiddenFieldStyle)with.invoke((Object)$this$hiddenFieldStyle_u24lambda_u2d0);
            Collection collection = CollectionsKt.listOf((Object)hiddenFieldStyle3);
            Set set2 = set;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            UUID uUID2 = uUID;
            return CollectionsKt.listOf((Object)new NamedStyles(uUID2, string6, string5, string4, set2, collection));
        }

        public static /* synthetic */ List hiddenFieldStyle$default(HiddenFieldTest hiddenFieldTest, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hiddenFieldStyle");
            }
            if ((n & 1) != 0) {
                function1 = hiddenFieldStyle.1.INSTANCE;
            }
            return hiddenFieldTest.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)function1);
        }

        @Test
        public static void ignoreUnaffectedVariables(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private String field;\n            \n                public Test(String someField) {\n                }\n            \n                static void method(String someField) {\n                    String localVariable = someField;\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameHiddenFields(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class B {\n                protected int n2;\n                int n3;\n                private int n4;\n            }\n          "), Assertions.java((String)"\n            public class A extends B {\n                int n;\n                int n1;\n            \n                class C {\n                    public void method(int n) {\n                        int n1 = n;\n                    }\n                }\n            \n                static class D {\n                    public void method(int n) {\n                    }\n                }\n            }\n          ", (String)"\n            public class A extends B {\n                int n;\n                int n1;\n            \n                class C {\n                    public void method(int n2) {\n                        int n3 = n2;\n                    }\n                }\n            \n                static class D {\n                    public void method(int n) {\n                    }\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void constructorParameter(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                private String field;\n            \n                public A(String field) {\n                }\n            }\n          ", (String)"\n            public class A {\n                private String field;\n            \n                public A(String field1) {\n                }\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.constructorParameter$lambda-1(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void ignoreConstructorParameter(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                private String field;\n            \n                public A(String field) {\n                }\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.ignoreConstructorParameter$lambda-2(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void methodParameter(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                private String field;\n            \n                public void method(String field) {\n                }\n            }\n          ", (String)"\n            public class A {\n                private String field;\n            \n                public void method(String field1) {\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodBodyLocalVariable(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                private String field;\n            \n                public void method(String param) {\n                    String field = param;\n                }\n            }\n          ", (String)"\n            public class A {\n                private String field;\n            \n                public void method(String param) {\n                    String field1 = param;\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void forLoops(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                int n;\n            \n                public void standardForLoop() {\n                    for (int n = 0; n < 1; n++) {\n                        int x = n;\n                    }\n                }\n            \n                public void enhancedForLoop(int[] arr) {\n                    for (int n : arr) {\n                        int x = n;\n                    }\n                }\n            }\n          ", (String)"\n            public class A {\n                int n;\n            \n                public void standardForLoop() {\n                    for (int n1 = 0; n1 < 1; n1++) {\n                        int x = n1;\n                    }\n                }\n            \n                public void enhancedForLoop(int[] arr) {\n                    for (int n1 : arr) {\n                        int x = n1;\n                    }\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void lambdaWithTypedParameterHides(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.Arrays;\n            \n            public class A {\n                List<Integer> numbers = Arrays.asList(1, 2, 3);\n                Integer value = 0;\n                {\n                    numbers.forEach((Integer value) -> String.valueOf(value));\n                }\n            }\n          ", (String)"\n            import java.util.List;\n            import java.util.Arrays;\n            \n            public class A {\n                List<Integer> numbers = Arrays.asList(1, 2, 3);\n                Integer value = 0;\n                {\n                    numbers.forEach((Integer value1) -> String.valueOf(value1));\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nestedClasses(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Outer {\n                int outer;\n            \n                public class Inner {\n                    int inner;\n            \n                    public Inner() {\n                        int inner = 0;\n                    }\n            \n                    public Inner(int inner) {\n                    }\n            \n                    public void method() {\n                        int outer = 0;\n                    }\n                }\n            }\n          ", (String)"\n            public class Outer {\n                int outer;\n            \n                public class Inner {\n                    int inner;\n            \n                    public Inner() {\n                        int inner1 = 0;\n                    }\n            \n                    public Inner(int inner) {\n                    }\n            \n                    public void method() {\n                        int outer1 = 0;\n                    }\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void incrementRenamedVariableNameUntilUnique(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                int n, n1;\n            \n                public void method(int n) {\n                    int n1 = 0;\n                }\n            }\n          ", (String)"\n            public class A {\n                int n, n1;\n            \n                public void method(int n2) {\n                    int n3 = 0;\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                int n, n1;\n            \n                public void method(int n) {\n                    int n2 = 0;\n                }\n            }\n          ", (String)"\n            public class A {\n                int n, n1;\n            \n                public void method(int n3) {\n                    int n2 = 0;\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreEnums(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum ExampleEnum {\n                A(0),\n                B(1),\n                C(2) {\n                    int hidden;\n            \n                    public void method() {\n                        int hidden = 0;\n                    }\n                };\n            \n                int hidden;\n                static int hiddenStatic;\n            \n                ExampleEnum(int hidden) {\n                }\n            \n                public void method() {\n                    int hidden = 0;\n                }\n            \n                public static void methodStatic() {\n                    int hiddenStatic = 0;\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreStaticMethodsAndInitializers(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class StaticMethods {\n                private int notHidden;\n            \n                public static void method() {\n                    // local variables of static methods don't hide instance fields.\n                    int notHidden;\n                }\n            \n                static {\n                    // local variables of static initializers don't hide instance fields.\n                    int notHidden;\n                }\n            \n                private int x;\n                private static int y;\n            \n                static class Inner {\n                    void useX(int x) {\n                        x++;\n                    }\n            \n                    void useY(int y) {\n                        y++;\n                    }\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreInterfaces(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            interface A {\n                int n = 0;\n            \n                void method(int n);\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamesSetters(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                int n;\n            \n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n            \n            class B {\n                int n;\n            \n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n          ", (String)"\n            class A {\n                int n;\n            \n                public void setN(int n1) {\n                    this.n = n1;\n                }\n            }\n            \n            class B {\n                int n;\n            \n                public B setN(int n1) {\n                    this.n = n1;\n                    return this;\n                }\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.renamesSetters$lambda-3(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void ignoreVoidSettersAndChangeSettersThatReturnItsClass(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                int n;\n            \n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n            \n            class B {\n                int n;\n            \n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n          ", (String)"\n            class A {\n                int n;\n            \n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n            \n            class B {\n                int n;\n            \n                public B setN(int n1) {\n                    this.n = n1;\n                    return this;\n                }\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.ignoreVoidSettersAndChangeSettersThatReturnItsClass$lambda-4(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void ignoreVoidSettersAndSettersThatReturnItsClass(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                int n;\n            \n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n            \n            class B {\n                int n;\n            \n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.ignoreVoidSettersAndSettersThatReturnItsClass$lambda-5(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void renamesAbstractMethodParameters(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public abstract class A {\n                int n;\n            \n                public abstract void method(int n);\n            }\n          ", (String)"\n            public abstract class A {\n                int n;\n            \n                public abstract void method(int n1);\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreAbstractMethodParameters(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public abstract class A {\n                int n;\n            \n                public abstract void method(int n);\n            }\n          ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.ignoreAbstractMethodParameters$lambda-6(jp, this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void updateJavaDocParamName(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public abstract class A {\n                int n;\n            \n                /**\n                 * @param n rename param\n                 */\n                public abstract void method(int n);\n            }\n          ", (String)"\n            public abstract class A {\n                int n;\n            \n                /**\n                 * @param n1 rename param\n                 */\n                public abstract void method(int n1);\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount(@NotNull HiddenFieldTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class B {\n                protected Integer n2;\n                Integer n3;\n                private Integer n4;\n            }\n          "), Assertions.java((String)"\n            public class A extends B {\n                Integer n;\n                Integer n1;\n            \n                class C {\n                    public void method(Integer n) {\n                        Integer n1 = n;\n                    }\n                }\n            }\n          ", (String)"\n            public class A extends B {\n                Integer n;\n                Integer n1;\n            \n                class C {\n                    public void method(Integer n2) {\n                        Integer n3 = n2;\n                    }\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void constructorParameter$lambda-1(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)constructorParameter.1.1.INSTANCE))));
        }

        private static void ignoreConstructorParameter$lambda-2(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreConstructorParameter.1.1.INSTANCE))));
        }

        private static void renamesSetters$lambda-3(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)renamesSetters.1.1.INSTANCE))));
        }

        private static void ignoreVoidSettersAndChangeSettersThatReturnItsClass$lambda-4(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreVoidSettersAndChangeSettersThatReturnItsClass.1.1.INSTANCE))));
        }

        private static void ignoreVoidSettersAndSettersThatReturnItsClass$lambda-5(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreVoidSettersAndSettersThatReturnItsClass.1.1.INSTANCE))));
        }

        private static void ignoreAbstractMethodParameters$lambda-6(JavaParser.Builder $jp, HiddenFieldTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.parser((Parser.Builder)$jp.styles((Iterable)this$0.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreAbstractMethodParameters.1.1.INSTANCE))));
        }
    }
}

