/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public interface JavaTypeMappingTest {
    public JavaType.FullyQualified classType(String var1);

    default public JavaType.Parameterized goatType() {
        return Objects.requireNonNull(TypeUtils.asParameterized((JavaType)this.classType("org.openrewrite.java.JavaTypeGoat")));
    }

    default public JavaType.Method methodType(String methodName) {
        JavaType.Method type = this.goatType().getMethods().stream().filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new IllegalStateException("Expected to find matching method named " + methodName));
        Assertions.assertThat((String)type.getDeclaringType().toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat");
        return type;
    }

    default public JavaType firstMethodParameter(String methodName) {
        return (JavaType)this.methodType(methodName).getParameterTypes().get(0);
    }

    @Test
    default public void javaLangObjectHasNoSupertype() {
        Assertions.assertThat((Object)this.goatType().getSupertype().getSupertype()).isNull();
    }

    @Test
    default public void interfacesContainImplicitAbstractFlag() {
        JavaType.Class clazz = (JavaType.Class)this.firstMethodParameter("clazz");
        JavaType.Method methodType = this.methodType("clazz");
        Assertions.assertThat((Collection)clazz.getFlags()).contains((Object[])new Flag[]{Flag.Abstract});
        Assertions.assertThat((Collection)methodType.getFlags()).contains((Object[])new Flag[]{Flag.Abstract});
    }

    @Test
    default public void extendsJavaLangObject() {
        Assertions.assertThat((String)this.goatType().getSupertype().getFullyQualifiedName()).isEqualTo("java.lang.Object");
    }

    @Test
    default public void constructor() {
        JavaType.Method ctor = this.methodType("<constructor>");
        Assertions.assertThat((String)ctor.getDeclaringType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.JavaTypeGoat");
    }

    @Test
    default public void array() {
        JavaType.Array arr = (JavaType.Array)this.firstMethodParameter("array");
        Assertions.assertThat((Object)TypeUtils.asArray((JavaType)arr.getElemType())).isNotNull();
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)TypeUtils.asArray((JavaType)arr.getElemType()).getElemType()).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void className() {
        JavaType.Class clazz = (JavaType.Class)this.firstMethodParameter("clazz");
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)clazz).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void primitive() {
        JavaType.Primitive primitive = (JavaType.Primitive)this.firstMethodParameter("primitive");
        Assertions.assertThat((Comparable)primitive).isSameAs((Object)JavaType.Primitive.Int);
    }

    @Test
    default public void parameterized() {
        JavaType.Parameterized parameterized = (JavaType.Parameterized)this.firstMethodParameter("parameterized");
        Assertions.assertThat((String)parameterized.getType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)parameterized.getTypeParameters().get(0))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void generic() {
        JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)TypeUtils.asParameterized((JavaType)this.firstMethodParameter("generic")).getTypeParameters().get(0);
        Assertions.assertThat((String)generic.getName()).isEqualTo("?");
        Assertions.assertThat((Comparable)generic.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)generic.getBounds().get(0))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void genericContravariant() {
        JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)TypeUtils.asParameterized((JavaType)this.firstMethodParameter("genericContravariant")).getTypeParameters().get(0);
        Assertions.assertThat((String)generic.getName()).isEqualTo("?");
        Assertions.assertThat((Comparable)generic.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.CONTRAVARIANT);
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)generic.getBounds().get(0))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void genericMultipleBounds() {
        List typeParameters = this.goatType().getTypeParameters();
        JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)typeParameters.get(typeParameters.size() - 1);
        Assertions.assertThat((String)generic.getName()).isEqualTo("S");
        Assertions.assertThat((Comparable)generic.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)generic.getBounds().get(0))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)generic.getBounds().get(1))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void genericUnbounded() {
        JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)TypeUtils.asParameterized((JavaType)this.firstMethodParameter("genericUnbounded")).getTypeParameters().get(0);
        Assertions.assertThat((String)generic.getName()).isEqualTo("U");
        Assertions.assertThat((Comparable)generic.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.INVARIANT);
        Assertions.assertThat((List)generic.getBounds()).isEmpty();
    }

    @Test
    default public void genericRecursive() {
        JavaType.Parameterized param = (JavaType.Parameterized)this.firstMethodParameter("genericRecursive");
        JavaType typeParam = (JavaType)param.getTypeParameters().get(0);
        JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)typeParam;
        Assertions.assertThat((String)generic.getName()).isEqualTo("?");
        Assertions.assertThat((Comparable)generic.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
        Assertions.assertThat((Object)TypeUtils.asArray((JavaType)((JavaType)generic.getBounds().get(0)))).isNotNull();
        JavaType.GenericTypeVariable elemType = (JavaType.GenericTypeVariable)TypeUtils.asArray((JavaType)((JavaType)generic.getBounds().get(0))).getElemType();
        Assertions.assertThat((String)elemType.getName()).isEqualTo("U");
        Assertions.assertThat((Comparable)elemType.getVariance()).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
        Assertions.assertThat((List)elemType.getBounds()).hasSize(1);
    }

    @Test
    default public void genericArray() {
        JavaType.Array arr = (JavaType.Array)this.firstMethodParameter("genericArray");
        JavaType.Parameterized parameterized = (JavaType.Parameterized)arr.getElemType();
        Assertions.assertThat((Object)parameterized).isNotNull();
        Assertions.assertThat((String)parameterized.getType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
        Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)parameterized.getTypeParameters().get(0))).getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
    }

    @Test
    default public void innerClass() {
        JavaType.FullyQualified clazz = TypeUtils.asFullyQualified((JavaType)this.firstMethodParameter("inner"));
        Assertions.assertThat((String)clazz.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C$Inner");
    }

    @Test
    default public void inheritedJavaTypeGoat() {
        JavaType.Parameterized clazz = (JavaType.Parameterized)this.firstMethodParameter("inheritedJavaTypeGoat");
        Assertions.assertThat((String)((JavaType)clazz.getTypeParameters().get(0)).toString()).isEqualTo("Generic{T}");
        Assertions.assertThat((String)((JavaType)clazz.getTypeParameters().get(1)).toString()).isEqualTo("Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}");
        Assertions.assertThat((String)clazz.toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$InheritedJavaTypeGoat<Generic{T}, Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}>");
    }

    @Test
    default public void genericIntersectionType() {
        JavaType.GenericTypeVariable clazz = (JavaType.GenericTypeVariable)this.firstMethodParameter("genericIntersection");
        Assertions.assertThat((String)((JavaType)clazz.getBounds().get(0)).toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$TypeA");
        Assertions.assertThat((String)((JavaType)clazz.getBounds().get(1)).toString()).isEqualTo("org.openrewrite.java.PT<Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.C}>");
        Assertions.assertThat((String)((JavaType)clazz.getBounds().get(2)).toString()).isEqualTo("org.openrewrite.java.C");
        Assertions.assertThat((String)clazz.toString()).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}");
    }

    @Test
    default public void enumTypeA() {
        JavaType.Class clazz = (JavaType.Class)this.firstMethodParameter("enumTypeA");
        JavaType.Method type = clazz.getMethods().stream().filter(m -> m.getName().equals("<constructor>")).findFirst().get();
        Assertions.assertThat((String)type.toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$EnumTypeA{name=<constructor>,return=org.openrewrite.java.JavaTypeGoat$EnumTypeA,parameters=[]}");
        JavaType.FullyQualified supertype = clazz.getSupertype();
        Assertions.assertThat((Object)supertype).isNotNull();
        Assertions.assertThat((String)supertype.toString()).isEqualTo("java.lang.Enum<org.openrewrite.java.JavaTypeGoat$EnumTypeA>");
    }

    @Test
    default public void enumTypeB() {
        JavaType.Class clazz = (JavaType.Class)this.firstMethodParameter("enumTypeB");
        JavaType.Method type = clazz.getMethods().stream().filter(m -> m.getName().equals("<constructor>")).findFirst().get();
        Assertions.assertThat((String)type.toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$EnumTypeB{name=<constructor>,return=org.openrewrite.java.JavaTypeGoat$EnumTypeB,parameters=[org.openrewrite.java.JavaTypeGoat$TypeA]}");
        JavaType.FullyQualified supertype = clazz.getSupertype();
        Assertions.assertThat((Object)supertype).isNotNull();
        Assertions.assertThat((String)supertype.toString()).isEqualTo("java.lang.Enum<org.openrewrite.java.JavaTypeGoat$EnumTypeB>");
    }

    @Test
    default public void ignoreSourceRetentionAnnotations() {
        JavaType.Parameterized goat = this.goatType();
        Assertions.assertThat((int)goat.getAnnotations().size()).isEqualTo(1);
        Assertions.assertThat((String)((JavaType.FullyQualified)goat.getAnnotations().get(0)).getClassName()).isEqualTo("AnnotationWithRuntimeRetention");
        JavaType.Method clazzMethod = this.methodType("clazz");
        Assertions.assertThat((int)clazzMethod.getAnnotations().size()).isEqualTo(1);
        Assertions.assertThat((String)((JavaType.FullyQualified)clazzMethod.getAnnotations().get(0)).getClassName()).isEqualTo("AnnotationWithRuntimeRetention");
    }

    @Test
    default public void recursiveIntersection() {
        JavaType.GenericTypeVariable clazz = TypeUtils.asGeneric((JavaType)this.firstMethodParameter("recursiveIntersection"));
        Assertions.assertThat((String)clazz.toString()).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$Extension<Generic{U}> & org.openrewrite.java.Intersection<Generic{U}>}");
    }
}

