/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.RemoveUnusedPrivateFields;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/cleanup/RemoveUnusedPrivateFieldsTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotChangeFieldsOnClassWithNativeMethod", "doNotRemoveAnnotatedField", "doNotRemoveSerialVersionUid", "fieldIsUsed", "nameIsShadowed", "notPrivateField", "onlyRemoveUnusedNamedVariable", "removeUnusedPrivateField", "usedInClassScope", "rewrite-java-tck"})
public interface RemoveUnusedPrivateFieldsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotRemoveSerialVersionUid();

    @Test
    public void doNotRemoveAnnotatedField();

    @Test
    public void doNotChangeFieldsOnClassWithNativeMethod();

    @Test
    public void notPrivateField();

    @Test
    public void fieldIsUsed();

    @Test
    public void usedInClassScope();

    @Test
    public void removeUnusedPrivateField();

    @Test
    public void nameIsShadowed();

    @Test
    public void onlyRemoveUnusedNamedVariable();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RemoveUnusedPrivateFieldsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RemoveUnusedPrivateFields());
        }

        @Test
        public static void doNotRemoveSerialVersionUid(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test implements java.io.Serializable {\n                private static final long serialVersionUID = 42L;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRemoveAnnotatedField(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @Deprecated\n                public String annotated;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeFieldsOnClassWithNativeMethod(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                public String notUsed;\n                public native void method();\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void notPrivateField(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                public String notUsed;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fieldIsUsed(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                private String value;\n                void method() {\n                    String useValue = value;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void usedInClassScope(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                private String value = \"\";\n                private String useValue = method(value);\n                String method(String arg0) {\n                    return arg0 + useValue;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeUnusedPrivateField(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                private String notUsed;\n            }\n            ", (String)"\n            public class Test {\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nameIsShadowed(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                public class Test {\n                    private String value;\n                    @SuppressWarnings({\"UnnecessaryLocalVariable\", \"RedundantSuppression\"})\n                    void method() {\n                        String value = \"name shadow\";\n                        String shadowedUse = value;\n                    }\n                }\n            ", (String)"\n                public class Test {\n                    @SuppressWarnings({\"UnnecessaryLocalVariable\", \"RedundantSuppression\"})\n                    void method() {\n                        String value = \"name shadow\";\n                        String shadowedUse = value;\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void onlyRemoveUnusedNamedVariable(@NotNull RemoveUnusedPrivateFieldsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                public class Test {\n                    private String aOne, aTwo, aThree;\n                    private String bOne, bTwo, bThree;\n                    private String cOne, cTwo, cThree;\n                    void method() {\n                        String removeAOne = aTwo + aThree;\n                        String removeBTwo = bOne + bThree;\n                        String removeCThree = cOne + cTwo;\n                    }\n                }\n            ", (String)"\n                public class Test {\n                    private String aTwo, aThree;\n                    private String bOne, bThree;\n                    private String cOne, cTwo;\n                    void method() {\n                        String removeAOne = aTwo + aThree;\n                        String removeBTwo = bOne + bThree;\n                        String removeCThree = cOne + cTwo;\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

