/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b/\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u0011\u001a\u00020\nH\u0017J\b\u0010\u0012\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u0014\u001a\u00020\nH\u0017J\b\u0010\u0015\u001a\u00020\nH\u0017J\b\u0010\u0016\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\u001a\u001a\u00020\nH\u0017J\b\u0010\u001b\u001a\u00020\nH\u0017J\u0018\u0010\u001c\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010 \u001a\u00020\nH\u0017J\b\u0010!\u001a\u00020\nH\u0017J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010%\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\b\u0010&\u001a\u00020\nH\u0017J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010+\u001a\u00020\nH\u0017J\b\u0010,\u001a\u00020\nH\u0017J\b\u0010-\u001a\u00020\nH\u0017J\b\u0010.\u001a\u00020\nH\u0017J\b\u0010/\u001a\u00020\nH\u0017J\u0010\u00100\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00102\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u00104\u001a\u00020\nH\u0017J\b\u00105\u001a\u00020\nH\u0017J\u0010\u00106\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00108\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u00109\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010:\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010;\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010<\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0018\u0010=\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0010\u0010>\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010?\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0018\u0010@\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0010\u0010A\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010B\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0018\u0010C\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0018\u0010D\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0018\u0010E\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0017J\u0010\u0010F\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010G\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010H\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010I\u001a\u00020\nH\u0017J\b\u0010J\u001a\u00020\nH\u0017J\b\u0010K\u001a\u00020\nH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006L"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/test/RewriteTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "replaceAnnotationRecipe", "Lorg/openrewrite/Recipe;", "getReplaceAnnotationRecipe", "()Lorg/openrewrite/Recipe;", "replaceToStringWithLiteralRecipe", "getReplaceToStringWithLiteralRecipe", "addClassAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addMethodAnnotations", "addVariableAnnotationsToVariableAlreadyAnnotated", "addVariableAnnotationsToVariableNotAnnotated", "afterStatementInBlock", "assignmentNotPartOfVariableDeclaration", "assignmentWithinIfPredicate", "beforeStatementInBlock", "chainedMethodInvocationsAsNewClassArgument", "chainedMethodInvocationsAsNewClassArgument2", "enumClassWithAnonymousInnerClassConstructor", "firstStatementInClassBlock", "firstStatementInMethodBlock", "innerEnumWithStaticMethod", "javaTemplateControlsSemiColons", "lambdaIsNewClass", "lambdaIsVariableInitializer", "Lorg/openrewrite/java/JavaParser$Builder;", "lastStatementInClassBlock", "lastStatementInMethodBlock", "methodDeclarationWithComment", "methodInvocationReplacementHasContextAboutLocalVariables", "replaceAndInterpolateMethodParameters", "replaceAnnotation", "replaceArguments", "replaceBody", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceExpressionWithAnotherExpression", "replaceFieldAccessWithMethodInvocation", "replaceForEachControlIterator", "replaceForEachControlVariable", "replaceIdentifierWithMethodInvocation", "replaceLambdaParameters", "replaceLambdaWithMethodReference", "replaceMethod", "replaceMethodAnnotations", "replaceMethodDeclarationAnnotation", "replaceMethodDeclarationVariableDeclarationAnnotation", "replaceMethodInvocationWithArray", "replaceMethodInvocationWithMethodReference", "replaceMethodNameAndArgumentsSimultaneously", "replaceMethodParameters", "replaceMethodParametersVariadicArray", "replaceMethodTypeParameters", "replaceMissingBody", "replaceNamedVariableInitializerMethodInvocation", "replacePackage", "replaceSingleExpressionInLambdaBody", "replaceSingleExpressionInLambdaBodyWithExpression", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementInLambdaBodyMultiStatementBlock", "replaceStatementInLambdaBodySingleStatementBlock", "replaceStatementInLambdaBodyWithVariableDeclaredInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "replaceVariableDeclarationAnnotation", "templateStatementIsWithinTryWithResourcesBlock", "templatingWhileLoopCondition", "rewrite-java-tck"})
public interface JavaTemplateTest
extends RewriteTest,
JavaRecipeTest {
    @NotNull
    public Recipe getReplaceToStringWithLiteralRecipe();

    @Test
    public void templateStatementIsWithinTryWithResourcesBlock();

    @Test
    public void replaceIdentifierWithMethodInvocation();

    @Test
    public void replaceExpressionWithAnotherExpression();

    @Test
    public void replaceFieldAccessWithMethodInvocation();

    @Test
    public void methodInvocationReplacementHasContextAboutLocalVariables();

    @Test
    public void innerEnumWithStaticMethod(@NotNull JavaParser var1);

    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInLambdaBodySingleStatementBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceStatementInLambdaBodyWithVariableDeclaredInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceStatementInLambdaBodyMultiStatementBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceSingleExpressionInLambdaBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceSingleExpressionInLambdaBodyWithExpression(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMethodNameAndArgumentsSimultaneously(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithArray(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParametersVariadicArray(@NotNull JavaParser var1);

    @Test
    public void replaceAndInterpolateMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaParameters(@NotNull JavaParser var1);

    @Test
    public void replaceSingleStatement(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void afterStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void firstStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void firstStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void replaceStatementRequiringNewImport(@NotNull JavaParser var1);

    @Test
    public void replaceArguments(@NotNull JavaParser var1);

    @NotNull
    public Recipe getReplaceAnnotationRecipe();

    @Test
    public void replaceClassAnnotation();

    @Test
    public void replaceMethodDeclarationAnnotation();

    @Test
    public void replaceVariableDeclarationAnnotation();

    @Test
    public void replaceMethodDeclarationVariableDeclarationAnnotation();

    @Test
    public void replaceMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceVariableAnnotations(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaParser var1);

    @Test
    public void addMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void addClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceAnnotation(@NotNull JavaParser var1);

    @Test
    public void replaceClassImplements(@NotNull JavaParser var1);

    @Test
    public void replaceClassExtends(@NotNull JavaParser var1);

    @Test
    public void replaceThrows(@NotNull JavaParser var1);

    @Disabled
    @Test
    public void replaceMethodTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceClassTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMissingBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceNamedVariableInitializerMethodInvocation(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void lambdaIsVariableInitializer(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void methodDeclarationWithComment();

    @Test
    public void assignmentNotPartOfVariableDeclaration();

    @Test
    public void assignmentWithinIfPredicate();

    @Test
    public void lambdaIsNewClass();

    @Test
    public void replaceForEachControlVariable();

    @Test
    public void replaceForEachControlIterator();

    @Test
    public void chainedMethodInvocationsAsNewClassArgument();

    @Test
    public void chainedMethodInvocationsAsNewClassArgument2();

    @Test
    public void templatingWhileLoopCondition();

    @Test
    public void javaTemplateControlsSemiColons();

    @Test
    public void enumClassWithAnonymousInnerClassConstructor();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getReplaceToStringWithLiteralRecipe(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = RewriteTest.toRecipe(DefaultImpls::_get_replaceToStringWithLiteralRecipe_$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"toRecipe{object : JavaVi\u2026\n            }\n        }}");
            return recipe2;
        }

        @Test
        public static void templateStatementIsWithinTryWithResourcesBlock(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(templateStatementIsWithinTryWithResourcesBlock.1.INSTANCE), null, "\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        new ByteArrayInputStream(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ", null, "\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        createBis(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void replaceIdentifierWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceIdentifierWithMethodInvocation.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f);\n                }\n            }\n        ", null, "\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f.getCanonicalFile().toPath());\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void replaceExpressionWithAnotherExpression(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceExpressionWithAnotherExpression.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            class Test {\n                void test(int i) {\n                    int n = +i;\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int i) {\n                    int n = i++;\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void replaceFieldAccessWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceFieldAccessWithMethodInvocation.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f);\n                }\n            }\n        ", null, "\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f.getCanonicalFile().toPath());\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void methodInvocationReplacementHasContextAboutLocalVariables(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(methodInvocationReplacementHasContextAboutLocalVariables.1.INSTANCE), null, "\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.clear();\n                }\n            }\n        ", null, "\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.add(\"jon\");\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void innerEnumWithStaticMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = this_.toRecipe(innerEnumWithStaticMethod.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A(type);\n                }\n            }\n        ", null, "\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A();\n                }\n            }\n        ", 0, 0, innerEnumWithStaticMethod.2.INSTANCE, null, 724, null);
        }

        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replacePackage.1.INSTANCE), null, "\n            package a;\n            class Test {\n            }\n        ", null, "\n            package b;\n            class Test {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethod.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                int test2(int n) {\n                    return n;\n                }\n            }\n        ", 0, 0, null, replaceMethod.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceLambdaWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaWithMethodReference.1.INSTANCE), null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = it -> it.toString();\n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodySingleStatementBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodySingleStatementBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 0;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 1;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodyWithVariableDeclaredInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodyWithVariableDeclaredInBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 0;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 1;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodyMultiStatementBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodyMultiStatementBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toLowerCase();\n                        return str;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toUpperCase();\n                        return str;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceSingleExpressionInLambdaBody.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toLowerCase().length() > 0);\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toUpperCase().length() > 0);\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBodyWithExpression(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceSingleExpressionInLambdaBodyWithExpression.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o.equals(Abc.A));\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o == Abc.A);\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethodNameAndArgumentsSimultaneously(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = this_.toRecipe(replaceMethodNameAndArgumentsSimultaneously.1.INSTANCE);
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                public class A {\n                    public A acceptInteger(Integer i) { return this; }\n                    public A acceptString(String s) { return this; }\n                    public A someOtherMethod() { return this; }\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptInteger(i)\n                            .someOtherMethod();\n                }\n            }\n        ", stringArray2, "\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptString(i.toString())\n                            .someOtherMethod();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void replaceMethodInvocationWithArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"package org.openrewrite;\npublic class Test {\n    public void method(int[] val) {}\n    public void method(int[] val1, String val2) {}\n}"};
            Recipe recipe3 = recipe2;
            recipe2 = this_.toRecipe(replaceMethodInvocationWithArray.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr, null);\n                }\n            }\n        ", (String[])recipe3, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr);\n                }\n            }\n        ", 0, 0, replaceMethodInvocationWithArray.2.INSTANCE, null, 708, null);
        }

        @Test
        public static void replaceMethodInvocationWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodInvocationWithMethodReference.1.INSTANCE), null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = getToString();\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParameters.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int m, java.util.List<String> n) {\n                    new Runnable() {\n                        void inner(int m, java.util.List<String> n) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParameters.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceMethodParametersVariadicArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParametersVariadicArray.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(Object[]... values) {\n                    new Runnable() {\n                        void inner(Object[]... values) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParametersVariadicArray.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceAndInterpolateMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceAndInterpolateMethodParameters.1.INSTANCE), null, "\n            class Test {\n                void test(String s) {\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int n, String s) {\n                }\n            }\n        ", 0, 0, null, replaceAndInterpolateMethodParameters.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaParameters.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceSingleStatement.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(beforeStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(afterStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void firstStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(firstStatementInClassBlock.1.INSTANCE), null, "\n            class Test {\n                // comment\n                int n;\n            }\n        ", null, "\n            class Test {\n                int m;\n                // comment\n                int n;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void firstStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(firstStatementInMethodBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    // comment\n                    int n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    int m = 0;\n                    // comment\n                    int n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInClassBlock.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            class Test {\n                int n;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInMethodBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceStatementRequiringNewImport.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceArguments.1.INSTANCE), null, "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test();\n                }\n            }\n        ", null, "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test(m, Integer.valueOf(n), \"foo\");\n                }\n            }\n        ", 0, 0, null, replaceArguments.2.INSTANCE, 468, null);
        }

        @NotNull
        public static Recipe getReplaceAnnotationRecipe(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = RewriteTest.toRecipe(DefaultImpls::_get_replaceAnnotationRecipe_$lambda-1);
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"toRecipe{object : JavaIs\u2026\n            }\n        }}");
            return recipe2;
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(\"ALL\") class Test {}", (String)"@Deprecated class Test {}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceClassAnnotation$lambda-2(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @SuppressWarnings(\"ALL\")\n                    void someTest() {}\n                }\n            ", (String)"\n                class A {\n                    @Deprecated\n                    void someTest() {}\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceMethodDeclarationAnnotation$lambda-3(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceVariableDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    @A1\n                    Object someObject;\n                }\n            ", (String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    @A2\n                    Object someObject;\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceVariableDeclarationAnnotation$lambda-4(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodDeclarationVariableDeclarationAnnotation(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    void someMethod(@A1 String a){}\n                }\n            ", (String)"\n                class A {\n                    @interface A1{}\n                    @interface A2{}\n                    \n                    void someMethod(@A2 String a){}\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceMethodDeclarationVariableDeclarationAnnotation$lambda-5(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodAnnotations.1.INSTANCE), null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotations.1.INSTANCE), null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceVariableAnnotations.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    // the m\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    // the m\n                    @SuppressWarnings(\"other\")\n                    int m;\n                    @SuppressWarnings(\"other\")\n                    final int n;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableAlreadyAnnotated.1.INSTANCE), null, "\n            class Test {\n                @SuppressWarnings(\"ALL\") private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\") /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                    @SuppressWarnings(\"ALL\") final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"ALL\")\n                @Deprecated\n                private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    int n;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableNotAnnotated.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    final int m;\n                    int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    final int m;\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addMethodAnnotations.1.INSTANCE), null, "\n            class Test {\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                void test1() {\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"other\")\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                @SuppressWarnings(\"other\")\n                void test1() {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addClassAnnotations.1.INSTANCE), null, "\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceAnnotation(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(new Function0<TreeVisitor<?, ExecutionContext>>(jp){
                final /* synthetic */ JavaParser $jp;
                {
                    this.$jp = $jp;
                    super(0);
                }

                @NotNull
                public final TreeVisitor<?, ExecutionContext> invoke() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(this.$jp){
                        private final JavaTemplate t;
                        {
                            this.t = JavaTemplate.builder(() -> replaceAnnotation.1.t$lambda-0(this), (String)"@Deprecated").javaParser(() -> replaceAnnotation.1.t$lambda-1($jp)).build();
                        }

                        public final JavaTemplate getT() {
                            return this.t;
                        }

                        @NotNull
                        public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                                J j = annotation2.withTemplate((SourceTemplate)this.t, annotation2.getCoordinates().replace(), new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                                return (J.Annotation)j;
                            }
                            return annotation2;
                        }

                        private static final Cursor t$lambda-0(replaceAnnotation.1 this$0) {
                            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                            return this$0.getCursor().getParentOrThrow();
                        }

                        private static final JavaParser t$lambda-1(JavaParser $jp) {
                            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
                            return $jp;
                        }
                    };
                }
            }), null, "\n            @SuppressWarnings(\"ALL\")\n            class Test {\n            }\n        ", null, "\n            @Deprecated\n            class Test {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassImplements.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassExtends.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceThrows.1.INSTANCE), null, "\n            class Test {\n                void test() {}\n            }\n        ", null, "\n            class Test {\n                void test() throws Exception {}\n            }\n        ", 0, 0, null, replaceThrows.2.INSTANCE, 468, null);
        }

        @Disabled
        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodTypeParameters.1.INSTANCE), null, "\n            import java.util.List;\n            \n            class Test {\n            \n                void test() {\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n            \n                <T, U> void test(List<T> t, U u) {\n                }\n            }\n        ", 0, 0, replaceMethodTypeParameters.2.INSTANCE, replaceMethodTypeParameters.3.INSTANCE, 212, null);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassTypeParameters.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            class Test<T, U> {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceBody.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMissingBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceMissingBody.1.INSTANCE), null, "\n            abstract class Test {\n                abstract void test();\n            }\n        ", null, "\n            abstract class Test {\n                void test(){\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceNamedVariableInitializerMethodInvocation(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceNamedVariableInitializerMethodInvocation.1.INSTANCE), null, "\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> Integer.valueOf(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return Integer.valueOf(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            Integer.valueOf(i);\n                        }\n                    }.toString();\n                }\n            }\n        ", null, "\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> new Integer(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return new Integer(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            new Integer(i);\n                        }\n                    }.toString();\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lambdaIsVariableInitializer(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(lambdaIsVariableInitializer.1.INSTANCE), null, "\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> Integer.valueOf(it);\n            }\n        ", null, "\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> new Integer(it);\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void methodDeclarationWithComment(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(methodDeclarationWithComment.1.INSTANCE), null, "\n            class A {\n            \n            }\n        ", null, "\n            class A {\n                /**\n                 * comment\n                 */\n                void foo() {\n                }\n\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void assignmentNotPartOfVariableDeclaration(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(assignmentNotPartOfVariableDeclaration.1.INSTANCE), null, "\n            class A {\n                void foo() {\n                    int i;\n                    i = Integer.valueOf(1);\n                }\n            }\n        ", null, "\n            class A {\n                void foo() {\n                    int i;\n                    i = 1;\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void assignmentWithinIfPredicate(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 1) == 0) {}\n                }\n            }\n        ", (String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 0) == 0) {}\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.assignmentWithinIfPredicate$lambda-6(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void lambdaIsNewClass(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = Integer.valueOf(1);\n                    }, \"hello\" );\n                }\n            }\n            ", (String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = 1;\n                    }, \"hello\" );\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.lambdaIsNewClass$lambda-7(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceForEachControlVariable(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            class T {\n                void m() {\n                    for (String s : new ArrayList<String>()) {}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            class T {\n                void m() {\n                    for (Object s : new ArrayList<String>()) {}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceForEachControlVariable$lambda-8(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void replaceForEachControlIterator(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            class T {\n                void m() {\n                    for (String s : new ArrayList<String>()) {}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            class T {\n                void m() {\n                    for (String s : Collections.emptyList()) {}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.replaceForEachControlIterator$lambda-9(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void chainedMethodInvocationsAsNewClassArgument(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            public class T {\n                void m(String arg) {\n                    U u = new U(arg.toString().toCharArray());\n                }\n                class U {\n                    U(char[] chars){}\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            public class T {\n                void m(String arg) {\n                    U u = new U(arg.toCharArray());\n                }\n                class U {\n                    U(char[] chars){}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.chainedMethodInvocationsAsNewClassArgument$lambda-10(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void chainedMethodInvocationsAsNewClassArgument2(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void m(String jsonPayload) {\n                    HttpEntity entity = new HttpEntity(jsonPayload.toString(), 0);\n                }\n                class HttpEntity {\n                    HttpEntity(String s, int i){}\n                }\n            }\n            ", (String)"\n            class T {\n                void m(String jsonPayload) {\n                    HttpEntity entity = new HttpEntity(jsonPayload, 0);\n                }\n                class HttpEntity {\n                    HttpEntity(String s, int i){}\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.chainedMethodInvocationsAsNewClassArgument2$lambda-11(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void templatingWhileLoopCondition(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            class T {\n                void m(List<?> l) {\n                    while (l.size() != 0) {}\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            class T {\n                void m(List<?> l) {\n                    while (!l.isEmpty()) {}\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.templatingWhileLoopCondition$lambda-12(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void javaTemplateControlsSemiColons(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                void m() {\n                    StringBuilder sb = new StringBuilder();\n                    sb.append((new BigDecimal(0).setScale(1, BigDecimal.ROUND_HALF_UP).doubleValue())).append(\"|\");\n                }\n            }\n        ", (String)"\n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                void m() {\n                    StringBuilder sb = new StringBuilder();\n                    sb.append((new BigDecimal(0).setScale(1, RoundingMode.HALF_UP).doubleValue())).append(\"|\");\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.javaTemplateControlsSemiColons$lambda-13(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void enumClassWithAnonymousInnerClassConstructor(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum MyEnum {\n                THING_ONE(new MyEnumThing() {\n                    @Override \n                    public String getName() {\n                        return \"Thing One\".toString();\n                    }\n                });\n                private final MyEnumThing enumThing;\n                MyEnum(MyEnumThing myEnumThing) {\n                    this.enumThing = myEnumThing;\n                }\n                interface MyEnumThing {\n                    String getName();\n                }\n            }\n            ", (String)"\n            enum MyEnum {\n                THING_ONE(new MyEnumThing() {\n                    @Override \n                    public String getName() {\n                        return \"Thing One\";\n                    }\n                });\n                private final MyEnumThing enumThing;\n                MyEnum(MyEnumThing myEnumThing) {\n                    this.enumThing = myEnumThing;\n                }\n                interface MyEnumThing {\n                    String getName();\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.enumClassWithAnonymousInnerClassConstructor$lambda-14(this_, arg_0), sourceSpecsArray);
        }

        @NotNull
        public static JavaParser getParser(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull JavaTemplateTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull JavaTemplateTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        private static TreeVisitor _get_replaceToStringWithLiteralRecipe_$lambda-0() {
            return (TreeVisitor)new JavaVisitor<ExecutionContext>(){
                @NotNull
                private MethodMatcher TO_STRING;
                private final JavaTemplate t;
                {
                    this.TO_STRING = new MethodMatcher("java.lang.String toString()");
                    this.t = JavaTemplate.builder(() -> replaceToStringWithLiteralRecipe.1.1.t$lambda-0(this), (String)"#{any(java.lang.String)}").build();
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method2, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J j = super.visitMethodInvocation(method2, (Object)ctx);
                    if (j == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J");
                    }
                    J mi = j;
                    if (mi instanceof J.MethodInvocation && this.TO_STRING.matches((J.MethodInvocation)mi)) {
                        Object[] objectArray = new Object[]{((J.MethodInvocation)mi).getSelect()};
                        J j2 = mi.withTemplate((SourceTemplate)this.t, ((J.MethodInvocation)mi).getCoordinates().replace(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j2, (String)"mi.withTemplate(t, mi.co\u2026tes.replace(), mi.select)");
                        return j2;
                    }
                    return mi;
                }

                private static final Cursor t$lambda-0(replaceToStringWithLiteralRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static TreeVisitor _get_replaceAnnotationRecipe_$lambda-1() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = JavaTemplate.builder(() -> replaceAnnotationRecipe.1.1.t$lambda-0(this), (String)"@Deprecated").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                        J j = annotation2.withTemplate((SourceTemplate)this.t, annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"A1")) {
                        J j = annotation2.withTemplate((SourceTemplate)JavaTemplate.builder(() -> replaceAnnotationRecipe.1.1.visitAnnotation$lambda-1(this), (String)"@A2").build(), annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(\u2026on.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    J.Annotation annotation3 = super.visitAnnotation(annotation2, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"super.visitAnnotation(annotation, p)");
                    return annotation3;
                }

                private static final Cursor t$lambda-0(replaceAnnotationRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }

                private static final Cursor visitAnnotation$lambda-1(replaceAnnotationRecipe.1.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor().getParentOrThrow();
                }
            };
        }

        private static void replaceClassAnnotation$lambda-2(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceMethodDeclarationAnnotation$lambda-3(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceVariableDeclarationAnnotation$lambda-4(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void replaceMethodDeclarationVariableDeclarationAnnotation$lambda-5(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceAnnotationRecipe());
        }

        private static void assignmentWithinIfPredicate$lambda-6(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(assignmentWithinIfPredicate.1.1.INSTANCE));
        }

        private static void lambdaIsNewClass$lambda-7(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(lambdaIsNewClass.1.1.INSTANCE));
        }

        private static void replaceForEachControlVariable$lambda-8(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(replaceForEachControlVariable.1.1.INSTANCE));
        }

        private static void replaceForEachControlIterator$lambda-9(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(replaceForEachControlIterator.1.1.INSTANCE));
        }

        private static void chainedMethodInvocationsAsNewClassArgument$lambda-10(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void chainedMethodInvocationsAsNewClassArgument2$lambda-11(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }

        private static void templatingWhileLoopCondition$lambda-12(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(templatingWhileLoopCondition.1.1.INSTANCE));
            spec.expectedCyclesThatMakeChanges(2);
        }

        private static void javaTemplateControlsSemiColons$lambda-13(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(javaTemplateControlsSemiColons.1.1.INSTANCE));
        }

        private static void enumClassWithAnonymousInnerClassConstructor$lambda-14(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.getReplaceToStringWithLiteralRecipe());
        }
    }
}

