/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b1\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\bf\u0018\u0000 J2\u00020\u0001:\u0001JJ\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\b\u0010\u001f\u001a\u00020\u0003H\u0017J\b\u0010 \u001a\u00020\u0003H\u0017J\b\u0010!\u001a\u00020\u0003H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017J\b\u0010#\u001a\u00020\u0003H\u0017J\b\u0010$\u001a\u00020\u0003H\u0017J\b\u0010%\u001a\u00020\u0003H\u0017J\b\u0010&\u001a\u00020\u0003H\u0017J\b\u0010'\u001a\u00020\u0003H\u0017J\b\u0010(\u001a\u00020\u0003H\u0017J\b\u0010)\u001a\u00020\u0003H\u0017J\b\u0010*\u001a\u00020\u0003H\u0017J\b\u0010+\u001a\u00020\u0003H\u0017J\b\u0010,\u001a\u00020\u0003H\u0017J\b\u0010-\u001a\u00020\u0003H\u0017J\b\u0010.\u001a\u00020\u0003H\u0017J\b\u0010/\u001a\u00020\u0003H\u0017J\b\u00100\u001a\u00020\u0003H\u0017J\b\u00101\u001a\u00020\u0003H\u0017J\b\u00102\u001a\u00020\u0003H\u0017J\b\u00103\u001a\u00020\u0003H\u0017J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000206052\u000e\b\u0001\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0002J\b\u0010:\u001a\u00020\u0003H\u0017J\b\u0010;\u001a\u00020\u0003H\u0017J\b\u0010<\u001a\u00020\u0003H\u0017J\b\u0010=\u001a\u00020\u0003H\u0017J\b\u0010>\u001a\u00020\u0003H\u0017J\b\u0010?\u001a\u00020\u0003H\u0017J\b\u0010@\u001a\u00020\u0003H\u0017J\b\u0010A\u001a\u00020\u0003H\u0017J\b\u0010B\u001a\u00020\u0003H\u0017J\b\u0010C\u001a\u00020\u0003H\u0017J\b\u0010D\u001a\u00020\u0003H\u0017J\b\u0010E\u001a\u00020\u0003H\u0017J\b\u0010F\u001a\u00020\u0003H\u0017J\b\u0010G\u001a\u00020\u0003H\u0017J\b\u0010H\u001a\u00020\u0003H\u0017J\b\u0010I\u001a\u00020\u0003H\u0017\u00a8\u0006K"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest;", "", "annotationEquality", "", "arrayAccess", "arrayType", "assert", "assignEquality", "assignment", "binary", "block", "breakNoLabel", "breakWithLabel", "caseStatement", "catch", "classDeclaration", "compilationUnit", "continueStatementNoLabel", "continueStatementWithLabel", "controlParentheses", "doWhile", "elseStatement", "empty", "enumValue", "enumValueSet", "fieldAccess", "fieldAccessEquality", "forEachControl", "forEachLoop", "forLoop", "forLoopControl", "fullyQualifiedReference", "identEquality", "identifier", "ifStatement", "import", "instanceOf", "label", "lambda", "literalEquality", "memberReference", "methodDeclaration", "methodInvocationAreEqual", "methodInvocationAreSemanticallyEqual", "multiCatch", "namedVariable", "newArray", "newClass", "noArgumentsTest", "packageStatement", "parameterizedType", "parentheses", "parseSources", "", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "sources", "", "", "primitive", "returnStatement", "switchStatement", "synchronized", "tagAnnotationEquality", "ternary", "throwsAreEqual", "throwsAreSemanticallyEqual", "tryResource", "tryStatement", "typeCast", "typeParameter", "unary", "variableDeclaration", "whileLoop", "wildCard", "Companion", "rewrite-java-tck"})
public interface SemanticallyEqualTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.SemanticallyEqualTest$Companion.$$INSTANCE;

    @Test
    public void fullyQualifiedReference();

    @Test
    public void noArgumentsTest();

    @Test
    public void tagAnnotationEquality();

    @Test
    public void annotationEquality();

    @Test
    public void identEquality();

    @Test
    public void fieldAccessEquality();

    @Test
    public void assignEquality();

    @Test
    public void arrayAccess();

    @Test
    public void arrayType();

    @Test
    public void assert();

    @Test
    public void assignment();

    @Test
    public void binary();

    @Test
    public void block();

    @Test
    public void breakNoLabel();

    @Test
    public void breakWithLabel();

    @Test
    public void caseStatement();

    @Test
    public void catch();

    @Test
    public void classDeclaration();

    @Test
    public void compilationUnit();

    @Test
    public void controlParentheses();

    @Test
    public void continueStatementNoLabel();

    @Test
    public void continueStatementWithLabel();

    @Test
    public void doWhile();

    @Test
    public void elseStatement();

    @Test
    public void empty();

    @Test
    public void enumValue();

    @Test
    public void enumValueSet();

    @Test
    public void fieldAccess();

    @Test
    public void forEachLoop();

    @Test
    public void forEachControl();

    @Test
    public void forLoop();

    @Test
    public void forLoopControl();

    @Test
    public void identifier();

    @Test
    public void ifStatement();

    @Test
    public void instanceOf();

    @Test
    public void import();

    @Test
    public void label();

    @Test
    public void lambda();

    @Test
    public void literalEquality();

    @Test
    public void memberReference();

    @Test
    public void methodDeclaration();

    @Test
    public void methodInvocationAreEqual();

    @Test
    public void methodInvocationAreSemanticallyEqual();

    @Test
    public void multiCatch();

    @Test
    public void newArray();

    @Test
    public void newClass();

    @Test
    public void packageStatement();

    @Test
    public void parameterizedType();

    @Test
    public void parentheses();

    @Test
    public void primitive();

    @Test
    public void returnStatement();

    @Test
    public void switchStatement();

    @Test
    public void synchronized();

    @Test
    public void ternary();

    @Test
    public void throwsAreEqual();

    @Test
    public void throwsAreSemanticallyEqual();

    @Test
    public void tryStatement();

    @Test
    public void tryResource();

    @Test
    public void typeCast();

    @Test
    public void typeParameter();

    @Test
    public void unary();

    @Test
    public void variableDeclaration();

    @Test
    public void namedVariable();

    @Test
    public void whileLoop();

    @Test
    public void wildCard();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest$Companion;", "", "()V", "annotInterface", "", "jp", "Lorg/openrewrite/java/JavaParser;", "getJp", "()Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final JavaParser jp;
        @NotNull
        private static final String annotInterface = "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        ";

        private Companion() {
        }

        @NotNull
        public final JavaParser getJp() {
            return jp;
        }

        static {
            $$INSTANCE = new Companion();
            JavaParser javaParser = JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion()\n      \u2026rue)\n            .build()");
            jp = javaParser;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        private static List<J.CompilationUnit> parseSources(SemanticallyEqualTest this_, @Language(value="java") String[] sources) {
            Companion.getJp().reset();
            List list = Companion.getJp().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::parseSources$lambda-0), Arrays.copyOf(sources, sources.length));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(InMemoryExecuti\u2026t -> fail(t) }, *sources)");
            return list;
        }

        @Test
        public static void fullyQualifiedReference(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                package org.mco.anno;\n                public @interface McAnno {}\n            ", "\n                import org.mco.anno.McAnno;\n                @McAnno\n                class M {}\n                @org.mco.anno.McAnno\n                class N {}\n            "};
            J.CompilationUnit cu = DefaultImpls.parseSources(this_, stringArray).get(1);
            J.Annotation c1Anno = (J.Annotation)((J.ClassDeclaration)cu.getClasses().get(0)).getLeadingAnnotations().get(0);
            J.Annotation c2Anno = (J.Annotation)((J.ClassDeclaration)cu.getClasses().get(1)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)c2Anno), (J)((J)c2Anno))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)c1Anno), (J)((J)c2Anno))).isTrue();
        }

        @Test
        public static void noArgumentsTest(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @NoArgAnnotation1\n                class A {}\n            ", "\n                @NoArgAnnotation1\n                class B {}\n            ", "\n                @NoArgAnnotation2\n                class C {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(0);
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isTrue();
            J.Annotation thirdAnnot = (J.Annotation)((J.ClassDeclaration)cus.get(2).getClasses().get(0)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)secondAnnot), (J)((J)thirdAnnot))).isFalse();
        }

        @Test
        public static void tagAnnotationEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @Tag(FastTests.class)\n                @Tag(FastTests.class)\n                @Tag(SlowTests.class)\n                class A {}\n            ", "\n                @interface Tags {\n                    Tag[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Tags.class)\n                @interface Tag {\n                    Class value();\n                }\n            ", "public interface FastTests {}", "public interface SlowTests {}"};
            J.ClassDeclaration clazz = (J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0);
            J.Annotation fastTest = (J.Annotation)clazz.getLeadingAnnotations().get(0);
            J.Annotation fastTest2 = (J.Annotation)clazz.getLeadingAnnotations().get(1);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)fastTest2))).isTrue();
            J.Annotation slowTest = (J.Annotation)clazz.getLeadingAnnotations().get(2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)slowTest))).isFalse();
        }

        @Test
        public static void annotationEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class A {}\n            ", "\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(0);
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isTrue();
        }

        @Test
        public static void identEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "\n                @MyAnnotation(value = true)\n                class B {}\n            ", "@interface MyAnnotation { boolean value(); }"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            NameTree firstIdent = ((J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(0)).getAnnotationType();
            NameTree secondIdent = ((J.Annotation)((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getLeadingAnnotations().get(0)).getAnnotationType();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)secondIdent))).isTrue();
            J.Identifier thirdIdent = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "YourAnnotation", JavaType.buildType((String)"YourAnnotation"), null);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)thirdIdent))).isFalse();
        }

        @Test
        public static void fieldAccessEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @Category(FastTest.class)\n                @Category(SlowTest.class)\n                class A {\n                }\n            ", "\n                @Category(FastTest.class)\n                @Category(SlowTest.class)\n                class B {\n                }\n            ", "\n                @interface Categories {\n                    Category[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Categories.class)\n                @interface Category {\n                    Class value();\n                }\n            ", "class FastTest {}", "class SlowTest {}"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            List list = ((J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Expression firstFieldAccess = (Expression)CollectionsKt.first((List)list);
            List list2 = ((J.Annotation)((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list2);
            Expression secondFieldAccess = (Expression)CollectionsKt.first((List)list2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)secondFieldAccess))).isTrue();
            List list3 = ((J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(1)).getArguments();
            Intrinsics.checkNotNull((Object)list3);
            Expression thirdFieldAccess = (Expression)CollectionsKt.first((List)list3);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)thirdFieldAccess))).isFalse();
        }

        @Test
        public static void assignEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "\n                @MyAnnotation(value = true)\n                class B {}\n            ", "@interface MyAnnotation { boolean value(); }"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            List list = ((J.Annotation)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Object object = CollectionsKt.first((List)list);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assignment");
            }
            J.Assignment firstAssign = (J.Assignment)object;
            List list2 = ((J.Annotation)((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getLeadingAnnotations().get(0)).getArguments();
            Intrinsics.checkNotNull((Object)list2);
            Object object2 = CollectionsKt.first((List)list2);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assignment");
            }
            J.Assignment secondAssign = (J.Assignment)object2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)secondAssign))).isTrue();
            Expression expression = secondAssign.getVariable();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            }
            J.Assignment thirdAssign = secondAssign.withVariable((Expression)((J.Identifier)expression).withSimpleName("otherValue"));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)thirdAssign))).isFalse();
            Expression expression2 = secondAssign.getAssignment();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Assignment fourthAssign = secondAssign.withAssignment((Expression)((J.Literal)expression2).withValue((Object)false));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)fourthAssign))).isFalse();
        }

        @Test
        public static void arrayAccess(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(String s) {\n                        int n[] = new int[] {0};\n                        int m = n[0];\n                    }\n                    void isEqual(String s) {\n                        int n[] = new int[] {0};\n                        int m = n[0];\n                    }\n                    void notEqual(String s) {\n                        int o[] = new int[] {0};\n                        int m = o[0];\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void arrayType(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    String[] original() {\n                        String[] s;\n                    }\n                    String[] isEqual() {\n                        return null;\n                    }\n                    Integer[] notEqual() {\n                        return null;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            TypeTree typeTree = ((J.MethodDeclaration)e).getReturnTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree);
            TypeTree original = typeTree;
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            TypeTree typeTree2 = ((J.MethodDeclaration)e2).getReturnTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree2);
            TypeTree isEqual = typeTree2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            TypeTree typeTree3 = ((J.MethodDeclaration)e3).getReturnTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree3);
            TypeTree notEqual = typeTree3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void assert(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(String s) {\n                        assert s != null;\n                    }\n                    void isEqual(String s) {\n                        assert s != null;\n                    }\n                    void notEqual(String s) {\n                        assert s == null;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assert");
            }
            J.Assert original = (J.Assert)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assert");
            }
            J.Assert isEqual = (J.Assert)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assert");
            }
            J.Assert notEqual = (J.Assert)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void assignment(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        String s;\n                        s = \"foo\";\n                    }\n                    void isEqual() {\n                        String s;\n                        s = \"foo\";\n                    }\n                    void notEqual() {\n                        String s;\n                        s = \"bar\";\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assignment");
            }
            J.Assignment original = (J.Assignment)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assignment");
            }
            J.Assignment isEqual = (J.Assignment)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assignment");
            }
            J.Assignment notEqual = (J.Assignment)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isTrue();
        }

        @Test
        public static void binary(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        int n = 0 + 1;\n                    }\n                    void isEqual() {\n                        int n = 0 + 1;\n                    }\n                    void notEqual() {\n                        int n = 1 + 1;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            }
            J.Binary original = (J.Binary)expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            }
            J.Binary isEqual = (J.Binary)expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            if (expression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            }
            J.Binary notEqual = (J.Binary)expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void block(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        int n = 0 + 1;\n                    }\n                    void isEqual() {\n                        int n = 0 + 1;\n                    }\n                    void notEqual() {\n                        int n = 1 + 1;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            J.Block original = block2;
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e2).getBody();
            Intrinsics.checkNotNull((Object)block3);
            J.Block isEqual = block3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block4);
            J.Block notEqual = block4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void breakNoLabel(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        while (true) {\n                            break;\n                        }\n                    }\n                    void isEqual() {\n                        while (true) {\n                            break;\n                        }\n                    }\n                    void notEqual() {\n                        labeled:\n                        while(true) {\n                            break labeled;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement = ((J.WhileLoop)e2).getBody();
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement original = (Statement)((J.Block)statement).getStatements().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement2 = ((J.WhileLoop)e4).getBody();
            if (statement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement isEqual = (Statement)((J.Block)statement2).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement3 = ((J.Label)e6).getStatement();
            if (statement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement4 = ((J.WhileLoop)statement3).getBody();
            if (statement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement notEqual = (Statement)((J.Block)statement4).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void breakWithLabel(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        labeled:\n                        while(true) {\n                            break labeled;\n                        }\n                    }\n                    void isEqual() {\n                        labeled:\n                        while(true) {\n                            break labeled;\n                        }\n                    }\n                    void notEqual() {\n                        while (true) {\n                            break;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement = ((J.Label)e2).getStatement();
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement2 = ((J.WhileLoop)statement).getBody();
            if (statement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement original = (Statement)((J.Block)statement2).getStatements().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement3 = ((J.Label)e4).getStatement();
            if (statement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement4 = ((J.WhileLoop)statement3).getBody();
            if (statement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement isEqual = (Statement)((J.Block)statement4).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            Statement statement5 = ((J.WhileLoop)e6).getBody();
            if (statement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement notEqual = (Statement)((J.Block)statement5).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void caseStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(String s) {\n                        switch (s) {\n                            case \"a\": {\n                                String statement = \"isEqual\";\n                                break;\n                            }\n                            default:\n                                break;\n                        }\n                    }\n                    void isEqual(String s) {\n                        switch (s) {\n                            case \"a\": {\n                                String\n                                    statement =\n                                    \"isEqual\";\n                                break;\n                            }\n                            default:\n                                break;\n                        }\n                    }\n                    void notEqual(String s) {\n                        switch (s) {\n                            case \"a\": {\n                                String\n                                    statement =\n                                    \"notEqual\";\n                                break;\n                            }\n                            default:\n                                break;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Switch");
            }
            Statement original = (Statement)((J.Switch)e2).getCases().getStatements().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Switch");
            }
            Statement isEqual = (Statement)((J.Switch)e4).getCases().getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Switch");
            }
            Statement notEqual = (Statement)((J.Switch)e6).getCases().getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isTrue();
        }

        @Test
        public static void catch(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(String s) {\n                        try {\n                        } catch (Exception e) {\n                            if (e instanceof IllegalStateException) {\n                                e.printStackTrace();\n                            }\n                        }\n                    }\n                    void isEqual(String s) {\n                        try {\n                        } catch (Exception e) {\n                            if (e instanceof IllegalStateException) {\n                                e.printStackTrace();\n                            }\n                        }\n                    }\n                    void notEqual(String s) {\n                        try {\n                        } catch (Exception e) {\n                            if (e instanceof IllegalArgumentException) {\n                                e.printStackTrace();\n                            }\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try.Catch original = (J.Try.Catch)((J.Try)e2).getCatches().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try.Catch isEqual = (J.Try.Catch)((J.Try)e4).getCatches().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try.Catch notEqual = (J.Try.Catch)((J.Try)e6).getCatches().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void classDeclaration(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"class A {}", "class B {}"};
            List<J.CompilationUnit> cus0 = DefaultImpls.parseSources(this_, stringArray);
            String[] stringArray2 = new String[]{"class A {}"};
            List<J.CompilationUnit> cus1 = DefaultImpls.parseSources(this_, stringArray2);
            J.ClassDeclaration original = (J.ClassDeclaration)cus0.get(0).getClasses().get(0);
            J.ClassDeclaration isEqual = (J.ClassDeclaration)cus1.get(0).getClasses().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            J.ClassDeclaration notEqual = (J.ClassDeclaration)cus0.get(1).getClasses().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void compilationUnit(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                package foo.bar;\n                \n                import java.util.ArrayList;\n                import java.util.List;\n                \n                class Test {\n                    List<String> s = new ArrayList<>();\n                }\n            "};
            J.CompilationUnit originalCu = DefaultImpls.parseSources(this_, stringArray).get(0);
            String[] stringArray2 = new String[]{"\n                package foo.bar;\n                \n                import java.util.ArrayList;\n                import java.util.List;\n                \n                class Test {\n                    List<String> s = new ArrayList<>();\n                }\n            "};
            J.CompilationUnit isEqualCu = DefaultImpls.parseSources(this_, stringArray2).get(0);
            String[] stringArray3 = new String[]{"\n                package foo.bar;\n                \n                import java.util.ArrayList;\n                import java.util.List;\n                \n                class NotEqual {\n                    List<String> s = new ArrayList<>();\n                }\n            "};
            J.CompilationUnit notEqualCu = DefaultImpls.parseSources(this_, stringArray3).get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)originalCu), (J)((J)isEqualCu))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)originalCu), (J)((J)notEqualCu))).isFalse();
        }

        @Test
        public static void controlParentheses(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(String s) {\n                        if (s.isEmpty()) {\n                        }\n                    }\n                    void isEqual(String s) {\n                        if (s.isEmpty()) {\n                        }\n                    }\n                    void notEqual(String s) {\n                        if (s == null) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.ControlParentheses original = ((J.If)e2).getIfCondition();
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.ControlParentheses isEqual = ((J.If)e4).getIfCondition();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.ControlParentheses notEqual = ((J.If)e6).getIfCondition();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void continueStatementNoLabel(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.ArrayList;\n                import java.util.List;\n                \n                class A {\n                    void original(List<String> strings) {\n                        for (String s : strings) {\n                            continue;\n                        }\n                    }\n                    void isEqual(List<String> strings) {\n                        for (String s : strings) {\n                            continue;\n                        }\n                    }\n                    void notEqual(List<String> strings) {\n                        outer:\n                        for (String s : strings) {\n                            continue outer;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement = ((J.ForEachLoop)e2).getBody();
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement original = (Statement)((J.Block)statement).getStatements().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement2 = ((J.ForEachLoop)e4).getBody();
            if (statement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement isEqual = (Statement)((J.Block)statement2).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement3 = ((J.Label)e6).getStatement();
            if (statement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement4 = ((J.ForEachLoop)statement3).getBody();
            if (statement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement notEqual = (Statement)((J.Block)statement4).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void continueStatementWithLabel(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                class A {\n                    void original(List<String> strings, List<String> contains) {\n                        equal:\n                        for (String s : strings) {\n                            for (String s2 : contains) {\n                                if (s.equals(\"\")) {\n                                    continue equal;\n                                }\n                            }\n                        }\n                    }\n                    void isEqual(List<String> strings, List<String> contains) {\n                        equal:\n                        for (String s : strings) {\n                            for (String s2 : contains) {\n                                if (s.equals(\"\")) {\n                                    continue equal;\n                                }\n                            }\n                        }\n                    }\n                    void notEqual(List<String> strings, List<String> contains) {\n                        other:\n                        for (String s : strings) {\n                            for (String s2 : contains) {\n                                if (s.equals(\"\")) {\n                                    continue other;\n                                }\n                            }\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement = ((J.Label)e2).getStatement();
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement2 = ((J.ForEachLoop)statement).getBody();
            if (statement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e3 = ((J.Block)statement2).getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement3 = ((J.ForEachLoop)e3).getBody();
            if (statement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e4 = ((J.Block)statement3).getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Statement statement4 = ((J.If)e4).getThenPart();
            if (statement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement original = (Statement)((J.Block)statement4).getStatements().get(0);
            Object e5 = body.getStatements().get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e6 = block3.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement5 = ((J.Label)e6).getStatement();
            if (statement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement6 = ((J.ForEachLoop)statement5).getBody();
            if (statement6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e7 = ((J.Block)statement6).getStatements().get(0);
            if (e7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement7 = ((J.ForEachLoop)e7).getBody();
            if (statement7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e8 = ((J.Block)statement7).getStatements().get(0);
            if (e8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Statement statement8 = ((J.If)e8).getThenPart();
            if (statement8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement isEqual = (Statement)((J.Block)statement8).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e9 = body.getStatements().get(2);
            if (e9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e9).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e10 = block4.getStatements().get(0);
            if (e10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement9 = ((J.Label)e10).getStatement();
            if (statement9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement10 = ((J.ForEachLoop)statement9).getBody();
            if (statement10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e11 = ((J.Block)statement10).getStatements().get(0);
            if (e11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            Statement statement11 = ((J.ForEachLoop)e11).getBody();
            if (statement11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Object e12 = ((J.Block)statement11).getStatements().get(0);
            if (e12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Statement statement12 = ((J.If)e12).getThenPart();
            if (statement12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block");
            }
            Statement notEqual = (Statement)((J.Block)statement12).getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void doWhile(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(int i) {\n                        do {\n                            i++;\n                        } while (i < 10);\n                    }\n                    void isEqual(int i) {\n                        do {\n                            i++;\n                        } while (i < 10);\n                    }\n                    void notEqual(int i) {\n                        do {\n                            i++;\n                        } while (i < 5);\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.DoWhileLoop");
            }
            J.DoWhileLoop original = (J.DoWhileLoop)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.DoWhileLoop");
            }
            J.DoWhileLoop isEqual = (J.DoWhileLoop)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.DoWhileLoop");
            }
            J.DoWhileLoop notEqual = (J.DoWhileLoop)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void elseStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(int i) {\n                        if (i == 0) {\n                        } else {\n                            i++;\n                        }\n                    }\n                    void isEqual(int i) {\n                        if (i == 0) {\n                        } else {\n                            i++;\n                        }\n                    }\n                    void notEqual(int i) {\n                        if (i == 0) {\n                        } else {\n                            i += 1;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If.Else else_ = ((J.If)e2).getElsePart();
            Intrinsics.checkNotNull((Object)else_);
            J.If.Else original = else_;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If.Else else_2 = ((J.If)e4).getElsePart();
            Intrinsics.checkNotNull((Object)else_2);
            J.If.Else isEqual = else_2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If.Else else_3 = ((J.If)e6).getElsePart();
            Intrinsics.checkNotNull((Object)else_3);
            J.If.Else notEqual = else_3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void empty(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        ;\n                    }\n                    void isEqual() {\n                        ;\n                    }\n                    void notEqual(int i) {\n                        i++;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Empty");
            }
            J.Empty original = (J.Empty)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Empty");
            }
            J.Empty isEqual = (J.Empty)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Unary");
            }
            J.Unary notEqual = (J.Unary)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void enumValue(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"public enum A { ONE }", "public enum B { ONE }"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            String[] stringArray2 = new String[]{"public enum A { ONE }"};
            List<J.CompilationUnit> cus1 = DefaultImpls.parseSources(this_, stringArray2);
            Object e = ((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValueSet");
            }
            Object e2 = ((J.EnumValueSet)e).getEnums().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValue");
            }
            J.EnumValue original = (J.EnumValue)e2;
            Object e3 = ((J.ClassDeclaration)cus1.get(0).getClasses().get(0)).getBody().getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValueSet");
            }
            Object e4 = ((J.EnumValueSet)e3).getEnums().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValue");
            }
            J.EnumValue isEqual = (J.EnumValue)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = ((J.ClassDeclaration)cus.get(1).getClasses().get(0)).getBody().getStatements().get(0);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValueSet");
            }
            Object e6 = ((J.EnumValueSet)e5).getEnums().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.EnumValue");
            }
            J.EnumValue notEqual = (J.EnumValue)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void enumValueSet(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"public enum A { ONE, TWO }", "public enum B { ONE, TWO }"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            String[] stringArray2 = new String[]{"public enum A { ONE, TWO }"};
            List<J.CompilationUnit> cus1 = DefaultImpls.parseSources(this_, stringArray2);
            Statement original = (Statement)((J.ClassDeclaration)cus.get(0).getClasses().get(0)).getBody().getStatements().get(0);
            Statement isEqual = (Statement)((J.ClassDeclaration)cus1.get(0).getClasses().get(0)).getBody().getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            J.ClassDeclaration notEqual = (J.ClassDeclaration)cus.get(1).getClasses().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void fieldAccess(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        int val = Inner.field0;\n                    }\n                    void isEqual() {\n                        int val = Inner.field0;\n                    }\n                    void notEqual() {\n                        int val = Inner.field1;\n                    }\n                    class Inner {\n                        public static final int field0 = 0;\n                        public static final int field1 = 0;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void forEachLoop(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                class Test {\n                    void original(List<String> strings) {\n                        for (String s : strings) {\n                        }\n                    }\n                    void isEqual(List<String> strings) {\n                        for (String s : strings) {\n                        }\n                    }\n                    void notEqual(List<String> strings) {\n                        for (String a : strings) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop original = (J.ForEachLoop)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop isEqual = (J.ForEachLoop)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop notEqual = (J.ForEachLoop)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void forEachControl(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                class Test {\n                    void original(List<String> strings) {\n                        for (String s : strings) {\n                        }\n                    }\n                    void isEqual(List<String> strings) {\n                        for (String s : strings) {\n                        }\n                    }\n                    void notEqual(List<String> strings) {\n                        for (String a : strings) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop.Control original = ((J.ForEachLoop)e2).getControl();
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop.Control isEqual = ((J.ForEachLoop)e4).getControl();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForEachLoop");
            }
            J.ForEachLoop.Control notEqual = ((J.ForEachLoop)e6).getControl();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void forLoop(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                class Test {\n                    void original(List<String> strings) {\n                        for (int i = 0; i < strings.size(); i++) {\n                        }\n                    }\n                    void isEqual(List<String> strings) {\n                        for (int i = 0; i < strings.size(); i++) {\n                        }\n                    }\n                    void notEqual(List<String> strings) {\n                        for (int j = 0; j < strings.size(); j++) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop original = (J.ForLoop)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop isEqual = (J.ForLoop)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop notEqual = (J.ForLoop)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void forLoopControl(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                class Test {\n                    void original(List<String> strings) {\n                        for (int i = 0; i < strings.size(); i++) {\n                        }\n                    }\n                    void isEqual(List<String> strings) {\n                        for (int i = 0; i < strings.size(); i++) {\n                        }\n                    }\n                    void notEqual(List<String> strings) {\n                        for (int j = 0; j < strings.size(); j++) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop.Control original = ((J.ForLoop)e2).getControl();
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop.Control isEqual = ((J.ForLoop)e4).getControl();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ForLoop");
            }
            J.ForLoop.Control notEqual = ((J.ForLoop)e6).getControl();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void identifier(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        int val;\n                    }\n                    void isEqual() {\n                        int val;\n                    }\n                    void notEqual() {\n                        int value;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.Identifier original = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getName();
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.Identifier isEqual = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getName();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.Identifier notEqual = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getName();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void ifStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        if (true) {}\n                    }\n                    void isEqual() {\n                        if (true) {}\n                    }\n                    void notEqual() {\n                        if (false) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If original = (J.If)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If isEqual = (J.If)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If notEqual = (J.If)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void instanceOf(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.Collection;\n                import java.util.List;\n                import java.util.Set;\n                \n                class Test {\n                    void original(Collection<String> strings) {\n                        if (strings instanceof List) {}\n                    }\n                    void isEqual(Collection<String> strings) {\n                        if (strings instanceof List) {}\n                    }\n                    void notEqual(Collection<String> strings) {\n                        if (strings instanceof Set) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Expression original = (Expression)((J.If)e2).getIfCondition().getTree();
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Expression isEqual = (Expression)((J.If)e4).getIfCondition().getTree();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            Expression notEqual = (Expression)((J.If)e6).getIfCondition().getTree();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void import(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                import java.util.ArrayList;\n            ", "import java.util.List;"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            J.Import original = (J.Import)cus.get(0).getImports().get(0);
            J.Import isEqual = (J.Import)cus.get(1).getImports().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            J.Import notEqual = (J.Import)cus.get(0).getImports().get(1);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void label(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.Collection;\n                \n                class Test {\n                    void original(Collection<String> strings) {\n                        label:\n                        for (String s : strings) {\n                            continue label;\n                        }\n                    }\n                    void isEqual(Collection<String> strings) {\n                        label:\n                        for (String s : strings) {\n                            continue label;\n                        }\n                    }\n                    void notEqual(Collection<String> strings) {\n                        diff:\n                        for (String s : strings) {\n                            continue diff;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            J.Label original = (J.Label)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            J.Label isEqual = (J.Label)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            J.Label notEqual = (J.Label)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void lambda(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.function.Function;\n                \n                class Test {\n                    void original() {\n                        Function<String, String> func = (String s) -> \"\";\n                    }\n                    void isEqual() {\n                        Function<String, String> func = (String s) -> \"\";\n                    }\n                    void notEqual() {\n                        Function<String, String> func = (String o) -> \"\";\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void literalEquality(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        int i = 0;\n                        String str = \"thisString\";\n                        String str2 = null;\n                    }\n                    void isEqual() {\n                        int i = 0;\n                        String str = \"thisString\";\n                        String str2 = null;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Statement intLiteral0 = (Statement)block2.getStatements().get(0);
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e2).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Statement intLiteral1 = (Statement)block3.getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)intLiteral0), (J)((J)intLiteral1)));
            Object e3 = body.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Statement strLiteral0 = (Statement)block4.getStatements().get(1);
            Object e4 = body.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block5 = ((J.MethodDeclaration)e4).getBody();
            Intrinsics.checkNotNull((Object)block5);
            Statement strLiteral1 = (Statement)block5.getStatements().get(1);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)strLiteral0), (J)((J)strLiteral1)));
            Object e5 = body.getStatements().get(0);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block6 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block6);
            Statement nullLiteral0 = (Statement)block6.getStatements().get(2);
            Object e6 = body.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block7 = ((J.MethodDeclaration)e6).getBody();
            Intrinsics.checkNotNull((Object)block7);
            Statement nullLiteral1 = (Statement)block7.getStatements().get(2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)nullLiteral0), (J)((J)nullLiteral1)));
        }

        @Test
        public static void memberReference(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    public static void func0(String s) {}\n                    public static void func1(String s) {}\n                }\n            ", "\n                import java.util.stream.Stream;\n\n                class Test {\n                    void original() {\n                        Stream.of(\"s\").forEach(A::func0);\n                    }\n                    void isEqual() {\n                        Stream.of(\"s\").forEach(A::func0);\n                    }\n                    void notEqual() {\n                        Stream.of(\"s\").forEach(A::func1);\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(1).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Expression original = (Expression)((J.MethodInvocation)e2).getArguments().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Expression isEqual = (Expression)((J.MethodInvocation)e4).getArguments().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Expression notEqual = (Expression)((J.MethodInvocation)e6).getArguments().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void methodDeclaration(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        String s = \"\";\n                    }\n                    void notEqual() {\n                        String s = \"notEqual\";\n                    }\n                }\n            "};
            J.Block body0 = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            String[] stringArray2 = new String[]{"\n                class Test {\n                    void original() {\n                        String s = \"\";\n                    }\n                }\n            "};
            J.Block body1 = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray2).get(0).getClasses().get(0)).getBody();
            Object e = body0.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration original = (J.MethodDeclaration)e;
            Object e2 = body1.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration isEqual = (J.MethodDeclaration)e2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body0.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration notEqual = (J.MethodDeclaration)e3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void methodInvocationAreEqual(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(Object o) {\n                        method(o);\n                    }\n                    void isEqual(Object o) {\n                        method(o);\n                    }\n                    void notEqual(Integer o) {\n                        method(o);\n                    }\n                    void method(Object o) {}\n                    void method(Integer o) {}\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation original = (J.MethodInvocation)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation isEqual = (J.MethodInvocation)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation notEqual = (J.MethodInvocation)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void methodInvocationAreSemanticallyEqual(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original(String o) {\n                        method(o);\n                    }\n                    void isEqual(Object o) {\n                        method(o);\n                    }\n                    void notEqual(Integer o) {\n                        method(o);\n                    }\n                    void method(Object o) {}\n                    void method(Integer o) {}\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation original = (J.MethodInvocation)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation isEqual = (J.MethodInvocation)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areSemanticallyEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation notEqual = (J.MethodInvocation)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areSemanticallyEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void multiCatch(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.io.File;\n                import java.io.FileInputStream;\n                import java.io.FileNotFoundException;\n                \n                class A {\n                    void original() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis = new FileInputStream(f)) {}\n                        catch (FileNotFoundException | RuntimeException e) {}\n                    }\n                    void isEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis = new FileInputStream(f)) {}\n                        catch (FileNotFoundException | RuntimeException e) {}\n                    }\n                    void notEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis = new FileInputStream(f)) {}\n                        catch (FileNotFoundException | NullPointerException e) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J j = ((J.Try.Catch)((J.Try)e2).getCatches().get(0)).getParameter().getTree();
            if (j == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree = ((J.VariableDeclarations)j).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree);
            TypeTree original = typeTree;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J j2 = ((J.Try.Catch)((J.Try)e4).getCatches().get(0)).getParameter().getTree();
            if (j2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree2 = ((J.VariableDeclarations)j2).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree2);
            TypeTree isEqual = typeTree2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J j3 = ((J.Try.Catch)((J.Try)e6).getCatches().get(0)).getParameter().getTree();
            if (j3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree3 = ((J.VariableDeclarations)j3).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree3);
            TypeTree notEqual = typeTree3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void newArray(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        int[] n = new int[0];\n                    }\n                    void isEqual() {\n                        int[] n = new int[0];\n                    }\n                    void notEqual() {\n                        long[] n = new long[0];\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void newClass(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.ArrayList;\n                import java.util.HashSet;\n                import java.util.List;\n                import java.util.Set;\n                \n                class A {\n                    void original() {\n                        List<String> l = new ArrayList<>();\n                    }\n                    void isEqual() {\n                        List<String> l = new ArrayList<>();\n                    }\n                    void notEqual() {\n                        Set<String> l = new HashSet<>();\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void packageStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"package foo;", "package foo;", "package bar;"};
            List<J.CompilationUnit> cus = DefaultImpls.parseSources(this_, stringArray);
            J.Package package_ = cus.get(0).getPackageDeclaration();
            if (package_ == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Package");
            }
            J.Package original = package_;
            J.Package package_2 = cus.get(1).getPackageDeclaration();
            if (package_2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Package");
            }
            J.Package isEqual = package_2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            J.Package package_3 = cus.get(2).getPackageDeclaration();
            if (package_3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Package");
            }
            J.Package notEqual = package_3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void parameterizedType(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.ArrayList;\n                import java.util.HashSet;\n                import java.util.List;\n                import java.util.Set;\n                \n                class A {\n                    void original() {\n                        List<String> l = new ArrayList<>();\n                    }\n                    void isEqual() {\n                        List<String> l = new ArrayList<>();\n                    }\n                    void notEqual() {\n                        Set<String> l = new HashSet<>();\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            TypeTree typeTree = ((J.NewClass)expression).getClazz();
            Intrinsics.checkNotNull((Object)typeTree);
            TypeTree original = typeTree;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            TypeTree typeTree2 = ((J.NewClass)expression2).getClazz();
            Intrinsics.checkNotNull((Object)typeTree2);
            TypeTree isEqual = typeTree2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            TypeTree typeTree3 = ((J.NewClass)expression3).getClazz();
            Intrinsics.checkNotNull((Object)typeTree3);
            TypeTree notEqual = typeTree3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void parentheses(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        int n = (0);\n                    }\n                    void isEqual() {\n                        int n = (0);\n                    }\n                    void notEqual() {\n                        int n = (1);\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void primitive(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        int n = 0;\n                    }\n                    void isEqual() {\n                        int n = 0;\n                    }\n                    void notEqual() {\n                        char c = 'c';\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree = ((J.VariableDeclarations)e2).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree);
            TypeTree original = typeTree;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree2 = ((J.VariableDeclarations)e4).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree2);
            TypeTree isEqual = typeTree2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree3 = ((J.VariableDeclarations)e6).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree3);
            TypeTree notEqual = typeTree3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void returnStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    int original() {\n                        return 0;\n                    }\n                    int isEqual() {\n                        return 0;\n                    }\n                    int notEqual() {\n                        return 1;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return original = (J.Return)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return isEqual = (J.Return)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return notEqual = (J.Return)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void switchStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(String s) {\n                        switch (s) {\n                            case \"a\": {\n                                String statement = \"isEqual\";\n                                break;\n                            }\n                            case \"b\": {\n                                String statement = \"isEqual\";\n                                break;\n                            }\n                            default:\n                                break;\n                        }\n                    }\n                    void isEqual(String s) {\n                        switch (s) {\n                            case \"a\": {\n                                String\n                                    statement =\n                                    \"isEqual\";\n                                break;\n                            }\n                            case \"b\": {\n                                String\n                                    statement =\n                                    \"isEqual\";\n                                break;\n                            }\n                            default:\n                                break;\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Statement switch0 = (Statement)block2.getStatements().get(0);
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e2).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Statement switch1 = (Statement)block3.getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)switch0), (J)((J)switch1))).isTrue();
        }

        @Test
        public static void synchronized(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        Integer n = 0;\n                        synchronized(n) {\n                        }\n                    }\n                    void isEqual() {\n                        Integer n = 0;\n                        synchronized(n) {\n                        }\n                    }\n                    void notEqual() {\n                        Integer m = 0;\n                        synchronized(m) {\n                        }\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Synchronized");
            }
            J.Synchronized original = (J.Synchronized)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Synchronized");
            }
            J.Synchronized isEqual = (J.Synchronized)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Synchronized");
            }
            J.Synchronized notEqual = (J.Synchronized)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void ternary(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(int n) {\n                        String evenOrOdd = n % 2 == 0 ? \"even\" : \"odd\";\n                    }\n                    void isEqual(int n) {\n                        String evenOrOdd = n % 2 == 0 ? \"even\" : \"odd\";\n                    }\n                    void notEqual(int n) {\n                        String evenOrOdd = n % 2 == 1 ? \"odd\" : \"even\";\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void throwsAreEqual(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        throw new RuntimeException();\n                    }\n                    void isEqual() {\n                        throw new RuntimeException();\n                    }\n                    void notEqual() {\n                        throw new IllegalStateException();\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw original = (J.Throw)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw isEqual = (J.Throw)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw notEqual = (J.Throw)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void throwsAreSemanticallyEqual(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original(IllegalStateException ex) {\n                        throw new RuntimeException(ex);\n                    }\n                    void isEqual(IllegalArgumentException ex) {\n                        throw new RuntimeException(ex);\n                    }\n                    void notEqual() {\n                        throw new RuntimeException();\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw original = (J.Throw)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw isEqual = (J.Throw)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areSemanticallyEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Throw");
            }
            J.Throw notEqual = (J.Throw)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areSemanticallyEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void tryStatement(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.io.File;\n                import java.io.FileInputStream;\n                import java.io.FileNotFoundException;\n                \n                class A {\n                    void original() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis0 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                    void isEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis0 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                    void notEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis1 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try original = (J.Try)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try isEqual = (J.Try)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try notEqual = (J.Try)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void tryResource(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.io.File;\n                import java.io.FileInputStream;\n                import java.io.FileNotFoundException;\n                \n                class A {\n                    void original() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis0 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                    void isEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis0 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                    void notEqual() {\n                        File f = new File(\"file.text\");\n                        try (FileInputStream fis1 = new FileInputStream(f)) {\n                        }\n                        catch (Exception e) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            List list = ((J.Try)e2).getResources();
            Intrinsics.checkNotNull((Object)list);
            J.Try.Resource original = (J.Try.Resource)list.get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            List list2 = ((J.Try)e4).getResources();
            Intrinsics.checkNotNull((Object)list2);
            J.Try.Resource isEqual = (J.Try.Resource)list2.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            List list3 = ((J.Try)e6).getResources();
            Intrinsics.checkNotNull((Object)list3);
            J.Try.Resource notEqual = (J.Try.Resource)list3.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void typeCast(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class A {\n                    void original() {\n                        Object o = (Class<String>) Class.forName(\"java.lang.String\");\n                    }\n                    void isEqual() {\n                        Object o = (Class<String>) Class.forName(\"java.lang.String\");\n                    }\n                    void notEqual() {\n                        Object o = (Class<Integer>) Class.forName(\"java.lang.Integer\");\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void typeParameter(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    class A<E extends Number> {}\n                    class B<E extends Number> {}\n                    class C<T> {}\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            List list = ((J.ClassDeclaration)e).getTypeParameters();
            Intrinsics.checkNotNull((Object)list);
            J.TypeParameter original = (J.TypeParameter)list.get(0);
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            List list2 = ((J.ClassDeclaration)e2).getTypeParameters();
            Intrinsics.checkNotNull((Object)list2);
            J.TypeParameter isEqual = (J.TypeParameter)list2.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            List list3 = ((J.ClassDeclaration)e3).getTypeParameters();
            Intrinsics.checkNotNull((Object)list3);
            J.TypeParameter notEqual = (J.TypeParameter)list3.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void unary(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        boolean b = !(1 == 2);\n                    }\n                    void isEqual() {\n                        boolean b = !(1 == 2);\n                    }\n                    void notEqual() {\n                        boolean b = !(2 == 2);\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression original = expression;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression2 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression2);
            Expression isEqual = expression2;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Expression expression3 = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression3);
            Expression notEqual = expression3;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void variableDeclaration(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        Integer i = 0;\n                    }\n                    void isEqual() {\n                        Integer i = 0;\n                    }\n                    void notEqual() {\n                        Integer k = 0;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Statement original = (Statement)block2.getStatements().get(0);
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e2).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Statement isEqual = (Statement)block3.getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Statement notEqual = (Statement)block4.getStatements().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void namedVariable(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        Integer i = 0;\n                    }\n                    void isEqual() {\n                        Integer i = 0;\n                    }\n                    void notEqual() {\n                        Integer k = 0;\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable original = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0);
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable isEqual = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e4).getVariables().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            J.VariableDeclarations.NamedVariable notEqual = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e6).getVariables().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void whileLoop(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                class Test {\n                    void original() {\n                        while (true) {}\n                    }\n                    void isEqual() {\n                        while (true) {}\n                    }\n                    void notEqual() {\n                        while (false) {}\n                    }\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop original = (J.WhileLoop)e2;
            Object e3 = body.getStatements().get(1);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block3 = ((J.MethodDeclaration)e3).getBody();
            Intrinsics.checkNotNull((Object)block3);
            Object e4 = block3.getStatements().get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop isEqual = (J.WhileLoop)e4;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e5 = body.getStatements().get(2);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block4 = ((J.MethodDeclaration)e5).getBody();
            Intrinsics.checkNotNull((Object)block4);
            Object e6 = block4.getStatements().get(0);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop notEqual = (J.WhileLoop)e6;
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isFalse();
        }

        @Test
        public static void wildCard(@NotNull SemanticallyEqualTest this_) {
            String[] stringArray = new String[]{"\n                import java.util.List;\n                \n                class Test {\n                    List<? extends B> original;\n                    List<? extends B> isEqual;\n                    List<? extends C> notEqual;\n                    interface B {}\n                    interface C {}\n                }\n            "};
            J.Block body = ((J.ClassDeclaration)DefaultImpls.parseSources(this_, stringArray).get(0).getClasses().get(0)).getBody();
            Object e = body.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree = ((J.VariableDeclarations)e).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree);
            List list = ((J.ParameterizedType)typeTree).getTypeParameters();
            Intrinsics.checkNotNull((Object)list);
            Expression original = (Expression)list.get(0);
            Object e2 = body.getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree2 = ((J.VariableDeclarations)e2).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree2);
            List list2 = ((J.ParameterizedType)typeTree2).getTypeParameters();
            Intrinsics.checkNotNull((Object)list2);
            Expression isEqual = (Expression)list2.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)isEqual))).isTrue();
            Object e3 = body.getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            TypeTree typeTree3 = ((J.VariableDeclarations)e3).getTypeExpression();
            Intrinsics.checkNotNull((Object)typeTree3);
            List list3 = ((J.ParameterizedType)typeTree3).getTypeParameters();
            Intrinsics.checkNotNull((Object)list3);
            Expression notEqual = (Expression)list3.get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)original), (J)((J)notEqual))).isTrue();
        }

        private static void parseSources$lambda-0(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }
    }
}

