/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.controlflow.ControlFlowVisualization;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b0\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\b\u0010\u001f\u001a\u00020\u0003H\u0017J\b\u0010 \u001a\u00020\u0003H\u0017J\b\u0010!\u001a\u00020\u0003H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017J\b\u0010#\u001a\u00020\u0003H\u0017J\b\u0010$\u001a\u00020\u0003H\u0017J\b\u0010%\u001a\u00020\u0003H\u0017J\b\u0010&\u001a\u00020\u0003H\u0017J\b\u0010'\u001a\u00020\u0003H\u0017J\b\u0010(\u001a\u00020\u0003H\u0017J\b\u0010)\u001a\u00020\u0003H\u0017J\b\u0010*\u001a\u00020\u0003H\u0017J\b\u0010+\u001a\u00020\u0003H\u0017J\b\u0010,\u001a\u00020\u0003H\u0017J\b\u0010-\u001a\u00020\u0003H\u0017J\b\u0010.\u001a\u00020\u0003H\u0017J\b\u0010/\u001a\u00020\u0003H\u0017J\b\u00100\u001a\u00020\u0003H\u0017J\b\u00101\u001a\u00020\u0003H\u0017J\b\u00102\u001a\u00020\u0003H\u0017J\b\u00103\u001a\u00020\u0003H\u0017J\b\u00104\u001a\u00020\u0003H\u0017J\b\u00105\u001a\u00020\u0003H\u0017J\b\u00106\u001a\u00020\u0003H\u0017J\b\u00107\u001a\u00020\u0003H\u0017J\b\u00108\u001a\u00020\u0003H\u0017J\b\u00109\u001a\u00020\u0003H\u0017J\b\u0010:\u001a\u00020\u0003H\u0017J\b\u0010;\u001a\u00020\u0003H\u0017J\b\u0010<\u001a\u00020\u0003H\u0017J\b\u0010=\u001a\u00020\u0003H\u0017J\b\u0010>\u001a\u00020\u0003H\u0017J\b\u0010?\u001a\u00020\u0003H\u0017\u00a8\u0006@"}, d2={"Lorg/openrewrite/java/controlflow/ControlFlowTest;", "Lorg/openrewrite/test/RewriteTest;", "a class declared inside a function", "", "a standalone boolean expression does not create a new basic block", "byte-buddy minimal replica", "control flow for != null", "control flow for init block", "control flow for try", "control flow for try with resources", "control flow for try with resources with catch and additional return", "control flow for try with return", "control flow graph for synchronized block", "decode url", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "display control flow graph for single basic block", "display control flow graph with dual branch", "display control flow graph with dual branch and statements afterwards", "display control flow graph with empty method signature", "display control flow graph with nested branch and statements afterwards", "do-while loop", "do-while loop with continue & break", "example code", "example image-ui-swing", "example imagej-ui-swing", "flow graph with branches with returns", "flow graph with branches with throws", "for each loop", "for each loop ending in return statement", "for each loop over new array", "for each loop with continue and break", "for i loop", "for i loop forever", "for i loop with continue and break", "for loop nested branching with continue", "for loop with continue then another conditional", "for loop with strange conditional", "identifies control flow with missing type information", "if method access in control", "if statement with && for boolean variable in control", "if statement with && in control", "if statement with OR in control", "if statement with multiple && in control", "if statement with negation for boolean variable in control", "if statement with negation in control", "if statement with return ending basic block", "if statement with wrapped parentheses in control", "if with JEmpty then", "if with JEmpty then and JEmpty else", "lambda foreach", "literal true", "objects print", "simple two branch exit condition", "ternary within the iterator for a for each loop", "throw an exception as an exit condition", "typecast", "while loop", "while loop ending in return", "while loop with continue & break", "while loop with no body and three conditionals", "while loop with no body one conditional", "while loop with no body two conditionals", "rewrite-java-tck"})
public interface ControlFlowTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void display control flow graph for single basic block();

    @Test
    public void control flow graph for synchronized block();

    @Test
    public void display control flow graph with dual branch();

    @Test
    public void display control flow graph with dual branch and statements afterwards();

    @Test
    public void display control flow graph with nested branch and statements afterwards();

    @Test
    public void flow graph with branches with returns();

    @Test
    public void flow graph with branches with throws();

    @Test
    public void display control flow graph with empty method signature();

    @Test
    public void if statement with return ending basic block();

    @Test
    public void if statement with && in control();

    @Test
    public void if statement with OR in control();

    @Test
    public void if statement with multiple && in control();

    @Test
    public void a standalone boolean expression does not create a new basic block();

    @Test
    public void if statement with && for boolean variable in control();

    @Test
    public void if statement with negation for boolean variable in control();

    @Test
    public void if statement with wrapped parentheses in control();

    @Test
    public void if method access in control();

    @Test
    public void if statement with negation in control();

    @Test
    public void while loop();

    @Test
    public void while loop with continue & break();

    @Test
    public void do-while loop();

    @Test
    public void do-while loop with continue & break();

    @Test
    public void for i loop();

    @Test
    public void for i loop with continue and break();

    @Test
    public void for i loop forever();

    @Test
    public void for each loop();

    @Test
    public void for loop nested branching with continue();

    @Test
    public void for each loop with continue and break();

    @Test
    public void for each loop over new array();

    @Test
    public void typecast();

    @Test
    public void throw an exception as an exit condition();

    @Test
    public void simple two branch exit condition();

    @Test
    public void literal true();

    @Test
    public void control flow for try with resources();

    @Test
    public void control flow for try with resources with catch and additional return();

    @Test
    public void control flow for try();

    @Test
    public void control flow for try with return();

    @Test
    public void control flow for init block();

    @Test
    public void control flow for != null();

    @Test
    public void decode url();

    @Test
    public void objects print();

    @Test
    public void identifies control flow with missing type information();

    @Test
    public void example code();

    @Test
    public void lambda foreach();

    @Test
    public void byte-buddy minimal replica();

    @Test
    public void while loop with no body one conditional();

    @Test
    public void while loop with no body two conditionals();

    @Test
    public void while loop with no body and three conditionals();

    @Test
    public void for loop with strange conditional();

    @Test
    public void example imagej-ui-swing();

    @Test
    public void a class declared inside a function();

    @Test
    public void for loop with continue then another conditional();

    @Test
    public void if with JEmpty then();

    @Test
    public void if with JEmpty then and JEmpty else();

    @Test
    public void example image-ui-swing();

    @Test
    public void while loop ending in return();

    @Test
    public void for each loop ending in return statement();

    @Test
    @Disabled(value="This test is broken")
    public void ternary within the iterator for a for each loop();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ControlFlowTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ControlFlowVisualization(false, false));
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        @Test
        public static void display control flow graph for single basic block(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                void test() {\n                    int x = start();\n                    x++;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow graph for synchronized block(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                private final Object lock = new Object();\n                abstract int start();\n                void test() {\n                    int x;\n                    synchronized (lock) {\n                        x = start();\n                        x++;\n                    }\n                    x--;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                private final Object lock = new Object();\n                abstract int start();\n                void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                    int x;\n                    synchronized (lock) {\n                        x = start();\n                        x++;\n                    }\n                    x--;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void display control flow graph with dual branch(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                void test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        int y = 3;\n                    } else {\n                        int y = 5;\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                void test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        int y = 3;\n                    } /*~~(3L)~~>*/else {\n                        int y = 5;\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void display control flow graph with dual branch and statements afterwards(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                void test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        int y = 3;\n                    } else {\n                        int y = 5;\n                    }\n                    x++;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                void test() /*~~(BB: 4 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        int y = 3;\n                    } /*~~(3L)~~>*/else {\n                        int y = 5;\n                    }\n                    /*~~(4L)~~>*/x++;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void display control flow graph with nested branch and statements afterwards(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                void test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        if (x == 1) {\n                            int y = 2;\n                        } else {\n                            int y = 5;\n                        }\n                    } else {\n                        int y = 5;\n                    }\n                    x++;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                void test() /*~~(BB: 6 CN: 2 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        if (/*~~(2C (==))~~>*/x == 1) /*~~(3L)~~>*/{\n                            int y = 2;\n                        } /*~~(4L)~~>*/else {\n                            int y = 5;\n                        }\n                    } /*~~(5L)~~>*/else {\n                        int y = 5;\n                    }\n                    /*~~(6L)~~>*/x++;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void flow graph with branches with returns(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        return 2;\n                    } else {\n                        return 5;\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        return 2;\n                    } /*~~(3L)~~>*/else {\n                        return 5;\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void flow graph with branches with throws(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        throw new RuntimeException();\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        throw new RuntimeException();\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void display control flow graph with empty method signature(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    //.. nop\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                    //.. nop\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with return ending basic block(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x == 1) {\n                        return 2;\n                    }\n                    x++;\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (==))~~>*/x == 1) /*~~(2L)~~>*/{\n                        return 2;\n                    }\n                    /*~~(3L)~~>*/x++;\n                    return 5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with && in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x >= 1 && x <= 2) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (>=))~~>*/x >= 1 && /*~~(2C (<=))~~>*//*~~(2L)~~>*/x <= 2) /*~~(3L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(4L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with OR in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x > 5 || x < 3) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (>))~~>*/x > 5 || /*~~(2C (<))~~>*//*~~(2L)~~>*/x < 3) /*~~(3L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(4L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with multiple && in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (x >= 1 && x <= 5 && x == 3) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 5 CN: 3 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C (>=))~~>*/x >= 1 && /*~~(2C (<=))~~>*//*~~(2L)~~>*/x <= 5 && /*~~(3C (==))~~>*//*~~(3L)~~>*/x == 3) /*~~(4L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(5L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void a standalone boolean expression does not create a new basic block(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    boolean b = x >= 1;\n                    if (b) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    boolean b = x >= 1;\n                    if (/*~~(1C)~~>*/b) /*~~(2L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with && for boolean variable in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                @SuppressWarnings({\"ExcessiveRangeCheck\", \"RedundantSuppression\"})\n                int test() {\n                    int x = start();\n                    x++;\n                    boolean b = x >= 1 && x <= 5 && x == 3;\n                    if (b) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                @SuppressWarnings({\"ExcessiveRangeCheck\", \"RedundantSuppression\"})\n                int test() /*~~(BB: 6 CN: 3 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    boolean /*~~(2L)~~>*/b = /*~~(1C (>=))~~>*/x >= 1 && /*~~(2C (<=))~~>*//*~~(3L)~~>*/x <= 5 && /*~~(4L)~~>*/x == 3;\n                    if (/*~~(3C)~~>*/b) /*~~(5L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(6L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with negation for boolean variable in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    boolean b = !(x >= 1);\n                    if (b) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    boolean b = !(x >= 1);\n                    if (/*~~(1C)~~>*/b) /*~~(2L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with wrapped parentheses in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    if ((x >= 1 && x <= 5)) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if ((/*~~(1C (>=))~~>*/x >= 1 && /*~~(2C (<=))~~>*//*~~(2L)~~>*/x <= 5)) /*~~(3L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(4L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if method access in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (theTest()) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (/*~~(1C)~~>*/theTest()) /*~~(2L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if statement with negation in control(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    if (!theTest()) {\n                        return 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    if (!/*~~(1C)~~>*/theTest()) /*~~(2L)~~>*/{\n                        return 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    while (theTest()) {\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 3 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    while (/*~~(1C)~~>*/theTest()) /*~~(2L)~~>*/{\n                        x += 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop with continue & break(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() {\n                    int x = start();\n                    x++;\n                    while (theTest()) {\n                        if (theTest2()) {\n                            continue;\n                        }\n                        if (theTest3()) {\n                            break;\n                        }\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() /*~~(BB: 7 CN: 3 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    while (/*~~(1C)~~>*/theTest()) /*~~(2L)~~>*/{\n                        if (/*~~(2C)~~>*/theTest2()) /*~~(3L)~~>*/{\n                            continue;\n                        }\n                        /*~~(4L)~~>*/if (/*~~(3C)~~>*/theTest3()) /*~~(5L)~~>*/{\n                            break;\n                        }\n                        /*~~(6L)~~>*/x += 2;\n                    }\n                    return /*~~(7L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void do-while loop(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    do {\n                        x += 2;\n                    } while (theTest());\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 3 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    do /*~~(2L)~~>*/{\n                        x += 2;\n                    } while (/*~~(1C)~~>*/theTest());\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void do-while loop with continue & break(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() {\n                    int x = start();\n                    x++;\n                    do {\n                        if (theTest2())\n                            continue;\n                        if (theTest3())\n                            break;\n                        x += 2;\n                    } while (theTest());\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() /*~~(BB: 7 CN: 3 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    do /*~~(2L)~~>*/{\n                        if (/*~~(2C)~~>*/theTest2())\n                            /*~~(3L)~~>*/continue;\n                        /*~~(4L)~~>*/if (/*~~(3C)~~>*/theTest3())\n                            /*~~(5L)~~>*/break;\n                        /*~~(6L)~~>*/x += 2;\n                    } while (/*~~(1C)~~>*/theTest());\n                    return /*~~(7L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for i loop(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (int i = 0; theTest(); i++) {\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 4 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (int i = 0; /*~~(1C)~~>*/theTest(); /*~~(2L)~~>*/i++) /*~~(3L)~~>*/{\n                        x += 2;\n                    }\n                    return /*~~(4L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for i loop with continue and break(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (int i = 0; theTest(); i++) {\n                        if (theTest2())\n                            continue;\n                        if (theTest3())\n                            break;\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                int test() /*~~(BB: 8 CN: 3 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (int i = 0; /*~~(1C)~~>*/theTest(); /*~~(2L)~~>*/i++) /*~~(3L)~~>*/{\n                        if (/*~~(2C)~~>*/theTest2())\n                            /*~~(4L)~~>*/continue;\n                        /*~~(5L)~~>*/if (/*~~(3C)~~>*/theTest3())\n                            /*~~(6L)~~>*/break;\n                        /*~~(7L)~~>*/x += 2;\n                    }\n                    return /*~~(8L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for i loop forever(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (;;) {\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                int test() /*~~(BB: 3 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (;;) /*~~(2L)~~>*/{\n                        x += 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for each loop(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract Iterable<Integer> iterable();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (Integer i : iterable()) {\n                        x += 2;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract Iterable<Integer> iterable();\n                int test() /*~~(BB: 3 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (Integer i : iterable()) /*~~(2L)~~>*/{\n                        x += 2;\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for loop nested branching with continue(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.LinkedList;\n\n            class Test {\n                public void test () {\n                    LinkedList<Integer> l1 = new LinkedList<>();\n                    int index = 1;\n                    for (int i = 0; i < l1.size(); i++)  {\n                        if (i > 5) {\n                            if (i * 2 < 50) {\n                                index += 1;\n                            } else {\n                                continue;\n                            }\n                        }\n                    }\n                }\n            }\n            ", (String)"\n            import java.util.LinkedList;\n\n            class Test {\n                public void test () /*~~(BB: 6 CN: 3 EX: 1 | 1L)~~>*/{\n                    LinkedList<Integer> l1 = new LinkedList<>();\n                    int index = 1;\n                    for (int i = 0; /*~~(1C (<))~~>*/i < l1.size(); /*~~(2L)~~>*/i++)  /*~~(3L)~~>*/{\n                        if (/*~~(2C (>))~~>*/i > 5) /*~~(4L)~~>*/{\n                            if (/*~~(3C (<))~~>*/i * 2 < 50) /*~~(5L)~~>*/{\n                                index += 1;\n                            } /*~~(6L)~~>*/else {\n                                continue;\n                            }\n                        }\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for each loop with continue and break(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                abstract Iterable<Integer> iterable();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (Integer i : iterable()) {\n                        if (theTest2())\n                            continue;\n                        if (theTest3())\n                            break;\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                abstract boolean theTest();\n                abstract boolean theTest2();\n                abstract boolean theTest3();\n                abstract Iterable<Integer> iterable();\n                int test() /*~~(BB: 6 CN: 3 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (Integer i : iterable()) /*~~(2L)~~>*/{\n                        if (/*~~(1C)~~>*/theTest2())\n                            /*~~(3L)~~>*/continue;\n                        /*~~(4L)~~>*/if (/*~~(2C)~~>*/theTest3())\n                            /*~~(5L)~~>*/break;\n                    }\n                    return /*~~(6L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for each loop over new array(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int start();\n                int test() {\n                    int x = start();\n                    x++;\n                    for (int i : new int[]{1, 2, 3, 5}) {\n                        System.out.println(i);\n                    }\n                    return 5;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract int start();\n                int test() /*~~(BB: 3 CN: 1 EX: 1 | 1L)~~>*/{\n                    int x = start();\n                    x++;\n                    for (int i : new int[]{1, 2, 3, 5}) /*~~(2L)~~>*/{\n                        System.out.println(i);\n                    }\n                    return /*~~(3L)~~>*/5;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typecast(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    int[] b = new int[1];\n                    char c = (char) b[0];\n                    if (1 == 1) {\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    } else {\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    String n = \"42\";\n                    int[] b = new int[1];\n                    char c = (char) b[0];\n                    if (/*~~(1C (==))~~>*/1 == 1) /*~~(2L)~~>*/{\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    } /*~~(3L)~~>*/else {\n                        System.out.println(n);\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void throw an exception as an exit condition(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() {\n                    if (guard()) {\n                        throw new RuntimeException();\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() /*~~(BB: 2 CN: 1 EX: 2 | 1L)~~>*/{\n                    if (/*~~(1C)~~>*/guard()) /*~~(2L)~~>*/{\n                        throw new RuntimeException();\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void simple two branch exit condition(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() {\n                    System.out.println(\"Hello!\");\n                    if (guard()) {\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() /*~~(BB: 2 CN: 1 EX: 2 | 1L)~~>*/{\n                    System.out.println(\"Hello!\");\n                    if (/*~~(1C)~~>*/guard()) /*~~(2L)~~>*/{\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void literal true(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    System.out.println(\"Hello!\");\n                    if (true) {\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() /*~~(BB: 2 CN: 1 EX: 2 | 1L)~~>*/{\n                    System.out.println(\"Hello!\");\n                    if (/*~~(1C)~~>*/true) /*~~(2L)~~>*/{\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for try with resources(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        try (InputStream source = source()) {\n                            System.out.println(source.read());\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{ return null; }\n                    void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        try (InputStream source = source()) {\n                            System.out.println(source.read());\n                        }\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for try with resources with catch and additional return(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    int test() {\n                        try (InputStream source = source()) {\n                            return source.read();\n                        } catch (RuntimeException ignored) {\n\n                        }\n                        return 0;\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{ return null; }\n                    int test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        try (InputStream source = source()) {\n                            return source.read();\n                        } catch (RuntimeException ignored) {\n\n                        }\n                        return 0;\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for try(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        InputStream source = source();\n                        try {\n                            System.out.println(source.read());\n                        } finally {\n                            source.close();\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{ return null; }\n                    void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        InputStream source = source();\n                        try {\n                            System.out.println(source.read());\n                        } finally {\n                            source.close();\n                        }\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for try with return(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    int test() {\n                        InputStream source = source();\n                        try {\n                            return source.read();\n                        } finally {\n                            source.close();\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{ return null; }\n                    int test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        InputStream source = source();\n                        try {\n                            return source.read();\n                        } finally {\n                            source.close();\n                        }\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for init block(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    {\n                        if (compute()) {\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                    static Boolean compute() {\n                        return null;\n                    }\n                }\n                ", (String)"\n                class Test {\n                    /*~~(BB: 2 CN: 1 EX: 2 | 1L)~~>*/{\n                        if (/*~~(1C)~~>*/compute()) /*~~(2L)~~>*/{\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                    static Boolean compute() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        return null;\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void control flow for != null(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        if (compute() != null) {\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                    static Object compute() {\n                        return null;\n                    }\n                }\n                ", (String)"\n                class Test {\n                    void test() /*~~(BB: 2 CN: 1 EX: 2 | 1L)~~>*/{\n                        if (/*~~(1C (!=))~~>*/compute() != null) /*~~(2L)~~>*/{\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                    static Object compute() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        return null;\n                    }\n                }\n                ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void decode url(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.lang.StringBuffer;\n                import java.nio.ByteBuffer;\n\n                class Test {\n                    /**\n                     * Decodes the specified URL as per RFC 3986, i.e. transforms\n                     * percent-encoded octets to characters by decoding with the UTF-8 character\n                     * set. This function is primarily intended for usage with\n                     * {@link java.net.URL} which unfortunately does not enforce proper URLs. As\n                     * such, this method will leniently accept invalid characters or malformed\n                     * percent-encoded octets and simply pass them literally through to the\n                     * result string. Except for rare edge cases, this will make unencoded URLs\n                     * pass through unaltered.\n                     *\n                     * @param url  The URL to decode, may be <code>null</code>.\n                     * @return The decoded URL or <code>null</code> if the input was\n                     *         <code>null</code>.\n                     */\n                    static String test(String url) {\n                        String decoded = url;\n                        if (url != null && url.indexOf('%') >= 0) {\n                            int n = url.length();\n                            StringBuffer buffer = new StringBuffer();\n                            ByteBuffer bytes = ByteBuffer.allocate(n);\n                            for (int i = 0; i < n;) {\n                                if (url.charAt(i) == '%') {\n                                    try {\n                                        do {\n                                            byte octet = (byte) Integer.parseInt(url.substring(i + 1, i + 3), 16);\n                                            bytes.put(octet);\n                                            i += 3;\n                                        } while (i < n && url.charAt(i) == '%');\n                                        continue;\n                                    } catch (RuntimeException e) {\n                                        // malformed percent-encoded octet, fall through and\n                                        // append characters literally\n                                    } finally {\n                                        if (bytes.position() > 0) {\n                                            bytes.flip();\n                                            buffer.append(utf8Decode(bytes));\n                                            bytes.clear();\n                                        }\n                                    }\n                                }\n                                buffer.append(url.charAt(i++));\n                            }\n                            decoded = buffer.toString();\n                        }\n                        return decoded;\n                    }\n\n                    private static String utf8Decode(ByteBuffer buff) {\n                        return null;\n                    }\n                }\n            ", (String)"\n            import java.lang.StringBuffer;\n            import java.nio.ByteBuffer;\n\n            class Test {\n                /**\n                 * Decodes the specified URL as per RFC 3986, i.e. transforms\n                 * percent-encoded octets to characters by decoding with the UTF-8 character\n                 * set. This function is primarily intended for usage with\n                 * {@link java.net.URL} which unfortunately does not enforce proper URLs. As\n                 * such, this method will leniently accept invalid characters or malformed\n                 * percent-encoded octets and simply pass them literally through to the\n                 * result string. Except for rare edge cases, this will make unencoded URLs\n                 * pass through unaltered.\n                 *\n                 * @param url  The URL to decode, may be <code>null</code>.\n                 * @return The decoded URL or <code>null</code> if the input was\n                 *         <code>null</code>.\n                 */\n                static String test(String url) /*~~(BB: 12 CN: 7 EX: 1 | 1L)~~>*/{\n                    String decoded = url;\n                    if (/*~~(1C (!=))~~>*/url != null && /*~~(2C (>=))~~>*//*~~(2L)~~>*/url.indexOf('%') >= 0) /*~~(3L)~~>*/{\n                        int n = url.length();\n                        StringBuffer buffer = new StringBuffer();\n                        ByteBuffer bytes = ByteBuffer.allocate(n);\n                        for (int i = 0; /*~~(3C (<))~~>*/i < n;) /*~~(4L)~~>*/{\n                            if (/*~~(4C (==))~~>*/url.charAt(i) == '%') /*~~(5L)~~>*/{\n                                try {\n                                    do /*~~(7L)~~>*/{\n                                        byte octet = (byte) Integer.parseInt(url.substring(i + 1, i + 3), 16);\n                                        bytes.put(octet);\n                                        i += 3;\n                                    } while (/*~~(5C (<))~~>*/i < n && /*~~(6C (==))~~>*//*~~(6L)~~>*/url.charAt(i) == '%');\n                                    /*~~(8L)~~>*/continue;\n                                } catch (RuntimeException e) {\n                                    // malformed percent-encoded octet, fall through and\n                                    // append characters literally\n                                } finally {\n                                    if (/*~~(7C (>))~~>*/bytes.position() > 0) /*~~(9L)~~>*/{\n                                        bytes.flip();\n                                        buffer.append(utf8Decode(bytes));\n                                        bytes.clear();\n                                    }\n                                }\n                            }\n                            /*~~(10L)~~>*/buffer.append(url.charAt(i++));\n                        }\n                        /*~~(11L)~~>*/decoded = buffer.toString();\n                    }\n                    return /*~~(12L)~~>*/decoded;\n                }\n\n                private static String utf8Decode(ByteBuffer buff) /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                    return null;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void objects print(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        Integer i = new Integer(1);\n                        System.out.println(i);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                        Integer i = new Integer(1);\n                        System.out.println(i);\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifies control flow with missing type information(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    if (potato) {\n                        // ...\n                    }\n                    if ((potato)) {\n                        // ...\n                    }\n                    if (potato && turnip) {\n                        // ...\n                    }\n                    if (potato && turnip || squash) {\n                        // ...\n                    }\n                    int a = 1, b = 2;\n                    if ((a = turnip) == b) {\n                        // ..\n                    }\n                    if (horse.equals(donkey)) {\n                        // ..\n                    }\n                    if (horse.contains(hay)) {\n                        // ..\n                    }\n                    boolean farmFresh = tomato;\n                    boolean farmFreshAndFancyFree = (chicken);\n                    boolean farmFreshEggs = true;\n                    farmFreshEggs = chicken.layEggs();\n                    while (farming) {\n                        // ...\n                    }\n                    for (int i = 0; areMoreCabbages(); i++) {\n                        // ...\n                    }\n                }\n            }\n            ", (String)"\n            class Test {\n                void test() /*~~(BB: 22 CN: 12 EX: 1 | 1L)~~>*/{\n                    if (/*~~(1C)~~>*/potato) /*~~(2L)~~>*/{\n                        // ...\n                    }\n                    /*~~(3L)~~>*/if ((/*~~(2C)~~>*/potato)) /*~~(4L)~~>*/{\n                        // ...\n                    }\n                    /*~~(5L)~~>*/if (/*~~(3C)~~>*/potato && /*~~(6L)~~>*/turnip) /*~~(7L)~~>*/{\n                        // ...\n                    }\n                    /*~~(8L)~~>*/if (/*~~(5C)~~>*/potato && /*~~(9L)~~>*/turnip || /*~~(10L)~~>*/squash) /*~~(11L)~~>*/{\n                        // ...\n                    }\n                    int a = /*~~(12L)~~>*/1, b = 2;\n                    if (/*~~(8C (==))~~>*/(a = turnip) == b) /*~~(13L)~~>*/{\n                        // ..\n                    }\n                    /*~~(14L)~~>*/if (/*~~(9C)~~>*/horse.equals(donkey)) /*~~(15L)~~>*/{\n                        // ..\n                    }\n                    /*~~(16L)~~>*/if (/*~~(10C)~~>*/horse.contains(hay)) /*~~(17L)~~>*/{\n                        // ..\n                    }\n                    boolean farmFresh = /*~~(18L)~~>*/tomato;\n                    boolean farmFreshAndFancyFree = (chicken);\n                    boolean farmFreshEggs = true;\n                    farmFreshEggs = chicken.layEggs();\n                    while (/*~~(11C)~~>*/farming) /*~~(19L)~~>*/{\n                        // ...\n                    }\n                    /*~~(20L)~~>*/for (int i = 0; /*~~(12C)~~>*/areMoreCabbages(); /*~~(21L)~~>*/i++) /*~~(22L)~~>*/{\n                        // ...\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::identifies_control_flow_with_missing_type_information$lambda-0, sourceSpecsArray);
        }

        @Test
        public static void example code(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            import java.io.FileOutputStream;\n            import java.io.IOException;\n            import java.io.InputStream;\n            import java.util.Enumeration;\n            import java.util.zip.ZipEntry;\n            import java.util.zip.ZipFile;\n\n            class Test {\n                void test(File destination, ZipEntry e, ZipFile zip) {\n                    File f = new File(destination, e.getName());\n                    if (!f.toPath().startsWith(destination.toPath())) {\n                        throw new IOException(\"Bad Zip Entry!\");\n                    }\n                    IOUtils.copy(\n                            zip.getInputStream(e),\n                            new FileOutputStream(f)\n                    );\n                }\n            }\n\n            class IOUtils {\n                static void copy(Object input, Object output) {\n                    //.. nop\n                }\n            }\n            ", (String)"\n            import java.io.File;\n            import java.io.FileOutputStream;\n            import java.io.IOException;\n            import java.io.InputStream;\n            import java.util.Enumeration;\n            import java.util.zip.ZipEntry;\n            import java.util.zip.ZipFile;\n\n            class Test {\n                void test(File destination, ZipEntry e, ZipFile zip) /*~~(BB: 3 CN: 1 EX: 2 | 1L)~~>*/{\n                    File f = new File(destination, e.getName());\n                    if (!/*~~(1C)~~>*/f.toPath().startsWith(destination.toPath())) /*~~(2L)~~>*/{\n                        throw new IOException(\"Bad Zip Entry!\");\n                    }\n                    /*~~(3L)~~>*/IOUtils.copy(\n                            zip.getInputStream(e),\n                            new FileOutputStream(f)\n                    );\n                }\n            }\n\n            class IOUtils {\n                static void copy(Object input, Object output) /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                    //.. nop\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void lambda foreach(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.LinkedList;\n            import java.util.stream.IntStream;\n            class Test{\n                int test() {\n                    LinkedList<Integer> x = new LinkedList<>();\n                    x.add(5);\n                    x.add(1);\n                    IntStream\n                        .range(0, x.size())\n                        .map( i -> {\n                            int y = x.get(i);\n                            return y++;\n                        })\n                        .forEach(ind -> {\n                            x.set(ind, x.get(ind) + 5);\n                            System.out.println(x.get(ind));\n                        });\n                    if (x.get(0) == 10) {\n                        return -1;\n                    }\n                    return x.get(0);\n                }\n            }\n\n            ", (String)"\n            import java.util.LinkedList;\n            import java.util.stream.IntStream;\n            class Test{\n                int test() /*~~(BB: 7 CN: 1 EX: 2 | 1L)~~>*/{\n                    LinkedList<Integer> x = new LinkedList<>();\n                    x.add(5);\n                    x.add(1);\n                    /*~~(2L)~~>*//*~~(3L)~~>*/IntStream\n                        .range(0, x.size())\n                        .map( i -> /*~~(4L)~~>*/{\n                            int y = x.get(i);\n                            return y++;\n                        })\n                        .forEach(ind -> /*~~(5L)~~>*/{\n                            x.set(ind, x.get(ind) + 5);\n                            System.out.println(x.get(ind));\n                        });\n                    if (/*~~(1C (==))~~>*/x.get(0) == 10) /*~~(6L)~~>*/{\n                        return -1;\n                    }\n                    return /*~~(7L)~~>*/x.get(0);\n                }\n            }\n\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void byte-buddy minimal replica(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.LinkedList;\n\n            class Test {\n                public void test () {\n                    LinkedList<Integer> l2 = new LinkedList<>();\n                    int index = 1;\n                    top:\n                    for (Integer j : l2) {\n                        for (Integer i : l1)  {\n                            if (i > 5) {\n                                break;\n                            }\n                        }\n                        if (i * 2 < 50) {\n                            index += 1;\n                        } else {\n                            continue top;\n                        }\n                    }\n                }\n            }\n            ", (String)"\n            import java.util.LinkedList;\n\n            class Test {\n                public void test () /*~~(BB: 7 CN: 4 EX: 1 | 1L)~~>*/{\n                    LinkedList<Integer> l2 = new LinkedList<>();\n                    int index = 1;\n                    top:\n                    for (Integer j : l2) /*~~(2L)~~>*/{\n                        for (Integer i : l1)  /*~~(3L)~~>*/{\n                            if (/*~~(1C (>))~~>*/i > 5) /*~~(4L)~~>*/{\n                                break;\n                            }\n                        }\n                        /*~~(5L)~~>*/if (/*~~(2C (<))~~>*/i * 2 < 50) /*~~(6L)~~>*/{\n                            index += 1;\n                        } /*~~(7L)~~>*/else {\n                            continue top;\n                        }\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop with no body one conditional(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean condition();\n\n                void test() {\n                    while (condition());\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean condition();\n\n                void test() /*~~(BB: 2 CN: 1 EX: 1 | 1L)~~>*/{\n                    while (/*~~(1C)~~>*/condition())/*~~(2L)~~>*/;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop with no body two conditionals(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean condition();\n                abstract boolean otherCondition();\n\n                void test() {\n                    while (condition() && otherCondition());\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean condition();\n                abstract boolean otherCondition();\n\n                void test() /*~~(BB: 3 CN: 2 EX: 1 | 1L)~~>*/{\n                    while (/*~~(1C)~~>*/condition() && /*~~(2L | 2C)~~>*/otherCondition())/*~~(3L)~~>*/;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop with no body and three conditionals(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean condition();\n                abstract boolean otherCondition();\n                abstract boolean thirdCondition();\n\n                void test() {\n                    while (condition() && otherCondition() && thirdCondition());\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean condition();\n                abstract boolean otherCondition();\n                abstract boolean thirdCondition();\n\n                void test() /*~~(BB: 4 CN: 3 EX: 1 | 1L)~~>*/{\n                    while (/*~~(1C)~~>*/condition() && /*~~(2L | 2C)~~>*/otherCondition() && /*~~(3L | 3C)~~>*/thirdCondition())/*~~(4L)~~>*/;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for loop with strange conditional(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract String entry();\n                void test() {\n                    for (;;) {\n                        if ((\"/\" + entry()).endsWith(\"/pom.xml\")) continue;\n                        System.out.println(\"Hello!\");\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract String entry();\n                void test() /*~~(BB: 4 CN: 2 EX: 1 | 1L)~~>*/{\n                    for (;;) /*~~(2L)~~>*/{\n                        if (/*~~(1C)~~>*/(\"/\" + entry()).endsWith(\"/pom.xml\")) /*~~(3L)~~>*/continue;\n                        /*~~(4L)~~>*/System.out.println(\"Hello!\");\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void example imagej-ui-swing(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.IOException;\n            import java.net.URL;\n            import java.util.jar.Attributes;\n            import java.util.jar.JarEntry;\n            import java.util.jar.JarInputStream;\n            import java.util.jar.Manifest;\n\n            class Test {\n                private String getCommit(final URL jarURL) {\n                    try {\n                        final JarInputStream in = new JarInputStream(jarURL.openStream());\n                        in.close();\n                        Manifest manifest = in.getManifest();\n                        if (manifest == null)\n                            for (;;) {\n                                final JarEntry entry = in.getNextJarEntry();\n                                if (entry == null) return null;\n                                if (entry.getName().equals(\"META-INF/MANIFEST.MF\")) {\n                                    manifest = new Manifest(in);\n                                    break;\n                                }\n                            }\n                        final Attributes attributes = manifest.getMainAttributes();\n                        return attributes.getValue(new Attributes.Name(\"Implementation-Build\"));\n                    } catch (IOException e) {\n                        return null;\n                    }\n                }\n            }\n            ", (String)"\n            import java.io.IOException;\n            import java.net.URL;\n            import java.util.jar.Attributes;\n            import java.util.jar.JarEntry;\n            import java.util.jar.JarInputStream;\n            import java.util.jar.Manifest;\n\n            class Test {\n                private String getCommit(final URL jarURL) /*~~(BB: 8 CN: 4 EX: 2 | 1L)~~>*/{\n                    try {\n                        final JarInputStream in = new JarInputStream(jarURL.openStream());\n                        in.close();\n                        Manifest manifest = in.getManifest();\n                        if (/*~~(1C (==))~~>*/manifest == null)\n                            /*~~(2L)~~>*/for (;;/*~~(3L)~~>*/) /*~~(4L)~~>*/{\n                                final JarEntry entry = in.getNextJarEntry();\n                                if (/*~~(2C (==))~~>*/entry == null) return /*~~(5L)~~>*/null;\n                                /*~~(6L)~~>*/if (/*~~(3C)~~>*/entry.getName().equals(\"META-INF/MANIFEST.MF\")) /*~~(7L)~~>*/{\n                                    manifest = new Manifest(in);\n                                    break;\n                                }\n                            }\n                        final /*~~(8L)~~>*/Attributes attributes = manifest.getMainAttributes();\n                        return attributes.getValue(new Attributes.Name(\"Implementation-Build\"));\n                    } catch (IOException e) {\n                        return null;\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void a class declared inside a function(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean conditional();\n\n                void testDeclareAClass() {\n                    if (conditional()) {\n                        class A implements ExampleInterface {\n\n                            @Override\n                            public int doSomething() {\n                                System.out.println(\"Hello\");\n                                return 1;\n                            }\n\n                            @Override\n                            public int doSomethingElse() {\n                                System.out.println(\"Hello\");\n                                return 2;\n                            }\n\n                            @Override\n                            public int doAThirdThing() {\n                                System.out.println(\"I don't know why you say goodbye, I say Hello!\");\n                                return 3;\n                            }\n                        }\n                        new A().doAThirdThing();\n                    }\n                }\n\n                interface ExampleInterface {\n                    int doSomething();\n                    int doSomethingElse();\n                    int doAThirdThing();\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean conditional();\n\n                void testDeclareAClass() {\n                    if (conditional()) {\n                        class A implements ExampleInterface {\n\n                            @Override\n                            public int doSomething() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                                System.out.println(\"Hello\");\n                                return 1;\n                            }\n\n                            @Override\n                            public int doSomethingElse() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                                System.out.println(\"Hello\");\n                                return 2;\n                            }\n\n                            @Override\n                            public int doAThirdThing() /*~~(BB: 1 CN: 0 EX: 1 | 1L)~~>*/{\n                                System.out.println(\"I don't know why you say goodbye, I say Hello!\");\n                                return 3;\n                            }\n                        }\n                        new A().doAThirdThing();\n                    }\n                }\n\n                interface ExampleInterface {\n                    int doSomething();\n                    int doSomethingElse();\n                    int doAThirdThing();\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for loop with continue then another conditional(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract String entry();\n                void test() {\n                    for (;;) {\n                        if ((\"/\" + entry()).endsWith(\"/pom.xml\")) continue;\n                        if (conditional()) {\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract String entry();\n                void test() /*~~(BB: 6 CN: 3 EX: 1 | 1L)~~>*/{\n                    for (;;/*~~(2L)~~>*/) /*~~(3L)~~>*/{\n                        if (/*~~(1C)~~>*/(\"/\" + entry()).endsWith(\"/pom.xml\")) /*~~(4L)~~>*/continue;\n                        /*~~(5L)~~>*/if (/*~~(2C)~~>*/conditional()) /*~~(6L)~~>*/{\n                            System.out.println(\"Hello!\");\n                        }\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if with JEmpty then(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract boolean conditional2();\n                abstract String entry();\n                void test() {\n                    if (conditional());\n                    if (conditional2()) {\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract boolean conditional2();\n                abstract String entry();\n                void test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    if (/*~~(1C)~~>*/conditional())/*~~(2L)~~>*/;\n                    /*~~(3L)~~>*/if (/*~~(2C)~~>*/conditional2()) /*~~(4L)~~>*/{\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if with JEmpty then and JEmpty else(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract boolean conditional2();\n                abstract String entry();\n                void test() {\n                    if (conditional());\n                    else;\n                    if (conditional2()) {\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean conditional();\n                abstract boolean conditional2();\n                abstract String entry();\n                void test() /*~~(BB: 5 CN: 2 EX: 2 | 1L)~~>*/{\n                    if (/*~~(1C)~~>*/conditional())/*~~(2L)~~>*/;\n                    /*~~(3L)~~>*/else;\n                    /*~~(4L)~~>*/if (/*~~(2C)~~>*/conditional2()) /*~~(5L)~~>*/{\n                        System.out.println(\"Goodbye!\");\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void example image-ui-swing(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.File;\n            import java.io.IOException;\n            import java.net.URL;\n            import java.util.jar.JarEntry;\n            import java.util.jar.JarInputStream;\n\n            class Test {\n                private String findSourceDirectory(final File gitWorkingDirectory, final URL jarURL) {\n                    try {\n                        int maxCount = 3;\n                        final JarInputStream in = new JarInputStream(jarURL.openStream());\n                        for (;;) {\n                            final JarEntry entry = in.getNextJarEntry();\n                            if (entry == null) break;\n                            String path = entry.getName();\n                            if (!path.endsWith(\".class\")) continue;\n                            if (--maxCount <= 0) break;\n                            final String sourceFile = \"Some java source code here\";\n                            if (sourceFile == null) continue;\n                            final String suffix = path.substring(0, path.lastIndexOf('/') + 1) + sourceFile;\n                            final String git = System.getProperty(\"imagej.updater.git.command\", \"git\");\n                            try {\n                                path = \"/user/something/something\";\n                                if (path.length() <= suffix.length()) continue;\n                                if (path.endsWith(\"\\n\")) path = path.substring(0, path.length() - 1);\n                            } catch (RuntimeException e) {\n                                /* ignore */\n                                continue;\n                            }\n                            if (path.indexOf('\\n') >= 0) continue; // ls-files found multiple files\n                            path = path.substring(0, path.length() - suffix.length());\n                            if (\"\".equals(path)) path = \".\";\n                            else if (path.endsWith(\"/src/main/java/\")) path = path.substring(0, path.length() - \"/src/main/java/\".length());\n                            in.close();\n                            return path;\n                        }\n                        in.close();\n                    } catch (IOException e) { /* ignore */ e.printStackTrace(); }\n                    return null;\n                }\n            }\n            ", (String)"\n            import java.io.File;\n            import java.io.IOException;\n            import java.net.URL;\n            import java.util.jar.JarEntry;\n            import java.util.jar.JarInputStream;\n\n            class Test {\n                private String findSourceDirectory(final File gitWorkingDirectory, final URL jarURL) /*~~(BB: 21 CN: 10 EX: 2 | 1L)~~>*/{\n                    try {\n                        int maxCount = 3;\n                        final JarInputStream in = new JarInputStream(jarURL.openStream());\n                        for (;;) /*~~(2L)~~>*/{\n                            final JarEntry entry = in.getNextJarEntry();\n                            if (/*~~(1C (==))~~>*/entry == null) /*~~(3L)~~>*/break;\n                            /*~~(4L)~~>*/String path = entry.getName();\n                            if (!/*~~(2C)~~>*/path.endsWith(\".class\")) /*~~(5L)~~>*/continue;\n                            /*~~(6L)~~>*/if (/*~~(3C (<=))~~>*/--maxCount <= 0) /*~~(7L)~~>*/break;\n                            final /*~~(8L)~~>*/String sourceFile = \"Some java source code here\";\n                            if (/*~~(4C (==))~~>*/sourceFile == null) /*~~(9L)~~>*/continue;\n                            final /*~~(10L)~~>*/String suffix = path.substring(0, path.lastIndexOf('/') + 1) + sourceFile;\n                            final String git = System.getProperty(\"imagej.updater.git.command\", \"git\");\n                            try {\n                                path = \"/user/something/something\";\n                                if (/*~~(5C (<=))~~>*/path.length() <= suffix.length()) /*~~(11L)~~>*/continue;\n                                /*~~(12L)~~>*/if (/*~~(6C)~~>*/path.endsWith(\"\\n\")) /*~~(13L)~~>*/path = path.substring(0, path.length() - 1);\n                            } catch (RuntimeException e) {\n                                /* ignore */\n                                continue;\n                            }\n                            /*~~(14L)~~>*/if (/*~~(7C (>=))~~>*/path.indexOf('\\n') >= 0) /*~~(15L)~~>*/continue; // ls-files found multiple files\n                            /*~~(16L)~~>*/path = path.substring(0, path.length() - suffix.length());\n                            if (/*~~(8C)~~>*/\"\".equals(path)) /*~~(17L)~~>*/path = \".\";\n                            /*~~(18L)~~>*/else if (path.endsWith(\"/src/main/java/\")) path = path.substring(0, path.length() - \"/src/main/java/\".length());\n                            /*~~(19L)~~>*/in.close();\n                            return path;\n                        }\n                        /*~~(20L)~~>*/in.close();\n                    } catch (IOException e) { /* ignore */ e.printStackTrace(); }\n                    return null;\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void while loop ending in return(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean conditional1();\n                abstract boolean conditional2();\n                int test() {\n                    while (conditional1()) {\n                        if (conditional2())\n                            continue;\n                        return 1;\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean conditional1();\n                abstract boolean conditional2();\n                int test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    while (/*~~(1C)~~>*/conditional1()) /*~~(2L)~~>*/{\n                        if (/*~~(2C)~~>*/conditional2())\n                            /*~~(3L)~~>*/continue;\n                        return /*~~(4L)~~>*/1;\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for each loop ending in return statement(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            abstract class Test {\n                abstract boolean conditional1();\n                int test() {\n                    for (String s : new ArrayList<String>()) {\n                        if (conditional1())\n                            continue;\n                        return 1;\n                    }\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList;\n            abstract class Test {\n                abstract boolean conditional1();\n                int test() /*~~(BB: 4 CN: 2 EX: 2 | 1L)~~>*/{\n                    for (String s : new ArrayList<String>()) /*~~(2L)~~>*/{\n                        if (/*~~(1C)~~>*/conditional1())\n                            /*~~(3L)~~>*/continue;\n                        return /*~~(4L)~~>*/1;\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        @Disabled(value="This test is broken")
        public static void ternary within the iterator for a for each loop(@NotNull ControlFlowTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract String[] array();\n\n                void test(boolean condition) {\n                    for (String s : condition ? array() : new String[] { \"Hello!\" }) {\n                        System.out.println(s);\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void identifies_control_flow_with_missing_type_information$lambda-0(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none());
        }
    }
}

