/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.MissingOverrideAnnotation;
import org.openrewrite.java.tree.J;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\bf\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/openrewrite/java/cleanup/MissingOverrideAnnotationTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "when a method already has an @Override annotation", "", "when a method implements an interface", "when a method overrides from a parent", "when a method overrides from a parent and a method implements an interface", "when a method overrides multiple layers of parents", "when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class", "when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class", "when ignoreObjectMethods is false and a method overrides from the base Object class", "when methods are implemented from multiple interfaces", "when methods are implemented from multiple layers of interfaces", "when the method is static", "when the superclass has abstract and non-abstract methods", "Companion", "rewrite-java-tck"})
public interface MissingOverrideAnnotationTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.cleanup.MissingOverrideAnnotationTest$Companion.$$INSTANCE;
    @Language(value="java")
    @NotNull
    public static final String testInterface = "\n            package com.example;\n            \n            interface TestInterface {\n                void testInterface();\n            }\n        ";
    @Language(value="java")
    @NotNull
    public static final String testInterface0 = "\n            package com.example;\n            \n            interface TestInterface0 {\n                void testInterface0();\n            }\n        ";
    @Language(value="java")
    @NotNull
    public static final String testInterfaceExtension = "\n            package com.example;\n            \n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n        ";
    @Language(value="java")
    @NotNull
    public static final String testParentParent = "\n            package com.example;\n            \n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n        ";
    @Language(value="java")
    @NotNull
    public static final String testParent = "\n            package com.example;\n            \n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n        ";
    @Language(value="java")
    @NotNull
    public static final String abstractTestParent = "\n            package com.example;\n            \n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        ";

    @NotNull
    public Recipe getRecipe();

    @Test
    public void when a method overrides from a parent();

    @Test
    public void when a method overrides multiple layers of parents();

    @Test
    public void when a method implements an interface();

    @Test
    public void when methods are implemented from multiple interfaces();

    @Test
    public void when methods are implemented from multiple layers of interfaces();

    @Test
    public void when a method overrides from a parent and a method implements an interface();

    @Test
    public void when the method is static();

    @Test
    public void when the superclass has abstract and non-abstract methods();

    @Test
    public void when a method already has an @Override annotation();

    @Test
    public void when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class();

    @Test
    public void when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class();

    @Test
    public void when ignoreObjectMethods is false and a method overrides from the base Object class();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/cleanup/MissingOverrideAnnotationTest$Companion;", "", "()V", "abstractTestParent", "", "testInterface", "testInterface0", "testInterfaceExtension", "testParent", "testParentParent", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Language(value="java")
        @NotNull
        public static final String testInterface = "\n            package com.example;\n            \n            interface TestInterface {\n                void testInterface();\n            }\n        ";
        @Language(value="java")
        @NotNull
        public static final String testInterface0 = "\n            package com.example;\n            \n            interface TestInterface0 {\n                void testInterface0();\n            }\n        ";
        @Language(value="java")
        @NotNull
        public static final String testInterfaceExtension = "\n            package com.example;\n            \n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n        ";
        @Language(value="java")
        @NotNull
        public static final String testParentParent = "\n            package com.example;\n            \n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n        ";
        @Language(value="java")
        @NotNull
        public static final String testParent = "\n            package com.example;\n            \n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n        ";
        @Language(value="java")
        @NotNull
        public static final String abstractTestParent = "\n            package com.example;\n            \n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull MissingOverrideAnnotationTest this_) {
            return (Recipe)new MissingOverrideAnnotation(null);
        }

        @Test
        public static void when a method overrides from a parent(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testParentParent};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test extends TestParentParent {\n                public void testParentParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test extends TestParentParent {\n                @Override\n                public void testParentParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when a method overrides multiple layers of parents(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testParent, MissingOverrideAnnotationTest.testParentParent};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test extends TestParent {\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test extends TestParent {\n                @Override\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when a method implements an interface(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testInterface};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test implements TestInterface {\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test implements TestInterface {\n                @Override\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when methods are implemented from multiple interfaces(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testInterface, MissingOverrideAnnotationTest.testInterface0};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test implements TestInterface, TestInterface0 {\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface0() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test implements TestInterface, TestInterface0 {\n                @Override\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface0() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when methods are implemented from multiple layers of interfaces(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testInterfaceExtension, MissingOverrideAnnotationTest.testInterface0};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test implements TestInterfaceExtension {\n                public void testInterfaceExtension() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface0() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test implements TestInterfaceExtension {\n                @Override\n                public void testInterfaceExtension() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface0() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when a method overrides from a parent and a method implements an interface(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testParent, MissingOverrideAnnotationTest.testParentParent, MissingOverrideAnnotationTest.testInterface};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test extends TestParent implements TestInterface {\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface() {\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test extends TestParent implements TestInterface {\n                @Override\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface() {\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when the method is static(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{"package com.example;\n\nimport java.util.Collection;\nimport java.util.Collections;\n\nclass TestBase {\n    protected static Collection<Object[]> parameters() {\n        return Collections.emptyList();\n    }\n}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            package com.example;\n            \n            import java.util.Collection;\n            import java.util.Collections;\n\n            class Test extends TestBase {\n                protected static Collection<Object[]> parameters() {\n                    return Collections.emptyList();\n                }\n            }\n        ", stringArray2, 7, null);
        }

        @Test
        public static void when the superclass has abstract and non-abstract methods(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.abstractTestParent};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test extends AbstractTestParent {\n                public boolean isAbstractBoolean() {\n                    return false;\n                }\n\n                public boolean isBoolean() {\n                    return true;\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            class Test extends AbstractTestParent {\n                @Override\n                public boolean isAbstractBoolean() {\n                    return false;\n                }\n\n                @Override\n                public boolean isBoolean() {\n                    return true;\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void when a method already has an @Override annotation(@NotNull MissingOverrideAnnotationTest this_) {
            String[] stringArray = new String[]{MissingOverrideAnnotationTest.testParent, MissingOverrideAnnotationTest.testParentParent};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            package com.example;\n            \n            class Test extends TestParent {\n                @Override\n                public void testParent() {\n                }\n            }\n        ", stringArray2, 7, null);
        }

        @Test
        public static void when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class(@NotNull MissingOverrideAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, (Recipe)new MissingOverrideAnnotation(Boolean.valueOf(true)), null, "\n            package com.example;\n            \n            class Test {\n                public void method() {\n                    //noinspection all\n                    Runnable t = new Runnable() {\n                        public void run() {\n                        }\n                    };\n                }\n            }\n        ", null, 21, null);
        }

        @Test
        public static void when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class(@NotNull MissingOverrideAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new MissingOverrideAnnotation(Boolean.valueOf(false)), null, "\n            package com.example;\n            \n            class Test {\n                public void method() {\n                    //noinspection all\n                    Runnable t = new Runnable() {\n                        public void run() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            package com.example;\n            \n            class Test {\n                public void method() {\n                    //noinspection all\n                    Runnable t = new Runnable() {\n                        @Override\n                        public void run() {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void when ignoreObjectMethods is false and a method overrides from the base Object class(@NotNull MissingOverrideAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new MissingOverrideAnnotation(null), null, "\n            package com.example;\n            \n            class Test {\n                public String toString() {\n                    return super.toString();\n                }\n            }\n        ", null, "\n            package com.example;\n            \n            class Test {\n                @Override\n                public String toString() {\n                    return super.toString();\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull MissingOverrideAnnotationTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull MissingOverrideAnnotationTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull MissingOverrideAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull MissingOverrideAnnotationTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull MissingOverrideAnnotationTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull MissingOverrideAnnotationTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

