/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.ExplicitLambdaArgumentTypes;
import org.openrewrite.java.cleanup.ExplicitLambdaArgumentTypesTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0017J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/openrewrite/java/cleanup/ExplicitLambdaArgumentTypesTest;", "Lorg/openrewrite/test/RewriteTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "arraysSortExample", "", "jp", "Lorg/openrewrite/java/JavaParser;", "arraysSortExampleWithGeneric", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "extendsConstraint", "handleMultiDimensionalFullyQualifiedArrays", "handleMultiDimensionalPrimitiveArrays", "handlePrimitiveArrays", "noArguments", "oneArgumentExistingExplicitType", "oneArgumentNoBlock", "oneArgumentWithBlock", "parameterizedTypes", "threeArgumentsNoBlock", "threeArgumentsWithBlock", "threeArgumentsWithBlockGeneric", "threeArgumentsWithBlockPrimitive", "twoArgumentsExistingExplicitType", "twoArgumentsNoBlock", "twoArgumentsWithBlock", "unknownArgumentType", "rewrite-java-tck"})
public interface ExplicitLambdaArgumentTypesTest
extends RewriteTest,
JavaRecipeTest {
    @Nullable
    public Recipe getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void unknownArgumentType(@NotNull JavaParser var1);

    @Test
    public void oneArgumentExistingExplicitType(@NotNull JavaParser var1);

    @Test
    public void oneArgumentNoBlock(@NotNull JavaParser var1);

    @Test
    public void twoArgumentsExistingExplicitType(@NotNull JavaParser var1);

    @Test
    public void twoArgumentsNoBlock(@NotNull JavaParser var1);

    @Test
    public void twoArgumentsWithBlock(@NotNull JavaParser var1);

    @Test
    public void handlePrimitiveArrays(@NotNull JavaParser var1);

    @Test
    public void handleMultiDimensionalPrimitiveArrays(@NotNull JavaParser var1);

    @Test
    public void handleMultiDimensionalFullyQualifiedArrays(@NotNull JavaParser var1);

    @Test
    public void oneArgumentWithBlock(@NotNull JavaParser var1);

    @Test
    public void threeArgumentsNoBlock(@NotNull JavaParser var1);

    @Test
    public void threeArgumentsWithBlock(@NotNull JavaParser var1);

    @Test
    public void threeArgumentsWithBlockPrimitive(@NotNull JavaParser var1);

    @Test
    public void threeArgumentsWithBlockGeneric(@NotNull JavaParser var1);

    @Test
    public void noArguments(@NotNull JavaParser var1);

    @Test
    public void arraysSortExample(@NotNull JavaParser var1);

    @Test
    public void arraysSortExampleWithGeneric(@NotNull JavaParser var1);

    @Test
    public void parameterizedTypes(@NotNull JavaParser var1);

    @Test
    public void extendsConstraint();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            return (Recipe)new ExplicitLambdaArgumentTypes();
        }

        public static void defaults(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ExplicitLambdaArgumentTypes());
        }

        @Test
        public static void unknownArgumentType(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Predicate;\n\n            class Test {\n                static void run(Predicate<WillyWonka> c) {\n                }\n\n                static void method() {\n                    run(a -> {\n                        return a.isEmpty();\n                    });\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void oneArgumentExistingExplicitType(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Consumer;\n\n            class Test {\n                static void run(Consumer<List<String>> c) {\n                }\n\n                static void method() {\n                    run(a -> a.size());\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void oneArgumentNoBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Consumer;\n\n            class Test {\n                static void run(Consumer<String> c) {\n                }\n\n                static void method() {\n                    run(q -> q.length());\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void twoArgumentsExistingExplicitType(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.BiConsumer;\n\n            class Test {\n                static void run(BiConsumer<String, Object> bc) {\n                }\n\n                static void method() {\n                    run((String a, Object b) -> a.length());\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void twoArgumentsNoBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.BiConsumer;\n\n            class Test {\n                static void run(BiConsumer<String, Object> bc) {\n                }\n\n                static void method() {\n                    run((a, b) -> a.length());\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void twoArgumentsWithBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.BiPredicate;\n\n            class Test {\n                static void run(BiPredicate<String, Object> bc) {\n                }\n\n                static void method() {\n                    run((a, b) -> {\n                        return a.isEmpty();\n                    });\n                }\n            }\n        ", null, "\n            import java.util.function.BiPredicate;\n\n            class Test {\n                static void run(BiPredicate<String, Object> bc) {\n                }\n\n                static void method() {\n                    run((String a, Object b) -> {\n                        return a.isEmpty();\n                    });\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void handlePrimitiveArrays(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, byte[], byte[]> func = (a, b) -> {\n                    return null;\n                };\n            }\n        ", null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, byte[], byte[]> func = (Integer a, byte[] b) -> {\n                    return null;\n                };\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void handleMultiDimensionalPrimitiveArrays(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, byte[][], byte[][]> func = (a, b) -> {\n                    return null;\n                };\n            }\n        ", null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, byte[][], byte[][]> func = (Integer a, byte[][] b) -> {\n                    return null;\n                };\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void handleMultiDimensionalFullyQualifiedArrays(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, Integer[][], Integer[][]> func = (a, b) -> {\n                    return null;\n                };\n            }\n        ", null, "\n            import java.util.function.BiFunction;\n\n            class Test {\n                private final BiFunction<Integer, Integer[][], Integer[][]> func = (Integer a, Integer[][] b) -> {\n                    return null;\n                };\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void oneArgumentWithBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Predicate;\n\n            class Test {\n                static void run(Predicate<String> c) {\n                }\n\n                static void method() {\n                    run(a -> {\n                        return a.isEmpty();\n                    });\n                }\n            }\n        ", null, "\n            import java.util.function.Predicate;\n\n            class Test {\n                static void run(Predicate<String> c) {\n                }\n\n                static void method() {\n                    run((String a) -> {\n                        return a.isEmpty();\n                    });\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void threeArgumentsNoBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((a, b, c) -> a.toUpperCase());\n                }\n\n                private interface TriConsumer {\n                    String method(String a, String b, String c);\n                }\n            }\n        ", null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((String a, String b, String c) -> a.toUpperCase());\n                }\n\n                private interface TriConsumer {\n                    String method(String a, String b, String c);\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void threeArgumentsWithBlock(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((a, b, c) -> {\n                        return a.toUpperCase();\n                    });\n                }\n\n                private interface TriConsumer {\n                    String method(String a, String b, String c);\n                }\n            }\n        ", null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((String a, String b, String c) -> {\n                        return a.toUpperCase();\n                    });\n                }\n\n                private interface TriConsumer {\n                    String method(String a, String b, String c);\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void threeArgumentsWithBlockPrimitive(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((a, b, c) -> {\n                        return a + b - c;\n                    });\n                }\n\n                private interface TriConsumer {\n                    int method(int a, int b, int c);\n                }\n            }\n        ", null, "\n            class Test {\n                static void run(TriConsumer tc) {\n                }\n\n                static void method() {\n                    run((int a, int b, int c) -> {\n                        return a + b - c;\n                    });\n                }\n\n                private interface TriConsumer {\n                    int method(int a, int b, int c);\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void threeArgumentsWithBlockGeneric(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            class Test {\n                static <T> void run(TriConsumer<T> tc) {\n                }\n\n                static void method() {\n                    run((a, b, c) -> {\n                        return a.toString();\n                    });\n                }\n\n                private interface TriConsumer<T> {\n                    T method(T a, T b, T c);\n                }\n            }\n        ", null, "\n            class Test {\n                static <T> void run(TriConsumer<T> tc) {\n                }\n\n                static void method() {\n                    run((Object a, Object b, Object c) -> {\n                        return a.toString();\n                    });\n                }\n\n                private interface TriConsumer<T> {\n                    T method(T a, T b, T c);\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void noArguments(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Supplier;\n\n            class Test {\n                static void run(Supplier<String> s) {\n                }\n\n                static void method() {\n                    run(() -> {\n                        return \"example\";\n                    });\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void arraysSortExample(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.Arrays;\n\n            class Test {\n                static void method(String[] arr) {\n                    Arrays.sort(arr, (a, b) -> {\n                        return a.length() - b.length();\n                    });\n                }\n            }\n        ", null, "\n            import java.util.Arrays;\n\n            class Test {\n                static void method(String[] arr) {\n                    Arrays.sort(arr, (String a, String b) -> {\n                        return a.length() - b.length();\n                    });\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void arraysSortExampleWithGeneric(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.Arrays;\n\n            class Test {\n                static <T> void method(T[] arr) {\n                    Arrays.sort(arr, (a, b) -> {\n                        return a.toString().length() - b.toString().length();\n                    });\n                }\n            }\n        ", null, "\n            import java.util.Arrays;\n\n            class Test {\n                static <T> void method(T[] arr) {\n                    Arrays.sort(arr, (T a, T b) -> {\n                        return a.toString().length() - b.toString().length();\n                    });\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void parameterizedTypes(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package javafx.beans.value;\n\n                public interface ObservableValue<T> {\n                    void addListener(ChangeListener<? super T> listener);\n                }\n            ", "\n                package javafx.beans.value;\n                \n                @FunctionalInterface\n                public interface ChangeListener<T> {\n                    void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n                }                \n            ", "package example;\n\nimport javafx.beans.value.ObservableValue;\nimport javafx.beans.value.ChangeListener;\n\npublic class Fred implements ObservableValue<String>{\n    public void addListener(ChangeListener<? super String> listener) {\n    }\n}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import javafx.beans.value.ObservableValue;\n            import example.Fred;\n            \n            class Test {\n                void foo() {\n                    Fred fred = new Fred();\n                    fred.addListener((ov, oldState, newState) -> {\n                    });\n                }\n            }\n        ", stringArray2, "\n            import javafx.beans.value.ObservableValue;\n            import example.Fred;\n            \n            class Test {\n                void foo() {\n                    Fred fred = new Fred();\n                    fred.addListener((ObservableValue<? extends String> ov, String oldState, String newState) -> {\n                    });\n                }\n            }\n        ", 0, 0, null, parameterizedTypes.1.INSTANCE, 454, null);
        }

        @Test
        public static void extendsConstraint(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.test;\n            \n            import java.util.List;\n            \n            class A {\n                void foo(List<? extends A> a) {\n                    a.forEach(it -> { });\n                }\n            }\n        ", (String)"\n            package com.test;\n            \n            import java.util.List;\n            \n            class A {\n                void foo(List<? extends A> a) {\n                    a.forEach((A it) -> { });\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ExplicitLambdaArgumentTypesTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ExplicitLambdaArgumentTypesTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

