/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.CombineSemanticallyEqualCatchBlocks;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/cleanup/CombineSemanticallyEqualCatchBlocksTest;", "Lorg/openrewrite/test/RewriteTest;", "blocksContainDifferentComments", "", "blocksContainSameComments", "childClassIsCaughtBeforeParentClass", "combineCatchesIntoNewMultiCatch", "combineSameSemanticallyEquivalentMethodTypes", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotCombineDifferentCatchBlocks", "fromCatchCombineWithMultiCatch", "fromMultiCatchCombineWithCatch", "fromMultiCatchCombineWithMultiCatch", "preserveOrderOfCatchesWhenPossible", "removeRedundantChildClasses", "removeRedundantChildClassesWithExistingMultiCatches", "rewrite-java-tck"})
public interface CombineSemanticallyEqualCatchBlocksTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotCombineDifferentCatchBlocks();

    @Test
    public void childClassIsCaughtBeforeParentClass();

    @Test
    public void blocksContainDifferentComments();

    @Test
    public void blocksContainSameComments();

    @Test
    public void combineSameSemanticallyEquivalentMethodTypes();

    @Test
    public void combineCatchesIntoNewMultiCatch();

    @Test
    public void fromMultiCatchCombineWithCatch();

    @Test
    public void fromCatchCombineWithMultiCatch();

    @Test
    public void fromMultiCatchCombineWithMultiCatch();

    @Test
    public void preserveOrderOfCatchesWhenPossible();

    @Test
    public void removeRedundantChildClasses();

    @Test
    public void removeRedundantChildClassesWithExistingMultiCatches();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new CombineSemanticallyEqualCatchBlocks());
        }

        @Test
        public static void doNotCombineDifferentCatchBlocks(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            String s = \"foo\";\n        } catch (B ex) {\n            String s = \"bar\";\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void childClassIsCaughtBeforeParentClass(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) { // Is subtype of BaseException with a unique block.\n            String diff;\n        } catch (BaseException ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blocksContainDifferentComments(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            // Comment 1\n        } catch (B ex) {\n            // Comment 2\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blocksContainSameComments(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            // Same\n        } catch (B ex) {\n            // Same\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n            // Same\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void combineSameSemanticallyEquivalentMethodTypes(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            base(ex);\n        } catch (B ex) {\n            base(ex);\n        }\n    }\n    void base(BaseException ex) {}\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n            base(ex);\n        }\n    }\n    void base(BaseException ex) {}\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void combineCatchesIntoNewMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fromMultiCatchCombineWithCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B | C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fromCatchCombineWithMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fromMultiCatchCombineWithMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class D extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (C | D ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C | D ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preserveOrderOfCatchesWhenPossible(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class C extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n            String diff;\n        } catch (C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | C ex) {\n        } catch (B ex) {\n            String diff;\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeRedundantChildClasses(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n        } catch (BaseException ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (B | BaseException ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeRedundantChildClassesWithExistingMultiCatches(@NotNull CombineSemanticallyEqualCatchBlocksTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Other extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (BaseException | Other ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (B | BaseException | Other ex) {\n        }\n    }\n}")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

