/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.VariableNameUtilsTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0013\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J+\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\b\u0010\u0016\u001a\u00020\u0007H\u0017J\b\u0010\u0017\u001a\u00020\u0007H\u0017J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\b\u0010\u0019\u001a\u00020\u0007H\u0017J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001e"}, d2={"Lorg/openrewrite/java/VariableNameUtilsTest;", "Lorg/openrewrite/test/RewriteTest;", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "allClassFieldsAreFound", "", "baseTest", "source", "", "", "scope", "expected", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "detectMethodParam", "doNotAddPackagePrivateNameFromSuperClass", "findNamesAvailableFromBlock", "forLoop", "result", "generateUniqueNameWithIncrementedNumber", "ifElse", "incrementExistingNumberPostFix", "innerClass", "lambda", "staticImportedFieldNames", "superClass", "switch", "tryCatchFinally", "whileLoops", "rewrite-java-tck"})
public interface VariableNameUtilsTest
extends RewriteTest {
    @NotNull
    public JavaParser getParser();

    @Test
    public void doNotAddPackagePrivateNameFromSuperClass();

    @Test
    public void staticImportedFieldNames();

    @Test
    public void allClassFieldsAreFound();

    @Test
    public void findNamesAvailableFromBlock();

    @Test
    public void detectMethodParam();

    @Test
    public void innerClass();

    @ParameterizedTest
    @CsvSource(value={"control: control, methodBlockA", "forBlock: forBlock, control, methodBlockA"}, delimiter=58)
    public void forLoop(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"ifScope: ifScope, methodParam, methodBlockA", "elseIfScope: elseIfScope, methodParam, methodBlockA", "elseScope: elseScope, methodParam, methodBlockA"}, delimiter=58)
    public void ifElse(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"supplier: supplier, methodBlockA", "anonMethodBlock: anonMethodBlock, methodBlockA, supplier"}, delimiter=58)
    public void lambda(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"classBlock: classBlock,superPublic, superProtected, superPackagePrivate,superSuperPublic, superSuperProtected, superSuperPackagePrivate"}, delimiter=58)
    public void superClass(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"caseA: caseA, methodParam, methodBlockA", "caseB: caseB, methodParam, methodBlockA", "defaultBlock: defaultBlock, methodParam, methodBlockA"}, delimiter=58)
    public void switch(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"resourceA: resourceA, methodBlockA", "tryBlock: tryBlock, methodBlockA, resourceA, resourceB", "catchControl: catchControl, methodBlockA, resourceA, resourceB", "catchBlock: catchBlock, methodBlockA, resourceA, resourceB, catchControl", "finallyBlock: finallyBlock, methodBlockA, resourceA, resourceB"}, delimiter=58)
    public void tryCatchFinally(@NotNull String var1, @NotNull String var2);

    @ParameterizedTest
    @CsvSource(value={"whileBlock: whileBlock, methodParam, methodBlockA", "doWhileBlock: doWhileBlock, methodParam, methodBlockA"}, delimiter=58)
    public void whileLoops(@NotNull String var1, @NotNull String var2);

    @Test
    public void incrementExistingNumberPostFix();

    @Test
    public void generateUniqueNameWithIncrementedNumber();

    public void baseTest(@NotNull String[] var1, @NotNull String var2, @NotNull String var3);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static JavaParser getParser(@NotNull VariableNameUtilsTest this_) {
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().build()");
            return javaParser;
        }

        @Test
        public static void doNotAddPackagePrivateNameFromSuperClass(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"package foo;\npublic class Super {\n    boolean pkgPrivate;\n}", "package bar;\n\nimport foo.Super;\n\nclass Test extends Super {\n    boolean classBlock;\n}"};
            String[] source = stringArray;
            this_.baseTest(source, "classBlock", "classBlock");
        }

        @Test
        public static void staticImportedFieldNames(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"import static java.nio.charset.StandardCharsets.UTF_8;\nimport static java.util.Collections.emptyList;\n\nclass Test {\n    boolean classBlock;\n}"};
            String[] source = stringArray;
            this_.baseTest(source, "classBlock", "classBlock, UTF_8");
        }

        @Test
        public static void allClassFieldsAreFound(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"class Test {\n    boolean classBlockA;\n    void method() {\n        boolean methodBlock;\n    }\n    boolean classBlockB;\n}"};
            String[] source = stringArray;
            this_.baseTest(source, "methodBlock", "methodBlock, classBlockA, classBlockB");
        }

        @Test
        public static void findNamesAvailableFromBlock(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"class Test {\n    boolean classFieldA;\n    void method (boolean methodParam) {\n        boolean methodBlockA;\n        for (int control = 0; control < 10; control++) {\n            boolean forBlock;\n            if (control == 5) {\n                boolean ifBlock;\n            }\n        }\n        boolean methodBlockB;\n    }\n    boolean classFieldB;\n}"};
            List sources = this_.getParser().parse((ExecutionContext)new InMemoryExecutionContext(), stringArray);
            String scope = "methodBlockA";
            Object[] objectArray = new String[]{"classFieldA", "classFieldB", "methodBlockA", "methodBlockB", "methodParam", "control", "forBlock", "ifBlock"};
            Set expected = SetsKt.setOf((Object[])objectArray);
            Set names = new LinkedHashSet();
            Recipe recipe2 = RewriteTest.toRecipe(() -> DefaultImpls.findNamesAvailableFromBlock$lambda-0(scope, names));
            recipe2.run(sources);
            Set result = CollectionsKt.toSet((Iterable)names);
            org.assertj.core.api.Assertions.assertThat((Collection)result).containsAll((Iterable)expected);
            org.assertj.core.api.Assertions.assertThat((Collection)expected).containsAll((Iterable)result);
        }

        @Test
        public static void detectMethodParam(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"class Test {\n    void method(boolean methodParam) {\n        boolean methodBlockA;\n        if (methodParam) {\n            boolean ifBlock;\n        }\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, "ifBlock", "ifBlock, methodBlockA, methodParam");
        }

        @Test
        public static void innerClass(@NotNull VariableNameUtilsTest this_) {
            String[] stringArray = new String[]{"class Test {\n    boolean classBlockA;\n    void method() {\n        boolean methodBlock;\n    }\n    boolean classBlockB;\n    class Inner {\n        boolean innerClassBlock;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, "innerClassBlock", "classBlockA, classBlockB, innerClassBlock");
        }

        @ParameterizedTest
        @CsvSource(value={"control: control, methodBlockA", "forBlock: forBlock, control, methodBlockA"}, delimiter=58)
        public static void forLoop(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"class Test {\n    void method() {\n        boolean methodBlockA;\n        for (int control = 0; control < 10; control++) {\n            boolean forBlock;\n        }\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"ifScope: ifScope, methodParam, methodBlockA", "elseIfScope: elseIfScope, methodParam, methodBlockA", "elseScope: elseScope, methodParam, methodBlockA"}, delimiter=58)
        public static void ifElse(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"class Test {\n    void method(short methodParam) {\n        boolean methodBlockA;\n        if (methodParam == 0) {\n            boolean ifScope;\n        } else if (methodParam == 1) {\n            boolean elseIfScope;\n        } else {\n            boolean elseScope;\n        }\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"supplier: supplier, methodBlockA", "anonMethodBlock: anonMethodBlock, methodBlockA, supplier"}, delimiter=58)
        public static void lambda(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"import java.util.function.Supplier;\n\nclass Test {\n    void method() {\n        boolean methodBlockA;\n        Supplier<Integer> supplier = new Supplier<Integer>() {\n            @Override\n            public Integer get() {\n                int anonMethodBlock;\n                return anonMethodBlock;\n            }\n        };\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"classBlock: classBlock,superPublic, superProtected, superPackagePrivate,superSuperPublic, superSuperProtected, superSuperPackagePrivate"}, delimiter=58)
        public static void superClass(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"package foo.bar;\n\nclass SuperSuper {\n    public int superSuperPublic;\n    protected int superSuperProtected;\n    private int superSuperPrivate;\n    int superSuperPackagePrivate;\n}", "package foo.bar;\n\nclass Super extends SuperSuper {\n    public int superPublic;\n    protected int superProtected;\n    private int superPrivate;\n    int superPackagePrivate;\n}", "package foo.bar;\n\nclass Test extends Super {\n    boolean classBlock;\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"caseA: caseA, methodParam, methodBlockA", "caseB: caseB, methodParam, methodBlockA", "defaultBlock: defaultBlock, methodParam, methodBlockA"}, delimiter=58)
        public static void switch(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"class Test {\n    void method(short methodParam) {\n        boolean methodBlockA;\n        switch (methodParam) {\n            case 0:\n                boolean caseA;\n                break;\n            case 1:\n                boolean caseB;\n                break;\n            default:\n                boolean defaultBlock;\n                break;\n        }\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"resourceA: resourceA, methodBlockA", "tryBlock: tryBlock, methodBlockA, resourceA, resourceB", "catchControl: catchControl, methodBlockA, resourceA, resourceB", "catchBlock: catchBlock, methodBlockA, resourceA, resourceB, catchControl", "finallyBlock: finallyBlock, methodBlockA, resourceA, resourceB"}, delimiter=58)
        public static void tryCatchFinally(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"import java.io.*;\n\nclass Test {\n    void method() {\n        File methodBlockA = new File(\"file.txt\");\n        try (FileInputStream resourceA = new FileInputStream(methodBlockA); FileInputStream resourceB = new FileInputStream(methodBlockA)) {\n            boolean tryBlock;\n        } catch (RuntimeException | IOException catchControl) {\n            boolean catchBlock;\n        } finally {\n            boolean finallyBlock;\n        }\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @ParameterizedTest
        @CsvSource(value={"whileBlock: whileBlock, methodParam, methodBlockA", "doWhileBlock: doWhileBlock, methodParam, methodBlockA"}, delimiter=58)
        public static void whileLoops(@NotNull VariableNameUtilsTest this_, @NotNull String scope, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String[] stringArray = new String[]{"import java.io.*;\n\nclass Test {\n    void method(short methodParam) {\n        boolean methodBlockA;\n        while (methodParam < 10) {\n            boolean whileBlock;\n            methodParam++;\n        }\n        do {\n            boolean doWhileBlock;\n            methodParam--;\n        } while (methodParam > 0);\n        boolean methodBlockB;\n    }\n}"};
            String[] source = stringArray;
            this_.baseTest(source, scope, result);
        }

        @Test
        public static void incrementExistingNumberPostFix(@NotNull VariableNameUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings(\"all\")\n            class Test {\n                int name = 0;\n                void method(int name1) {\n                    int name2 = 0;\n                }\n            }\n        ", (String)"\n            @SuppressWarnings(\"all\")\n            class Test {\n                int name = 0;\n                void method(int name1) {\n                    int name3 = 0;\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::incrementExistingNumberPostFix$lambda-2, sourceSpecsArray);
        }

        @Test
        public static void generateUniqueNameWithIncrementedNumber(@NotNull VariableNameUtilsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings(\"all\")\n            class Test {\n                int ignored = 0;\n                void method(int ignored1) {\n                    int ignored2 = 0;\n                    for (int ignored3 = 0; ignored3 < 10; ignored3++) { // scope does not apply.\n                        int ignored4 = 0; // scope does not apply.\n                    }\n                    if (ignored1 > 0) {\n                        int ignored5 = 0; // scope does not apply.\n                    }\n                    try {\n                        int ignored6 = 0; // scope does not apply.\n                    } catch (Exception ex) {\n                    }\n                }\n            }\n        ", (String)"\n            @SuppressWarnings(\"all\")\n            class Test {\n                int ignored = 0;\n                void method(int ignored1) {\n                    int ignored2 = 0;\n                    for (int ignored3 = 0; ignored3 < 10; ignored3++) { // scope does not apply.\n                        int ignored4 = 0; // scope does not apply.\n                    }\n                    if (ignored1 > 0) {\n                        int ignored5 = 0; // scope does not apply.\n                    }\n                    try {\n                        int ignored6 = 0; // scope does not apply.\n                    } catch (Exception ignored3) {\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::generateUniqueNameWithIncrementedNumber$lambda-4, sourceSpecsArray);
        }

        /*
         * WARNING - void declaration
         */
        public static void baseTest(@NotNull VariableNameUtilsTest this_, @NotNull String[] source, @NotNull String scope, @NotNull String expected) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            List sources = this_.getParser().parse((ExecutionContext)new InMemoryExecutionContext(), Arrays.copyOf(source, source.length));
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)expected, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            Set expectedResult = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Set names = new LinkedHashSet();
            Recipe recipe2 = RewriteTest.toRecipe(() -> DefaultImpls.baseTest$lambda-6(scope, names));
            recipe2.run(sources);
            Set result = CollectionsKt.toSet((Iterable)names);
            org.assertj.core.api.Assertions.assertThat((Collection)result).containsAll((Iterable)expectedResult);
            org.assertj.core.api.Assertions.assertThat((Collection)expectedResult).containsAll((Iterable)result);
        }

        private static TreeVisitor findNamesAvailableFromBlock$lambda-0(String $scope, Set $names) {
            Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
            Intrinsics.checkNotNullParameter((Object)$names, (String)"$names");
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>($scope, (Set<String>)$names){
                final /* synthetic */ String $scope;
                final /* synthetic */ Set<String> $names;
                {
                    this.$scope = $scope;
                    this.$names = $names;
                }

                @NotNull
                public J.Identifier visitIdentifier(@NotNull J.Identifier identifier, @NotNull ExecutionContext p) {
                    J.Identifier identifier2;
                    Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)this.$scope)) {
                        Cursor cursor = this.getCursor().dropParentUntil(findNamesAvailableFromBlock.recipe.1.1::visitIdentifier$lambda-0);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"this.cursor.dropParentUntil { it is J.Block }");
                        Cursor blockCursor = cursor;
                        Set set = VariableNameUtils.findNamesInScope((Cursor)blockCursor);
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"findNamesInScope(blockCursor)");
                        this.$names.addAll(set);
                        J.Identifier identifier3 = identifier.withSimpleName("changed");
                        Intrinsics.checkNotNullExpressionValue((Object)identifier3, (String)"{\n                      \u2026d\")\n                    }");
                        identifier2 = identifier3;
                    } else {
                        identifier2 = identifier;
                    }
                    return identifier2;
                }

                private static final boolean visitIdentifier$lambda-0(Object it) {
                    return it instanceof J.Block;
                }
            };
        }

        private static TreeVisitor incrementExistingNumberPostFix$lambda-2$lambda-1() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.Identifier visitIdentifier(@NotNull J.Identifier identifier, @NotNull ExecutionContext p) {
                    J.Identifier identifier2;
                    Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)"name2")) {
                        J.Identifier identifier3 = identifier.withSimpleName(VariableNameUtils.generateVariableName((String)"name1", (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER));
                        identifier2 = identifier3;
                        Intrinsics.checkNotNullExpressionValue((Object)identifier3, (String)"{\n                      \u2026                        }");
                    } else {
                        identifier2 = identifier;
                    }
                    return identifier2;
                }
            };
        }

        private static void incrementExistingNumberPostFix$lambda-2(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::incrementExistingNumberPostFix$lambda-2$lambda-1));
        }

        private static TreeVisitor generateUniqueNameWithIncrementedNumber$lambda-4$lambda-3() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.Identifier visitIdentifier(@NotNull J.Identifier identifier, @NotNull ExecutionContext p) {
                    J.Identifier identifier2;
                    Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)"ex")) {
                        J.Identifier identifier3 = identifier.withSimpleName(VariableNameUtils.generateVariableName((String)"ignored", (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER));
                        identifier2 = identifier3;
                        Intrinsics.checkNotNullExpressionValue((Object)identifier3, (String)"{\n                      \u2026                        }");
                    } else {
                        identifier2 = identifier;
                    }
                    return identifier2;
                }
            };
        }

        private static void generateUniqueNameWithIncrementedNumber$lambda-4(RecipeSpec spec) {
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::generateUniqueNameWithIncrementedNumber$lambda-4$lambda-3));
        }

        private static TreeVisitor baseTest$lambda-6(String $scope, Set $names) {
            Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
            Intrinsics.checkNotNullParameter((Object)$names, (String)"$names");
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>($scope, (Set<String>)$names){
                final /* synthetic */ String $scope;
                final /* synthetic */ Set<String> $names;
                {
                    this.$scope = $scope;
                    this.$names = $names;
                }

                @NotNull
                public J.Identifier visitIdentifier(@NotNull J.Identifier identifier, @NotNull ExecutionContext p) {
                    J.Identifier identifier2;
                    Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)identifier.getSimpleName(), (Object)this.$scope)) {
                        Set set = VariableNameUtils.findNamesInScope((Cursor)this.getCursor());
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"findNamesInScope(this.cursor)");
                        this.$names.addAll(set);
                        J.Identifier identifier3 = identifier.withSimpleName("changed");
                        Intrinsics.checkNotNullExpressionValue((Object)identifier3, (String)"{\n                      \u2026d\")\n                    }");
                        identifier2 = identifier3;
                    } else {
                        identifier2 = identifier;
                    }
                    return identifier2;
                }
            };
        }
    }
}

