/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.UseDiamondOperator;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/cleanup/UseDiamondOperatorTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotUseDiamondOperatorsForVariablesHavingNullOrUnknownTypes", "noLeftSide", "notAsAChainedMethodInvocation", "returnTypeParamsDoNotMatchNewClassParams", "useDiamondOperator", "useDiamondOperatorTest2", "varArgIsParameterizedNewClass", "rewrite-java-tck"})
public interface UseDiamondOperatorTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void useDiamondOperator();

    @Test
    public void varArgIsParameterizedNewClass();

    @Test
    public void useDiamondOperatorTest2();

    @Test
    public void returnTypeParamsDoNotMatchNewClassParams();

    @Test
    public void doNotUseDiamondOperatorsForVariablesHavingNullOrUnknownTypes();

    @Test
    public void noLeftSide();

    @Test
    public void notAsAChainedMethodInvocation();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull UseDiamondOperatorTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new UseDiamondOperator());
        }

        @Test
        public static void useDiamondOperator(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n\n            class Test<X, Y> {\n                void test() {\n                    List<String> ls = new ArrayList<String>();\n                    Map<X,Y> map = new HashMap<X,Y>();\n                    List<String> ls2 = new ArrayList<String>() {\n                    };\n                }\n            }\n        ", (String)"\n            import java.util.*;\n\n            class Test<X, Y> {\n                void test() {\n                    List<String> ls = new ArrayList<>();\n                    Map<X,Y> map = new HashMap<>();\n                    List<String> ls2 = new ArrayList<String>() {\n                    };\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void varArgIsParameterizedNewClass(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n\n            class Foo {\n                void something(List<Integer>... lists) {}\n                void somethingElse(Object[] o, List<Integer> s){}\n                void doSomething() {\n                    something(new ArrayList<Integer>(), new ArrayList<Integer>());\n                    something(new ArrayList<Integer>());\n                    somethingElse(new String[0], new ArrayList<Integer>());\n                }\n            }\n            ", (String)"\n            import java.util.*;\n\n            class Foo {\n                void something(List<Integer>... lists) {}\n                void somethingElse(Object[] o, List<Integer> s){}\n                void doSomething() {\n                    something(new ArrayList<>(), new ArrayList<>());\n                    something(new ArrayList<>());\n                    somethingElse(new String[0], new ArrayList<>());\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void useDiamondOperatorTest2(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.HashMap;\n            import java.util.function.Predicate;\n            import java.util.List;\n            import java.util.Map;\n            \n            class Foo<T> {\n                Map<String, Integer> map;\n                Map unknownMap;\n                public Foo(Predicate<T> p) {}\n                public void something(Foo<List<String>> foos){}\n                public void somethingEasy(List<List<String>> l){}\n                \n                Foo getFoo() {\n                    // variable type initializer\n                    Foo<List<String>> f = new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                    // assignment\n                    map = new HashMap<String, Integer>();\n                    unknownMap = new HashMap<String, Integer>();\n                    // method argument type assignment\n                    something(new Foo<List<String>>(it -> it.stream().anyMatch(b -> true)));\n                    somethingEasy(new ArrayList<List<String>>());\n                    // return type and assignment type unknown\n                    Object o = new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                    // return type unknown\n                    return new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                }\n                \n                Foo<List<String>> getFoo2() {\n                    // return type expression\n                    return new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                }\n            }\n        ", (String)"\n            import java.util.ArrayList;\n            import java.util.HashMap;\n            import java.util.function.Predicate;\n            import java.util.List;\n            import java.util.Map;\n            \n            class Foo<T> {\n                Map<String, Integer> map;\n                Map unknownMap;\n                public Foo(Predicate<T> p) {}\n                public void something(Foo<List<String>> foos){}\n                public void somethingEasy(List<List<String>> l){}\n                \n                Foo getFoo() {\n                    // variable type initializer\n                    Foo<List<String>> f = new Foo<>(it -> it.stream().anyMatch(baz -> true));\n                    // assignment\n                    map = new HashMap<>();\n                    unknownMap = new HashMap<String, Integer>();\n                    // method argument type assignment\n                    something(new Foo<>(it -> it.stream().anyMatch(b -> true)));\n                    somethingEasy(new ArrayList<>());\n                    // return type and assignment type unknown\n                    Object o = new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                    // return type unknown\n                    return new Foo<List<String>>(it -> it.stream().anyMatch(baz -> true));\n                }\n                \n                Foo<List<String>> getFoo2() {\n                    // return type expression\n                    return new Foo<>(it -> it.stream().anyMatch(baz -> true));\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void returnTypeParamsDoNotMatchNewClassParams(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.function.Predicate;\n            \n            class Test {\n                interface MyInterface<T> { }\n                class MyClass<S, T> implements MyInterface<T>{\n                    public MyClass(Predicate<S> p, T check) {}\n                }\n            \n                public MyInterface<Integer> a() {\n                    return new MyClass<List<String>, Integer>(l -> l.stream().anyMatch(String::isEmpty), 0);\n                }\n                public MyClass<List<String>, Integer> b() {\n                    return new MyClass<List<String>, Integer>(l -> l.stream().anyMatch(String::isEmpty), 0);\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.function.Predicate;\n            \n            class Test {\n                interface MyInterface<T> { }\n                class MyClass<S, T> implements MyInterface<T>{\n                    public MyClass(Predicate<S> p, T check) {}\n                }\n            \n                public MyInterface<Integer> a() {\n                    return new MyClass<List<String>, Integer>(l -> l.stream().anyMatch(String::isEmpty), 0);\n                }\n                public MyClass<List<String>, Integer> b() {\n                    return new MyClass<>(l -> l.stream().anyMatch(String::isEmpty), 0);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotUseDiamondOperatorsForVariablesHavingNullOrUnknownTypes(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import lombok.val;\n            import java.util.ArrayList;\n\n            class Test<X, Y> {\n                void test() {\n                    val ls = new ArrayList<String>();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void noLeftSide(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.HashMap;\n            class Test {\n                static {\n                    new HashMap<String, String>();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void notAsAChainedMethodInvocation(@NotNull UseDiamondOperatorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public static ResponseBuilder<String> bResponseEntity(String entity) {\n                    return new ResponseBuilder<String>().entity(entity);\n                }\n                public static ResponseBuilder<String> bResponse(String entity) {\n                    return new ResponseBuilder<String>();\n                }\n\n                public static class ResponseBuilder<T> {\n                    public ResponseBuilder<T> entity(T entity) {\n                        return this;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                public static ResponseBuilder<String> bResponseEntity(String entity) {\n                    return new ResponseBuilder<String>().entity(entity);\n                }\n                public static ResponseBuilder<String> bResponse(String entity) {\n                    return new ResponseBuilder<>();\n                }\n\n                public static class ResponseBuilder<T> {\n                    public ResponseBuilder<T> entity(T entity) {\n                        return this;\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

