/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeMappingTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/JavaParserTypeMappingTest;", "Lorg/openrewrite/java/JavaTypeMappingTest;", "beforeRecipe", "", "methodInvocationOnUnknownType", "methodInvocationWithUnknownTypeSymbol", "parameterizedTypesAreDeeplyBasedOnBounds", "Companion", "rewrite-java-tck"})
public interface JavaParserTypeMappingTest
extends JavaTypeMappingTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.JavaParserTypeMappingTest$Companion.$$INSTANCE;

    @BeforeEach
    public void beforeRecipe();

    @Test
    public void parameterizedTypesAreDeeplyBasedOnBounds();

    @Test
    public void methodInvocationWithUnknownTypeSymbol();

    @Test
    public void methodInvocationOnUnknownType();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/JavaParserTypeMappingTest$Companion;", "", "()V", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final JavaParser parser;

        private Companion() {
        }

        @NotNull
        public final JavaParser getParser() {
            return parser;
        }

        static {
            $$INSTANCE = new Companion();
            JavaParser javaParser = JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion()\n      \u2026rue)\n            .build()");
            parser = javaParser;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @BeforeEach
        public static void beforeRecipe(@NotNull JavaParserTypeMappingTest this_) {
            Companion.getParser().reset();
        }

        @Test
        public static void parameterizedTypesAreDeeplyBasedOnBounds(@NotNull JavaParserTypeMappingTest this_) {
            String[] stringArray = new String[]{"abstract class TypeA<T extends Number> extends java.util.ArrayList<T> {}", "class TypeB extends TypeA<Integer> {\n    // Attempt to force a race condition in the JavaTypeCache.\n    java.util.List<String> list = new java.util.ArrayList<>();\n}", "class TypeC<T extends String> extends java.util.ArrayList<T> {\n    // Attempt to force a race condition in the JavaTypeCache.\n    java.util.List<Object> list = new java.util.ArrayList<>();\n}"};
            String[] sources = stringArray;
            List cus = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::parameterizedTypesAreDeeplyBasedOnBounds$lambda-0), Arrays.copyOf(sources, sources.length));
            JavaType.FullyQualified fullyQualified = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(0)).getClasses().get(0)).getType();
            if (fullyQualified == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType.Parameterized typeA = (JavaType.Parameterized)fullyQualified;
            Object e = typeA.getTypeParameters().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            Assertions.assertThat((String)((JavaType.GenericTypeVariable)e).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.FullyQualified fullyQualified2 = typeA.getSupertype();
            if (fullyQualified2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType.Parameterized typeASuperType = (JavaType.Parameterized)fullyQualified2;
            Assertions.assertThat((String)typeASuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.Number}>");
            JavaType.FullyQualified fullyQualified3 = typeASuperType.getType();
            if (fullyQualified3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            Assertions.assertThat((String)((JavaType.Class)fullyQualified3).getTypeParameters().get(0).toString()).isEqualTo("Generic{E}");
            JavaType.FullyQualified fullyQualified4 = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(1)).getClasses().get(0)).getType();
            if (fullyQualified4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            JavaType.Class typeB = (JavaType.Class)fullyQualified4;
            JavaType.FullyQualified fullyQualified5 = typeB.getSupertype();
            Intrinsics.checkNotNull((Object)fullyQualified5);
            Assertions.assertThat((String)fullyQualified5.toString()).isEqualTo("TypeA<java.lang.Integer>");
            JavaType.FullyQualified fullyQualified6 = typeB.getSupertype();
            if (fullyQualified6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType.Parameterized typeBSuperType = (JavaType.Parameterized)fullyQualified6;
            JavaType.FullyQualified fullyQualified7 = typeBSuperType.getType();
            if (fullyQualified7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            Assertions.assertThat((String)((JavaType.Class)fullyQualified7).getTypeParameters().get(0).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.FullyQualified fullyQualified8 = ((J.ClassDeclaration)((J.CompilationUnit)cus.get(2)).getClasses().get(0)).getType();
            if (fullyQualified8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType.Parameterized typeC = (JavaType.Parameterized)fullyQualified8;
            Object e2 = typeC.getTypeParameters().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            Assertions.assertThat((String)((JavaType.GenericTypeVariable)e2).toString()).isEqualTo("Generic{T extends java.lang.String}");
            JavaType.FullyQualified fullyQualified9 = typeC.getSupertype();
            if (fullyQualified9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            JavaType.Parameterized typeCSuperType = (JavaType.Parameterized)fullyQualified9;
            Assertions.assertThat((String)typeCSuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.String}>");
            JavaType.FullyQualified fullyQualified10 = typeCSuperType.getType();
            if (fullyQualified10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            Assertions.assertThat((String)((JavaType.Class)fullyQualified10).getTypeParameters().get(0).toString()).isEqualTo("Generic{E}");
        }

        @Test
        public static void methodInvocationWithUnknownTypeSymbol(@NotNull JavaParserTypeMappingTest this_) {
            String source = "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nclass Test {\n    class Parent {\n    }\n    class Child extends Parent {\n    }\n\n    List<Parent> method(List<Parent> values) {\n        return values.stream()\n                .map(o -> {\n                    if (o instanceof Child) {\n                        return new UnknownType(((Child) o).toString());\n                    }\n                    return o;\n                })\n                .collect(Collectors.toList());\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::methodInvocationWithUnknownTypeSymbol$lambda-1), stringArray);
            Assertions.assertThat((List)cu).isNotNull();
        }

        @Test
        public static void methodInvocationOnUnknownType(@NotNull JavaParserTypeMappingTest this_) {
            String source = "import java.util.ArrayList;\n// do not import List to create an UnknownType\n\nclass Test {\n    class Base {\n        private int foo;\n        public boolean setFoo(int foo) {\n            this.foo = foo;\n        }\n        public int getFoo() {\n            return foo;\n        }\n    }\n    List<Base> createUnknownType(List<Integer> values) {\n        List<Base> bases = new ArrayList<>();\n        values.forEach((v) -> {\n            Base b = new Base();\n            b.setFoo(v);\n            bases.add(b);\n        });\n        return bases;\n    }\n}";
            String[] stringArray = new String[]{source};
            List cu = Companion.getParser().parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::methodInvocationOnUnknownType$lambda-2), stringArray);
            Assertions.assertThat((List)cu).isNotNull();
        }

        @NotNull
        public static JavaType.Parameterized goatType(@NotNull JavaParserTypeMappingTest this_) {
            return JavaTypeMappingTest.DefaultImpls.goatType(this_);
        }

        @NotNull
        public static JavaType.Method methodType(@NotNull JavaParserTypeMappingTest this_, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            return JavaTypeMappingTest.DefaultImpls.methodType(this_, methodName);
        }

        @NotNull
        public static JavaType firstMethodParameter(@NotNull JavaParserTypeMappingTest this_, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            return JavaTypeMappingTest.DefaultImpls.firstMethodParameter(this_, methodName);
        }

        @Test
        public static void javaLangObjectHasNoSupertype(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.javaLangObjectHasNoSupertype(this_);
        }

        @Test
        public static void interfacesContainImplicitAbstractFlag(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.interfacesContainImplicitAbstractFlag(this_);
        }

        @Test
        public static void extendsJavaLangObject(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.extendsJavaLangObject(this_);
        }

        @Test
        public static void constructor(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.constructor(this_);
        }

        @Test
        public static void array(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.array(this_);
        }

        @Test
        public static void className(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.className(this_);
        }

        @Test
        public static void primitive(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.primitive(this_);
        }

        @Test
        public static void parameterized(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.parameterized(this_);
        }

        @Test
        public static void generic(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.generic(this_);
        }

        @Test
        public static void genericContravariant(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericContravariant(this_);
        }

        @Test
        public static void genericMultipleBounds(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericMultipleBounds(this_);
        }

        @Test
        public static void genericUnbounded(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericUnbounded(this_);
        }

        @Test
        public static void genericRecursive(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericRecursive(this_);
        }

        @Test
        public static void genericArray(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericArray(this_);
        }

        @Test
        public static void innerClass(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.innerClass(this_);
        }

        @Test
        public static void inheritedJavaTypeGoat(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.inheritedJavaTypeGoat(this_);
        }

        @Test
        public static void genericIntersectionType(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.genericIntersectionType(this_);
        }

        @Test
        public static void enumTypeA(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.enumTypeA(this_);
        }

        @Test
        public static void enumTypeB(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.enumTypeB(this_);
        }

        @Test
        public static void ignoreSourceRetentionAnnotations(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.ignoreSourceRetentionAnnotations(this_);
        }

        @Test
        public static void recursiveIntersection(@NotNull JavaParserTypeMappingTest this_) {
            JavaTypeMappingTest.DefaultImpls.recursiveIntersection(this_);
        }

        private static void parameterizedTypesAreDeeplyBasedOnBounds$lambda-0(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void methodInvocationWithUnknownTypeSymbol$lambda-1(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }

        private static void methodInvocationOnUnknownType$lambda-2(Throwable t) {
            AssertionsKt.fail((Throwable)t);
            throw new KotlinNothingValueException();
        }
    }
}

