/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b(\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u000b\u001a\u00020\u0004H\u0017J\b\u0010\f\u001a\u00020\u0004H\u0017J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0011\u001a\u00020\u0004H\u0017J\u0018\u0010\u0012\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0016\u001a\u00020\u0004H\u0017J\b\u0010\u0017\u001a\u00020\u0004H\u0017J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\u001a\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010 \u001a\u00020\u0004H\u0017J\b\u0010!\u001a\u00020\u0004H\u0017J\b\u0010\"\u001a\u00020\u0004H\u0017J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010-\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u0010.\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u00100\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u00101\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u00102\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u00103\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u00104\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u00105\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u00106\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u00108\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010:\u001a\u00020\u0004H\u0017\u00a8\u0006;"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/test/RewriteTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addClassAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addMethodAnnotations", "addVariableAnnotationsToVariableAlreadyAnnotated", "addVariableAnnotationsToVariableNotAnnotated", "afterStatementInBlock", "assignmentNotPartOfVariableDeclaration", "assignmentWithinIfPredicate", "beforeStatementInBlock", "firstStatementInClassBlock", "firstStatementInMethodBlock", "innerEnumWithStaticMethod", "lambdaIsNewClass", "lambdaIsVariableInitializer", "Lorg/openrewrite/java/JavaParser$Builder;", "lastStatementInClassBlock", "lastStatementInMethodBlock", "methodDeclarationWithComment", "methodInvocationReplacementHasContextAboutLocalVariables", "replaceAndInterpolateMethodParameters", "replaceArguments", "replaceBody", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceExpressionWithAnotherExpression", "replaceFieldAccessWithMethodInvocation", "replaceIdentifierWithMethodInvocation", "replaceLambdaParameters", "replaceLambdaWithMethodReference", "replaceMethod", "replaceMethodAnnotations", "replaceMethodInvocationWithArray", "replaceMethodInvocationWithMethodReference", "replaceMethodNameAndArgumentsSimultaneously", "replaceMethodParameters", "replaceMethodParametersVariadicArray", "replaceMethodTypeParameters", "replaceMissingBody", "replaceNamedVariableInitializerMethodInvocation", "replacePackage", "replaceSingleExpressionInLambdaBody", "replaceSingleExpressionInLambdaBodyWithExpression", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementInLambdaBodyMultiStatementBlock", "replaceStatementInLambdaBodySingleStatementBlock", "replaceStatementInLambdaBodyWithVariableDeclaredInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "templateStatementIsWithinTryWithResourcesBlock", "rewrite-java-tck"})
public interface JavaTemplateTest
extends RewriteTest,
JavaRecipeTest {
    @Test
    public void templateStatementIsWithinTryWithResourcesBlock();

    @Test
    public void replaceIdentifierWithMethodInvocation();

    @Test
    public void replaceExpressionWithAnotherExpression();

    @Test
    public void replaceFieldAccessWithMethodInvocation();

    @Test
    public void methodInvocationReplacementHasContextAboutLocalVariables();

    @Test
    public void innerEnumWithStaticMethod(@NotNull JavaParser var1);

    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInLambdaBodySingleStatementBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceStatementInLambdaBodyWithVariableDeclaredInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceStatementInLambdaBodyMultiStatementBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceSingleExpressionInLambdaBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceSingleExpressionInLambdaBodyWithExpression(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMethodNameAndArgumentsSimultaneously(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithArray(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParametersVariadicArray(@NotNull JavaParser var1);

    @Test
    public void replaceAndInterpolateMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaParameters(@NotNull JavaParser var1);

    @Test
    public void replaceSingleStatement(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void afterStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void firstStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void firstStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void replaceStatementRequiringNewImport(@NotNull JavaParser var1);

    @Test
    public void replaceArguments(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotation(@NotNull JavaParser var1);

    @Test
    public void replaceMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceVariableAnnotations(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaParser var1);

    @Test
    public void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaParser var1);

    @Test
    public void addMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void addClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassImplements(@NotNull JavaParser var1);

    @Test
    public void replaceClassExtends(@NotNull JavaParser var1);

    @Test
    public void replaceThrows(@NotNull JavaParser var1);

    @Disabled
    @Test
    public void replaceMethodTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceClassTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMissingBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceNamedVariableInitializerMethodInvocation(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void lambdaIsVariableInitializer(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void methodDeclarationWithComment();

    @Test
    public void assignmentNotPartOfVariableDeclaration();

    @Test
    public void assignmentWithinIfPredicate();

    @Test
    public void lambdaIsNewClass();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void templateStatementIsWithinTryWithResourcesBlock(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(templateStatementIsWithinTryWithResourcesBlock.1.INSTANCE), null, "\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        new ByteArrayInputStream(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ", null, "\n            import java.io.*;\n            import java.nio.charset.StandardCharsets;\n            \n            class Test {\n                ByteArrayInputStream createBis(byte[] bytes) {\n                    return new ByteArrayInputStream(bytes);\n                }\n                \n                void doSomething() {\n                    String sout = \"\";\n                    try (BufferedReader br = new BufferedReader(new FileReader(null))) {\n                        createBis(\"bytes\".getBytes(StandardCharsets.UTF_8));\n                    } catch (IOException e) {\n                        e.printStackTrace();\n                    }\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void replaceIdentifierWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceIdentifierWithMethodInvocation.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f);\n                }\n            }\n        ", null, "\n            import java.io.File;\n            class Test {\n                void test(File f) {\n                    System.out.println(f.getCanonicalFile().toPath());\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void replaceExpressionWithAnotherExpression(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceExpressionWithAnotherExpression.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            class Test {\n                void test(int i) {\n                    int n = +i;\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int i) {\n                    int n = i++;\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void replaceFieldAccessWithMethodInvocation(@NotNull JavaTemplateTest this_) {
            Recipe recipe2 = this_.toRecipe(replaceFieldAccessWithMethodInvocation.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, recipe2, null, "\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f);\n                }\n            }\n        ", null, "\n            import java.io.File;\n            class Test {\n                File f;\n                void test() {\n                    System.out.println(this.f.getCanonicalFile().toPath());\n                }\n            }\n        ", 1, 1, null, null, 789, null);
        }

        @Test
        public static void methodInvocationReplacementHasContextAboutLocalVariables(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(methodInvocationReplacementHasContextAboutLocalVariables.1.INSTANCE), null, "\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.clear();\n                }\n            }\n        ", null, "\n            import java.util.List;\n            class Test {\n                List<String> words;\n                void test() {\n                    words.add(\"jon\");\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void innerEnumWithStaticMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = this_.toRecipe(innerEnumWithStaticMethod.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A(type);\n                }\n            }\n        ", null, "\n            class A {\n                public enum Type {\n                    One;\n            \n                    public Type(String t) {\n                    }\n            \n                    String t;\n            \n                    public static Type fromType(String type) {\n                        return null;\n                    }\n                }\n            \n                public A(Type type) {}\n                public A() {}\n            \n                public void method(Type type) {\n                    new A();\n                }\n            }\n        ", 0, 0, innerEnumWithStaticMethod.2.INSTANCE, null, 724, null);
        }

        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replacePackage.1.INSTANCE), null, "\n            package a;\n            class Test {\n            }\n        ", null, "\n            package b;\n            class Test {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethod.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                int test2(int n) {\n                    return n;\n                }\n            }\n        ", 0, 0, null, replaceMethod.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceLambdaWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaWithMethodReference.1.INSTANCE), null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = it -> it.toString();\n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodySingleStatementBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodySingleStatementBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 0;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                int n;\n\n                void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        return n == 1;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodyWithVariableDeclaredInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodyWithVariableDeclaredInBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 0;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<Object> obj) {\n                    obj.filter(o -> {\n                        int n = 0;\n                        return n == 1;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInLambdaBodyMultiStatementBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInLambdaBodyMultiStatementBlock.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toLowerCase();\n                        return str;\n                    });\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.map(o -> {\n                        String str = o;\n                        str = o.toUpperCase();\n                        return str;\n                    });\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceSingleExpressionInLambdaBody.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toLowerCase().length() > 0);\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                static void method(Stream<String> obj) {\n                    obj.filter(o -> o.toUpperCase().length() > 0);\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleExpressionInLambdaBodyWithExpression(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceSingleExpressionInLambdaBodyWithExpression.1.INSTANCE), null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o.equals(Abc.A));\n                }\n            }\n        ", null, "\n            import java.util.stream.Stream;\n\n            class Test {\n                enum Abc {A,B,C}\n                static void method(Stream<Abc> obj) {\n                    Object a = obj.filter(o -> o == Abc.A);\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethodNameAndArgumentsSimultaneously(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = this_.toRecipe(replaceMethodNameAndArgumentsSimultaneously.1.INSTANCE);
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                public class A {\n                    public A acceptInteger(Integer i) { return this; }\n                    public A acceptString(String s) { return this; }\n                    public A someOtherMethod() { return this; }\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptInteger(i)\n                            .someOtherMethod();\n                }\n            }\n        ", stringArray2, "\n            package org.openrewrite;\n            \n            public class Foo {\n                {\n                    Integer i = 1;\n                    new A().someOtherMethod()\n                            .acceptString(i.toString())\n                            .someOtherMethod();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void replaceMethodInvocationWithArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"package org.openrewrite;\npublic class Test {\n    public void method(int[] val) {}\n    public void method(int[] val1, String val2) {}\n}"};
            Recipe recipe3 = recipe2;
            recipe2 = this_.toRecipe(replaceMethodInvocationWithArray.1.INSTANCE);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, null, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr, null);\n                }\n            }\n        ", (String[])recipe3, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr);\n                }\n            }\n        ", 0, 0, replaceMethodInvocationWithArray.2.INSTANCE, null, 708, null);
        }

        @Test
        public static void replaceMethodInvocationWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodInvocationWithMethodReference.1.INSTANCE), null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = getToString();\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParameters.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int m, java.util.List<String> n) {\n                    new Runnable() {\n                        void inner(int m, java.util.List<String> n) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParameters.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceMethodParametersVariadicArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodParametersVariadicArray.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(Object[]... values) {\n                    new Runnable() {\n                        void inner(Object[]... values) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, replaceMethodParametersVariadicArray.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceAndInterpolateMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceAndInterpolateMethodParameters.1.INSTANCE), null, "\n            class Test {\n                void test(String s) {\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int n, String s) {\n                }\n            }\n        ", 0, 0, null, replaceAndInterpolateMethodParameters.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceLambdaParameters.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceSingleStatement.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(beforeStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(afterStatementInBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void firstStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(firstStatementInClassBlock.1.INSTANCE), null, "\n            class Test {\n                // comment\n                int n;\n            }\n        ", null, "\n            class Test {\n                int m;\n                // comment\n                int n;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void firstStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(firstStatementInMethodBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    // comment\n                    int n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    int m = 0;\n                    // comment\n                    int n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInClassBlock.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            class Test {\n                int n;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(lastStatementInMethodBlock.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceStatementRequiringNewImport.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceArguments.1.INSTANCE), null, "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test();\n                }\n            }\n        ", null, "\n            abstract class Test {\n                abstract void test();\n                abstract void test(int m, int n, String foo);\n                void fred(int m, int n, String foo) {\n                    test(m, Integer.valueOf(n), \"foo\");\n                }\n            }\n        ", 0, 0, null, replaceArguments.2.INSTANCE, 468, null);
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotation.1.INSTANCE), null, "@SuppressWarnings(\"ALL\") class Test {}", null, "@Deprecated class Test {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodAnnotations.1.INSTANCE), null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassAnnotations.1.INSTANCE), null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceVariableAnnotations.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    // the m\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    // the m\n                    @SuppressWarnings(\"other\")\n                    int m;\n                    @SuppressWarnings(\"other\")\n                    final int n;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableAlreadyAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableAlreadyAnnotated.1.INSTANCE), null, "\n            class Test {\n                @SuppressWarnings(\"ALL\") private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\") /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                    @SuppressWarnings(\"ALL\") final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"ALL\")\n                @Deprecated\n                private final int m, a;\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated /* hello */\n                    Boolean z;\n                    // comment n\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    int n;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    final Boolean b;\n                    @SuppressWarnings(\"ALL\")\n                    @Deprecated\n                    // comment x, y\n                    private Boolean x, y;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addVariableAnnotationsToVariableNotAnnotated(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addVariableAnnotationsToVariableNotAnnotated.1.INSTANCE), null, "\n            class Test {\n                void test() {\n                    final int m;\n                    int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"ALL\")\n                    final int m;\n                    @SuppressWarnings(\"ALL\")\n                    int n;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addMethodAnnotations.1.INSTANCE), null, "\n            class Test {\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                void test1() {\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"other\")\n                public void test0() {\n                }\n\n                static final String WARNINGS = \"ALL\";\n\n                @SuppressWarnings(\"other\")\n                void test1() {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addClassAnnotations.1.INSTANCE), null, "\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassImplements.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassExtends.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceThrows.1.INSTANCE), null, "\n            class Test {\n                void test() {}\n            }\n        ", null, "\n            class Test {\n                void test() throws Exception {}\n            }\n        ", 0, 0, null, replaceThrows.2.INSTANCE, 468, null);
        }

        @Disabled
        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceMethodTypeParameters.1.INSTANCE), null, "\n            import java.util.List;\n            \n            class Test {\n            \n                void test() {\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n            \n                <T, U> void test(List<T> t, U u) {\n                }\n            }\n        ", 0, 0, replaceMethodTypeParameters.2.INSTANCE, replaceMethodTypeParameters.3.INSTANCE, 212, null);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(replaceClassTypeParameters.1.INSTANCE), null, "\n            class Test {\n            }\n        ", null, "\n            class Test<T, U> {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceBody.1.INSTANCE), null, "\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceMissingBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceMissingBody.1.INSTANCE), null, "\n            abstract class Test {\n                abstract void test();\n            }\n        ", null, "\n            abstract class Test {\n                void test(){\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceNamedVariableInitializerMethodInvocation(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(replaceNamedVariableInitializerMethodInvocation.1.INSTANCE), null, "\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> Integer.valueOf(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return Integer.valueOf(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            Integer.valueOf(i);\n                        }\n                    }.toString();\n                }\n            }\n        ", null, "\n            import java.util.Arrays;\n            import java.util.List;\n            import java.util.function.Function;\n            class Test {\n                void t() {\n                    List<String> nums = Arrays.asList(\"1\", \"2\", \"3\");\n                    nums.forEach(s -> new Integer(s));\n                }\n                void inLambda(int i) {\n                    Function<String, Integer> toString = it -> {\n                        try {\n                            return new Integer(it);\n                        }catch (NumberFormatException ex) {\n                            ex.printStackTrace();\n                        }\n                        return 0;\n                    };\n                }\n                String inClassDeclaration(int i) {\n                    return new Object() {\n                        void foo() {\n                            new Integer(i);\n                        }\n                    }.toString();\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void lambdaIsVariableInitializer(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, this_.toRecipe(lambdaIsVariableInitializer.1.INSTANCE), null, "\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> Integer.valueOf(it);\n            }\n        ", null, "\n            import java.util.function.Function;\n            class Test {\n                Function<String, Integer> asInteger = it -> new Integer(it);\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void methodDeclarationWithComment(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(methodDeclarationWithComment.1.INSTANCE), null, "\n            class A {\n            \n            }\n        ", null, "\n            class A {\n                /**\n                 * comment\n                 */\n                void foo() {\n                }\n\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void assignmentNotPartOfVariableDeclaration(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, this_.toRecipe(assignmentNotPartOfVariableDeclaration.1.INSTANCE), null, "\n            class A {\n                void foo() {\n                    int i;\n                    i = Integer.valueOf(1);\n                }\n            }\n        ", null, "\n            class A {\n                void foo() {\n                    int i;\n                    i = 1;\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void assignmentWithinIfPredicate(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 1) == 0) {}\n                }\n            }\n        ", (String)"\n            class A {\n                void foo() {\n                    double value = 0;\n                    if ((value = 0) == 0) {}\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.assignmentWithinIfPredicate$lambda-0(this_, arg_0), sourceSpecsArray);
        }

        @Test
        public static void lambdaIsNewClass(@NotNull JavaTemplateTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = Integer.valueOf(1);\n                    }, \"hello\" );\n                }\n            }\n            ", (String)"\n            class T {\n                public T (int a, Runnable r, String s) { }\n                static void method() {\n                    new T(1, () -> {\n                        int i;\n                        i = 1;\n                    }, \"hello\" );\n                }\n            }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.lambdaIsNewClass$lambda-1(this_, arg_0), sourceSpecsArray);
        }

        @NotNull
        public static JavaParser getParser(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull JavaTemplateTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull JavaTemplateTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull JavaTemplateTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull JavaTemplateTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        private static void assignmentWithinIfPredicate$lambda-0(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(assignmentWithinIfPredicate.1.1.INSTANCE));
        }

        private static void lambdaIsNewClass$lambda-1(JavaTemplateTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            spec.recipe(this$0.toRecipe(lambdaIsNewClass.1.1.INSTANCE));
        }
    }
}

