/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J!\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/search/FindMethodsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "findConstructors", "jp", "Lorg/openrewrite/java/JavaParser;", "findDataFlowFromSource", "findMethodReferences", "findMethods", "Lorg/openrewrite/java/search/FindMethods;", "methodPattern", "", "matchOverrides", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Lorg/openrewrite/java/search/FindMethods;", "findOverriddenMethodReferences", "findStaticMethodCalls", "findStaticallyImportedMethodCalls", "matchOnInnerClass", "matchVarargs", "rewrite-java-tck"})
public interface FindMethodsTest
extends JavaRecipeTest {
    @NotNull
    public FindMethods findMethods(@Nullable String var1, @Nullable Boolean var2);

    @Test
    public void findConstructors(@NotNull JavaParser var1);

    @Test
    public void findMethodReferences(@NotNull JavaParser var1);

    @Test
    public void findOverriddenMethodReferences(@NotNull JavaParser var1);

    @Test
    public void findStaticMethodCalls(@NotNull JavaParser var1);

    @Test
    public void findStaticallyImportedMethodCalls(@NotNull JavaParser var1);

    @Test
    public void matchVarargs(@NotNull JavaParser var1);

    @Test
    public void matchOnInnerClass(@NotNull JavaParser var1);

    @Test
    public void findDataFlowFromSource(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static FindMethods findMethods(@NotNull FindMethodsTest this_, @Nullable String methodPattern, @Nullable Boolean matchOverrides) {
            return new FindMethods(methodPattern, matchOverrides, null);
        }

        @Test
        public static void findConstructors(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethods findMethods = this_.findMethods("A <constructor>(String)", false);
            String[] stringArray = new String[]{"\n            class A {\n                public A(String s) {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findMethods, null, "\n            class Test {\n                A a = new A(\"test\");\n            }\n        ", stringArray2, "\n            class Test {\n                A a = /*~~>*/new A(\"test\");\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void findMethodReferences(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethods findMethods = this_.findMethods("A singleArg(String)", false);
            String[] stringArray = new String[]{"\n            class A {\n                public void singleArg(String s) {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findMethods, null, "\n            class Test {\n                void test() {\n                    new java.util.ArrayList<String>().forEach(new A()::singleArg);\n                }\n            }\n        ", stringArray2, "\n            class Test {\n                void test() {\n                    new java.util.ArrayList<String>().forEach(new A()::/*~~>*/singleArg);\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void findOverriddenMethodReferences(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)this_.findMethods("java.util.Collection isEmpty()", true), null, "\n            class Test {\n                void test() {\n                    new java.util.ArrayList<String>().isEmpty();\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    /*~~>*/new java.util.ArrayList<String>().isEmpty();\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void findStaticMethodCalls(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)this_.findMethods("java.util.Collections emptyList()", false), null, "\n            import java.util.Collections;\n            public class A {\n               Object o = Collections.emptyList();\n            }\n        ", null, "\n            import java.util.Collections;\n            public class A {\n               Object o = /*~~>*/Collections.emptyList();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void findStaticallyImportedMethodCalls(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)this_.findMethods("java.util.Collections emptyList()", false), null, "\n            import static java.util.Collections.emptyList;\n            public class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            public class A {\n               Object o = /*~~>*/emptyList();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchVarargs(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethods findMethods = this_.findMethods("A foo(String, Object...)", false);
            String[] stringArray = new String[]{"\n            public class A {\n                public void foo(String s, Object... o) {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findMethods, null, "\n            public class B {\n               public void test() {\n                   new A().foo(\"s\", \"a\", 1);\n               }\n            }\n        ", stringArray2, "\n            public class B {\n               public void test() {\n                   /*~~>*/new A().foo(\"s\", \"a\", 1);\n               }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void matchOnInnerClass(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethods findMethods = this_.findMethods("B.C foo()", false);
            String[] stringArray = new String[]{"\n            public class B {\n               public static class C {\n                   public void foo() {}\n               }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)findMethods, null, "\n            public class A {\n               void test() {\n                   new B.C().foo();\n               }\n            }\n        ", stringArray2, "\n            public class A {\n               void test() {\n                   /*~~>*/new B.C().foo();\n               }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void findDataFlowFromSource(@NotNull FindMethodsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new FindMethods("java.util.Collections emptyList()", Boolean.valueOf(false), "data"), null, "\n            import static java.util.Collections.emptyList;\n            public class A {\n               void test() {\n                   Object o = emptyList();\n                   System.out.println(o);\n               }\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            public class A {\n               void test() {\n                   Object o = /*~~>*/emptyList();\n                   System.out.println(/*~~>*/o);\n               }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void checkValidation(@NotNull FindMethodsTest this_) {
            FindMethods recipe2 = this_.findMethods(null, false);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("methodPattern");
            recipe2 = this_.findMethods("com.foo.Foo bar()", false);
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isTrue();
        }

        @NotNull
        public static JavaParser getParser(@NotNull FindMethodsTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull FindMethodsTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull FindMethodsTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull FindMethodsTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull FindMethodsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindMethodsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindMethodsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindMethodsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindMethodsTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        public static void assertChangedBase(@NotNull FindMethodsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindMethodsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull FindMethodsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FindMethodsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull FindMethodsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull FindMethodsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

