/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.dataflow.Dataflow;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.LocalTaintFlowSpec;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\u0012\u0010\u0015\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/dataflow/DataflowInsanityTest;", "Lorg/openrewrite/test/RewriteTest;", "DependencyCheck", "", "aws-serverless-java-container", "basex", "big file", "californium", "commons-io ", "commons-io if test ", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "goat test", "jsonschema2pojo", "karate", "maven-scm", "random types doing strange things", "simple", "termux-app TermuxDocumentProvider", "test assignment to null variable", "doRunDataFlow", "Lorg/openrewrite/java/JavaIsoVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-java-tck"})
public interface DataflowInsanityTest
extends RewriteTest {
    public void doRunDataFlow(@NotNull JavaIsoVisitor<ExecutionContext> var1);

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void simple();

    @Test
    public void random types doing strange things();

    @Test
    public void test assignment to null variable();

    @Test
    public void goat test();

    @Test
    public void big file();

    @Test
    public void maven-scm();

    @Test
    public void aws-serverless-java-container();

    @Test
    @Disabled(value="Basic block already has a successor")
    public void basex();

    @Test
    public void californium();

    @Test
    public void DependencyCheck();

    @Test
    public void jsonschema2pojo();

    @Test
    public void karate();

    @Test
    public void termux-app TermuxDocumentProvider();

    @Test
    public void commons-io if test ();

    @Test
    public void commons-io ();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void doRunDataFlow(@NotNull DataflowInsanityTest this_, @NotNull JavaIsoVisitor<ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            Dataflow.startingAt((Cursor)receiver.getCursor()).findSinks((LocalFlowSpec)new LocalTaintFlowSpec<Expression, Expression>(){

                public boolean isSource(@NotNull Expression source, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return true;
                }

                public boolean isSink(@NotNull Expression sink, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return true;
                }
            });
        }

        public static void defaults(@NotNull DataflowInsanityTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(() -> DefaultImpls.defaults$lambda-0(this_)));
            spec.expectedCyclesThatMakeChanges(0).cycles(1);
        }

        @Test
        public static void simple(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class A {\n                public void m() {\n                    int i = 0;\n                    i = 1;\n                }\n            }\n        ", (String)"\n            public class A {\n                public void m() {\n                    int i = 0;\n                    i = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void random types doing strange things(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.Collection;\n                import java.util.ArrayList;\n                import java.util.function.Supplier;\n\n                @SuppressWarnings(\"RedundantSuppression\")\n                abstract class Test<P extends Collection> implements Supplier<P> {\n                    Object field;\n                    Object ternaryStrangeness = conditional() ? get() : get().stream();\n                    static Boolean conditional() {\n                        return null;\n                    }\n                    static {\n                        Supplier s = new Test<Collection>() {\n                            @Override\n                            public Collection get() {\n                                return new ArrayList<>();\n                            }\n                        };\n                    }\n                    Test() {\n                        Collection c = new ArrayList();\n                        c.add(1);\n                        //noinspection UnusedAssignment\n                        field = c;\n                        this.field = \"Over achievements!\";\n                    }\n\n                    @Override\n                    public P get() {\n                        return null;\n                    }\n\n                    void test() {\n                        String n = \"42\";\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void test assignment to null variable(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.io.File;\n            import java.io.FileFilter;\n\n            class Test {\n                void test2(File srcDir, File destDir, FileFilter filter) {\n                    // Cater for destination being directory within the source directory (see IO-141)\n                    List<String> exclusionList = null;\n                    String canonicalDestDir = destDir.getCanonicalPath();\n                    if (canonicalDestDir.startsWith(srcDir.getCanonicalPath())) {\n                        File[] srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);\n                        if (srcFiles != null && srcFiles.length > 0) {\n                            exclusionList = new ArrayList<String>(srcFiles.length);\n                            for (File srcFile : srcFiles) {\n                                File copiedFile = new File(destDir, srcFile.getName());\n                                exclusionList.add(copiedFile.getCanonicalPath());\n                            }\n                        }\n                    }\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void goat test(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite.java;\n\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n\n            // Whenever this class is changed, make a corresponding change in JavaTypeGoat in the main resources folder.\n            @AnnotationWithRuntimeRetention\n            @AnnotationWithSourceRetention\n            public abstract class JavaTypeGoat<T, S extends PT<S> & C> {\n\n                public static final PT<TypeA> parameterizedField = new PT<TypeA>() {\n                };\n\n                public static abstract class InheritedJavaTypeGoat<T, U extends PT<U> & C> extends JavaTypeGoat<T, U> {\n                    public InheritedJavaTypeGoat() {\n                        super();\n                    }\n                }\n\n                public enum EnumTypeA {\n                    FOO, BAR(),\n                    @AnnotationWithRuntimeRetention\n                    FUZ\n                }\n\n                public enum EnumTypeB {\n                    FOO(null);\n                    private TypeA label;\n                    EnumTypeB(TypeA label) {\n                        this.label = label;\n                    }\n                }\n\n                public abstract class ExtendsJavaTypeGoat extends JavaTypeGoat<T, S> {\n                }\n\n                public static abstract class Extension<U extends Extension<U>> {}\n\n                public static class TypeA {}\n                public static class TypeB {}\n\n                @AnnotationWithRuntimeRetention\n                @AnnotationWithSourceRetention\n                public abstract void clazz(C n);\n                public abstract void primitive(int n);\n                public abstract void array(C[][] n);\n                public abstract PT<C> parameterized(PT<C> n);\n                public abstract PT<PT<C>> parameterizedRecursive(PT<PT<C>> n);\n                public abstract PT<? extends C> generic(PT<? extends C> n);\n                public abstract PT<? super C> genericContravariant(PT<? super C> n);\n                public abstract <U extends JavaTypeGoat<U, ?>> JavaTypeGoat<? extends U[], ?> genericRecursive(JavaTypeGoat<? extends U[], ?> n);\n                public abstract <U> PT<U> genericUnbounded(PT<U> n);\n                public abstract void genericArray(PT<C>[] n);\n                public abstract void inner(C.Inner n);\n                public abstract void enumTypeA(EnumTypeA n);\n                public abstract void enumTypeB(EnumTypeB n);\n                public abstract <U extends PT<U> & C> InheritedJavaTypeGoat<T, U> inheritedJavaTypeGoat(InheritedJavaTypeGoat<T, U> n);\n                public abstract <U extends TypeA & PT<U> & C> U genericIntersection(U n);\n                public abstract T genericT(T n); // remove after signatures are common.\n                public abstract <U extends JavaTypeGoat.Extension<U> & Intersection<U>> void recursiveIntersection(U n);\n            }\n\n            interface C {\n                class Inner {\n                }\n            }\n\n            interface PT<T> {\n            }\n\n            interface Intersection<T extends JavaTypeGoat.Extension<T> & Intersection<T>> {\n                T getIntersectionType();\n            }\n\n            @Retention(RetentionPolicy.SOURCE)\n            @interface AnnotationWithSourceRetention {}\n\n            @Retention(RetentionPolicy.RUNTIME)\n            @interface AnnotationWithRuntimeRetention {}\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void big file(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)new StringBuilder(115853).append("\n            /*\n             * Licensed to the Apache Software Foundation (ASF) under one or more\n             * contributor license agreements.  See the NOTICE file distributed with\n             * this work for additional information regarding copyright ownership.\n             * The ASF licenses this file to You under the Apache License, Version 2.0\n             * (the \"License\"); you may not use this file except in compliance with\n             * the License.  You may obtain a copy of the License at\n             *\n             *      http://www.apache.org/licenses/LICENSE-2.0\n             *\n             * Unless required by applicable law or agreed to in writing, software\n             * distributed under the License is distributed on an \"AS IS\" BASIS,\n             * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n             * See the License for the specific language governing permissions and\n             * limitations under the License.\n             */\n            package org.apache.commons.io;\n\n            import java.io.File;\n            import java.io.FileFilter;\n            import java.io.FileInputStream;\n            import java.io.FileNotFoundException;\n            import java.io.FileOutputStream;\n            import java.io.IOException;\n            import java.io.InputStream;\n            import java.io.OutputStream;\n            import java.net.URL;\n            import java.net.URLConnection;\n            import java.nio.ByteBuffer;\n            import java.nio.channels.FileChannel;\n            import java.nio.charset.Charset;\n            import java.util.ArrayList;\n            import java.util.Collection;\n            import java.util.Date;\n            import java.util.Iterator;\n            import java.util.List;\n            import java.util.zip.CRC32;\n            import java.util.zip.CheckedInputStream;\n            import java.util.zip.Checksum;\n\n            import org.apache.commons.io.filefilter.DirectoryFileFilter;\n            import org.apache.commons.io.filefilter.FalseFileFilter;\n            import org.apache.commons.io.filefilter.FileFilterUtils;\n            import org.apache.commons.io.filefilter.IOFileFilter;\n            import org.apache.commons.io.filefilter.SuffixFileFilter;\n            import org.apache.commons.io.filefilter.TrueFileFilter;\n            import org.apache.commons.io.output.NullOutputStream;\n\n            /**\n             * General file manipulation utilities.\n             * <p>\n             * Facilities are provided in the following areas:\n             * <ul>\n             * <li>writing to a file\n             * <li>reading from a file\n             * <li>make a directory including parent directories\n             * <li>copying files and directories\n             * <li>deleting files and directories\n             * <li>converting to and from a URL\n             * <li>listing files and directories by filter and extension\n             * <li>comparing file content\n             * <li>file last changed date\n             * <li>calculating a checksum\n             * </ul>\n             * <p>\n             * Origin of code: Excalibur, Alexandria, Commons-Utils\n             *\n             * @author <a href=\"mailto:burton@relativity.yi.org\">Kevin A. Burton</A>\n             * @author <a href=\"mailto:sanders@apache.org\">Scott Sanders</a>\n             * @author <a href=\"mailto:dlr@finemaltcoding.com\">Daniel Rall</a>\n             * @author <a href=\"mailto:Christoph.Reck@dlr.de\">Christoph.Reck</a>\n             * @author <a href=\"mailto:peter@apache.org\">Peter Donald</a>\n             * @author <a href=\"mailto:jefft@apache.org\">Jeff Turner</a>\n             * @author Matthew Hawthorne\n             * @author <a href=\"mailto:jeremias@apache.org\">Jeremias Maerki</a>\n             * @author Stephen Colebourne\n             * @author Ian Springer\n             * @author Chris Eldredge\n             * @author Jim Harrington\n             * @author Niall Pemberton\n             * @author Sandy McArthur\n             * @version $Id$\n             */\n            public class FileUtils {\n\n                /**\n                 * Instances should NOT be constructed in standard programming.\n                 */\n                public FileUtils() {\n                    super();\n                }\n\n                /**\n                 * The number of bytes in a kilobyte.\n                 */\n                public static final long ONE_KB = 1024;\n\n                /**\n                 * The number of bytes in a megabyte.\n                 */\n                public static final long ONE_MB = ONE_KB * ONE_KB;\n\n                /**\n                 * The number of bytes in a 50 MB.\n                 */\n                private static final long FIFTY_MB = ONE_MB * 50;\n\n                /**\n                 * The number of bytes in a gigabyte.\n                 */\n                public static final long ONE_GB = ONE_KB * ONE_MB;\n\n                /**\n                 * An empty array of type <code>File</code>.\n                 */\n                public static final File[] EMPTY_FILE_ARRAY = new File[0];\n\n                /**\n                 * The UTF-8 character set, used to decode octets in URLs.\n                 */\n                private static final Charset UTF8 = Charset.forName(\"UTF-8\");\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Returns the path to the system temporary directory.\n                 *\n                 * @return the path to the system temporary directory.\n                 *\n                 * @since Commons IO 2.0\n                 */\n                public static String getTempDirectoryPath() {\n                    return System.getProperty(\"java.io.tmpdir\");\n                }\n\n                /**\n                 * Returns a {@link File} representing the system temporary directory.\n                 *\n                 * @return the system temporary directory.\n                 *\n                 * @since Commons IO 2.0\n                 */\n                public static File getTempDirectory() {\n                    return new File(getTempDirectoryPath());\n                }\n\n                /**\n                 * Returns the path to the user's home directory.\n                 *\n                 * @return the path to the user's home directory.\n                 *\n                 * @since Commons IO 2.0\n                 */\n                public static String getUserDirectoryPath() {\n                    return System.getProperty(\"user.home\");\n                }\n\n                /**\n                 * Returns a {@link File} representing the user's home directory.\n                 *\n                 * @return the user's home directory.\n                 *\n                 * @since Commons IO 2.0\n                 */\n                public static File getUserDirectory() {\n                    return new File(getUserDirectoryPath());\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Opens a {@link FileInputStream} for the specified file, providing better\n                 * error messages than simply calling <code>new FileInputStream(file)</code>.\n                 * <p>\n                 * At the end of the method either the stream will be successfully opened,\n                 * or an exception will have been thrown.\n                 * <p>\n                 * An exception is thrown if the file does not exist.\n                 * An exception is thrown if the file object exists but is a directory.\n                 * An exception is thrown if the file exists but cannot be read.\n                 *\n                 * @param file  the file to open for input, must not be <code>null</code>\n                 * @return a new {@link FileInputStream} for the specified file\n                 * @throws FileNotFoundException if the file does not exist\n                 * @throws IOException if the file object is a directory\n                 * @throws IOException if the file cannot be read\n                 * @since Commons IO 1.3\n                 */\n                public static FileInputStream openInputStream(File file) throws IOException {\n                    if (file.exists()) {\n                        if (file.isDirectory()) {\n                            throw new IOException(\"File '\" + file + \"' exists but is a directory\");\n                        }\n                        if (file.canRead() == false) {\n                            throw new IOException(\"File '\" + file + \"' cannot be read\");\n                        }\n                    } else {\n                        throw new FileNotFoundException(\"File '\" + file + \"' does not exist\");\n                    }\n                    return new FileInputStream(file);\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Opens a {@link FileOutputStream} for the specified file, checking and\n                 * creating the parent directory if it does not exist.\n                 * <p>\n                 * At the end of the method either the stream will be successfully opened,\n                 * or an exception will have been thrown.\n                 * <p>\n                 * The parent directory will be created if it does not exist.\n                 * The file will be created if it does not exist.\n                 * An exception is thrown if the file object exists but is a directory.\n                 * An exception is thrown if the file exists but cannot be written to.\n                 * An exception is thrown if the parent directory cannot be created.\n                 *\n                 * @param file  the file to open for output, must not be <code>null</code>\n                 * @return a new {@link FileOutputStream} for the specified file\n                 * @throws IOException if the file object is a directory\n                 * @throws IOException if the file cannot be written to\n                 * @throws IOException if a parent directory needs creating but that fails\n                 * @since Commons IO 1.3\n                 */\n                public static FileOutputStream openOutputStream(File file) throws IOException {\n                    if (file.exists()) {\n                        if (file.isDirectory()) {\n                            throw new IOException(\"File '\" + file + \"' exists but is a directory\");\n                        }\n                        if (file.canWrite() == false) {\n                            throw new IOException(\"File '\" + file + \"' cannot be written to\");\n                        }\n                    } else {\n                        File parent = file.getParentFile();\n                        if (parent != null && parent.exists() == false) {\n                            if (parent.mkdirs() == false) {\n                                throw new IOException(\"File '\" + file + \"' could not be created\");\n                            }\n                        }\n                    }\n                    return new FileOutputStream(file);\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Returns a human-readable version of the file size, where the input\n                 * represents a specific number of bytes.\n                 *\n                 * If the size is over 1GB, the size is returned as the number of whole GB,\n                 * i.e. the size is rounded down to the nearest GB boundary.\n                 *\n                 * Similarly for the 1MB and 1KB boundaries.\n                 *\n                 * @param size  the number of bytes\n                 * @return a human-readable display value (includes units - GB, MB, KB or bytes)\n                 */\n                // See https://issues.apache.org/jira/browse/IO-226 - should the rounding be changed?\n                public static String byteCountToDisplaySize(long size) {\n                    String displaySize;\n\n                    if (size / ONE_GB > 0) {\n                        displaySize = String.valueOf(size / ONE_GB) + \" GB\";\n                    } else if (size / ONE_MB > 0) {\n                        displaySize = String.valueOf(size / ONE_MB) + \" MB\";\n                    } else if (size / ONE_KB > 0) {\n                        displaySize = String.valueOf(size / ONE_KB) + \" KB\";\n                    } else {\n                        displaySize = String.valueOf(size) + \" bytes\";\n                    }\n                    return displaySize;\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Implements the same behaviour as the \"touch\" utility on Unix. It creates\n                 * a new file with size 0 or, if the file exists already, it is opened and\n                 * closed without modifying it, but updating the file date and time.\n                 * <p>\n                 * NOTE: As from v1.3, this method throws an IOException if the last\n                 * modified date of the file cannot be set. Also, as from v1.3 this method\n                 * creates parent directories if they do not exist.\n                 *\n                 * @param file  the File to touch\n                 * @throws IOException If an I/O problem occurs\n                 */\n                public static void touch(File file) throws IOException {\n                    if (!file.exists()) {\n                        OutputStream out = openOutputStream(file);\n                        IOUtils.closeQuietly(out);\n                    }\n                    boolean success = file.setLastModified(System.currentTimeMillis());\n                    if (!success) {\n                        throw new IOException(\"Unable to set the last modification time for \" + file);\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Converts a Collection containing java.io.File instanced into array\n                 * representation. This is to account for the difference between\n                 * File.listFiles() and FileUtils.listFiles().\n                 *\n                 * @param files  a Collection containing java.io.File instances\n                 * @return an array of java.io.File\n                 */\n                public static File[] convertFileCollectionToFileArray(Collection<File> files) {\n                     return files.toArray(new File[files.size()]);\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Finds files within a given directory (and optionally its\n                 * subdirectories). All files found are filtered by an IOFileFilter.\n                 *\n                 * @param files the collection of files found.\n                 * @param directory the directory to search in.\n                 * @param filter the filter to apply to files and directories.\n                 */\n                private static void innerListFiles(Collection<File> files, File directory,\n                        IOFileFilter filter) {\n                    File[] found = directory.listFiles((FileFilter) filter);\n                    if (found != null) {\n                        for (File file : found) {\n                            if (file.isDirectory()) {\n                                innerListFiles(files, file, filter);\n                            } else {\n                                files.add(file);\n                            }\n                        }\n                    }\n                }\n\n                /**\n                 * Finds files within a given directory (and optionally its\n                 * subdirectories). All files found are filtered by an IOFileFilter.\n                 * <p>\n                 * If your search should recurse into subdirectories you can pass in\n                 * an IOFileFilter for directories. You don't need to bind a\n                 * DirectoryFileFilter (via logical AND) to this filter. This method does\n                 * that for you.\n                 * <p>\n                 * An example: If you want to search through all directories called\n                 * \"temp\" you pass in <code>FileFilterUtils.NameFileFilter(\"temp\")</code>\n                 * <p>\n                 * Another common usage of this method is find files in a directory\n                 * tree but ignoring the directories generated CVS. You can simply pass\n                 * in <code>FileFilterUtils.makeCVSAware(null)</code>.\n                 *\n                 * @param directory  the directory to search in\n                 * @param fileFilter  filter to apply when finding files.\n                 * @param dirFilter  optional filter to apply when finding subdirectories.\n                 * If this parameter is <code>null</code>, subdirectories will not be included in the\n                 * search. Use TrueFileFilter.INSTANCE to match all directories.\n                 * @return an collection of java.io.File with the matching files\n                 * @see org.apache.commons.io.filefilter.FileFilterUtils\n                 * @see org.apache.commons.io.filefilter.NameFileFilter\n                 */\n                public static Collection<File> listFiles(\n                        File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {\n                    if (!directory.isDirectory()) {\n                        throw new IllegalArgumentException(\n                                \"Parameter 'directory' is not a directory\");\n                    }\n                    if (fileFilter == null) {\n                        throw new NullPointerException(\"Parameter 'fileFilter' is null\");\n                    }\n\n                    //Setup effective file filter\n                    IOFileFilter effFileFilter = FileFilterUtils.and(fileFilter,\n                        FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));\n\n                    //Setup effective directory filter\n                    IOFileFilter effDirFilter;\n                    if (dirFilter == null) {\n                        effDirFilter = FalseFileFilter.INSTANCE;\n                    } else {\n                        effDirFilter = FileFilterUtils.and(dirFilter,\n                            DirectoryFileFilter.INSTANCE);\n                    }\n\n                    //Find files\n                    Collection<File> files = new java.util.LinkedList<File>();\n                    innerListFiles(files, directory,\n                        FileFilterUtils.or(effFileFilter, effDirFilter));\n                    return files;\n                }\n\n                /**\n                 * Allows iteration over the files in given directory (and optionally\n                 * its subdirectories).\n                 * <p>\n                 * All files found are filtered by an IOFileFilter. This method is\n                 * based on {@link #listFiles(File, IOFileFilter, IOFileFilter)}.\n                 *\n                 * @param directory  the directory to search in\n                 * @param fileFilter  filter to apply when finding files.\n                 * @param dirFilter  optional filter to apply when finding subdirectories.\n                 * If this parameter is <code>null</code>, subdirectories will not be included in the\n                 * search. Use TrueFileFilter.INSTANCE to match all directories.\n                 * @return an iterator of java.io.File for the matching files\n                 * @see org.apache.commons.io.filefilter.FileFilterUtils\n                 * @see org.apache.commons.io.filefilter.NameFileFilter\n                 * @since Commons IO 1.2\n                 */\n                public static Iterator<File> iterateFiles(\n                        File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {\n                    return listFiles(directory, fileFilter, dirFilter).iterator();\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Converts an array of file extensions to suffixes for use\n                 * with IOFileFilters.\n                 *\n                 * @param extensions  an array of extensions. Format: {\"java\", \"xml\"}\n                 * @return an array of suffixes. Format: {\".java\", \".xml\"}\n                 */\n                private static String[] toSuffixes(String[] extensions) {\n                    String[] suffixes = new String[extensions.length];\n                    for (int i = 0; i < extensions.length; i++) {\n                        suffixes[i] = \".\" + extensions[i];\n                    }\n                    return suffixes;\n                }\n\n\n                /**\n                 * Finds files within a given directory (and optionally its subdirectories)\n                 * which match an array of extensions.\n                 *\n                 * @param directory  the directory to search in\n                 * @param extensions  an array of extensions, ex. {\"java\",\"xml\"}. If this\n                 * parameter is <code>null</code>, all files are returned.\n                 * @param recursive  if true all subdirectories are searched as well\n                 * @return an collection of java.io.File with the matching files\n                 */\n                public static Collection<File> listFiles(\n                        File directory, String[] extensions, boolean recursive) {\n                    IOFileFilter filter;\n                    if (extensions == null) {\n                        filter = TrueFileFilter.INSTANCE;\n                    } else {\n                        String[] suffixes = toSuffixes(extensions);\n                        filter = new SuffixFileFilter(suffixes);\n                    }\n                    return listFiles(directory, filter,\n                        (recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));\n                }\n\n                /**\n                 * Allows iteration over the files in a given directory (and optionally\n                 * its subdirectories) which match an array of extensions. This method\n                 * is based on {@link #listFiles(File, String[], boolean)}.\n                 *\n                 * @param directory  the directory to search in\n                 * @param extensions  an array of extensions, ex. {\"java\",\"xml\"}. If this\n                 * parameter is <code>null</code>, all files are returned.\n                 * @param recursive  if true all subdirectories are searched as well\n                 * @return an iterator of java.io.File with the matching files\n                 * @since Commons IO 1.2\n                 */\n                public static Iterator<File> iterateFiles(\n                        File directory, String[] extensions, boolean recursive) {\n                    return listFiles(directory, extensions, recursive).iterator();\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Compares the contents of two files to determine if they are equal or not.\n                 * <p>\n                 * This method checks to see if the two files are different lengths\n                 * or if they point to the same file, before resorting to byte-by-byte\n                 * comparison of the contents.\n                 * <p>\n                 * Code origin: Avalon\n                 *\n                 * @param file1  the first file\n                 * @param file2  the second file\n                 * @return true if the content of the files are equal or they both don't\n                 * exist, false otherwise\n                 * @throws IOException in case of an I/O error\n                 */\n                public static boolean contentEquals(File file1, File file2) throws IOException {\n                    boolean file1Exists = file1.exists();\n                    if (file1Exists != file2.exists()) {\n                        return false;\n                    }\n\n                    if (!file1Exists) {\n                        // two not existing files are equal\n                        return true;\n                    }\n\n                    if (file1.isDirectory() || file2.isDirectory()) {\n                        // don't want to compare directory contents\n                        throw new IOException(\"Can't compare directories, only files\");\n                    }\n\n                    if (file1.length() != file2.length()) {\n                        // lengths differ, cannot be equal\n                        return false;\n                    }\n\n                    if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {\n                        // same file\n                        return true;\n                    }\n\n                    InputStream input1 = null;\n                    InputStream input2 = null;\n                    try {\n                        input1 = new FileInputStream(file1);\n                        input2 = new FileInputStream(file2);\n                        return IOUtils.contentEquals(input1, input2);\n\n                    } finally {\n                        IOUtils.closeQuietly(input1);\n                        IOUtils.closeQuietly(input2);\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Convert from a <code>URL</code> to a <code>File</code>.\n                 * <p>\n                 * From version 1.1 this method will decode the URL.\n                 * Syntax such as <code>file:///my%20docs/file.txt</code> will be\n                 * correctly decoded to <code>/my docs/file.txt</code>. Starting with version\n                 * 1.5, this method uses UTF-8 to decode percent-encoded octets to characters.\n                 * Additionally, malformed percent-encoded octets are handled leniently by\n                 * passing them through literally.\n                 *\n                 * @param url  the file URL to convert, <code>null</code> returns <code>null</code>\n                 * @return the equivalent <code>File</code> object, or <code>null</code>\n                 *  if the URL's protocol is not <code>file</code>\n                 */\n                public static File toFile(URL url) {\n                    if (url == null || !\"file\".equalsIgnoreCase(url.getProtocol())) {\n                        return null;\n                    } else {\n                        String filename = url.getFile().replace('/', File.separatorChar);\n                        filename = decodeUrl(filename);\n                        return new File(filename);\n                    }\n                }\n\n                /**\n                 * Decodes the specified URL as per RFC 3986, i.e. transforms\n                 * percent-encoded octets to characters by decoding with the UTF-8 character\n                 * set. This function is primarily intended for usage with\n                 * {@link java.net.URL} which unfortunately does not enforce proper URLs. As\n                 * such, this method will leniently accept invalid characters or malformed\n                 * percent-encoded octets and simply pass them literally through to the\n                 * result string. Except for rare edge cases, this will make unencoded URLs\n                 * pass through unaltered.\n                 *\n                 * @param url  The URL to decode, may be <code>null</code>.\n                 * @return The decoded URL or <code>null</code> if the input was\n                 *         <code>null</code>.\n                 */\n                static String decodeUrl(String url) {\n                    String decoded = url;\n                    if (url != null && url.indexOf('%') >= 0) {\n                        int n = url.length();\n                        StringBuffer buffer = new StringBuffer();\n                        ByteBuffer bytes = ByteBuffer.allocate(n);\n                        for (int i = 0; i < n;) {\n                            if (url.charAt(i) == '%') {\n                                try {\n                                    do {\n                                        byte octet = (byte) Integer.parseInt(url.substring(i + 1, i + 3), 16);\n                                        bytes.put(octet);\n                                        i += 3;\n                                    } while (i < n && url.charAt(i) == '%');\n                                    continue;\n                                } catch (RuntimeException e) {\n                                    // malformed percent-encoded octet, fall through and\n                                    // append characters literally\n                                } finally {\n                                    if (bytes.position() > 0) {\n                                        bytes.flip();\n                                        buffer.append(UTF8.decode(bytes).toString());\n                                        bytes.clear();\n                                    }\n                                }\n                            }\n                            buffer.append(url.charAt(i++));\n                        }\n                        decoded = buffer.toString();\n                    }\n                    return decoded;\n                }\n\n                /**\n                 * Converts each of an array of <code>URL</code> to a <code>File</code>.\n                 * <p>\n                 * Returns an array of the same size as the input.\n                 * If the input is <code>null</code>, an empty array is returned.\n                 * If the input contains <code>null</code>, the output array contains <code>null</code> at the same\n                 * index.\n                 * <p>\n                 * This method will decode the URL.\n                 * Syntax such as <code>file:///my%20docs/file.txt</code> will be\n                 * correctly decoded to <code>/my docs/file.txt</code>.\n                 *\n                 * @param urls  the file URLs to convert, <code>null</code> returns empty array\n                 * @return a non-<code>null</code> array of Files matching the input, with a <code>null</code> item\n                 *  if there was a <code>null</code> at that index in the input array\n                 * @throws IllegalArgumentException if any file is not a URL file\n                 * @throws IllegalArgumentException if any file is incorrectly encoded\n                 * @since Commons IO 1.1\n                 */\n                public static File[] toFiles(URL[] urls) {\n                    if (urls == null || urls.length == 0) {\n                        return EMPTY_FILE_ARRAY;\n                    }\n                    File[] files = new File[urls.length];\n                    for (int i = 0; i < urls.length; i++) {\n                        URL url = urls[i];\n                        if (url != null) {\n                            if (url.getProtocol().equals(\"file\") == false) {\n                                throw new IllegalArgumentException(\n                                        \"URL could not be converted to a File: \" + url);\n                            }\n                            files[i] = toFile(url);\n                        }\n                    }\n                    return files;\n                }\n\n                /**\n                 * Converts each of an array of <code>File</code> to a <code>URL</code>.\n                 * <p>\n                 * Returns an array of the same size as the input.\n                 *\n                 * @param files  the files to convert\n                 * @return an array of URLs matching the input\n                 * @throws IOException if a file cannot be converted\n                 */\n                public static URL[] toURLs(File[] files) throws IOException {\n                    URL[] urls = new URL[files.length];\n\n                    for (int i = 0; i < urls.length; i++) {\n                        urls[i] = files[i].toURI().toURL();\n                    }\n\n                    return urls;\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Copies a file to a directory preserving the file date.\n                 * <p>\n                 * This method copies the contents of the specified source file\n                 * to a file of the same name in the specified destination directory.\n                 * The destination directory is created if it does not exist.\n                 * If the destination file exists, then this method will overwrite it.\n                 * <p>\n                 * <strong>Note:</strong> This method tries to preserve the file's last\n                 * modified date/times using {@link File#setLastModified(long)}, however\n                 * it is not guaranteed that the operation will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcFile  an existing file to copy, must not be <code>null</code>\n                 * @param destDir  the directory to place the copy in, must not be <code>null</code>\n                 *\n                 * @throws NullPointerException if source or destination is null\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @see #copyFile(File, File, boolean)\n                 */\n                public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {\n                    copyFileToDirectory(srcFile, destDir, true);\n                }\n\n                /**\n                 * Copies a file to a directory optionally preserving the file date.\n                 * <p>\n                 * This method copies the contents of the specified source file\n                 * to a file of the same name in the specified destination directory.\n                 * The destination directory is created if it does not exist.\n                 * If the destination file exists, then this method will overwrite it.\n                 * <p>\n                 * <strong>Note:</strong> Setting <code>preserveFileDate</code> to\n                 * <code>true</code> tries to preserve the file's last modified\n                 * date/times using {@link File#setLastModified(long)}, however it is\n                 * not guaranteed that the operation will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcFile  an existing file to copy, must not be <code>null</code>\n                 * @param destDir  the directory to place the copy in, must not be <code>null</code>\n                 * @param preserveFileDate  true if the file date of the copy\n                 *  should be the same as the original\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @see #copyFile(File, File, boolean)\n                 * @since Commons IO 1.3\n                 */\n                public static void copyFileToDirectory(File srcFile, File destDir, boolean preserveFileDate) throws IOException {\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (destDir.exists() && destDir.isDirectory() == false) {\n                        throw new IllegalArgumentException(\"Destination '\" + destDir + \"' is not a directory\");\n                    }\n                    File destFile = new File(destDir, srcFile.getName());\n                    copyFile(srcFile, destFile, preserveFileDate);\n                }\n\n                /**\n                 * Copies a file to a new location preserving the file date.\n                 * <p>\n                 * This method copies the contents of the specified source file to the\n                 * specified destination file. The directory holding the destination file is\n                 * created if it does not exist. If the destination file exists, then this\n                 * method will overwrite it.\n                 * <p>\n                 * <strong>Note:</strong> This method tries to preserve the file's last\n                 * modified date/times using {@link File#setLastModified(long)}, however\n                 * it is not guaranteed that the operation will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcFile  an existing file to copy, must not be <code>null</code>\n                 * @param destFile  the new file, must not be <code>null</code>\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @see #copyFileToDirectory(File, File)\n                 */\n                public static void copyFile(File srcFile, File destFile) throws IOException {\n                    copyFile(srcFile, destFile, true);\n                }\n\n                /**\n                 * Copies a file to a new location.\n                 * <p>\n                 * This method copies the contents of the specified source file\n                 * to the specified destination file.\n                 * The directory holding the destination file is created if it does not exist.\n                 * If the destination file exists, then this method will overwrite it.\n                 * <p>\n                 * <strong>Note:</strong> Setting <code>preserveFileDate</code> to\n                 * <code>true</code> tries to preserve the file's last modified\n                 * date/times using {@link File#setLastModified(long)}, however it is\n                 * not guaranteed that the operation will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcFile  an existing file to copy, must not be <code>null</code>\n                 * @param destFile  the new file, must not be <code>null</code>\n                 * @param preserveFileDate  true if the file date of the copy\n                 *  should be the same as the original\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @see #copyFileToDirectory(File, File, boolean)\n                 */\n                public static void copyFile(File srcFile, File destFile,\n                        boolean preserveFileDate) throws IOException {\n                    if (srcFile == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destFile == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (srcFile.exists() == false) {\n                        throw new FileNotFoundException(\"Source '\" + srcFile + \"' does not exist\");\n                    }\n                    if (srcFile.isDirectory()) {\n                        throw new IOException(\"Source '\" + srcFile + \"' exists but is a directory\");\n                    }\n                    if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {\n                        throw new IOException(\"Source '\" + srcFile + \"' and destination '\" + destFile + \"' are the same\");\n                    }\n                    if (destFile.getParentFile() != null && destFile.getParentFile().exists() == false) {\n                        if (destFile.getParentFile().mkdirs() == false) {\n                            throw new IOException(\"Destination '\" + destFile + \"' directory cannot be created\");\n                        }\n                    }\n                    if (destFile.exists() && destFile.canWrite() == false) {\n                        throw new IOException(\"Destination '\" + destFile + \"' exists but is read-only\");\n                    }\n                    doCopyFile(srcFile, destFile, preserveFileDate);\n                }\n\n                /**\n                 * Internal copy file method.\n                 *\n                 * @param srcFile  the validated source file, must not be <code>null</code>\n                 * @param destFile  the validated destination file, must not be <code>null</code>\n                 * @param preserveFileDate  whether to preserve the file date\n                 * @throws IOException if an error occurs\n                 */\n                private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {\n                    if (destFile.exists() && destFile.isDirectory()) {\n                        throw new IOException(\"Destination '\" + destFile + \"' exists but is a directory\");\n                    }\n\n                    FileInputStream fis = null;\n                    FileOutputStream fos = null;\n                    FileChannel input = null;\n                    FileChannel output = null;\n                    try {\n                        fis = new FileInputStream(srcFile);\n                        fos = new FileOutputStream(destFile);\n                        input  = fis.getChannel();\n                        output = fos.getChannel();\n                        long size = input.size();\n                        long pos = 0;\n                        long count = 0;\n                        while (pos < size) {\n                            count = (size - pos) > FIFTY_MB ? FIFTY_MB : (size - pos);\n                            pos += output.transferFrom(input, pos, count);\n                        }\n                    } finally {\n                        IOUtils.closeQuietly(output);\n                        IOUtils.closeQuietly(fos);\n                        IOUtils.closeQuietly(input);\n                        IOUtils.closeQuietly(fis);\n                    }\n\n                    if (srcFile.length() != destFile.length()) {\n                        throw new IOException(\"Failed to copy full contents from '\" +\n                                srcFile + \"' to '\" + destFile + \"'\");\n                    }\n                    if (preserveFileDate) {\n                        destFile.setLastModified(srcFile.lastModified());\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Copies a directory to within another directory preserving the file dates.\n                 * <p>\n                 * This method copies the source directory and all its contents to a\n                 * directory of the same name in the specified destination directory.\n                 * <p>\n                 * The destination directory is created if it does not exist.\n                 * If the destination directory did exist, then this method merges\n                 * the source with the destination, with the source taking precedence.\n                 * <p>\n                 * <strong>Note:</strong> This method tries to preserve the files' last\n                 * modified date/times using {@link File#setLastModified(long)}, however\n                 * it is not guaranteed that those operations will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcDir  an existing directory to copy, must not be <code>null</code>\n                 * @param destDir  the directory to place the copy in, must not be <code>null</code>\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 1.2\n                 */\n                public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {\n                    if (srcDir == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (srcDir.exists() && srcDir.isDirectory() == false) {\n                        throw new IllegalArgumentException(\"Source '\" + destDir + \"' is not a directory\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (destDir.exists() && destDir.isDirectory() == false) {\n                        throw new IllegalArgumentException(\"Destination '\" + destDir + \"' is not a directory\");\n                    }\n                    copyDirectory(srcDir, new File(destDir, srcDir.getName()), true);\n                }\n\n                /**\n                 * Copies a whole directory to a new location preserving the file dates.\n                 * <p>\n                 * This method copies the specified directory and all its child\n                 * directories and files to the specified destination.\n                 * The destination is the new location and name of the directory.\n                 * <p>\n                 * The destination directory is created if it does not exist.\n                 * If the destination directory did exist, then this method merges\n                 * the source with the destination, with the source taking precedence.\n                 * <p>\n                 * <strong>Note:</strong> This method tries to preserve the files' last\n                 * modified date/times using {@link File#setLastModified(long)}, however\n                 * it is not guaranteed that those operations will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcDir  an existing directory to copy, must not be <code>null</code>\n                 * @param destDir  the new directory, must not be <code>null</code>\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 1.1\n                 */\n                public static void copyDirectory(File srcDir, File destDir) throws IOException {\n                    copyDirectory(srcDir, destDir, true);\n                }\n\n                /**\n                 * Copies a whole directory to a new location.\n                 * <p>\n                 * This method copies the contents of the specified source directory\n                 * to within the specified destination directory.\n                 * <p>\n                 * The destination directory is created if it does not exist.\n                 * If the destination directory did exist, then this method merges\n                 * the source with the destination, with the source taking precedence.\n                 * <p>\n                 * <strong>Note:</strong> Setting <code>preserveFileDate</code> to\n                 * <code>true</code> tries to preserve the files' last modified\n                 * date/times using {@link File#setLastModified(long)}, however it is\n                 * not guaranteed that those operations will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * @param srcDir  an existing directory to copy, must not be <code>null</code>\n                 * @param destDir  the new directory, must not be <code>null</code>\n                 * @param preserveFileDate  true if the file date of the copy\n                 *  should be the same as the original\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 1.1\n                 */\n                public static void copyDirectory(File srcDir, File destDir,\n                        boolean preserveFileDate) throws IOException {\n                    copyDirectory(srcDir, destDir, null, preserveFileDate);\n                }\n\n                /**\n                 * Copies a filtered directory to a new location preserving the file dates.\n                 * <p>\n                 * This method copies the contents of the specified source directory\n                 * to within the specified destination directory.\n                 * <p>\n                 * The destination directory is created if it does not exist.\n                 * If the destination directory did exist, then this method merges\n                 * the source with the destination, with the source taking precedence.\n                 * <p>\n                 * <strong>Note:</strong> This method tries to preserve the files' last\n                 * modified date/times using {@link File#setLastModified(long)}, however\n                 * it is not guaranteed that those operations will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * <h4>Example: Copy directories only</h4>\n                 *  <pre>\n                 *  // only copy the directory structure\n                 *  FileUtils.copyDirectory(srcDir, destDir, DirectoryFileFilter.DIRECTORY);\n                 *  </pre>\n                 *\n                 * <h4>Example: Copy directories and txt files</h4>\n                 *  <pre>\n                 *  // Create a filter for \".txt\" files\n                 *  IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter(\".txt\");\n                 *  IOFileFilter txtFiles = FileFilterUtils.andFileFilter(FileFileFilter.FILE, txtSuffixFilter);\n                 *\n                 *  // Create a filter for either directories or \".txt\" files\n                 *  FileFilter filter = FileFilterUtils.orFileFilter(DirectoryFileFilter.DIRECTORY, txtFiles);\n                 *\n                 *  // Copy using the filter\n                 *  FileUtils.copyDirectory(srcDir, destDir, filter);\n                 *  </pre>\n                 *\n                 * @param srcDir  an existing directory to copy, must not be <code>null</code>\n                 * @param destDir  the new directory, must not be <code>null</code>\n                 * @param filter  the filter to apply, null means copy all directories and files\n                 *  should be the same as the original\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 1.4\n                 */\n                public static void copyDirectory(File srcDir, File destDir,\n                        FileFilter filter) throws IOException {\n                    copyDirectory(srcDir, destDir, filter, true);\n                }\n\n                /**\n                 * Copies a filtered directory to a new location.\n                 * <p>\n                 * This method copies the contents of the specified source directory\n                 * to within the specified destination directory.\n                 * <p>\n                 * The destination directory is created if it does not exist.\n                 * If the destination directory did exist, then this method merges\n                 * the source with the destination, with the source taking precedence.\n                 * <p>\n                 * <strong>Note:</strong> Setting <code>preserveFileDate</code> to\n                 * <code>true</code> tries to preserve the files' last modified\n                 * date/times using {@link File#setLastModified(long)}, however it is\n                 * not guaranteed that those operations will succeed.\n                 * If the modification operation fails, no indication is provided.\n                 *\n                 * <h4>Example: Copy directories only</h4>\n                 *  <pre>\n                 *  // only copy the directory structure\n                 *  FileUtils.copyDirectory(srcDir, destDir, DirectoryFileFilter.DIRECTORY, false);\n                 *  </pre>\n                 *\n                 * <h4>Example: Copy directories and txt files</h4>\n                 *  <pre>\n                 *  // Create a filter for \".txt\" files\n                 *  IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter(\".txt\");\n                 *  IOFileFilter txtFiles = FileFilterUtils.andFileFilter(FileFileFilter.FILE, txtSuffixFilter);\n                 *\n                 *  // Create a filter for either directories or \".txt\" files\n                 *  FileFilter filter = FileFilterUtils.orFileFilter(DirectoryFileFilter.DIRECTORY, txtFiles);\n                 *\n                 *  // Copy using the filter\n                 *  FileUtils.copyDirectory(srcDir, destDir, filter, false);\n                 *  </pre>\n                 *\n                 * @param srcDir  an existing directory to copy, must not be <code>null</code>\n                 * @param destDir  the new directory, must not be <code>null</code>\n                 * @param filter  the filter to apply, null means copy all directories and files\n                 * @param preserveFileDate  true if the file date of the copy\n                 *  should be the same as the original\n                 *\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 1.4\n                 */\n                public static void copyDirectory(File srcDir, File destDir,\n                        FileFilter filter, boolean preserveFileDate) throws IOException {\n                    if (srcDir == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (srcDir.exists() == false) {\n                        throw new FileNotFoundException(\"Source '\" + srcDir + \"' does not exist\");\n                    }\n                    if (srcDir.isDirectory() == false) {\n                        throw new IOException(\"Source '\" + srcDir + \"' exists but is not a directory\");\n                    }\n                    if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {\n                        throw new IOException(\"Source '\" + srcDir + \"' and destination '\" + destDir + \"' are the same\");\n                    }\n\n                    // Cater for destination being directory within the source directory (see IO-141)\n                    List<String> exclusionList = null;\n                    String canonicalDestDir = destDir.getCanonicalPath();\n                    if (canonicalDestDir.startsWith(srcDir.getCanonicalPath())) {\n                        File[] srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);\n                        if (srcFiles != null && srcFiles.length > 0) {\n                            exclusionList = new ArrayList<String>(srcFiles.length);\n                            for (File srcFile : srcFiles) {\n                                File copiedFile = new File(destDir, srcFile.getName());\n                                exclusionList.add(copiedFile.getCanonicalPath());\n                            }\n                        }\n                    }\n                    doCopyDirectory(srcDir, destDir, filter, preserveFileDate, exclusionList);\n                }\n\n                /**\n                 * Internal copy directory method.\n                 *\n                 * @param srcDir  the validated source directory, must not be <code>null</code>\n                 * @param destDir  the validated destination directory, must not be <code>null</code>\n                 * @param filter  the filter to apply, null means copy all directories and files\n                 * @param preserveFileDate  whether to preserve the file date\n                 * @param exclusionList  List of files and directories to exclude from the copy, may be null\n                 * @throws IOException if an error occurs\n                 * @since Commons IO 1.1\n                 */\n                private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter,\n                        boolean preserveFileDate, List<String> exclusionList) throws IOException {\n                    // recurse\n                    File[] files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);\n                    if (files == null) {  // null if security restricted\n                        throw new IOException(\"Failed to list contents of \" + srcDir);\n                    }\n                    if (destDir.exists()) {\n                        if (destDir.isDirectory() == false) {\n                            throw new IOException(\"Destination '\" + destDir + \"' exists but is not a directory\");\n                        }\n                    } else {\n                        if (destDir.mkdirs() == false) {\n                            throw new IOException(\"Destination '\" + destDir + \"' directory cannot be created\");\n                        }\n                    }\n                    if (destDir.canWrite() == false) {\n                        throw new IOException(\"Destination '\" + destDir + \"' cannot be written to\");\n                    }\n                    for (File file : files) {\n                        File copiedFile = new File(destDir, file.getName());\n                        if (exclusionList == null || !exclusionList.contains(file.getCanonicalPath())) {\n                            if (file.isDirectory()) {\n                                doCopyDirectory(file, copiedFile, filter, preserveFileDate, exclusionList);\n                            } else {\n                                doCopyFile(file, copiedFile, preserveFileDate);\n                            }\n                        }\n                    }\n\n                    // Do this last, as the above has probably affected directory metadata\n                    if (preserveFileDate) {\n                        destDir.setLastModified(srcDir.lastModified());\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Copies bytes from the URL <code>source</code> to a file\n                 * <code>destination</code>. The directories up to <code>destination</code>\n                 * will be created if they don't already exist. <code>destination</code>\n                 * will be overwritten if it already exists.\n                 * <p>\n                 * Warning: this method does not set a connection or read timeout and thus\n                 * might block forever. Use {@link #copyURLToFile(URL, File, int, int)}\n                 * with reasonable timeouts to prevent this.\n                 *\n                 * @param source  the <code>URL</code> to copy bytes from, must not be <code>null</code>\n                 * @param destination  the non-directory <code>File</code> to write bytes to\n                 *  (possibly overwriting), must not be <code>null</code>\n                 * @throws IOException if <code>source</code> URL cannot be opened\n                 * @throws IOException if <code>destination</code> is a directory\n                 * @throws IOException if <code>destination</code> cannot be written\n                 * @throws IOException if <code>destination</code> needs creating but can't be\n                 * @throws IOException if an IO error occurs during copying\n                 */\n                public static void copyURLToFile(URL source, File destination) throws IOException {\n                    InputStream input = source.openStream();\n                    copyInputStreamToFile(input, destination);\n                }\n\n                /**\n                 * Copies bytes from the URL <code>source</code> to a file\n                 * <code>destination</code>. The directories up to <code>destination</code>\n                 * will be created if they don't already exist. <code>destination</code>\n                 * will be overwritten if it already exists.\n                 *\n                 * @param source  the <code>URL</code> to copy bytes from, must not be <code>null</code>\n                 * @param destination  the non-directory <code>File</code> to write bytes to\n                 *  (possibly overwriting), must not be <code>null</code>\n                 * @param connectionTimeout the number of milliseconds until this method\n                 *  will timeout if no connection could be established to the <code>source</code>\n                 * @param readTimeout the number of milliseconds until this method will\n                 *  timeout if no data could be read from the <code>source</code>\n                 * @throws IOException if <code>source</code> URL cannot be opened\n                 * @throws IOException if <code>destination</code> is a directory\n                 * @throws IOException if <code>destination</code> cannot be written\n                 * @throws IOException if <code>destination</code> needs creating but can't be\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 2.0\n                 */\n                public static void copyURLToFile(URL source, File destination,\n                        int connectionTimeout, int readTimeout) throws IOException {\n                    URLConnection connection = source.openConnection();\n                    connection.setConnectTimeout(connectionTimeout);\n                    connection.setReadTimeout(readTimeout);\n                    InputStream input = connection.getInputStream();\n                    copyInputStreamToFile(input, destination);\n                }\n\n                /**\n                 * Copies bytes from an {@link InputStream} <code>source</code> to a file\n                 * <code>destination</code>. The directories up to <code>destination</code>\n                 * will be created if they don't already exist. <code>destination</code>\n                 * will be overwritten if it already exists.\n                 *\n                 * @param source  the <code>InputStream</code> to copy bytes from, must not be <code>null</code>\n                 * @param destination  the non-directory <code>File</code> to write bytes to\n                 *  (possibly overwriting), must not be <code>null</code>\n                 * @throws IOException if <code>destination</code> is a directory\n                 * @throws IOException if <code>destination</code> cannot be written\n                 * @throws IOException if <code>destination</code> needs creating but can't be\n                 * @throws IOException if an IO error occurs during copying\n                 * @since Commons IO 2.0\n                 */\n                public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {\n                    try {\n                        FileOutputStream output = openOutputStream(destination);\n                        try {\n                            IOUtils.copy(source, output);\n                        } finally {\n                            IOUtils.closeQuietly(output);\n                        }\n                    } finally {\n                        IOUtils.closeQuietly(source);\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Deletes a directory recursively.\n                 *\n                 * @param directory  directory to delete\n                 * @throws IOException in case deletion is unsuccessful\n                 */\n                public static void deleteDirectory(File directory) throws IOException {\n                    if (!directory.exists()) {\n                        return;\n                    }\n\n                    if (!isSymlink(directory)) {\n                        cleanDirectory(directory);\n                    }\n\n                    if (!directory.delete()) {\n                        String message =\n                            \"Unable to delete directory \" + d").append("irectory + \".\";\n                        throw new IOException(message);\n                    }\n                }\n\n                /**\n                 * Deletes a file, never throwing an exception. If file is a directory, delete it and all sub-directories.\n                 * <p>\n                 * The difference between File.delete() and this method are:\n                 * <ul>\n                 * <li>A directory to be deleted does not have to be empty.</li>\n                 * <li>No exceptions are thrown when a file or directory cannot be deleted.</li>\n                 * </ul>\n                 *\n                 * @param file  file or directory to delete, can be <code>null</code>\n                 * @return <code>true</code> if the file or directory was deleted, otherwise\n                 * <code>false</code>\n                 *\n                 * @since Commons IO 1.4\n                 */\n                public static boolean deleteQuietly(File file) {\n                    if (file == null) {\n                        return false;\n                    }\n                    try {\n                        if (file.isDirectory()) {\n                            cleanDirectory(file);\n                        }\n                    } catch (Exception ignored) {\n                    }\n\n                    try {\n                        return file.delete();\n                    } catch (Exception ignored) {\n                        return false;\n                    }\n                }\n\n                /**\n                 * Cleans a directory without deleting it.\n                 *\n                 * @param directory directory to clean\n                 * @throws IOException in case cleaning is unsuccessful\n                 */\n                public static void cleanDirectory(File directory) throws IOException {\n                    if (!directory.exists()) {\n                        String message = directory + \" does not exist\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    if (!directory.isDirectory()) {\n                        String message = directory + \" is not a directory\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    File[] files = directory.listFiles();\n                    if (files == null) {  // null if security restricted\n                        throw new IOException(\"Failed to list contents of \" + directory);\n                    }\n\n                    IOException exception = null;\n                    for (File file : files) {\n                        try {\n                            forceDelete(file);\n                        } catch (IOException ioe) {\n                            exception = ioe;\n                        }\n                    }\n\n                    if (null != exception) {\n                        throw exception;\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Waits for NFS to propagate a file creation, imposing a timeout.\n                 * <p>\n                 * This method repeatedly tests {@link File#exists()} until it returns\n                 * true up to the maximum time specified in seconds.\n                 *\n                 * @param file  the file to check, must not be <code>null</code>\n                 * @param seconds  the maximum time in seconds to wait\n                 * @return true if file exists\n                 * @throws NullPointerException if the file is <code>null</code>\n                 */\n                public static boolean waitFor(File file, int seconds) {\n                    int timeout = 0;\n                    int tick = 0;\n                    while (!file.exists()) {\n                        if (tick++ >= 10) {\n                            tick = 0;\n                            if (timeout++ > seconds) {\n                                return false;\n                            }\n                        }\n                        try {\n                            Thread.sleep(100);\n                        } catch (InterruptedException ignore) {\n                            // ignore exception\n                        } catch (Exception ex) {\n                            break;\n                        }\n                    }\n                    return true;\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Reads the contents of a file into a String.\n                 * The file is always closed.\n                 *\n                 * @param file  the file to read, must not be <code>null</code>\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @return the file contents, never <code>null</code>\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 */\n                public static String readFileToString(File file, String encoding) throws IOException {\n                    InputStream in = null;\n                    try {\n                        in = openInputStream(file);\n                        return IOUtils.toString(in, encoding);\n                    } finally {\n                        IOUtils.closeQuietly(in);\n                    }\n                }\n\n\n                /**\n                 * Reads the contents of a file into a String using the default encoding for the VM.\n                 * The file is always closed.\n                 *\n                 * @param file  the file to read, must not be <code>null</code>\n                 * @return the file contents, never <code>null</code>\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.3.1\n                 */\n                public static String readFileToString(File file) throws IOException {\n                    return readFileToString(file, null);\n                }\n\n                /**\n                 * Reads the contents of a file into a byte array.\n                 * The file is always closed.\n                 *\n                 * @param file  the file to read, must not be <code>null</code>\n                 * @return the file contents, never <code>null</code>\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.1\n                 */\n                public static byte[] readFileToByteArray(File file) throws IOException {\n                    InputStream in = null;\n                    try {\n                        in = openInputStream(file);\n                        return IOUtils.toByteArray(in);\n                    } finally {\n                        IOUtils.closeQuietly(in);\n                    }\n                }\n\n                /**\n                 * Reads the contents of a file line by line to a List of Strings.\n                 * The file is always closed.\n                 *\n                 * @param file  the file to read, must not be <code>null</code>\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @return the list of Strings representing each line in the file, never <code>null</code>\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 * @since Commons IO 1.1\n                 */\n                public static List<String> readLines(File file, String encoding) throws IOException {\n                    InputStream in = null;\n                    try {\n                        in = openInputStream(file);\n                        return IOUtils.readLines(in, encoding);\n                    } finally {\n                        IOUtils.closeQuietly(in);\n                    }\n                }\n\n                /**\n                 * Reads the contents of a file line by line to a List of Strings using the default encoding for the VM.\n                 * The file is always closed.\n                 *\n                 * @param file  the file to read, must not be <code>null</code>\n                 * @return the list of Strings representing each line in the file, never <code>null</code>\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.3\n                 */\n                public static List<String> readLines(File file) throws IOException {\n                    return readLines(file, null);\n                }\n\n                /**\n                 * Returns an Iterator for the lines in a <code>File</code>.\n                 * <p>\n                 * This method opens an <code>InputStream</code> for the file.\n                 * When you have finished with the iterator you should close the stream\n                 * to free internal resources. This can be done by calling the\n                 * {@link LineIterator#close()} or\n                 * {@link LineIterator#closeQuietly(LineIterator)} method.\n                 * <p>\n                 * The recommended usage pattern is:\n                 * <pre>\n                 * LineIterator it = FileUtils.lineIterator(file, \"UTF-8\");\n                 * try {\n                 *   while (it.hasNext()) {\n                 *     String line = it.nextLine();\n                 *     /// do something with line\n                 *   }\n                 * } finally {\n                 *   LineIterator.closeQuietly(iterator);\n                 * }\n                 * </pre>\n                 * <p>\n                 * If an exception occurs during the creation of the iterator, the\n                 * underlying stream is closed.\n                 *\n                 * @param file  the file to open for input, must not be <code>null</code>\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @return an Iterator of the lines in the file, never <code>null</code>\n                 * @throws IOException in case of an I/O error (file closed)\n                 * @since Commons IO 1.2\n                 */\n                public static LineIterator lineIterator(File file, String encoding) throws IOException {\n                    InputStream in = null;\n                    try {\n                        in = openInputStream(file);\n                        return IOUtils.lineIterator(in, encoding);\n                    } catch (IOException ex) {\n                        IOUtils.closeQuietly(in);\n                        throw ex;\n                    } catch (RuntimeException ex) {\n                        IOUtils.closeQuietly(in);\n                        throw ex;\n                    }\n                }\n\n                /**\n                 * Returns an Iterator for the lines in a <code>File</code> using the default encoding for the VM.\n                 *\n                 * @param file  the file to open for input, must not be <code>null</code>\n                 * @return an Iterator of the lines in the file, never <code>null</code>\n                 * @throws IOException in case of an I/O error (file closed)\n                 * @since Commons IO 1.3\n                 * @see #lineIterator(File, String)\n                 */\n                public static LineIterator lineIterator(File file) throws IOException {\n                    return lineIterator(file, null);\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Writes a String to a file creating the file if it does not exist.\n                 *\n                 * NOTE: As from v1.3, the parent directories of the file will be created\n                 * if they do not exist.\n                 *\n                 * @param file  the file to write\n                 * @param data  the content to write to the file\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 */\n                public static void writeStringToFile(File file, String data, String encoding) throws IOException {\n                    OutputStream out = null;\n                    try {\n                        out = openOutputStream(file);\n                        IOUtils.write(data, out, encoding);\n                    } finally {\n                        IOUtils.closeQuietly(out);\n                    }\n                }\n\n                /**\n                 * Writes a String to a file creating the file if it does not exist using the default encoding for the VM.\n                 *\n                 * @param file  the file to write\n                 * @param data  the content to write to the file\n                 * @throws IOException in case of an I/O error\n                 */\n                public static void writeStringToFile(File file, String data) throws IOException {\n                    writeStringToFile(file, data, null);\n                }\n\n                /**\n                 * Writes a CharSequence to a file creating the file if it does not exist using the default encoding for the VM.\n                 *\n                 * @param file  the file to write\n                 * @param data  the content to write to the file\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 2.0\n                 */\n                public static void write(File file, CharSequence data) throws IOException {\n                    String str = data == null ? null : data.toString();\n                    writeStringToFile(file, str);\n                }\n\n                /**\n                 * Writes a CharSequence to a file creating the file if it does not exist.\n                 *\n                 * @param file  the file to write\n                 * @param data  the content to write to the file\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 * @since Commons IO 2.0\n                 */\n                public static void write(File file, CharSequence data, String encoding) throws IOException {\n                    String str = data == null ? null : data.toString();\n                    writeStringToFile(file, str, encoding);\n                }\n\n                /**\n                 * Writes a byte array to a file creating the file if it does not exist.\n                 * <p>\n                 * NOTE: As from v1.3, the parent directories of the file will be created\n                 * if they do not exist.\n                 *\n                 * @param file  the file to write to\n                 * @param data  the content to write to the file\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.1\n                 */\n                public static void writeByteArrayToFile(File file, byte[] data) throws IOException {\n                    OutputStream out = null;\n                    try {\n                        out = openOutputStream(file);\n                        out.write(data);\n                    } finally {\n                        IOUtils.closeQuietly(out);\n                    }\n                }\n\n                /**\n                 * Writes the <code>toString()</code> value of each item in a collection to\n                 * the specified <code>File</code> line by line.\n                 * The specified character encoding and the default line ending will be used.\n                 * <p>\n                 * NOTE: As from v1.3, the parent directories of the file will be created\n                 * if they do not exist.\n                 *\n                 * @param file  the file to write to\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @param lines  the lines to write, <code>null</code> entries produce blank lines\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 * @since Commons IO 1.1\n                 */\n                public static void writeLines(File file, String encoding, Collection<?> lines) throws IOException {\n                    writeLines(file, encoding, lines, null);\n                }\n\n                /**\n                 * Writes the <code>toString()</code> value of each item in a collection to\n                 * the specified <code>File</code> line by line.\n                 * The default VM encoding and the default line ending will be used.\n                 *\n                 * @param file  the file to write to\n                 * @param lines  the lines to write, <code>null</code> entries produce blank lines\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.3\n                 */\n                public static void writeLines(File file, Collection<?> lines) throws IOException {\n                    writeLines(file, null, lines, null);\n                }\n\n                /**\n                 * Writes the <code>toString()</code> value of each item in a collection to\n                 * the specified <code>File</code> line by line.\n                 * The specified character encoding and the line ending will be used.\n                 * <p>\n                 * NOTE: As from v1.3, the parent directories of the file will be created\n                 * if they do not exist.\n                 *\n                 * @param file  the file to write to\n                 * @param encoding  the encoding to use, <code>null</code> means platform default\n                 * @param lines  the lines to write, <code>null</code> entries produce blank lines\n                 * @param lineEnding  the line separator to use, <code>null</code> is system default\n                 * @throws IOException in case of an I/O error\n                 * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n                 * @since Commons IO 1.1\n                 */\n                public static void writeLines(File file, String encoding, Collection<?> lines, String lineEnding)\n                    throws IOException {\n                    OutputStream out = null;\n                    try {\n                        out = openOutputStream(file);\n                        IOUtils.writeLines(lines, lineEnding, out, encoding);\n                    } finally {\n                        IOUtils.closeQuietly(out);\n                    }\n                }\n\n                /**\n                 * Writes the <code>toString()</code> value of each item in a collection to\n                 * the specified <code>File</code> line by line.\n                 * The default VM encoding and the specified line ending will be used.\n                 *\n                 * @param file  the file to write to\n                 * @param lines  the lines to write, <code>null</code> entries produce blank lines\n                 * @param lineEnding  the line separator to use, <code>null</code> is system default\n                 * @throws IOException in case of an I/O error\n                 * @since Commons IO 1.3\n                 */\n                public static void writeLines(File file, Collection<?> lines, String lineEnding) throws IOException {\n                    writeLines(file, null, lines, lineEnding);\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Deletes a file. If file is a directory, delete it and all sub-directories.\n                 * <p>\n                 * The difference between File.delete() and this method are:\n                 * <ul>\n                 * <li>A directory to be deleted does not have to be empty.</li>\n                 * <li>You get exceptions when a file or directory cannot be deleted.\n                 *      (java.io.File methods returns a boolean)</li>\n                 * </ul>\n                 *\n                 * @param file  file or directory to delete, must not be <code>null</code>\n                 * @throws NullPointerException if the directory is <code>null</code>\n                 * @throws FileNotFoundException if the file was not found\n                 * @throws IOException in case deletion is unsuccessful\n                 */\n                public static void forceDelete(File file) throws IOException {\n                    if (file.isDirectory()) {\n                        deleteDirectory(file);\n                    } else {\n                        boolean filePresent = file.exists();\n                        if (!file.delete()) {\n                            if (!filePresent){\n                                throw new FileNotFoundException(\"File does not exist: \" + file);\n                            }\n                            String message =\n                                \"Unable to delete file: \" + file;\n                            throw new IOException(message);\n                        }\n                    }\n                }\n\n\n\n\n                /**\n                 * Schedules a file to be deleted when JVM exits.\n                 * If file is directory delete it and all sub-directories.\n                 *\n                 * @param file  file or directory to delete, must not be <code>null</code>\n                 * @throws NullPointerException if the file is <code>null</code>\n                 * @throws IOException in case deletion is unsuccessful\n                 */\n                public static void forceDeleteOnExit(File file) throws IOException {\n                    if (file.isDirectory()) {\n                        deleteDirectoryOnExit(file);\n                    } else {\n                        file.deleteOnExit();\n                    }\n                }\n\n                /**\n                 * Schedules a directory recursively for deletion on JVM exit.\n                 *\n                 * @param directory  directory to delete, must not be <code>null</code>\n                 * @throws NullPointerException if the directory is <code>null</code>\n                 * @throws IOException in case deletion is unsuccessful\n                 */\n                private static void deleteDirectoryOnExit(File directory) throws IOException {\n                    if (!directory.exists()) {\n                        return;\n                    }\n\n                    if (!isSymlink(directory)) {\n                        cleanDirectoryOnExit(directory);\n                    }\n                    directory.deleteOnExit();\n                }\n\n                /**\n                 * Cleans a directory without deleting it.\n                 *\n                 * @param directory  directory to clean, must not be <code>null</code>\n                 * @throws NullPointerException if the directory is <code>null</code>\n                 * @throws IOException in case cleaning is unsuccessful\n                 */\n                private static void cleanDirectoryOnExit(File directory) throws IOException {\n                    if (!directory.exists()) {\n                        String message = directory + \" does not exist\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    if (!directory.isDirectory()) {\n                        String message = directory + \" is not a directory\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    File[] files = directory.listFiles();\n                    if (files == null) {  // null if security restricted\n                        throw new IOException(\"Failed to list contents of \" + directory);\n                    }\n\n                    IOException exception = null;\n                    for (File file : files) {\n                        try {\n                            forceDeleteOnExit(file);\n                        } catch (IOException ioe) {\n                            exception = ioe;\n                        }\n                    }\n\n                    if (null != exception) {\n                        throw exception;\n                    }\n                }\n\n                /**\n                 * Makes a directory, including any necessary but nonexistent parent\n                 * directories. If a file already exists with specified name but it is\n                 * not a directory then an IOException is thrown.\n                 * If the directory cannot be created (or does not already exist)\n                 * then an IOException is thrown.\n                 *\n                 * @param directory  directory to create, must not be <code>null</code>\n                 * @throws NullPointerException if the directory is <code>null</code>\n                 * @throws IOException if the directory cannot be created or the file already exists but is not a directory\n                 */\n                public static void forceMkdir(File directory) throws IOException {\n                    if (directory.exists()) {\n                        if (!directory.isDirectory()) {\n                            String message =\n                                \"File \"\n                                    + directory\n                                    + \" exists and is \"\n                                    + \"not a directory. Unable to create directory.\";\n                            throw new IOException(message);\n                        }\n                    } else {\n                        if (!directory.mkdirs()) {\n                            // Double-check that some other thread or process hasn't made\n                            // the directory in the background\n                            if (!directory.isDirectory())\n                            {\n                                String message =\n                                    \"Unable to create directory \" + directory;\n                                throw new IOException(message);\n                            }\n                        }\n                    }\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Returns the size of the specified file or directory. If the provided\n                 * {@link File} is a regular file, then the file's length is returned.\n                 * If the argument is a directory, then the size of the directory is\n                 * calculated recursively. If a directory or subdirectory is security\n                 * restricted, its size will not be included.\n                 *\n                 * @param file the regular file or directory to return the size\n                 *        of (must not be <code>null</code>).\n                 *\n                 * @return the length of the file, or recursive size of the directory,\n                 *         provided (in bytes).\n                 *\n                 * @throws NullPointerException if the file is <code>null</code>\n                 * @throws IllegalArgumentException if the file does not exist.\n                 *\n                 * @since Commons IO 2.0\n                 */\n                public static long sizeOf(File file) {\n\n                    if (!file.exists()) {\n                        String message = file + \" does not exist\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    if (file.isDirectory()) {\n                        return sizeOfDirectory(file);\n                    } else {\n                        return file.length();\n                    }\n\n                }\n\n                /**\n                 * Counts the size of a directory recursively (sum of the length of all files).\n                 *\n                 * @param directory  directory to inspect, must not be <code>null</code>\n                 * @return size of directory in bytes, 0 if directory is security restricted\n                 * @throws NullPointerException if the directory is <code>null</code>\n                 */\n                public static long sizeOfDirectory(File directory) {\n                    if (!directory.exists()) {\n                        String message = directory + \" does not exist\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    if (!directory.isDirectory()) {\n                        String message = directory + \" is not a directory\";\n                        throw new IllegalArgumentException(message);\n                    }\n\n                    long size = 0;\n\n                    File[] files = directory.listFiles();\n                    if (files == null) {  // null if security restricted\n                        return 0L;\n                    }\n                    for (File file : files) {\n                        size += sizeOf(file);\n                    }\n\n                    return size;\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Tests if the specified <code>File</code> is newer than the reference\n                 * <code>File</code>.\n                 *\n                 * @param file  the <code>File</code> of which the modification date must\n                 * be compared, must not be <code>null</code>\n                 * @param reference  the <code>File</code> of which the modification date\n                 * is used, must not be <code>null</code>\n                 * @return true if the <code>File</code> exists and has been modified more\n                 * recently than the reference <code>File</code>\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 * @throws IllegalArgumentException if the reference file is <code>null</code> or doesn't exist\n                 */\n                 public static boolean isFileNewer(File file, File reference) {\n                    if (reference == null) {\n                        throw new IllegalArgumentException(\"No specified reference file\");\n                    }\n                    if (!reference.exists()) {\n                        throw new IllegalArgumentException(\"The reference file '\"\n                                + reference + \"' doesn't exist\");\n                    }\n                    return isFileNewer(file, reference.lastModified());\n                }\n\n                /**\n                 * Tests if the specified <code>File</code> is newer than the specified\n                 * <code>Date</code>.\n                 *\n                 * @param file  the <code>File</code> of which the modification date\n                 * must be compared, must not be <code>null</code>\n                 * @param date  the date reference, must not be <code>null</code>\n                 * @return true if the <code>File</code> exists and has been modified\n                 * after the given <code>Date</code>.\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 * @throws IllegalArgumentException if the date is <code>null</code>\n                 */\n                public static boolean isFileNewer(File file, Date date) {\n                    if (date == null) {\n                        throw new IllegalArgumentException(\"No specified date\");\n                    }\n                    return isFileNewer(file, date.getTime());\n                }\n\n                /**\n                 * Tests if the specified <code>File</code> is newer than the specified\n                 * time reference.\n                 *\n                 * @param file  the <code>File</code> of which the modification date must\n                 * be compared, must not be <code>null</code>\n                 * @param timeMillis  the time reference measured in milliseconds since the\n                 * epoch (00:00:00 GMT, January 1, 1970)\n                 * @return true if the <code>File</code> exists and has been modified after\n                 * the given time reference.\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 */\n                 public static boolean isFileNewer(File file, long timeMillis) {\n                    if (file == null) {\n                        throw new IllegalArgumentException(\"No specified file\");\n                    }\n                    if (!file.exists()) {\n                        return false;\n                    }\n                    return file.lastModified() > timeMillis;\n                }\n\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Tests if the specified <code>File</code> is older than the reference\n                 * <code>File</code>.\n                 *\n                 * @param file  the <code>File</code> of which the modification date must\n                 * be compared, must not be <code>null</code>\n                 * @param reference  the <code>File</code> of which the modification date\n                 * is used, must not be <code>null</code>\n                 * @return true if the <code>File</code> exists and has been modified before\n                 * the reference <code>File</code>\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 * @throws IllegalArgumentException if the reference file is <code>null</code> or doesn't exist\n                 */\n                 public static boolean isFileOlder(File file, File reference) {\n                    if (reference == null) {\n                        throw new IllegalArgumentException(\"No specified reference file\");\n                    }\n                    if (!reference.exists()) {\n                        throw new IllegalArgumentException(\"The reference file '\"\n                                + reference + \"' doesn't exist\");\n                    }\n                    return isFileOlder(file, reference.lastModified());\n                }\n\n                /**\n                 * Tests if the specified <code>File</code> is older than the specified\n                 * <code>Date</code>.\n                 *\n                 * @param file  the <code>File</code> of which the modification date\n                 * must be compared, must not be <code>null</code>\n                 * @param date  the date reference, must not be <code>null</code>\n                 * @return true if the <code>File</code> exists and has been modified\n                 * before the given <code>Date</code>.\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 * @throws IllegalArgumentException if the date is <code>null</code>\n                 */\n                public static boolean isFileOlder(File file, Date date) {\n                    if (date == null) {\n                        throw new IllegalArgumentException(\"No specified date\");\n                    }\n                    return isFileOlder(file, date.getTime());\n                }\n\n                /**\n                 * Tests if the specified <code>File</code> is older than the specified\n                 * time reference.\n                 *\n                 * @param file  the <code>File</code> of which the modification date must\n                 * be compared, must not be <code>null</code>\n                 * @param timeMillis  the time reference measured in milliseconds since the\n                 * epoch (00:00:00 GMT, January 1, 1970)\n                 * @return true if the <code>File</code> exists and has been modified before\n                 * the given time reference.\n                 * @throws IllegalArgumentException if the file is <code>null</code>\n                 */\n                 public static boolean isFileOlder(File file, long timeMillis) {\n                    if (file == null) {\n                        throw new IllegalArgumentException(\"No specified file\");\n                    }\n                    if (!file.exists()) {\n                        return false;\n                    }\n                    return file.lastModified() < timeMillis;\n                }\n\n                //-----------------------------------------------------------------------\n                /**\n                 * Computes the checksum of a file using the CRC32 checksum routine.\n                 * The value of the checksum is returned.\n                 *\n                 * @param file  the file to checksum, must not be <code>null</code>\n                 * @return the checksum value\n                 * @throws NullPointerException if the file or checksum is <code>null</code>\n                 * @throws IllegalArgumentException if the file is a directory\n                 * @throws IOException if an IO error occurs reading the file\n                 * @since Commons IO 1.3\n                 */\n                public static long checksumCRC32(File file) throws IOException {\n                    CRC32 crc = new CRC32();\n                    checksum(file, crc);\n                    return crc.getValue();\n                }\n\n                /**\n                 * Computes the checksum of a file using the specified checksum object.\n                 * Multiple files may be checked using one <code>Checksum</code> instance\n                 * if desired simply by reusing the same checksum object.\n                 * For example:\n                 * <pre>\n                 *   long csum = FileUtils.checksum(file, new CRC32()).getValue();\n                 * </pre>\n                 *\n                 * @param file  the file to checksum, must not be <code>null</code>\n                 * @param checksum  the checksum object to be used, must not be <code>null</code>\n                 * @return the checksum specified, updated with the content of the file\n                 * @throws NullPointerException if the file or checksum is <code>null</code>\n                 * @throws IllegalArgumentException if the file is a directory\n                 * @throws IOException if an IO error occurs reading the file\n                 * @since Commons IO 1.3\n                 */\n                public static Checksum checksum(File file, Checksum checksum) throws IOException {\n                    if (file.isDirectory()) {\n                        throw new IllegalArgumentException(\"Checksums can't be computed on directories\");\n                    }\n                    InputStream in = null;\n                    try {\n                        in = new CheckedInputStream(new FileInputStream(file), checksum);\n                        IOUtils.copy(in, new NullOutputStream());\n                    } finally {\n                        IOUtils.closeQuietly(in);\n                    }\n                    return checksum;\n                }\n\n                /**\n                 * Moves a directory.\n                 * <p>\n                 * When the destination directory is on another file system, do a \"copy and delete\".\n                 *\n                 * @param srcDir the directory to be moved\n                 * @param destDir the destination directory\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs moving the file\n                 * @since Commons IO 1.4\n                 */\n                public static void moveDirectory(File srcDir, File destDir) throws IOException {\n                    if (srcDir == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (!srcDir.exists()) {\n                        throw new FileNotFoundException(\"Source '\" + srcDir + \"' does not exist\");\n                    }\n                    if (!srcDir.isDirectory()) {\n                        throw new IOException(\"Source '\" + srcDir + \"' is not a directory\");\n                    }\n                    if (destDir.exists()) {\n                        throw new FileExistsException(\"Destination '\" + destDir + \"' already exists\");\n                    }\n                    boolean rename = srcDir.renameTo(destDir);\n                    if (!rename) {\n                        copyDirectory( srcDir, destDir );\n                        deleteDirectory( srcDir );\n                        if (srcDir.exists()) {\n                            throw new IOException(\"Failed to delete original directory '\" + srcDir +\n                                    \"' after copy to '\" + destDir + \"'\");\n                        }\n                    }\n                }\n\n                /**\n                 * Moves a directory to another directory.\n                 *\n                 * @param src the file to be moved\n                 * @param destDir the destination file\n                 * @param createDestDir If <code>true</code> create the destination directory,\n                 * otherwise if <code>false</code> throw an IOException\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs moving the file\n                 * @since Commons IO 1.4\n                 */\n                public static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) throws IOException {\n                    if (src == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination directory must not be null\");\n                    }\n                    if (!destDir.exists() && createDestDir) {\n                        destDir.mkdirs();\n                    }\n                    if (!destDir.exists()) {\n                        throw new FileNotFoundException(\"Destination directory '\" + destDir +\n                                \"' does not exist [createDestDir=\" + createDestDir +\"]\");\n                    }\n                    if (!destDir.isDirectory()) {\n                        throw new IOException(\"Destination '\" + destDir + \"' is not a directory\");\n                    }\n                    moveDirectory(src, new File(destDir, src.getName()));\n\n                }\n\n                /**\n                 * Moves a file.\n                 * <p>\n                 * When the destination file is on another file system, do a \"copy and delete\".\n                 *\n                 * @param srcFile the file to be moved\n                 * @param destFile the destination file\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs moving the file\n                 * @since Commons IO 1.4\n                 */\n                public static void moveFile(File srcFile, File destFile) throws IOException {\n                    if (srcFile == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destFile == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (!srcFile.exists()) {\n                        throw new FileNotFoundException(\"Source '\" + srcFile + \"' does not exist\");\n                    }\n                    if (srcFile.isDirectory()) {\n                        throw new IOException(\"Source '\" + srcFile + \"' is a directory\");\n                    }\n                    if (destFile.exists()) {\n                        throw new FileExistsException(\"Destination '\" + destFile + \"' already exists\");\n                    }\n                    if (destFile.isDirectory()) {\n                        throw new IOException(\"Destination '\" + destFile + \"' is a directory\");\n                    }\n                    boolean rename = srcFile.renameTo(destFile);\n                    if (!rename) {\n                        copyFile( srcFile, destFile );\n                        if (!srcFile.delete()) {\n                            FileUtils.deleteQuietly(destFile);\n                            throw new IOException(\"Failed to delete original file '\" + srcFile +\n                                    \"' after copy to '\" + destFile + \"'\");\n                        }\n                    }\n                }\n\n                /**\n                 * Moves a file to a directory.\n                 *\n                 * @param srcFile the file to be moved\n                 * @param destDir the destination file\n                 * @param createDestDir If <code>true</code> create the destination directory,\n                 * otherwise if <code>false</code> throw an IOException\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs moving the file\n                 * @since Commons IO 1.4\n                 */\n                public static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) throws IOException {\n                    if (srcFile == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination directory must not be null\");\n                    }\n                    if (!destDir.exists() && createDestDir) {\n                        destDir.mkdirs();\n                    }\n                    if (!destDir.exists()) {\n                        throw new FileNotFoundException(\"Destination directory '\" + destDir +\n                                \"' does not exist [createDestDir=\" + createDestDir +\"]\");\n                    }\n                    if (!destDir.isDirectory()) {\n                        throw new IOException(\"Destination '\" + destDir + \"' is not a directory\");\n                    }\n                    moveFile(srcFile, new File(destDir, srcFile.getName()));\n                }\n\n                /**\n                 * Moves a file or directory to the destination directory.\n                 * <p>\n                 * When the destination is on another file system, do a \"copy and delete\".\n                 *\n                 * @param src the file or directory to be moved\n                 * @param destDir the destination directory\n                 * @param createDestDir If <code>true</code> create the destination directory,\n                 * otherwise if <code>false</code> throw an IOException\n                 * @throws NullPointerException if source or destination is <code>null</code>\n                 * @throws IOException if source or destination is invalid\n                 * @throws IOException if an IO error occurs moving the file\n                 * @since Commons IO 1.4\n                 */\n                public static void moveToDirectory(File src, File destDir, boolean createDestDir) throws IOException {\n                    if (src == null) {\n                        throw new NullPointerException(\"Source must not be null\");\n                    }\n                    if (destDir == null) {\n                        throw new NullPointerException(\"Destination must not be null\");\n                    }\n                    if (!src.exists()) {\n                        throw new FileNotFoundException(\"Source '\" + src + \"' does not exist\");\n                    }\n                    if (src.isDirectory()) {\n                        moveDirectoryToDirectory(src, destDir, createDestDir);\n                    } else {\n                        moveFileToDirectory(src, destDir, createDestDir);\n                    }\n                }\n\n                /**\n                 * Determines whether the specified file is a Symbolic Link rather than an actual file.\n                 * <p>\n                 * Will not return true if there is a Symbolic Link anywhere in the path,\n                 * only if the specific file is.\n                 *\n                 * @param file the file to check\n                 * @return true if the file is a Symbolic Link\n                 * @throws IOException if an IO error occurs while checking the file\n                 * @since Commons IO 2.0\n                 */\n                public static boolean isSymlink(File file) throws IOException {\n                    if (file == null) {\n                        throw new NullPointerException(\"File must not be null\");\n                    }\n                    // Type information would be missing\n                    // if (FilenameUtils.isSystemWindows()) {\n                    //     return false;\n                    // }\n                    File fileInCanonicalDir = null;\n                    if (file.getParent() == null) {\n                        fileInCanonicalDir = file;\n                    } else {\n                        File canonicalDir = file.getParentFile().getCanonicalFile();\n                        fileInCanonicalDir = new File(canonicalDir, file.getName());\n                    }\n\n                    if (fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile())) {\n                        return false;\n                    } else {\n                        return true;\n                    }\n                }\n            }\n            ").toString())};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void maven-scm(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package org.apache.maven.scm.provider.git.gitexe.command;\n\n                /*\n                 * Licensed to the Apache Software Foundation (ASF) under one\n                 * or more contributor license agreements.  See the NOTICE file\n                 * distributed with this work for additional information\n                 * regarding copyright ownership.  The ASF licenses this file\n                 * to you under the Apache License, Version 2.0 (the\n                 * \"License\"); you may not use this file except in compliance\n                 * with the License.  You may obtain a copy of the License at\n                 *\n                 * http://www.apache.org/licenses/LICENSE-2.0\n                 *\n                 * Unless required by applicable law or agreed to in writing,\n                 * software distributed under the License is distributed on an\n                 * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n                 * KIND, either express or implied.  See the License for the\n                 * specific language governing permissions and limitations\n                 * under the License.\n                 */\n\n                import org.apache.commons.io.FilenameUtils;\n\n                import org.apache.maven.scm.ScmException;\n                import org.apache.maven.scm.provider.git.util.GitUtil;\n                import org.apache.maven.scm.providers.gitlib.settings.Settings;\n                import org.codehaus.plexus.util.cli.CommandLineException;\n                import org.codehaus.plexus.util.cli.CommandLineUtils;\n                import org.codehaus.plexus.util.cli.Commandline;\n                import org.codehaus.plexus.util.cli.StreamConsumer;\n                import org.slf4j.Logger;\n                import org.slf4j.LoggerFactory;\n\n                import java.io.File;\n                import java.io.IOException;\n                import java.util.List;\n\n                /**\n                 * Command line construction utility.\n                 *\n                 * @author Brett Porter\n                 * @author <a href=\"mailto:struberg@yahoo.de\">Mark Struberg</a>\n                 *\n                 */\n                public final class GitCommandLineUtils\n                {\n                    private static final Logger LOGGER = LoggerFactory.getLogger( GitCommandLineUtils.class );\n\n                    private GitCommandLineUtils()\n                    {\n                    }\n\n                    public static void addTarget( Commandline cl, List<File> files )\n                    {\n                        if ( files == null || files.isEmpty() )\n                        {\n                            return;\n                        }\n                        final File workingDirectory = cl.getWorkingDirectory();\n                        try\n                        {\n                            final String canonicalWorkingDirectory = workingDirectory.getCanonicalPath();\n                            for ( File file : files )\n                            {\n                                String relativeFile = file.getPath();\n\n                                final String canonicalFile = file.getCanonicalPath();\n                                if ( canonicalFile.startsWith( canonicalWorkingDirectory ) )\n                                {\n                                    // so we can omit the starting characters\n                                    relativeFile = canonicalFile.substring( canonicalWorkingDirectory.length() );\n\n                                    if ( relativeFile.startsWith( File.separator ) )\n                                    {\n                                        relativeFile = relativeFile.substring( File.separator.length() );\n                                    }\n                                }\n\n                                // no setFile() since this screws up the working directory!\n                                cl.createArg().setValue( FilenameUtils.separatorsToUnix( relativeFile ) );\n                            }\n                        }\n                        catch ( IOException ex )\n                        {\n                            throw new IllegalArgumentException( \"Could not get canonical paths for workingDirectory = \"\n                                + workingDirectory + \" or files=\" + files, ex );\n                        }\n                    }\n\n                    /**\n                     *\n                     * @param workingDirectory\n                     * @param command\n                     * @return TODO\n                     */\n                    public static Commandline getBaseGitCommandLine( File workingDirectory, String command )\n                    {\n                        return getAnonymousBaseGitCommandLine( workingDirectory, command );\n                    }\n\n                    /**\n                     * Creates a {@link Commandline} for which the toString() do not display\n                     * password.\n                     *\n                     * @param workingDirectory\n                     * @param command\n                     * @return CommandLine with anonymous output.\n                     */\n                    private static Commandline getAnonymousBaseGitCommandLine( File workingDirectory, String command )\n                    {\n                        if ( command == null || command.length() == 0 )\n                        {\n                            return null;\n                        }\n\n                        Commandline cl = new AnonymousCommandLine();\n\n                        composeCommand( workingDirectory, command, cl );\n\n                        return cl;\n                    }\n\n                    private static void composeCommand( File workingDirectory, String command, Commandline cl )\n                    {\n                        Settings settings = GitUtil.getSettings();\n\n                        cl.setExecutable( settings.getGitCommand() );\n\n                        cl.createArg().setValue( command );\n\n                        if ( workingDirectory != null )\n                        {\n                            cl.setWorkingDirectory( workingDirectory.getAbsolutePath() );\n                        }\n                    }\n\n                    public static int execute( Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr )\n                        throws ScmException\n                    {\n//                        if ( LOGGER.isInfoEnabled() )\n//                        {\n//                            LOGGER.info( \"Executing: \" + cl );\n//                            LOGGER.info( \"Working directory: \" + cl.getWorkingDirectory().getAbsolutePath() );\n//                        }\n\n                        int exitCode;\n                        try\n                        {\n                            exitCode = CommandLineUtils.executeCommandLine( cl, consumer, stderr );\n                        }\n                        catch ( CommandLineException ex )\n                        {\n                            throw new ScmException( \"Error while executing command.\", ex );\n                        }\n\n                        return exitCode;\n                    }\n\n                    public static int execute( Commandline cl, CommandLineUtils.StringStreamConsumer stdout,\n                                               CommandLineUtils.StringStreamConsumer stderr )\n                        throws ScmException\n                    {\n//                        if ( LOGGER.isInfoEnabled() )\n//                        {\n//                            LOGGER.info( \"Executing: \" + cl );\n//                            LOGGER.info( \"Working directory: \" + cl.getWorkingDirectory().getAbsolutePath() );\n//                        }\n\n                        int exitCode;\n                        try\n                        {\n                            exitCode = CommandLineUtils.executeCommandLine( cl, stdout, stderr );\n                        }\n                        catch ( CommandLineException ex )\n                        {\n                            throw new ScmException( \"Error while executing command.\", ex );\n                        }\n\n                        return exitCode;\n                    }\n\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void aws-serverless-java-container(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                /*\n * Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance\n * with the License. A copy of the License is located at\n *\n * http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES\n * OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\npackage com.amazonaws.serverless.proxy.internal;\n\nimport edu.umd.cs.findbugs.annotations.SuppressFBWarnings;\nimport org.slf4j.Logger;\nimport org.slf4j.LoggerFactory;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.util.HashSet;\nimport java.util.Locale;\nimport java.util.Set;\n\n/**\n * This class contains utility methods to address FSB security issues found in the application, such as string sanitization\n * and file path validation.\n */\npublic final class SecurityUtils {\n    private static Logger log = LoggerFactory.getLogger(SecurityUtils.class);\n\n    private static Set<String> SCHEMES = new HashSet<String>() {{\n        add(\"http\");\n        add(\"https\");\n        add(\"HTTP\");\n        add(\"HTTPS\");\n    }};\n\n    private static Set<Integer> PORTS = new HashSet<Integer>() {{\n        add(443);\n        add(80);\n        add(3000); // we allow port 3000 for SAM local\n    }};\n\n    public static boolean isValidPort(String port) {\n        if (port == null) {\n            return false;\n        }\n        try {\n            int intPort = Integer.parseInt(port);\n            return PORTS.contains(intPort);\n        } catch (NumberFormatException e) {\n            log.error(\"Invalid port parameter: \" + crlf(port));\n            return false;\n        }\n    }\n\n    public static boolean isValidScheme(String scheme) {\n        return SCHEMES.contains(scheme);\n    }\n\n    public static boolean isValidHost(String host, String apiId, String region) {\n        if (host == null) {\n            return false;\n        }\n        if (host.endsWith(\".amazonaws.com\")) {\n            String defaultHost = new StringBuilder().append(apiId)\n                                                    .append(\".execute-api.\")\n                                                    .append(region)\n                                                    .append(\".amazonaws.com\").toString();\n            return host.equals(defaultHost);\n        } else {\n            return LambdaContainerHandler.getContainerConfig().getCustomDomainNames().contains(host);\n        }\n    }\n\n    /**\n     * Replaces CRLF characters in a string with empty string (\"\").\n     * @param s The string to be cleaned\n     * @return A copy of the original string without CRLF characters\n     */\n    public static String crlf(String s) {\n        if (s == null) {\n            return null;\n        }\n        return s.replaceAll(\"[\\r\\n]\", \"\");\n    }\n\n\n    /**\n     * Escapes all special characters in a java string\n     * @param s The string to be cleaned\n     * @return The escaped string\n     */\n    public static String encode(String s) {\n        if (s == null) {\n            return null;\n        }\n\n        int sz = s.length();\n\n        StringBuffer buffer = new StringBuffer();\n        for (int i = 0; i < sz; i++) {\n            char ch = s.charAt(i);\n\n            // handle unicode\n            if (ch > 0xfff) {\n                buffer.append(\"\\\\u\" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));\n            } else if (ch > 0xff) {\n                buffer.append(\"\\\\u0\" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));\n            } else if (ch > 0x7f) {\n                buffer.append(\"\\\\u00\" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));\n            } else if (ch < 32) {\n                switch (ch) {\n                case '\\b':\n                    buffer.append('\\\\');\n                    buffer.append('b');\n                    break;\n                case '\\n':\n                    buffer.append('\\\\');\n                    buffer.append('n');\n                    break;\n                case '\\t':\n                    buffer.append('\\\\');\n                    buffer.append('t');\n                    break;\n                case '\\f':\n                    buffer.append('\\\\');\n                    buffer.append('f');\n                    break;\n                case '\\r':\n                    buffer.append('\\\\');\n                    buffer.append('r');\n                    break;\n                default:\n                    if (ch > 0xf) {\n                        buffer.append(\"\\\\u00\" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));\n                    } else {\n                        buffer.append(\"\\\\u000\" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));\n                    }\n                    break;\n                }\n            } else {\n                switch (ch) {\n                case '\\'':\n\n                    buffer.append('\\'');\n                    break;\n                case '\"':\n                    buffer.append('\\\\');\n                    buffer.append('\"');\n                    break;\n                case '\\\\':\n                    buffer.append('\\\\');\n                    buffer.append('\\\\');\n                    break;\n                case '/':\n                    buffer.append('/');\n                    break;\n                default:\n                    buffer.append(ch);\n                    break;\n                }\n            }\n        }\n\n        return buffer.toString();\n    }\n\n    public static String getValidFilePath(String inputPath) {\n        return getValidFilePath(inputPath, false);\n    }\n\n    /**\n     * Returns an absolute file path given an input path and validates that it is not trying\n     * to write/read from a directory other than /tmp.\n     * @param inputPath The input path\n     * @return The absolute path to the file\n     * @throws IllegalArgumentException If the given path is not valid or outside of /tmp\n     */\n    @SuppressFBWarnings(\"PATH_TRAVERSAL_IN\")\n    public static String getValidFilePath(final String inputPath, boolean isWrite) {\n        if (inputPath == null || \"\".equals(inputPath.trim())) {\n            return null;\n        }\n        String testInputPath = inputPath;\n        if (testInputPath.startsWith(\"file://\")) {\n            testInputPath = testInputPath.substring(6);\n        }\n\n        File f = new File(testInputPath);\n        try {\n            String canonicalPath = f.getCanonicalPath();\n\n            if (isWrite && canonicalPath.startsWith(\"/var/task\")) {\n                throw new IllegalArgumentException(\"Trying to write to /var/task folder\");\n            }\n\n            boolean isAllowed = false;\n            for (String allowedPath : LambdaContainerHandler.getContainerConfig().getValidFilePaths()) {\n                if (canonicalPath.startsWith(allowedPath)) {\n                    isAllowed = true;\n                    break;\n                }\n            }\n            if (!isAllowed) {\n                throw new IllegalArgumentException(\"File path not allowed: \" + encode(canonicalPath));\n            }\n\n            return (inputPath.startsWith(\"file://\") ? \"file://\" + canonicalPath : canonicalPath);\n        } catch (IOException e) {\n            log.error(\"Invalid file path: {}\", encode(testInputPath));\n            throw new IllegalArgumentException(\"Invalid file path\", e);\n        }\n    }\n}\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        @Disabled(value="Basic block already has a successor")
        public static void basex(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package org.basex.gui.view.editor;\n\n                import static org.basex.core.Text.*;\n                import static org.basex.gui.GUIConstants.*;\n                import static org.basex.util.Token.*;\n\n                import java.awt.*;\n                import java.io.*;\n                import java.util.*;\n                import java.util.List;\n                import java.util.Timer;\n                import java.util.concurrent.atomic.*;\n                import java.util.regex.*;\n\n                import javax.swing.*;\n\n                import org.basex.build.json.*;\n                import org.basex.core.*;\n                import org.basex.core.cmd.*;\n                import org.basex.core.parse.*;\n                import org.basex.data.*;\n                import org.basex.gui.*;\n                import org.basex.gui.dialog.*;\n                import org.basex.gui.layout.*;\n                import org.basex.gui.layout.BaseXFileChooser.*;\n                import org.basex.gui.listener.*;\n                import org.basex.gui.text.*;\n                import org.basex.gui.text.TextPanel.Action;\n                import org.basex.gui.view.*;\n                import org.basex.gui.view.project.*;\n                import org.basex.io.*;\n                import org.basex.io.in.*;\n                import org.basex.io.parse.json.*;\n                import org.basex.io.parse.xml.*;\n                import org.basex.query.*;\n                import org.basex.query.func.*;\n                import org.basex.query.value.item.*;\n                import org.basex.query.value.node.*;\n                import org.basex.util.*;\n                import org.basex.util.list.*;\n                import org.xml.sax.*;\n\n                /**\n                 * This view allows the input and evaluation of queries and documents.\n                 *\n                 * @author BaseX Team 2005-22, BSD License\n                 * @author Christian Gruen\n                 */\n                public final class EditorView extends View {\n                  /** Delay for showing the please wait info. */\n                  private static final int WAIT_DELAY = 250;\n                  /** Delay for highlighting an error. */\n                  private static final int SEARCH_DELAY = 100;\n                  /** Link pattern. */\n                  private static final Pattern LINK = Pattern.compile(\"(.*?), ([0-9]+)/([0-9]+)\");\n\n                  /** Project files. */\n                  final ProjectView project;\n                  /** Go button. */\n                  final AbstractButton exec;\n                  /** Test button. */\n                  final AbstractButton tests;\n\n                  /** History Button. */\n                  private final AbstractButton history;\n                  /** Stop Button. */\n                  private final AbstractButton stop;\n                  /** Search bar. */\n                  private final SearchBar search;\n                  /** Info label. */\n                  private final BaseXLabel info;\n                  /** Position label. */\n                  private final BaseXLabel pos;\n                  /** Splitter. */\n                  private final BaseXSplit split;\n                  /** Tabs. */\n                  private final BaseXTabs tabs;\n                  /** Context. */\n                  private final BaseXLabel context;\n\n                  /** Query file that has last been evaluated. */\n                  private IOFile execFile;\n                  /** Main-memory document. */\n                  private DBNode doc;\n\n                  /** Parse counter. */\n                  private final AtomicInteger parseID = new AtomicInteger();\n                  /** Parse query context. */\n                  private final AtomicBoolean parsing = new AtomicBoolean();\n                  /** Input info. */\n                  private InputInfo inputInfo;\n\n                  /**\n                   * Default constructor.\n                   * @param notifier view notifier\n                   */\n                  public EditorView(final ViewNotifier notifier) {\n                    super(EDITORVIEW, notifier);\n                    layout(new BorderLayout());\n                    setBackground(PANEL);\n\n                    tabs = new BaseXTabs(gui);\n                    tabs.setFocusable(Prop.MAC);\n                    tabs.addDragDrop();\n                    tabs.setTabLayoutPolicy(gui.gopts.get(GUIOptions.SCROLLTABS) ? JTabbedPane.SCROLL_TAB_LAYOUT :\n                      JTabbedPane.WRAP_TAB_LAYOUT);\n                    tabs.addMouseListener((MouseClickedListener) e -> {\n                      final int i = tabs.indexAtLocation(e.getX(), e.getY());\n                      if(i != -1 && SwingUtilities.isMiddleMouseButton(e)) {\n                        final Component comp = tabs.getComponentAt(i);\n                        if(comp instanceof EditorArea) close((EditorArea) comp);\n                      }\n                    });\n\n                    final SearchEditor center = new SearchEditor(gui, tabs, null);\n                    search = center.bar();\n\n                    final AbstractButton newB = BaseXButton.command(GUIMenuCmd.C_EDIT_NEW, gui);\n                    final AbstractButton openB = BaseXButton.command(GUIMenuCmd.C_EDIT_OPEN, gui);\n                    final AbstractButton saveB = BaseXButton.get(\"c_save\", SAVE, false, gui);\n                    final AbstractButton find = search.button(FIND_REPLACE);\n                    final AbstractButton vars = BaseXButton.command(GUIMenuCmd.C_EXTERNAL_VARIABLES, gui);\n\n                    history = BaseXButton.get(\"c_history\", BaseXLayout.addShortcut(RECENTLY_OPENED,\n                        BaseXKeys.HISTORY.toString()), false, gui);\n                    exec = BaseXButton.get(\"c_go\", BaseXLayout.addShortcut(RUN_QUERY,\n                        BaseXKeys.EXEC.toString()), false, gui);\n                    stop = BaseXButton.get(\"c_stop\", STOP, false, gui);\n                    stop.setEnabled(false);\n                    tests = BaseXButton.get(\"c_test\", BaseXLayout.addShortcut(RUN_TESTS,\n                        BaseXKeys.TESTS.toString()), false, gui);\n\n                    final BaseXBack buttons = new BaseXBack(false);\n                    buttons.layout(new ColumnLayout());\n                    buttons.add(newB);\n                    buttons.add(openB);\n                    buttons.add(saveB);\n                    buttons.add(history);\n                    buttons.add(Box.createHorizontalStrut(8));\n                    buttons.add(find);\n                    buttons.add(Box.createHorizontalStrut(8));\n                    buttons.add(stop);\n                    buttons.add(exec);\n                    buttons.add(vars);\n                    buttons.add(tests);\n\n                    context = new BaseXLabel(\"\").resize(1.2f);\n                    context.setForeground(dgray);\n\n                    final BaseXBack north = new BaseXBack(false).layout(new BorderLayout(10, 0));\n                    north.add(buttons, BorderLayout.WEST);\n                    north.add(context, BorderLayout.CENTER);\n                    north.add(new BaseXHeader(EDITOR), BorderLayout.EAST);\n\n                    // status and query pane\n                    search.editor(addTab(), false);\n\n                    info = new BaseXLabel().setText(OK, Msg.SUCCESS).resize(1.2f);\n                    pos = new BaseXLabel(\" \").resize(1.2f);\n\n                    posCode.invokeLater();\n\n                    final BaseXBack south = new BaseXBack(false).border(8, 0, 0, 0);\n                    south.layout(new BorderLayout(4, 0));\n                    south.add(info, BorderLayout.CENTER);\n                    south.add(pos, BorderLayout.EAST);\n\n                    final BaseXBack main = new BaseXBack().border(5);\n                    main.setOpaque(false);\n                    main.layout(new BorderLayout());\n                    main.add(north, BorderLayout.NORTH);\n                    main.add(center, BorderLayout.CENTER);\n                    main.add(south, BorderLayout.SOUTH);\n\n                    project = new ProjectView(this);\n                    split = new BaseXSplit(true);\n                    split.setOpaque(false);\n                    split.add(project);\n                    split.add(main);\n                    split.init(new double[] { 0.3, 0.7 }, new double[] { 0, 1 });\n                    toggleProject();\n                    add(split, BorderLayout.CENTER);\n\n                    refreshLayout();\n\n                    // add listeners\n                    saveB.addActionListener(e -> {\n                      final JPopupMenu pop = new JPopupMenu();\n                      final StringBuilder mnem = new StringBuilder();\n                      final JMenuItem sa = GUIMenu.newItem(GUIMenuCmd.C_EDIT_SAVE, gui, mnem);\n                      final JMenuItem sas = GUIMenu.newItem(GUIMenuCmd.C_EDIT_SAVE_AS, gui, mnem);\n                      sa.setEnabled(GUIMenuCmd.C_EDIT_SAVE.enabled(gui));\n                      sas.setEnabled(GUIMenuCmd.C_EDIT_SAVE_AS.enabled(gui));\n                      pop.add(sa);\n                      pop.add(sas);\n                      pop.show(saveB, 0, saveB.getHeight());\n                    });\n\n                    history.addActionListener(e -> historyPopup(0));\n                    refreshHistory(null);\n\n                    info.addMouseListener((MouseClickedListener) e -> markError(true));\n                    stop.addActionListener(e -> {\n                      stop.setEnabled(false);\n                      gui.stop();\n                    });\n                    exec.addActionListener(e -> run(getEditor(), Action.EXECUTE));\n                    tests.addActionListener(e -> run(getEditor(), Action.TEST));\n                    tabs.addChangeListener(e -> {\n                      final EditorArea ea = getEditor();\n                      if(ea == null) return;\n                      search.editor(ea, true);\n                      gui.refreshControls(false);\n                      posCode.invokeLater();\n                      refreshMark();\n                      run(ea, Action.PARSE);\n                      gui.setTitle();\n                    });\n\n                    BaseXLayout.addDrop(this, file -> {\n                      if(file instanceof File) open(new IOFile((File) file));\n                    });\n                  }\n\n                  @Override\n                  public void refreshInit() { }\n\n                  @Override\n                  public void refreshFocus() { }\n\n                  @Override\n                  public void refreshMark() {\n                    tests.setEnabled(getEditor().file().hasSuffix(IO.XQSUFFIXES));\n                  }\n\n                  @Override\n                  public void refreshContext(final boolean more, final boolean quick) { }\n\n                  @Override\n                  public void refreshLayout() {\n                    for(final EditorArea edit : editors()) edit.refreshLayout(mfont);\n                    project.refreshLayout();\n                    search.refreshLayout();\n                  }\n\n                  @Override\n                  public void refreshUpdate() { }\n\n                  @Override\n                  public boolean visible() {\n                    return gui.gopts.get(GUIOptions.SHOWEDITOR);\n                  }\n\n                  @Override\n                  public void visible(final boolean v) {\n                    gui.gopts.set(GUIOptions.SHOWEDITOR, v);\n                  }\n\n                  @Override\n                  protected boolean db() {\n                    return false;\n                  }\n\n                  /**\n                   * Shows a history popup menu.\n                   * @param start first entry\n                   */\n                  public void historyPopup(final int start) {\n                    // create list of paths; show opened files first\n                    final HashSet<String> opened = new HashSet<>();\n                    for(final EditorArea edit : editors()) opened.add(edit.file().path());\n                    final List<String> paths = new ArrayList<>(opened);\n                    for(final String path : gui.gopts.get(GUIOptions.EDITOR)) {\n                      if(!paths.contains(path)) paths.add(path);\n                    }\n                    paths.sort((path1, path2) -> {\n                      final boolean c1 = opened.contains(path1), c2 = opened.contains(path2);\n                      return c1 == c2 ? path1.compareTo(path2) : c1 ? -1 : 1;\n                    });\n\n                    final JPopupMenu menu = new JPopupMenu();\n                    int p = start - 1;\n                    final int max = Math.min(paths.size(), start + BaseXHistory.MAXPAGE);\n                    if(start > 0) menu.add(new JMenuItem(DOTS)).addActionListener(\n                        ac -> historyPopup(start - BaseXHistory.MAXPAGE));\n                    while(++p < max) {\n                      final String path = paths.get(p);\n                      final IOFile file = new IOFile(path);\n                      final String label = file.name() + \" \\u00b7 \" + BaseXLayout.reversePath(file);\n                      final JMenuItem item = new JMenuItem(label);\n                      item.setToolTipText(BaseXLayout.info(file, true));\n                      if(opened.contains(path)) BaseXLayout.boldFont(item);\n                      menu.add(item).addActionListener(ac -> open(file));\n                    }\n                    if(p < paths.size()) menu.add(new JMenuItem(DOTS)).addActionListener(\n                        ac -> historyPopup(start + BaseXHistory.MAXPAGE));\n                    menu.show(history, 0, history.getHeight());\n                  }\n\n                  /**\n                   * Refreshes the context label.\n                   */\n                  public void refreshContextLabel() {\n                    final String label = context();\n                    context.setText(label.isEmpty() ? \"\" : CONTEXT + COLS + label);\n                  }\n\n                  /**\n                   * Sets an XML document as context.\n                   * @param file file\n                   */\n                  public void setContext(final IOFile file) {\n                    try {\n                      // close database\n                      if(Close.close(gui.context)) gui.notify.init();\n                      doc = new DBNode(file);\n                      // remove context item binding\n                      final Map<String, String> map = gui.context.options.toMap(MainOptions.BINDINGS);\n                      map.remove(\"\");\n                      DialogBindings.assign(map, gui);\n                      refreshContextLabel();\n                    } catch(final IOException ex) {\n                      Util.debug(ex);\n                      BaseXDialog.error(gui, Util.info(ex));\n                    }\n                  }\n\n                  /**\n                   * Returns a string describing the current context.\n                   * @return context string (can be empty)\n                   */\n                  public String context() {\n                    // check if context binding was set\n                    String value = gui.context.options.toMap(MainOptions.BINDINGS).get(\"\");\n                    if(value != null) {\n                      value = Strings.concat(\"xs:untypedAtomic(\", Atm.get(value), ')');\n                    }\n                    // check if database is opened\n                    if(value == null) {\n                      final Data data = gui.context.data();\n                      if(data != null) value = Function._DB_OPEN.args(data.meta.name);\n                    }\n                    // check if main-memory document exists\n                    if(value == null) {\n                      if(doc != null) value = Function.DOC.args(new IOFile(doc.data().meta.original).name());\n                    } else {\n                      doc = null;\n                    }\n                    return value != null ? value.trim() : \"\";\n                  }\n\n                  /**\n                   * Shows the project view.\n                   */\n                  public void showProject() {\n                    if(!gui.gopts.get(GUIOptions.SHOWPROJECT)) {\n                      gui.gopts.invert(GUIOptions.SHOWPROJECT);\n                      split.visible(true);\n                    }\n                  }\n\n                  /**\n                   * Toggles the project view.\n                   */\n                  public void toggleProject() {\n                    final boolean show = gui.gopts.get(GUIOptions.SHOWPROJECT);\n                    split.visible(show);\n                    if(show) {\n                      project.focus();\n                    } else {\n                      focusEditor();\n                    }\n                  }\n\n                  /**\n                   * Focuses the project view.\n                   */\n                  public void findFiles() {\n                    project.findFiles(getEditor());\n                  }\n\n                  /**\n                   * Focuses the current editor.\n                   */\n                  public void focusEditor() {\n                    SwingUtilities.invokeLater(() -> getEditor().requestFocusInWindow());\n                  }\n\n                  /**\n                   * Focuses the currently edited file in the project view.\n                   */\n                  public void jumpToFile() {\n                    project.jumpTo(getEditor().file(), true);\n                  }\n\n                  /**\n                   * Switches the current editor tab.\n                   * @param next next next/previous tab\n                   */\n                  public void tab(final boolean next) {\n                    final int s = tabs.getTabCount();\n                    final int i = (s + tabs.getSelectedIndex() + (next ? 1 : -1)) % s;\n                    tabs.setSelectedIndex(i);\n                  }\n\n                  /**\n                   * Opens previously opened and new files.\n                   * @param files files to be opened\n                   */\n                  public void init(final ArrayList<IOFile> files) {\n                    for(final String file : gui.gopts.get(GUIOptions.OPEN)) open(new IOFile(file), true, false);\n                    for(final IOFile file : files) open(file, true, false);\n\n                    // open temporary files\n                    final EditorArea edit = getEditor();\n                    final String prefix = Prop.HOMEDIR.hashCode() + \"-\";\n                    for(final IOFile file : new IOFile(Prop.TEMPDIR, Prop.PROJECT).children()) {\n                      if(!file.name().startsWith(prefix)) continue;\n                      try {\n                        final byte[] text = read(file);\n                        if(text != null) {\n                          final EditorArea ea = addTab();\n                          ea.setText(text);\n                          refreshControls(ea, true);\n                          file.delete();\n                        }\n                      } catch(final IOException ex) {\n                        Util.debug(ex);\n                      }\n                    }\n                    if(!edit.opened()) closeEditor(edit);\n\n                    gui.setTitle();\n                  }\n\n                  /**\n                   * Opens a new file.\n                   */\n                  public void open() {\n                    // open file chooser for XML creation\n                    final BaseXFileChooser fc = new BaseXFileChooser(gui, OPEN, gui.gopts.get(GUIOptions.WORKPATH));\n                    fc.filter(XQUERY_FILES, false, IO.XQSUFFIXES);\n                    fc.filter(BXS_FILES, false, IO.BXSSUFFIX);\n                    fc.textFilters();\n                    for(final IOFile f : fc.multi().selectAll(Mode.FOPEN)) open(f);\n                  }\n\n                  /**\n                   * Saves the contents of the currently opened editor.\n                   * @return {@code false} if operation was canceled\n                   */\n                  public boolean save() {\n                    final EditorArea edit = getEditor();\n                    return edit.opened() ? edit.save() : saveAs();\n                  }\n\n                  /**\n                   * Saves the contents of the currently opened editor under a new name.\n                   * @return {@code false} if operation was canceled\n                   */\n                  public boolean saveAs() {\n                    // open file chooser for XML creation\n                    final EditorArea edit = getEditor();\n                    final String path = edit.opened() ? edit.file().path() : gui.gopts.get(GUIOptions.WORKPATH);\n                    final BaseXFileChooser fc = new BaseXFileChooser(gui, SAVE_AS, path);\n                    fc.filter(XQUERY_FILES, false, IO.XQSUFFIXES);\n                    fc.filter(BXS_FILES, false, IO.BXSSUFFIX);\n                    fc.textFilters();\n                    fc.suffix(IO.XQSUFFIX);\n\n                    // save new file\n                    final IOFile file = fc.select(Mode.FSAVE);\n                    if(file == null || !edit.save(file)) return false;\n                    // success: parse contents\n                    run(edit, Action.PARSE);\n                    return true;\n                  }\n\n                  /**\n                   * Creates a new file.\n                   */\n                  public void newFile() {\n                    if(!visible()) GUIMenuCmd.C_SHOW_EDITOR.execute(gui);\n                    refreshControls(addTab(), true);\n                  }\n\n                  /**\n                   * Deletes a file.\n                   * @param file file to be deleted\n                   * @return success flag\n                   */\n                  public boolean delete(final IOFile file) {\n                    final EditorArea edit = find(file);\n                    if(edit != null) close(edit);\n                    return file.delete();\n                  }\n\n                  /**\n                   * Opens and parses the specified query file.\n                   * @param file query file\n                   * @return opened editor or {@code null} if file could not be opened\n                   */\n                  public EditorArea open(final IOFile file) {\n                    return open(file, true, true);\n                  }\n\n                  /**\n                   * Opens and focuses the specified query file.\n                   * @param file query file\n                   * @param parse parse contents\n                   * @param error display error if file does not exist\n                   * @return opened editor, or {@code null} if file could not be opened\n                   */\n                  private EditorArea open(final IOFile file, final boolean parse, final boolean error) {\n                    if(!visible()) GUIMenuCmd.C_SHOW_EDITOR.execute(gui);\n\n                    EditorArea edit = find(file);\n                    if(edit != null) {\n                      // display open file\n                      tabs.setSelectedComponent(edit);\n                    } else {\n                      try {\n                        // check and retrieve content\n                        final byte[] text = read(file);\n                        if(text == null) return null;\n\n                        // get current editor\n                        edit = getEditor();\n                        // create new tab if text in current tab is stored on disk or has been modified\n                        if(edit.opened() || edit.modified()) edit = addTab();\n                        edit.initText(text);\n                        edit.file(file, error);\n                        if(parse) run(edit, Action.PARSE);\n                      } catch(final IOException ex) {\n                        refreshHistory(null);\n                        Util.debug(ex);\n                        if(error) BaseXDialog.error(gui, Util.info(FILE_NOT_OPENED_X, file));\n                        return null;\n                      }\n                    }\n                    focusEditor();\n                    return edit;\n                  }\n\n                  /**\n                   * Parses or evaluates the current file.\n                   * @param action action\n                   * @param editor current editor\n                   */\n                  void run(final EditorArea editor, final Action action) {\n                    refreshControls(editor, false);\n\n                    // skip checks if input has not changed\n                    final byte[] text = editor.getText();\n                    if(eq(text, editor.last) && action == Action.CHECK) return;\n                    editor.last = text;\n\n                    // save modified files before executing queries\n                    if(gui.gopts.get(GUIOptions.SAVERUN) && (action == Action.EXECUTE || action == Action.TEST)) {\n                      for(final EditorArea edit : editors()) {\n                        if(edit.opened()) edit.save();\n                      }\n                    }\n\n                    IOFile file = editor.file();\n                    final boolean xquery = file.hasSuffix(IO.XQSUFFIXES) || !file.name().contains(\".\");\n                    final boolean script = file.hasSuffix(IO.BXSSUFFIX);\n\n                    if(action == Action.TEST) {\n                      // test query\n                      if(xquery) gui.execute(true, new Test(file.path()));\n                    } else if(action == Action.EXECUTE && script) {\n                      // execute script\n                      gui.execute(true, new Execute(string(text)).baseURI(file.path()));\n                    } else if(action == Action.EXECUTE || xquery) {\n                      // execute or parse query\n                      String input = string(text);\n                      if(action == Action.EXECUTE || gui.gopts.get(GUIOptions.EXECRT)) {\n                        // find main module if current file cannot be evaluated; return early if no module is found\n                        if(!xquery || QueryParser.isLibrary(input)) {\n                          final EditorArea ea = execEditor();\n                          if(ea == null) return;\n                          file = ea.file();\n                          input = string(ea.getText());\n                        }\n                        // execute query\n                        final XQuery cmd = new XQuery(input);\n                        if(doc != null) cmd.bind(null, doc);\n                        gui.execute(true, cmd.baseURI(file.path()));\n                        execFile = file;\n                      } else {\n                        // parse: replace empty query with empty sequence (suppresses errors for plain text files)\n                        parse(input.isEmpty() ? \"()\" : input, file);\n                      }\n                    } else if(file.hasSuffix(IO.JSONSUFFIX)) {\n                      try {\n                        final IOContent io = new IOContent(text);\n                        io.name(file.path());\n                        JsonConverter.get(new JsonParserOptions()).convert(io);\n                        info(null);\n                      } catch(final IOException ex) {\n                        info(ex);\n                      }\n                    } else if(script || file.hasSuffix(gui.gopts.xmlSuffixes()) || file.hasSuffix(IO.XSLSUFFIXES)) {\n                      final ArrayInput ai = new ArrayInput(text);\n                      try {\n                        // check XML syntax\n                        if(startsWith(text, '<') || !script) new XmlParser().parse(ai);\n                        // check command script\n                        if(script) CommandParser.get(string(text), gui.context).parse();\n                        info(null);\n                      } catch(final Exception ex) {\n                        info(ex);\n                      }\n                    } else if(action != Action.CHECK) {\n                      info(null);\n                    } else {\n                      // no particular file format, no particular action: reset status info\n                      info.setText(OK, Msg.SUCCESS);\n                    }\n                  }\n\n                  /**\n                   * Evaluates the info message resulting from command or query parsing.\n                   * @param ex exception or {@code null}\n                   */\n                  private void info(final Exception ex) {\n                    info(ex, false, false);\n                  }\n\n                  /**\n                   * Returns the editor whose contents have been executed last.\n                   * @return editor or {@code null}\n                   */\n                  private EditorArea execEditor() {\n                    final IOFile file = execFile;\n                    if(file != null) {\n                      for(final EditorArea edit : editors()) {\n                        if(edit.file().path().equals(file.path())) return edit;\n                      }\n                      execFile = null;\n                    }\n                    return null;\n                  }\n\n                  /**\n                   * Retrieves the contents of the specified file, or opens it externally.\n                   * @param file query file\n                   * @return contents, or {@code null} reference if file is opened externally\n                   * @throws IOException I/O exception\n                   */\n                  private byte[] read(final IOFile file) throws IOException {\n                    try {\n                      // try to open as validated UTF-8 document\n                      return new NewlineInput(file).validate(true).content();\n                    } catch(final InputException ex) {\n                      // error...\n                      Util.debug(ex);\n                      final String button = BaseXDialog.yesNoCancel(gui, H_FILE_BINARY);\n                      // open binary as text; do not validate\n                      if(button == B_NO) return new NewlineInput(file).content();\n                      // open external application\n                      if(button == B_YES) {\n                        try {\n                          file.open();\n                        } catch(final IOException ioex) {\n                          Util.debug(ioex);\n                          Desktop.getDesktop().open(file.file());\n                        }\n                      }\n                      // return nothing (also applies if dialog is canceled)\n                      return null;\n                    }\n                  }\n\n                  /**\n                   * Refreshes the list of recent query files and updates the query path.\n                   * @param file new file (can be {@code null})\n                   */\n                  void refreshHistory(final IOFile file) {\n                    final StringList paths = new StringList();\n                    if(file != null) {\n                      gui.gopts.setFile(GUIOptions.WORKPATH, file.parent());\n                      paths.add(file.path());\n                      tabs.setToolTipTextAt(tabs.getSelectedIndex(), BaseXLayout.info(file, true));\n                    }\n                    for(final String old : gui.gopts.get(GUIOptions.EDITOR)) {\n                      if(paths.size() < BaseXHistory.MAX) paths.addUnique(old);\n                    }\n\n                    // store sorted history\n                    gui.gopts.setFiles(GUIOptions.EDITOR, paths.finish());\n                    history.setEnabled(!paths.isEmpty());\n                  }\n\n                  /**\n                   * Closes all editors.\n                   */\n                  public void closeAll() {\n                    for(final EditorArea ea : editors()) closeEditor(ea);\n                    gui.saveOptions();\n                  }\n\n                  /**\n                   * Closes an editor.\n                   * @param edit editor to be closed (if {@code null}, the currently opened editor will be closed)\n                   */\n                  public void close(final EditorArea edit) {\n                    closeEditor(edit);\n                    gui.saveOptions();\n                  }\n\n                  /**\n                   * Closes an editor.\n                   * @param edit editor to be closed (if {@code null}, the currently opened editor will be closed)\n                   */\n                  private void closeEditor(final EditorArea edit) {\n                    final EditorArea ea = edit != null ? edit : getEditor();\n                    if(ea.modified() && !confirm(ea)) return;\n\n                    // remove reference to last executed file\n                    if(execFile != null && ea.file().path().equals(execFile.path())) execFile = null;\n                    tabs.remove(ea);\n                    // no panels left: open default tab\n                    if(tabs.getTabCount() == 0) {\n                      addTab();\n                      SwingUtilities.invokeLater(this::toggleProject);\n                    } else {\n                      focusEditor();\n                    }\n                  }\n\n                  /**\n                   * Starts a thread, which shows a waiting info after a short timeout.\n                   * @param id thread id\n                   */\n                  public void pleaseWait(final int id) {\n                    new Timer(true).schedule(new TimerTask() {\n                      @Override\n                      public void run() {\n                        if(gui.running(id)) {\n                          info.setText(PLEASE_WAIT_D, Msg.SUCCESS).setToolTipText(null);\n                          stop.setEnabled(true);\n                        }\n                      }\n                    }, WAIT_DELAY);\n                  }\n\n                  /**\n                   * Parses the current query after a little delay.\n                   * @param input query input\n                   * @param file file\n                   */\n                  private void parse(final String input, final IO file) {\n                    final int id = parseID.incrementAndGet();\n                    new Timer(true).schedule(new TimerTask() {\n                      @Override\n                      public void run() {\n                        // let current parser finish; check if thread is obsolete\n                        while(parsing.get()) Performance.sleep(1);\n                        if(id != parseID.get()) return;\n\n                        // parse query\n                        parsing.set(true);\n                        try(QueryContext qc = new QueryContext(gui.context)) {\n                          qc.parse(input, file.path());\n                          if(id == parseID.get()) info(null);\n                        } catch(final QueryException ex) {\n                          if(id == parseID.get()) info(ex);\n                        } finally {\n                          parsing.set(false);\n                        }\n                      }\n                    }, SEARCH_DELAY);\n                  }\n\n                  /**\n                   * Processes the result from a command or query execution.\n                   * @param th exception or {@code null}\n                   * @param stopped {@code true} if evaluation was stopped\n                   * @param refresh refresh buttons\n                   */\n                  public void info(final Throwable th, final boolean stopped, final boolean refresh) {\n                    // do not refresh view when query is running\n                    if(!refresh && stop.isEnabled()) return;\n\n                    parseID.incrementAndGet();\n                    final EditorArea editor = getEditor();\n                    String path = \"\";\n                    if(editor != null) {\n                      path = editor.file().path();\n                      editor.resetError();\n                    }\n\n                    if(refresh) {\n                      stop.setEnabled(false);\n                      refreshMark();\n                    }\n\n                    if(stopped || th == null) {\n                      info.setCursor(CURSORARROW);\n                      info.setText(stopped ? INTERRUPTED : OK, Msg.SUCCESS);\n                      info.setToolTipText(null);\n                      inputInfo = null;\n                    } else {\n                      info.setCursor(CURSORHAND);\n                      final String msg = Util.message(th), local = th.getLocalizedMessage();\n                      info.setText(local != null ? local : msg, Msg.ERROR);\n                      final String tt = msg.replace(\"<\", \"&lt;\").replace(\">\", \"&gt;\").\n                        replaceAll(\"\\r?\\n\", \"<br/>\").replaceAll(\"(<br/>.*?)<br/>.*\", \"$1\");\n                      info.setToolTipText(\"<html>\" + tt + \"</html>\");\n\n                      if(th instanceof QueryIOException) {\n                        inputInfo = ((QueryIOException) th).getCause().info();\n                      } else if(th instanceof QueryException) {\n                        inputInfo = ((QueryException) th).info();\n                      } else if(th instanceof SAXParseException) {\n                        final SAXParseException ex = (SAXParseException) th;\n                        inputInfo = new InputInfo(path, ex.getLineNumber(), ex.getColumnNumber());\n                      } else {\n                        inputInfo = new InputInfo(path, 1, 1);\n                      }\n                      markError(false);\n                    }\n                  }\n\n                  /**\n                   * Jumps to the specified file and position.\n                   * @param link link\n                   */\n                  public void jump(final String link) {\n                    final Matcher m = LINK.matcher(link);\n                    if(m.matches()) {\n                      inputInfo = new InputInfo(m.group(1), Strings.toInt(m.group(2)), Strings.toInt(m.group(3)));\n                      markError(true);\n                    } else {\n                      Util.stack(\"No match found: \" + link);\n                    }\n                  }\n\n                  /**\n                   * Jumps to the current error.\n                   * @param jump jump to error position (if necessary, open file)\n                   */\n                  public void markError(final boolean jump) {\n                    InputInfo ii = inputInfo;\n                    final String path;\n                    final boolean error = ii == null;\n                    if(error) {\n                      final TreeMap<String, InputInfo> errors = project.errors();\n                      if(errors.isEmpty()) return;\n                      path = errors.get(errors.keySet().iterator().next()).path();\n                    } else {\n                      path = ii.path();\n                    }\n                    if(path == null) return;\n\n                    final IOFile file = new IOFile(path);\n                    final EditorArea found = find(file), opened;\n                    if(jump) {\n                      opened = open(file, error, true);\n                      // update error information if file was not already opened\n                      if(found == null && error) ii = inputInfo;\n                    } else {\n                      opened = found;\n                    }\n                    // no editor available, no input info\n                    if(opened == null || ii == null) return;\n\n                    // mark error, jump to error position\n                    final int ep = pos(opened.last, ii.line(), ii.column());\n                    opened.error(ep);\n\n                    if(jump) {\n                      opened.setCaret(ep);\n                      posCode.invokeLater();\n                      // jump to file in project view if file was opened by this function call\n                      if(found == null) project.jumpTo(opened.file(), false);\n                    }\n                  }\n\n                  /**\n                   * Returns an editor offset for the specified line and column.\n                   * @param text text\n                   * @param line line\n                   * @param col column\n                   * @return position\n                   */\n                  private static int pos(final byte[] text, final int line, final int col) {\n                    final int ll = text.length;\n                    int ep = ll;\n                    for(int p = 0, l = 1, c = 1; p < ll; ++c, p += cl(text, p)) {\n                      if(l > line || l == line && c == col) {\n                        ep = p;\n                        break;\n                      }\n                      if(text[p] == '\\n') {\n                        ++l;\n                        c = 0;\n                      }\n                    }\n                    if(ep < ll && Character.isLetterOrDigit(cp(text, ep))) {\n                      while(ep > 0 && Character.isLetterOrDigit(cp(text, ep - 1))) ep--;\n                    }\n                    return ep;\n                  }\n\n                  /**\n                   * Returns paths of all open files.\n                   * @return file paths\n                   */\n                  public String[] openFiles() {\n                    // remember opened files\n                    final StringList files = new StringList();\n                    for(final EditorArea edit : editors()) {\n                      if(edit.opened()) files.add(edit.file().path());\n                    }\n                    return files.finish();\n                  }\n\n                  /**\n                   * Returns the current editor.\n                   * @return editor or {@code null}\n                   */\n                  public EditorArea getEditor() {\n                    final Component c = tabs.getSelectedComponent();\n                    return c instanceof EditorArea ? (EditorArea) c : null;\n                  }\n\n                  /**\n                   * Updates the references to renamed files.\n                   * @param old old file file reference\n                   * @param renamed updated file reference\n                   */\n                  public void rename(final IOFile old, final IOFile renamed) {\n                    try {\n                      // use canonical representation and add slash to names of directories\n                      final boolean dir = renamed.isDir();\n                      final String oldPath = old.file().getCanonicalPath() + (dir ? File.separator : \"\");\n                      // iterate through all tabs\n                      for(final Component c : tabs.getComponents()) {\n                        if(!(c instanceof EditorArea)) continue;\n\n                        final EditorArea ea = (EditorArea) c;\n                        if(!ea.opened()) continue;\n\n                        final String editPath = ea.file().file().getCanonicalPath();\n                        if(dir) {\n                          // change path to files in a renamed directory\n                          if(editPath.startsWith(oldPath)) {\n                            ea.file(new IOFile(renamed, editPath.substring(oldPath.length())), true);\n                          }\n                        } else if(oldPath.equals(editPath)) {\n                          // update file reference and label of editor tab\n                          ea.file(renamed, true);\n                          ea.label.setText(renamed.name());\n                          break;\n                        }\n                      }\n                    } catch(final IOException ex) {\n                      Util.errln(ex);\n                    }\n                  }\n\n                  /**\n                   * Refreshes the query modification flag.\n                   * @param edit editor\n                   * @param enforce enforce action\n                   */\n                  void refreshControls(final EditorArea edit, final boolean enforce) {\n                    // update modification flag\n                    final boolean modified = edit.hist != null && edit.hist.modified();\n                    if(modified == edit.modified() && !enforce) return;\n\n                    edit.modified(modified);\n\n                    // update tab title\n                    String title = edit.file().name();\n                    if(modified) title += '*';\n                    edit.label.setText(title);\n\n                    // update components\n                    gui.refreshControls(false);\n                    gui.setTitle();\n                    posCode.invokeLater();\n                    refreshMark();\n                  }\n\n                  /** Code for setting cursor position. */\n                  public final GUICode posCode = new GUICode() {\n                    @Override\n                    public void execute(final Object arg) {\n                      final int[] lc = getEditor().pos();\n                      pos.setText(lc[0] + \" : \" + lc[1]);\n                    }\n                  };\n\n                  /**\n                   * Finds the editor that contains the specified file.\n                   * @param file file to be found\n                   * @return editor or {@code null}\n                   */\n                  private EditorArea find(final IO file) {\n                    for(final EditorArea edit : editors()) {\n                      if(edit.file().eq(file)) return edit;\n                    }\n                    return null;\n                  }\n\n                  /**\n                   * Choose a unique tab file.\n                   * @return io reference\n                   */\n                  private IOFile newTabFile() {\n                    // collect numbers of existing files\n                    final BoolList bl = new BoolList();\n                    for(final EditorArea edit : editors()) {\n                      if(edit.opened()) continue;\n                      final String n = edit.file().name().substring(FILE.length());\n                      bl.set(n.isEmpty() ? 1 : Integer.parseInt(n), true);\n                    }\n                    // find first free file number\n                    int b = 0;\n                    final int bs = bl.size();\n                    while(++b < bs && bl.get(b));\n                    // create io reference\n                    return new IOFile(gui.gopts.get(GUIOptions.WORKPATH), FILE + (b == 1 ? \"\" : b));\n                  }\n\n                  /**\n                   * Adds a new editor tab.\n                   * @return editor reference\n                   */\n                  private EditorArea addTab() {\n                    final EditorArea edit = new EditorArea(this, newTabFile());\n                    edit.setFont(mfont);\n\n                    final BaseXBack tab = new BaseXBack(false).layout(new BorderLayout(10, 0));\n                    tab.add(edit.label, BorderLayout.CENTER);\n\n                    final AbstractButton close = tabButton(\"e_close\", \"e_close2\");\n                    close.addActionListener(e -> close(edit));\n                    tab.add(close, BorderLayout.EAST);\n\n                    tabs.add(edit, tab, tabs.getTabCount());\n                    return edit;\n                  }\n\n                  /**\n                   * Adds a new tab button.\n                   * @param icon name of button icon\n                   * @param rollover rollover icon\n                   * @return button\n                   */\n                  private AbstractButton tabButton(final String icon, final String rollover) {\n                    final AbstractButton close = BaseXButton.get(icon, null, false, gui);\n                    close.setBorder(BaseXLayout.border(2, 0, 2, 0));\n                    close.setContentAreaFilled(false);\n                    close.setFocusable(false);\n                    close.setRolloverIcon(BaseXImages.icon(rollover));\n                    return close;\n                  }\n\n                  /**\n                   * Shows a confirmation dialog for the specified editor, or all editors.\n                   * @param edit editor to be saved, or {@code null} to save all editors\n                   * @return {@code true} if all editors were confirmed\n                   */\n                  public boolean confirm(final EditorArea edit) {\n                    final boolean all = edit == null;\n                     final EditorArea[] eas = all ? editors() : new EditorArea[] { edit };\n                    final String[] buttons = all && eas.length > 1 ? new String[] { CLOSE_ALL } : new String[0];\n\n                    for(final EditorArea ea : eas) {\n                      tabs.setSelectedComponent(ea);\n                      if(ea.modified() && (ea.opened() || edit != null && trim(ea.getText()).length != 0)) {\n                        final String msg = Util.info(CLOSE_FILE_X, ea.file().name());\n                        final String action = BaseXDialog.yesNoCancel(gui, msg, buttons);\n                        if(action == null || action.equals(B_YES) && !save()) return false;\n                        else if(action.equals(CLOSE_ALL)) break;\n                      }\n                    }\n\n                    // close application: remember opened files\n                    final IOFile tmpDir = new IOFile(Prop.TEMPDIR, Prop.PROJECT);\n                    if(edit == null && eas.length > 0 && tmpDir.md()) {\n                      try {\n                        final String prefix = Prop.HOMEDIR.hashCode() + \"-\";\n                        int c = 0;\n                        for(final EditorArea ea : eas) {\n                          final byte[] text = ea.getText();\n                          if(!ea.opened() && text.length > 0) {\n                            new IOFile(tmpDir, prefix + c++ + IO.TMPSUFFIX).write(text);\n                          }\n                        }\n                      } catch(final IOException ex) {\n                        Util.debug(ex);\n                      }\n                    }\n                    return true;\n                  }\n\n                  /**\n                   * Returns all editors.\n                   * @return editors\n                   */\n                  private EditorArea[] editors() {\n                    final ArrayList<EditorArea> edits = new ArrayList<>();\n                    for(final Component c : tabs.getComponents()) {\n                      if(c instanceof EditorArea) edits.add((EditorArea) c);\n                    }\n                    return edits.toArray(new EditorArea[0]);\n                  }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void californium(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                /*******************************************************************************\n                 * Copyright (c) 2017 Bosch Software Innovations GmbH and others.\n                 *\n                 * All rights reserved. This program and the accompanying materials\n                 * are made available under the terms of the Eclipse Public License v2.0\n                 * and Eclipse Distribution License v1.0 which accompany this distribution.\n                 *\n                 * The Eclipse Public License is available at\n                 *    http://www.eclipse.org/legal/epl-v20.html\n                 * and the Eclipse Distribution License is available at\n                 *    http://www.eclipse.org/org/documents/edl-v10.html.\n                 *\n                 * Contributors:\n                 *    Bosch Software Innovations GmbH - initial creation\n                 *                                      derived from HelloWorldServer example\n                 *    Bosch Software Innovations GmbH - migrate to SLF4J\n                 ******************************************************************************/\n                package org.eclipse.californium.examples;\n\n                import java.io.File;\n                import java.io.FileInputStream;\n                import java.io.IOException;\n                import java.io.InputStream;\n                import java.net.SocketException;\n                import java.util.Arrays;\n                import java.util.HashMap;\n                import java.util.Map;\n\n                import org.eclipse.californium.core.CoapResource;\n                import org.eclipse.californium.core.coap.CoAP;\n                import org.eclipse.californium.core.coap.MediaTypeRegistry;\n                import org.eclipse.californium.core.coap.Request;\n                import org.eclipse.californium.core.coap.Response;\n                import org.eclipse.californium.core.config.CoapConfig;\n                import org.eclipse.californium.core.network.Exchange;\n                import org.eclipse.californium.core.server.resources.CoapExchange;\n                import org.eclipse.californium.core.server.resources.MyIpResource;\n                import org.eclipse.californium.core.server.resources.Resource;\n                import org.eclipse.californium.elements.config.Configuration;\n                import org.eclipse.californium.elements.config.UdpConfig;\n                import org.eclipse.californium.elements.config.Configuration.DefinitionsProvider;\n                import org.eclipse.californium.elements.config.TcpConfig;\n                import org.eclipse.californium.elements.util.StringUtil;\n                import org.eclipse.californium.plugtests.AbstractTestServer;\n                import org.eclipse.californium.plugtests.PlugtestServer.BaseConfig;\n                import org.eclipse.californium.plugtests.resources.MyContext;\n                import org.eclipse.californium.scandium.config.DtlsConfig;\n                import org.slf4j.Logger;\n                import org.slf4j.LoggerFactory;\n\n                import picocli.CommandLine;\n                import picocli.CommandLine.Command;\n                import picocli.CommandLine.Option;\n                import picocli.CommandLine.ParameterException;\n                import picocli.CommandLine.ParseResult;\n\n                public class SimpleFileServer extends AbstractTestServer {\n\n                \tprivate static final Logger LOG = LoggerFactory.getLogger(SimpleFileServer.class);\n\n                \tprivate static final File CONFIG_FILE = new File(\"Californium3.properties\");\n                \tprivate static final String CONFIG_HEADER = \"Californium CoAP Properties file for Fileserver\";\n                \t// 2 MB\n                \tprivate static final int DEFAULT_MAX_RESOURCE_SIZE = 2 * 1024 * 1024;\n                \tprivate static final int DEFAULT_BLOCK_SIZE = 512;\n\n                \tstatic {\n                \t\tCoapConfig.register();\n                \t\tUdpConfig.register();\n                \t\tDtlsConfig.register();\n                \t\tTcpConfig.register();\n                \t}\n\n                \tprivate static DefinitionsProvider DEFAULTS = new DefinitionsProvider() {\n\n                \t\t@Override\n                \t\tpublic void applyDefinitions(Configuration config) {\n                \t\t\tconfig.set(CoapConfig.MAX_RESOURCE_BODY_SIZE, DEFAULT_MAX_RESOURCE_SIZE);\n                \t\t\tconfig.set(CoapConfig.MAX_MESSAGE_SIZE, DEFAULT_BLOCK_SIZE);\n                \t\t\tconfig.set(CoapConfig.PREFERRED_BLOCK_SIZE, DEFAULT_BLOCK_SIZE);\n                \t\t\tconfig.setTransient(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE);\n                \t\t\tconfig.setTransient(TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE);\n                \t\t\tconfig.set(EXTERNAL_UDP_MAX_MESSAGE_SIZE, 64);\n                \t\t\tconfig.set(EXTERNAL_UDP_PREFERRED_BLOCK_SIZE, 64);\n                \t\t}\n                \t};\n\n                \tprivate static final String DEFAULT_PATH = \"data\";\n\n                \t@Command(name = \"SimpleFileServer\", version = \"(c) 2017, Bosch Software Innovations GmbH and others.\")\n                \tpublic static class Config extends BaseConfig {\n\n                \t\t@Option(names = \"--file-root\", description = \"files root. Default \\\"\" + DEFAULT_PATH + \"\\\"\")\n                \t\tpublic String fileRoot = DEFAULT_PATH;\n\n                \t\t@Option(names = \"--path-root\", description = \"resource-path root. Default \\\"\" + DEFAULT_PATH + \"\\\"\")\n                \t\tpublic String pathRoot = DEFAULT_PATH;\n\n                \t}\n\n                \tprivate static final Config config = new Config();\n\n                \t/*\n                \t * Application entry point.\n                \t */\n                \tpublic static void main(String[] args) {\n                \t\tString version = StringUtil.CALIFORNIUM_VERSION == null ? \"\" : StringUtil.CALIFORNIUM_VERSION;\n                \t\tCommandLine cmd = new CommandLine(config);\n                \t\ttry {\n                \t\t\tParseResult result = cmd.parseArgs(args);\n                \t\t\tif (result.isVersionHelpRequested()) {\n                \t\t\t\tSystem.out.println(\"\\nCalifornium (Cf) \" + cmd.getCommandName() + \" \" + version);\n                \t\t\t\tcmd.printVersionHelp(System.out);\n                \t\t\t\tSystem.out.println();\n                \t\t\t}\n                \t\t\tif (result.isUsageHelpRequested()) {\n                \t\t\t\tcmd.usage(System.out);\n                \t\t\t\treturn;\n                \t\t\t}\n                \t\t} catch (ParameterException ex) {\n                \t\t\tSystem.err.println(ex.getMessage());\n                \t\t\tSystem.err.println();\n                \t\t\tcmd.usage(System.err);\n                \t\t\tSystem.exit(-1);\n                \t\t}\n\n                \t\tConfiguration netConfig = Configuration.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);\n                \t\t// reduce the message size for plain UDP\n                \t\tConfiguration udpConfig = new Configuration(netConfig)\n                \t\t\t\t.set(CoapConfig.MAX_MESSAGE_SIZE, netConfig.get(EXTERNAL_UDP_MAX_MESSAGE_SIZE))\n                \t\t\t\t.set(CoapConfig.PREFERRED_BLOCK_SIZE, netConfig.get(EXTERNAL_UDP_PREFERRED_BLOCK_SIZE));\n                \t\tMap<Select, Configuration> protocolConfig = new HashMap<>();\n                \t\tprotocolConfig.put(new Select(Protocol.UDP, InterfaceType.EXTERNAL), udpConfig);\n\n                \t\ttry {\n                \t\t\tString filesRootPath = config.fileRoot;\n                \t\t\tString coapRootPath = config.pathRoot;\n\n                \t\t\tif (0 <= coapRootPath.indexOf('/')) {\n                \t\t\t\tLOG.error(\"{} don't use '/'! Only one path segement for coap root allowed!\", coapRootPath);\n                \t\t\t\treturn;\n                \t\t\t}\n\n                \t\t\tFile filesRoot = new File(filesRootPath);\n                \t\t\tif (!filesRoot.exists()) {\n                \t\t\t\tLOG.error(\"{} doesn't exists!\", filesRoot.getAbsolutePath());\n                \t\t\t\treturn;\n                \t\t\t} else if (!filesRoot.isDirectory()) {\n                \t\t\t\tLOG.error(\"{} is no directory!\", filesRoot.getAbsolutePath());\n                \t\t\t\treturn;\n                \t\t\t}\n\n                \t\t\tlistURIs(filesRoot, coapRootPath);\n\n                \t\t\t// create server\n                \t\t\tSimpleFileServer server = new SimpleFileServer(netConfig, protocolConfig, coapRootPath, filesRoot);\n                \t\t\tserver.add(new MyContext(MyContext.RESOURCE_NAME, version, true));\n\n                \t\t\t// add endpoints on all IP addresses\n                \t\t\tserver.addEndpoints(null, null, Arrays.asList(Protocol.UDP, Protocol.DTLS, Protocol.TCP, Protocol.TLS),\n                \t\t\t\t\tconfig);\n                \t\t\tserver.start();\n\n                \t\t} catch (SocketException e) {\n                \t\t\tLOG.error(\"Failed to initialize server: \", e);\n                \t\t}\n                \t}\n\n                \tpublic static void listURIs(File filesRoot, String coapRootPath) {\n                \t\tFile[] files = filesRoot.listFiles();\n                \t\tfor (File file : files) {\n                \t\t\tif (file.isFile() && file.canRead()) {\n                \t\t\t\tLOG.info(\"GET: coap://<host>/{}/{}\", coapRootPath, file.getName());\n                \t\t\t}\n                \t\t}\n                \t\tfor (File file : files) {\n                \t\t\tif (file.isDirectory() && file.canRead()) {\n                \t\t\t\tlistURIs(file, coapRootPath + \"/\" + file.getName());\n                \t\t\t}\n                \t\t}\n                \t}\n\n                \t/*\n                \t * Constructor for a new simple file server. Here, the resources of the\n                \t * server are initialized.\n                \t */\n                \tpublic SimpleFileServer(Configuration config, Map<Select, Configuration> protocolConfig, String coapRootPath,\n                \t\t\tFile filesRoot) throws SocketException {\n                \t\tsuper(config, protocolConfig);\n                \t\tadd(new FileResource(config, coapRootPath, filesRoot));\n                \t\tadd(new MyIpResource(MyIpResource.RESOURCE_NAME, true));\n                \t}\n\n                \tclass FileResource extends CoapResource {\n\n                \t\tprivate final Configuration config;\n                \t\t/**\n                \t\t * Files root directory.\n                \t\t */\n                \t\tprivate final File filesRoot;\n\n                \t\t/**\n                \t\t * Create CoAP file resource.\n                \t\t *\n                \t\t * @param config configuration\n                \t\t * @param coapRootPath CoAP resource (base) name\n                \t\t * @param filesRoot files root\n                \t\t */\n                \t\tpublic FileResource(Configuration config, String coapRootPath, File filesRoot) {\n                \t\t\tsuper(coapRootPath);\n                \t\t\tthis.config = config;\n                \t\t\tthis.filesRoot = filesRoot;\n                \t\t}\n\n                \t\t/*\n                \t\t * Override the default behavior so that requests to sub resources\n                \t\t * (typically /{path}/{file-name}) are handled by /file resource.\n                \t\t */\n                \t\t@Override\n                \t\tpublic Resource getChild(String name) {\n                \t\t\treturn this;\n                \t\t}\n\n                \t\t@Override\n                \t\tpublic void handleRequest(Exchange exchange) {\n                \t\t\ttry {\n                \t\t\t\tsuper.handleRequest(exchange);\n                \t\t\t} catch (Exception e) {\n                \t\t\t\tLOG.error(\"Exception while handling a request on the {} resource\", getName(), e);\n                \t\t\t\texchange.sendResponse(new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR));\n                \t\t\t}\n                \t\t}\n\n                \t\t@Override\n                \t\tpublic void handleGET(final CoapExchange exchange) {\n                \t\t\tRequest request = exchange.advanced().getRequest();\n                \t\t\tLOG.info(\"Get received : {}\", request);\n\n                \t\t\tint accept = request.getOptions().getAccept();\n                \t\t\tif (MediaTypeRegistry.UNDEFINED == accept) {\n                \t\t\t\taccept = MediaTypeRegistry.APPLICATION_OCTET_STREAM;\n                \t\t\t} else if (MediaTypeRegistry.APPLICATION_OCTET_STREAM != accept) {\n                \t\t\t\texchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);\n                \t\t\t\treturn;\n                \t\t\t}\n\n                \t\t\tString myURI = getURI() + \"/\";\n                \t\t\tString path = \"/\" + request.getOptions().getUriPathString();\n                \t\t\tif (!path.startsWith(myURI)) {\n                \t\t\t\tLOG.info(\"Request {} does not match {}!\", path, myURI);\n                \t\t\t\texchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);\n                \t\t\t\treturn;\n                \t\t\t}\n                \t\t\tpath = path.substring(myURI.length());\n                \t\t\tif (request.getOptions().hasBlock2()) {\n                \t\t\t\tLOG.info(\"Send file {} {}\", path, request.getOptions().getBlock2());\n                \t\t\t} else {\n                \t\t\t\tLOG.info(\"Send file {}\", path);\n                \t\t\t}\n                \t\t\tFile file = new File(filesRoot, path);\n                \t\t\tif (!file.exists() || !file.isFile()) {\n                \t\t\t\tLOG.warn(\"File {} doesn't exist!\", file.getAbsolutePath());\n                \t\t\t\texchange.respond(CoAP.ResponseCode.NOT_FOUND);\n                \t\t\t\treturn;\n                \t\t\t}\n                \t\t\tif (!checkFileLocation(file, filesRoot)) {\n                \t\t\t\tLOG.warn(\"File {} is not in {}!\", file.getAbsolutePath(), filesRoot.getAbsolutePath());\n                \t\t\t\texchange.respond(CoAP.ResponseCode.UNAUTHORIZED);\n                \t\t\t\treturn;\n                \t\t\t}\n\n                \t\t\tif (!file.canRead()) {\n                \t\t\t\tLOG.warn(\"File {} is not readable!\", file.getAbsolutePath());\n                \t\t\t\texchange.respond(CoAP.ResponseCode.UNAUTHORIZED);\n                \t\t\t\treturn;\n                \t\t\t}\n                \t\t\tlong maxLength = config.get(CoapConfig.MAX_RESOURCE_BODY_SIZE);\n                \t\t\tlong length = file.length();\n                \t\t\tif (length > maxLength) {\n                \t\t\t\tLOG.warn(\"File {} is too large {} (max.: {})!\", file.getAbsolutePath(), length, maxLength);\n                \t\t\t\texchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);\n                \t\t\t\treturn;\n                \t\t\t}\n                \t\t\ttry (InputStream in = new FileInputStream(file)) {\n                \t\t\t\tbyte[] content = new byte[(int) length];\n                \t\t\t\tint r = in.read(content);\n                \t\t\t\tif (length == r) {\n                \t\t\t\t\tResponse response = new Response(CoAP.ResponseCode.CONTENT);\n                \t\t\t\t\tresponse.setPayload(content);\n                \t\t\t\t\tresponse.getOptions().setSize2((int) length);\n                \t\t\t\t\tresponse.getOptions().setContentFormat(accept);\n                \t\t\t\t\texchange.respond(response);\n                \t\t\t\t} else {\n                \t\t\t\t\tLOG.warn(\"File {} could not be read in!\", file.getAbsolutePath());\n                \t\t\t\t\texchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);\n                \t\t\t\t}\n                \t\t\t} catch (IOException ex) {\n                \t\t\t\tLOG.warn(\"File {}:\", file.getAbsolutePath(), ex);\n                \t\t\t\texchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);\n                \t\t\t}\n                \t\t}\n\n                \t\t/**\n                \t\t * Check, if file is located in root.\n                \t\t *\n                \t\t * Detect attacks via \"../.../../file\".\n                \t\t *\n                \t\t * @param file file to check\n                \t\t * @param root file root\n                \t\t * @return true, if file is locate in root (or a sub-folder of root),\n                \t\t *         false, otherwise.\n                \t\t */\n                \t\tprivate boolean checkFileLocation(File file, File root) {\n                \t\t\ttry {\n                \t\t\t\treturn file.getCanonicalPath().startsWith(root.getCanonicalPath());\n                \t\t\t} catch (IOException ex) {\n                \t\t\t\tLOG.warn(\"File {}:\", file.getAbsolutePath(), ex);\n                \t\t\t\treturn false;\n                \t\t\t}\n                \t\t}\n                \t}\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void DependencyCheck(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                /*\n                 * This file is part of dependency-check-core.\n                 *\n                 * Licensed under the Apache License, Version 2.0 (the \"License\");\n                 * you may not use this file except in compliance with the License.\n                 * You may obtain a copy of the License at\n                 *\n                 *     http://www.apache.org/licenses/LICENSE-2.0\n                 *\n                 * Unless required by applicable law or agreed to in writing, software\n                 * distributed under the License is distributed on an \"AS IS\" BASIS,\n                 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n                 * See the License for the specific language governing permissions and\n                 * limitations under the License.\n                 *\n                 * Copyright (c) 2013 Jeremy Long. All Rights Reserved.\n                 */\n                package org.owasp.dependencycheck.analyzer;\n\n                import java.io.BufferedInputStream;\n                import java.io.File;\n                import java.io.FileFilter;\n                import java.io.FileInputStream;\n                import java.io.FileNotFoundException;\n                import java.io.FileOutputStream;\n                import java.io.IOException;\n                import java.nio.file.Path;\n                import java.util.Collections;\n                import java.util.Enumeration;\n                import java.util.HashSet;\n                import java.util.List;\n                import java.util.Set;\n                import java.util.concurrent.atomic.AtomicInteger;\n                import javax.annotation.concurrent.ThreadSafe;\n\n                import org.apache.commons.compress.archivers.ArchiveEntry;\n                import org.apache.commons.compress.archivers.ArchiveInputStream;\n                import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;\n                import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;\n                import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;\n                import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;\n                import org.apache.commons.compress.archivers.zip.ZipFile;\n                import org.apache.commons.compress.compressors.CompressorInputStream;\n                import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;\n                import org.apache.commons.compress.compressors.bzip2.BZip2Utils;\n                import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;\n                import org.apache.commons.compress.compressors.gzip.GzipUtils;\n                import org.apache.commons.compress.utils.IOUtils;\n                import org.eclipse.packager.rpm.RpmTag;\n                import org.eclipse.packager.rpm.parse.RpmInputStream;\n                import org.owasp.dependencycheck.Engine;\n                import static org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer.shouldProcess;\n                import org.owasp.dependencycheck.analyzer.exception.AnalysisException;\n                import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;\n                import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;\n                import org.owasp.dependencycheck.dependency.Dependency;\n                import org.owasp.dependencycheck.exception.InitializationException;\n                import org.owasp.dependencycheck.utils.FileFilterBuilder;\n                import org.owasp.dependencycheck.utils.FileUtils;\n                import org.owasp.dependencycheck.utils.Settings;\n\n                import org.slf4j.Logger;\n                import org.slf4j.LoggerFactory;\n\n                /**\n                 * <p>\n                 * An analyzer that extracts files from archives and ensures any supported files\n                 * contained within the archive are added to the dependency list.</p>\n                 *\n                 * @author Jeremy Long\n                 */\n                @ThreadSafe\n                public class ArchiveAnalyzer extends AbstractFileTypeAnalyzer {\n\n                    /**\n                     * The logger.\n                     */\n                    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveAnalyzer.class);\n                    /**\n                     * The count of directories created during analysis. This is used for\n                     * creating temporary directories.\n                     */\n                    private static final AtomicInteger DIRECTORY_COUNT = new AtomicInteger(0);\n                    /**\n                     * The parent directory for the individual directories per archive.\n                     */\n                    private File tempFileLocation = null;\n                    /**\n                     * The max scan depth that the analyzer will recursively extract nested\n                     * archives.\n                     */\n                    private int maxScanDepth;\n                    /**\n                     * The file filter used to filter supported files.\n                     */\n                    private FileFilter fileFilter = null;\n                    /**\n                     * The set of things we can handle with Zip methods\n                     */\n                    private static final Set<String> KNOWN_ZIP_EXT = Collections.unmodifiableSet(\n                            newHashSet(\"zip\", \"ear\", \"war\", \"jar\", \"sar\", \"apk\", \"nupkg\", \"aar\"));\n                    /**\n                     * The set of additional extensions we can handle with Zip methods\n                     */\n                    private static final Set<String> ADDITIONAL_ZIP_EXT = new HashSet<>();\n                    /**\n                     * The set of file extensions supported by this analyzer. Note for\n                     * developers, any additions to this list will need to be explicitly handled\n                     * in {@link #extractFiles(File, File, Engine)}.\n                     */\n                    private static final Set<String> EXTENSIONS = Collections.unmodifiableSet(\n                            newHashSet(\"tar\", \"gz\", \"tgz\", \"bz2\", \"tbz2\", \"rpm\"));\n\n                    /**\n                     * Detects files with extensions to remove from the engine's collection of\n                     * dependencies.\n                     */\n                    private static final FileFilter REMOVE_FROM_ANALYSIS = FileFilterBuilder.newInstance()\n                            .addExtensions(\"zip\", \"tar\", \"gz\", \"tgz\", \"bz2\", \"tbz2\", \"nupkg\", \"rpm\").build();\n                    /**\n                     * Detects files with .zip extension.\n                     */\n                    private static final FileFilter ZIP_FILTER = FileFilterBuilder.newInstance().addExtensions(\"zip\").build();\n\n                    //<editor-fold defaultstate=\"collapsed\" desc=\"All standard implementation details of Analyzer\">\n                    /**\n                     * The name of the analyzer.\n                     */\n                    private static final String ANALYZER_NAME = \"Archive Analyzer\";\n                    /**\n                     * The phase that this analyzer is intended to run in.\n                     */\n                    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INITIAL;\n\n                    /**\n                     * Make java compiler happy\n                     */\n                    public ArchiveAnalyzer() {\n                    }\n\n                    /**\n                     * Initializes the analyzer with the configured settings.\n                     *\n                     * @param settings the configured settings to use\n                     */\n                    @Override\n                    public void initialize(Settings settings) {\n                        super.initialize(settings);\n                        initializeSettings();\n                    }\n\n                    @Override\n                    protected FileFilter getFileFilter() {\n                        return fileFilter;\n                    }\n\n                    /**\n                     * Returns the name of the analyzer.\n                     *\n                     * @return the name of the analyzer.\n                     */\n                    @Override\n                    public String getName() {\n                        return ANALYZER_NAME;\n                    }\n\n                    /**\n                     * Returns the phase that the analyzer is intended to run in.\n                     *\n                     * @return the phase that the analyzer is intended to run in.\n                     */\n                    @Override\n                    public AnalysisPhase getAnalysisPhase() {\n                        return ANALYSIS_PHASE;\n                    }\n                    //</editor-fold>\n\n                    /**\n                     * Returns the key used in the properties file to reference the analyzer's\n                     * enabled property.\n                     *\n                     * @return the analyzer's enabled property setting key\n                     */\n                    @Override\n                    protected String getAnalyzerEnabledSettingKey() {\n                        return Settings.KEYS.ANALYZER_ARCHIVE_ENABLED;\n                    }\n\n                    /**\n                     * The prepare method does nothing for this Analyzer.\n                     *\n                     * @param engine a reference to the dependency-check engine\n                     * @throws InitializationException is thrown if there is an exception\n                     * deleting or creating temporary files\n                     */\n                    @Override\n                    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {\n                        try {\n                            final File baseDir = getSettings().getTempDirectory();\n                            tempFileLocation = File.createTempFile(\"check\", \"tmp\", baseDir);\n                            if (!tempFileLocation.delete()) {\n                                setEnabled(false);\n                                final String msg = String.format(\"Unable to delete temporary file '%s'.\", tempFileLocation.getAbsolutePath());\n                                throw new InitializationException(msg);\n                            }\n                            if (!tempFileLocation.mkdirs()) {\n                                setEnabled(false);\n                                final String msg = String.format(\"Unable to create directory '%s'.\", tempFileLocation.getAbsolutePath());\n                                throw new InitializationException(msg);\n                            }\n                        } catch (IOException ex) {\n                            setEnabled(false);\n                            throw new InitializationException(\"Unable to create a temporary file\", ex);\n                        }\n                    }\n\n                    /**\n                     * The close method deletes any temporary files and directories created\n                     * during analysis.\n                     *\n                     * @throws Exception thrown if there is an exception deleting temporary\n                     * files\n                     */\n                    @Override\n                    public void closeAnalyzer() throws Exception {\n                        if (tempFileLocation != null && tempFileLocation.exists()) {\n                            LOGGER.debug(\"Attempting to delete temporary files from `{}`\", tempFileLocation.toString());\n                            final boolean success = FileUtils.delete(tempFileLocation);\n                            if (!success && tempFileLocation.exists()) {\n                                final String[] l = tempFileLocation.list();\n                                if (l != null && l.length > 0) {\n                                    LOGGER.warn(\"Failed to delete the Archive Analyzer's temporary files from `{}`, \"\n                                            + \"see the log for more details\", tempFileLocation.toString());\n                                }\n                            }\n                        }\n                    }\n\n                    /**\n                     * Determines if the file can be analyzed by the analyzer. If the npm\n                     * analyzer are enabled the archive analyzer will skip the node_modules and\n                     * bower_modules directories.\n                     *\n                     * @param pathname the path to the file\n                     * @return true if the file can be analyzed by the given analyzer; otherwise\n                     * false\n                     */\n                    @Override\n                    public boolean accept(File pathname) {\n                        boolean accept = super.accept(pathname);\n                        final boolean npmEnabled = getSettings().getBoolean(Settings.KEYS.ANALYZER_NODE_AUDIT_ENABLED, false);\n                        final boolean yarnEnabled = getSettings().getBoolean(Settings.KEYS.ANALYZER_YARN_AUDIT_ENABLED, false);\n                        final boolean pnpmEnabled = getSettings().getBoolean(Settings.KEYS.ANALYZER_PNPM_AUDIT_ENABLED, false);\n                        if (accept && (npmEnabled || yarnEnabled || pnpmEnabled)) {\n                            try {\n                                accept = shouldProcess(pathname);\n                            } catch (AnalysisException ex) {\n                                throw new UnexpectedAnalysisException(ex.getMessage(), ex.getCause());\n                            }\n                        }\n                        return accept;\n                    }\n\n                    /**\n                     * Analyzes a given dependency. If the dependency is an archive, such as a\n                     * WAR or EAR, the contents are extracted, scanned, and added to the list of\n                     * dependencies within the engine.\n                     *\n                     * @param dependency the dependency to analyze\n                     * @param engine the engine scanning\n                     * @throws AnalysisException thrown if there is an analysis exception\n                     */\n                    @Override\n                    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {\n                        extractAndAnalyze(dependency, engine, 0);\n                        engine.sortDependencies();\n                    }\n\n                    /**\n                     * Extracts the contents of the archive dependency and scans for additional\n                     * dependencies.\n                     *\n                     * @param dependency the dependency being analyzed\n                     * @param engine the engine doing the analysis\n                     * @param scanDepth the current scan depth; extracctAndAnalyze is recursive\n                     * and will, be default, only go 3 levels deep\n                     * @throws AnalysisException thrown if there is a problem analyzing the\n                     * dependencies\n                     */\n                    private void extractAndAnalyze(Dependency dependency, Engine engine, int scanDepth) throws AnalysisException {\n                        final File f = new File(dependency.getActualFilePath());\n                        final File tmpDir = getNextTempDirectory();\n                        extractFiles(f, tmpDir, engine);\n\n                        //make a copy\n                        final List<Dependency> dependencySet = findMoreDependencies(engine, tmpDir);\n\n                        if (dependencySet != null && !dependencySet.isEmpty()) {\n                            for (Dependency d : dependencySet) {\n                                if (d.getFilePath().startsWith(tmpDir.getAbsolutePath())) {\n                                    //fix the dependency's display name and path\n                                    final String displayPath = String.format(\"%s%s\",\n                                            dependency.getFilePath(),\n                                            d.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));\n                                    final String displayName = String.format(\"%s: %s\",\n                                            dependency.getFileName(),\n                                            d.getFileName());\n                                    d.setFilePath(displayPath);\n                                    d.setFileName(displayName);\n                                    d.addAllProjectReferences(dependency.getProjectReferences());\n\n                                    //TODO - can we get more evidence from the parent? EAR contains module name, etc.\n                                    //analyze the dependency (i.e. extract files) if it is a supported type.\n                                    if (this.accept(d.getActualFile()) && scanDepth < maxScanDepth) {\n                                        extractAndAnalyze(d, engine, scanDepth + 1);\n                                    }\n                                } else {\n                                    dependencySet.stream().filter((sub) -> sub.getFilePath().startsWith(tmpDir.getAbsolutePath())).forEach((sub) -> {\n                                        final String displayPath = String.format(\"%s%s\",\n                                                dependency.getFilePath(),\n                                                sub.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));\n                                        final String displayName = String.format(\"%s: %s\",\n                                                dependency.getFileName(),\n                                                sub.getFileName());\n                                        sub.setFilePath(displayPath);\n                                        sub.setFileName(displayName);\n                                    });\n                                }\n                            }\n                        }\n                        if (REMOVE_FROM_ANALYSIS.accept(dependency.getActualFile())) {\n                            addDisguisedJarsToDependencies(dependency, engine);\n                            engine.removeDependency(dependency);\n                        }\n                    }\n\n                    /**\n                     * If a zip file was identified as a possible JAR, this method will add the\n                     * zip to the list of dependencies.\n                     *\n                     * @param dependency the zip file\n                     * @param engine the engine\n                     * @throws AnalysisException thrown if there is an issue\n                     */\n                    private void addDisguisedJarsToDependencies(Dependency dependency, Engine engine) throws AnalysisException {\n                        if (ZIP_FILTER.accept(dependency.getActualFile()) && isZipFileActuallyJarFile(dependency)) {\n                            final File tempDir = getNextTempDirectory();\n                            final String fileName = dependency.getFileName();\n\n                            LOGGER.info(\"The zip file '{}' appears to be a JAR file, making a copy and analyzing it as a JAR.\", fileName);\n                            final File tmpLoc = new File(tempDir, fileName.substring(0, fileName.length() - 3) + \"jar\");\n                            //store the archives sha1 and change it so that the engine doesn't think the zip and jar file are the same\n                            // and add it is a related dependency.\n                            final String archiveMd5 = dependency.getMd5sum();\n                            final String archiveSha1 = dependency.getSha1sum();\n                            final String archiveSha256 = dependency.getSha256sum();\n                            try {\n                                dependency.setMd5sum(\"\");\n                                dependency.setSha1sum(\"\");\n                                dependency.setSha256sum(\"\");\n                                org.apache.commons.io.FileUtils.copyFile(dependency.getActualFile(), tmpLoc);\n                                final List<Dependency> dependencySet = findMoreDependencies(engine, tmpLoc);\n                                if (dependencySet != null && !dependencySet.isEmpty()) {\n                                    dependencySet.forEach((d) -> {\n                                        //fix the dependency's display name and path\n                                        if (d.getActualFile().equals(tmpLoc)) {\n                                            d.setFilePath(dependency.getFilePath());\n                                            d.setDisplayFileName(dependency.getFileName());\n                                        } else {\n                                            d.getRelatedDependencies().stream().filter((rel) -> rel.getActualFile().equals(tmpLoc)).forEach((rel) -> {\n                                                rel.setFilePath(dependency.getFilePath());\n                                                rel.setDisplayFileName(dependency.getFileName());\n                                            });\n                                        }\n                                    });\n                                }\n                            } catch (IOException ex) {\n                                LOGGER.debug(\"Unable to perform deep copy on '{}'\", dependency.getActualFile().getPath(), ex);\n                            } finally {\n                                dependency.setMd5sum(archiveMd5);\n                                dependency.setSha1sum(archiveSha1);\n                                dependency.setSha256sum(archiveSha256);\n                            }\n                        }\n                    }\n\n                    /**\n                     * Scan the given file/folder, and return any new dependencies found.\n                     *\n                     * @param engine used to scan\n                     * @param file target of scanning\n                     * @return any dependencies that weren't known to the engine before\n                     */\n                    private static List<Dependency> findMoreDependencies(Engine engine, File file) {\n                        return engine.scan(file);\n                    }\n\n                    /**\n                     * Retrieves the next temporary directory to extract an archive too.\n                     *\n                     * @return a directory\n                     * @throws AnalysisException thrown if unable to create temporary directory\n                     */\n                    private File getNextTempDirectory() throws AnalysisException {\n                        final File directory = new File(tempFileLocation, String.valueOf(DIRECTORY_COUNT.incrementAndGet()));\n                        //getting an exception for some directories not being able to be created; might be because the directory already exists?\n                        if (directory.exists()) {\n                            return getNextTempDirectory();\n                        }\n                        if (!directory.mkdirs()) {\n                            final String msg = String.format(\"Unable to create temp directory '%s'.\", directory.getAbsolutePath());\n                            throw new AnalysisException(msg);\n                        }\n                        return directory;\n                    }\n\n                    /**\n                     * Extracts the contents of an archive into the specified directory.\n                     *\n                     * @param archive an archive file such as a WAR or EAR\n                     * @param destination a directory to extract the contents to\n                     * @param engine the scanning engine\n                     * @throws AnalysisException thrown if the archive is not found\n                     */\n                    private void extractFiles(File archive, File destination, Engine engine) throws AnalysisException {\n                        if (archive != null && destination != null) {\n                            String archiveExt = FileUtils.getFileExtension(archive.getName());\n                            if (archiveExt == null) {\n                                return;\n                            }\n                            archiveExt = archiveExt.toLowerCase();\n\n                            final FileInputStream fis;\n                            try {\n                                fis = new FileInputStream(archive);\n                            } catch (FileNotFoundException ex) {\n                                final String msg = String.format(\"Error extracting file `%s`: %s\", archive.getAbsolutePath(), ex.getMessage());\n                                LOGGER.debug(msg, ex);\n                                throw new AnalysisException(msg);\n                            }\n                            BufferedInputStream in = null;\n                            ZipArchiveInputStream zin = null;\n                            TarArchiveInputStream tin = null;\n                            GzipCompressorInputStream gin = null;\n                            BZip2CompressorInputStream bzin = null;\n                            RpmInputStream rin = null;\n                            CpioArchiveInputStream cain = null;\n                            try {\n                                if (KNOWN_ZIP_EXT.contains(archiveExt) || ADDITIONAL_ZIP_EXT.contains(archiveExt)) {\n                                    in = new BufferedInputStream(fis);\n                                    ensureReadableJar(archiveExt, in);\n                                    zin = new ZipArchiveInputStream(in);\n                                    extractArchive(zin, destination, engine);\n                                } else if (\"tar\".equals(archiveExt)) {\n                                    in = new BufferedInputStream(fis);\n                                    tin = new TarArchiveInputStream(in);\n                                    extractArchive(tin, destination, engine);\n                                } else if (\"gz\".equals(archiveExt) || \"tgz\".equals(archiveExt)) {\n                                    final String uncompressedName = GzipUtils.getUncompressedFilename(archive.getName());\n                                    final File f = new File(destination, uncompressedName);\n                                    if (engine.accept(f)) {\n                                        final String destPath = destination.getCanonicalPath();\n                                        if (!f.getCanonicalPath().startsWith(destPath)) {\n                                            final String msg = String.format(\n                                                    \"Archive (%s) contains a file that would be written outside of the destination directory\",\n                                                    archive.getPath());\n                                            throw new AnalysisException(msg);\n                                        }\n                                        in = new BufferedInputStream(fis);\n                                        gin = new GzipCompressorInputStream(in);\n                                        decompressFile(gin, f);\n                                    }\n                                } else if (\"bz2\".equals(archiveExt) || \"tbz2\".equals(archiveExt)) {\n                                    final String uncompressedName = BZip2Utils.getUncompressedFilename(archive.getName());\n                                    final File f = new File(destination, uncompressedName);\n                                    if (engine.accept(f)) {\n                                        final String destPath = destination.getCanonicalPath();\n                                        if (!f.getCanonicalPath().startsWith(destPath)) {\n                                            final String msg = String.format(\n                                                    \"Archive (%s) contains a file that would be written outside of the destination directory\",\n                                                    archive.getPath());\n                                            throw new AnalysisException(msg);\n                                        }\n                                        in = new BufferedInputStream(fis);\n                                        bzin = new BZip2CompressorInputStream(in);\n                                        decompressFile(bzin, f);\n                                    }\n                                } else if (\"rpm\".equals(archiveExt)) {\n                                    rin = new RpmInputStream(fis);\n                                    //return of getTag is not used - but the call is a\n                                    //necassary step in reading from the stream\n                                    rin.getPayloadHeader().getTag(RpmTag.NAME);\n                                    cain = new CpioArchiveInputStream(rin);\n                                    extractArchive(cain, destination, engine);\n                                }\n                            } catch (ArchiveExtractionException ex) {\n                                LOGGER.warn(\"Exception extracting archive '{}'.\", archive.getName());\n                                LOGGER.debug(\"\", ex);\n                            } catch (IOException ex) {\n                                LOGGER.warn(\"Exception reading archive '{}'.\", archive.getName());\n                                LOGGER.debug(\"\", ex);\n                            } finally {\n                                //overly verbose and not needed... but keeping it anyway due to\n                                //having issue with file handles being left open\n                                FileUtils.close(fis);\n                                FileUtils.close(in);\n                                FileUtils.close(zin);\n                                FileUtils.close(tin);\n                                FileUtils.close(gin);\n                                FileUtils.close(bzin);\n                            }\n                        }\n                    }\n\n                    /**\n                     * Checks if the file being scanned is a JAR or WAR that begins with\n                     * '#!/bin' which indicates it is a fully executable jar. If a fully\n                     * executable JAR is identified the input stream will be advanced to the\n                     * start of the actual JAR file ( skipping the script).\n                     *\n                     * @see\n                     * <a href=\"http://docs.spring.io/spring-boot/docs/1.3.0.BUILD-SNAPSHOT/reference/htmlsingle/#deployment-install\">Installing\n                     * Spring Boot Applications</a>\n                     * @param archiveExt the file extension\n                     * @param in the input stream\n                     * @throws IOException thrown if there is an error reading the stream\n                     */\n                    private void ensureReadableJar(final String archiveExt, BufferedInputStream in) throws IOException {\n                        if ((\"war\".equals(archiveExt) || \"jar\".equals(archiveExt)) && in.markSupported()) {\n                            in.mark(7);\n                            final byte[] b = new byte[7];\n                            final int read = in.read(b);\n                            if (read == 7\n                                    && b[0] == '#'\n                                    && b[1] == '!'\n                                    && b[2] == '/'\n                                    && b[3] == 'b'\n                                    && b[4] == 'i'\n                                    && b[5] == 'n'\n                                    && b[6] == '/') {\n                                boolean stillLooking = true;\n                                int chr;\n                                int nxtChr;\n                                //CSOFF: InnerAssignment\n                                //CSOFF: NestedIfDepth\n                                while (stillLooking && (chr = in.read()) != -1) {\n                                    if (chr == '\\n' || chr == '\\r') {\n                                        in.mark(4);\n                                        if ((chr = in.read()) != -1) {\n                                            if (chr == 'P' && (chr = in.read()) != -1) {\n                                                if (chr == 'K' && (chr = in.read()) != -1) {\n                                                    if ((chr == 3 || chr == 5 || chr == 7) && (nxtChr = in.read()) != -1) {\n                                                        if (nxtChr == chr + 1) {\n                                                            stillLooking = false;\n                                                            in.reset();\n                                                        }\n                                                    }\n                                                }\n                                            }\n                                        }\n                                    }\n                                }\n                                //CSON: InnerAssignment\n                                //CSON: NestedIfDepth\n                            } else {\n                                in.reset();\n                            }\n                        }\n                    }\n\n                    /**\n                     * Extracts files from an archive.\n                     *\n                     * @param input the archive to extract files from\n                     * @param destination the location to write the files too\n                     * @param engine the dependency-check engine\n                     * @throws ArchiveExtractionException thrown if there is an exception\n                     * extracting files from the archive\n                     */\n                    private void extractArchive(ArchiveInputStream input, File destination, Engine engine) throws ArchiveExtractionException {\n                        ArchiveEntry entry;\n                        try {\n                            //final String destPath = destination.getCanonicalPath();\n                            final Path d = destination.toPath();\n                            while ((entry = input.getNextEntry()) != null) {\n                                //final File file = new File(destination, entry.getName());\n                                final Path f = d.resolve(entry.getName()).normalize();\n                                if (!f.startsWith(d)) {\n                                    LOGGER.debug(\"ZipSlip detected\\n-Destination: \" + d.toString() + \"\\n-Path: \" + f.toString());\n                                    final String msg = String.format(\n                                            \"Archive contains a file (%s) that would be extracted outside of the target directory.\",\n                                            entry.getName());\n                                    throw new ArchiveExtractionException(msg);\n                                }\n                                final File file = f.toFile();\n                                if (entry.isDirectory()) {\n                                    if (!file.exists() && !file.mkdirs()) {\n                                        final String msg = String.format(\"Unable to create directory '%s'.\", file.getAbsolutePath());\n                                        throw new AnalysisException(msg);\n                                    }\n                                } else if (engine.accept(file)) {\n                                    extractAcceptedFile(input, file);\n                                }\n                            }\n                        } catch (IOException | AnalysisException ex) {\n                            throw new ArchiveExtractionException(ex);\n                        } finally {\n                            FileUtils.close(input);\n                        }\n                    }\n\n                    /**\n                     * Extracts a file from an archive.\n                     *\n                     * @param input the archives input stream\n                     * @param file the file to extract\n                     * @throws AnalysisException thrown if there is an error\n                     */\n                    private static void extractAcceptedFile(ArchiveInputStream input, File file) throws AnalysisException {\n                        LOGGER.debug(\"Extracting '{}'\", file.getPath());\n                        final File parent = file.getParentFile();\n                        if (!parent.isDirectory() && !parent.mkdirs()) {\n                            final String msg = String.format(\"Unable to build directory '%s'.\", parent.getAbsolutePath());\n                            throw new AnalysisException(msg);\n                        }\n                        try (FileOutputStream fos = new FileOutputStream(file)) {\n                            IOUtils.copy(input, fos);\n                        } catch (FileNotFoundException ex) {\n                            LOGGER.debug(\"\", ex);\n                            final String msg = String.format(\"Unable to find file '%s'.\", file.getName());\n                            throw new AnalysisException(msg, ex);\n                        } catch (IOException ex) {\n                            LOGGER.debug(\"\", ex);\n                            final String msg = String.format(\"IO Exception while parsing file '%s'.\", file.getName());\n                            throw new AnalysisException(msg, ex);\n                        }\n                    }\n\n                    /**\n                     * Decompresses a file.\n                     *\n                     * @param inputStream the compressed file\n                     * @param outputFile the location to write the decompressed file\n                     * @throws ArchiveExtractionException thrown if there is an exception\n                     * decompressing the file\n                     */\n                    private void decompressFile(CompressorInputStream inputStream, File outputFile) throws ArchiveExtractionException {\n                        LOGGER.debug(\"Decompressing '{}'\", outputFile.getPath());\n                        try (FileOutputStream out = new FileOutputStream(outputFile)) {\n                            IOUtils.copy(inputStream, out);\n                        } catch (IOException ex) {\n                            LOGGER.debug(\"\", ex);\n                            throw new ArchiveExtractionException(ex);\n                        }\n                    }\n\n                    /**\n                     * Attempts to determine if a zip file is actually a JAR file.\n                     *\n                     * @param dependency the dependency to check\n                     * @return true if the dependency appears to be a JAR file; otherwise false\n                     */\n                    private boolean isZipFileActuallyJarFile(Dependency dependency) {\n                        boolean isJar = false;\n                        ZipFile zip = null;\n                        try {\n                            zip = new ZipFile(dependency.getActualFilePath());\n                            if (zip.getEntry(\"META-INF/MANIFEST.MF\") != null\n                                    || zip.getEntry(\"META-INF/maven\") != null) {\n                                final Enumeration<ZipArchiveEntry> entries = zip.getEntries();\n                                while (entries.hasMoreElements()) {\n                                    final ZipArchiveEntry entry = entries.nextElement();\n                                    if (!entry.isDirectory()) {\n                                        final String name = entry.getName().toLowerCase();\n                                        if (name.endsWith(\".class\")) {\n                                            isJar = true;\n                                            break;\n                                        }\n                                    }\n                                }\n                            }\n                        } catch (IOException ex) {\n                            LOGGER.debug(\"Unable to unzip zip file '{}'\", dependency.getFilePath(), ex);\n                        } finally {\n                            ZipFile.closeQuietly(zip);\n                        }\n                        return isJar;\n                    }\n\n                    /**\n                     * Initializes settings used by the scanning functions of the archive\n                     * analyzer.\n                     */\n                    private void initializeSettings() {\n                        maxScanDepth = getSettings().getInt(\"archive.scan.depth\", 3);\n                        final Set<String> extensions = new HashSet<>(EXTENSIONS);\n                        extensions.addAll(KNOWN_ZIP_EXT);\n                        final String additionalZipExt = getSettings().getString(Settings.KEYS.ADDITIONAL_ZIP_EXTENSIONS);\n                        if (additionalZipExt != null) {\n                            final String[] ext = additionalZipExt.split(\"\\\\s*,\\\\s*\");\n                            Collections.addAll(extensions, ext);\n                            Collections.addAll(ADDITIONAL_ZIP_EXT, ext);\n                        }\n                        fileFilter = FileFilterBuilder.newInstance().addExtensions(extensions).build();\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void jsonschema2pojo(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                /**\n                 * Copyright \u00a9 2010-2020 Nokia\n                 *\n                 * Licensed under the Apache License, Version 2.0 (the \"License\");\n                 * you may not use this file except in compliance with the License.\n                 * You may obtain a copy of the License at\n                 *\n                 *      http://www.apache.org/licenses/LICENSE-2.0\n                 *\n                 * Unless required by applicable law or agreed to in writing, software\n                 * distributed under the License is distributed on an \"AS IS\" BASIS,\n                 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n                 * See the License for the specific language governing permissions and\n                 * limitations under the License.\n                 */\n\n                package org.jsonschema2pojo.maven;\n\n                import static java.lang.String.*;\n                import static java.util.Arrays.*;\n                import static java.util.regex.Pattern.*;\n\n                import java.io.File;\n                import java.io.FileFilter;\n                import java.io.IOException;\n                import java.util.ArrayList;\n                import java.util.List;\n\n                import org.apache.maven.shared.utils.io.DirectoryScanner;\n                import org.apache.maven.shared.utils.io.MatchPatterns;\n\n                /**\n                 * <p>A file filter that supports include and exclude patterns.</p>\n                 *\n                 * @author Christian Trimble\n                 * @since 0.4.3\n                 */\n                public class MatchPatternsFileFilter implements FileFilter {\n                    MatchPatterns includePatterns;\n                    MatchPatterns excludePatterns;\n                    String sourceDirectory;\n                    boolean caseSensitive;\n\n                    /**\n                     * <p>Builder for MatchPatternFileFilter instances.</p>\n                     */\n                    public static class Builder {\n                        List<String> includes = new ArrayList<>();\n                        List<String> excludes = new ArrayList<>();\n                        String sourceDirectory;\n                        boolean caseSensitive;\n\n                        public Builder addIncludes(List<String> includes) {\n                            this.includes.addAll(processPatterns(includes));\n                            return this;\n                        }\n\n                        public Builder addIncludes(String... includes) {\n                            if (includes != null) {\n                                addIncludes(asList(includes));\n                            }\n                            return this;\n                        }\n\n                        public Builder addExcludes(List<String> excludes) {\n                            this.excludes.addAll(processPatterns(excludes));\n                            return this;\n                        }\n\n                        public Builder addExcludes(String... excludes) {\n                            if (excludes != null) {\n                                addExcludes(asList(excludes));\n                            }\n                            return this;\n                        }\n\n                        public Builder addDefaultExcludes() {\n                            excludes.addAll(processPatterns(asList(DirectoryScanner.DEFAULTEXCLUDES)));\n                            return this;\n                        }\n\n                        public Builder withSourceDirectory(String canonicalSourceDirectory) {\n                            this.sourceDirectory = canonicalSourceDirectory;\n                            return this;\n                        }\n\n                        public Builder withCaseSensitive(boolean caseSensitive) {\n                            this.caseSensitive = caseSensitive;\n                            return this;\n                        }\n\n                        public MatchPatternsFileFilter build() {\n                            if (includes.isEmpty()) {\n                                includes.add(processPattern(\"**/*\"));\n                            }\n                            return new MatchPatternsFileFilter(\n                                    MatchPatterns.from(includes.toArray(new String[] {})),\n                                    MatchPatterns.from(excludes.toArray(new String[] {})),\n                                    sourceDirectory,\n                                    caseSensitive);\n                        }\n                    }\n\n                    MatchPatternsFileFilter(MatchPatterns includePatterns, MatchPatterns excludePatterns, String sourceDirectory, boolean caseSensitive) {\n                        this.includePatterns = includePatterns;\n                        this.excludePatterns = excludePatterns;\n                        this.sourceDirectory = sourceDirectory;\n                        this.caseSensitive = caseSensitive;\n                    }\n\n                    @Override\n                    public boolean accept(File file) {\n                        try {\n                            String path = relativePath(file);\n                            return file.isDirectory() ?\n                                    includePatterns.matchesPatternStart(path, caseSensitive) && !excludePatterns.matches(path, caseSensitive) :\n                                    includePatterns.matches(path, caseSensitive) && !excludePatterns.matches(path, caseSensitive);\n                        } catch (IOException e) {\n                            return false;\n                        }\n                    }\n\n                    String relativePath(File file) throws IOException {\n                        String canonicalPath = file.getCanonicalPath();\n                        if (!canonicalPath.startsWith(sourceDirectory)) {\n                            throw new IOException(format(\"the path %s is not a decendent of the basedir %s\", canonicalPath, sourceDirectory));\n                        }\n                        return canonicalPath.substring(sourceDirectory.length()).replaceAll(\"^\" + quote(File.separator), \"\");\n                    }\n\n                    static List<String> processPatterns(List<String> patterns) {\n                        if (patterns == null)\n                            return null;\n                        List<String> processed = new ArrayList<>();\n                        for (String pattern : patterns) {\n                            processed.add(processPattern(pattern));\n                        }\n                        return processed;\n                    }\n\n                    static String processPattern(String pattern) {\n                        return pattern\n                                .trim()\n                                .replace('/', File.separatorChar)\n                                .replace('\\\\', File.separatorChar)\n                                .replaceAll(quote(File.separator) + \"$\", File.separator + \"**\");\n                    }\n\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void karate(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                /*\n                 * The MIT License\n                 *\n                 * Copyright 2019 Intuit Inc.\n                 *\n                 * Permission is hereby granted, free of charge, to any person obtaining a copy\n                 * of this software and associated documentation files (the \"Software\"), to deal\n                 * in the Software without restriction, including without limitation the rights\n                 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n                 * copies of the Software, and to permit persons to whom the Software is\n                 * furnished to do so, subject to the following conditions:\n                 *\n                 * The above copyright notice and this permission notice shall be included in\n                 * all copies or substantial portions of the Software.\n                 *\n                 * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n                 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n                 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n                 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n                 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n                 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n                 * THE SOFTWARE.\n                 */\n                package com.intuit.karate.job;\n\n                import java.io.File;\n                import java.io.FileInputStream;\n                import java.io.FileOutputStream;\n                import java.io.IOException;\n                import java.util.function.Predicate;\n                import java.util.zip.ZipEntry;\n                import java.util.zip.ZipInputStream;\n                import java.util.zip.ZipOutputStream;\n\n                /**\n                 *\n                 * @author pthomas3\n                 */\n                public class JobUtils {\n\n                    public static void zip(File src, File dest) {\n                        try {\n                            src = src.getCanonicalFile();\n                            FileOutputStream fos = new FileOutputStream(dest);\n                            ZipOutputStream zipOut = new ZipOutputStream(fos);\n                            zip(src, \"\", zipOut, 0);\n                            zipOut.close();\n                            fos.close();\n                        } catch (IOException e) {\n                            throw new RuntimeException(e);\n                        }\n                    }\n\n                    private static void zip(File fileToZip, String fileName, ZipOutputStream zipOut, int level) throws IOException {\n                        if (fileToZip.isHidden()) {\n                            return;\n                        }\n                        if (fileToZip.isDirectory()) {\n                            String entryName = fileName;\n                            zipOut.putNextEntry(new ZipEntry(entryName + \"/\"));\n                            zipOut.closeEntry();\n                            File[] children = fileToZip.listFiles();\n                            for (File childFile : children) {\n                                String childFileName = childFile.getName();\n                                // TODO improve ?\n                                if (childFileName.equals(\"target\") || childFileName.equals(\"build\")) {\n                                    continue;\n                                }\n                                if (level != 0) {\n                                    childFileName = entryName + \"/\" + childFileName;\n                                }\n                                zip(childFile, childFileName, zipOut, level + 1);\n                            }\n                            return;\n                        }\n                        ZipEntry zipEntry = new ZipEntry(fileName);\n                        zipOut.putNextEntry(zipEntry);\n                        FileInputStream fis = new FileInputStream(fileToZip);\n                        byte[] bytes = new byte[1024];\n                        int length;\n                        while ((length = fis.read(bytes)) >= 0) {\n                            zipOut.write(bytes, 0, length);\n                        }\n                        fis.close();\n                    }\n\n                    public static void unzip(File src, File dest) {\n                        try {\n                            byte[] buffer = new byte[1024];\n                            ZipInputStream zis = new ZipInputStream(new FileInputStream(src));\n                            ZipEntry zipEntry = zis.getNextEntry();\n                            while (zipEntry != null) {\n                                File newFile = createFile(dest, zipEntry);\n                                if (zipEntry.isDirectory()) {\n                                    newFile.mkdirs();\n                                } else {\n                                    File parentFile = newFile.getParentFile();\n                                    if (parentFile != null && !parentFile.exists()) {\n                                        parentFile.mkdirs();\n                                    }\n                                    FileOutputStream fos = new FileOutputStream(newFile);\n                                    int len;\n                                    while ((len = zis.read(buffer)) > 0) {\n                                        fos.write(buffer, 0, len);\n                                    }\n                                    fos.close();\n                                }\n                                zipEntry = zis.getNextEntry();\n                            }\n                            zis.closeEntry();\n                            zis.close();\n                        } catch (IOException e) {\n                            throw new RuntimeException(e);\n                        }\n                    }\n\n                    private static File createFile(File destinationDir, ZipEntry zipEntry) throws IOException {\n                        File destFile = new File(destinationDir, zipEntry.getName());\n                        String destDirPath = destinationDir.getCanonicalPath();\n                        String destFilePath = destFile.getCanonicalPath();\n                        if (!destFilePath.startsWith(destDirPath)) {\n                            throw new IOException(\"entry outside target dir: \" + zipEntry.getName());\n                        }\n                        return destFile;\n                    }\n\n                    public static File getFirstFileMatching(File parent, Predicate<String> predicate) {\n                        File[] files = parent.listFiles((f, n) -> predicate.test(n));\n                        return files == null || files.length == 0 ? null : files[0];\n                    }\n\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void termux-app TermuxDocumentProvider(@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                package com.termux.filepicker;\n\n                import android.content.res.AssetFileDescriptor;\n                import android.database.Cursor;\n                import android.database.MatrixCursor;\n                import android.graphics.Point;\n                import android.os.CancellationSignal;\n                import android.os.ParcelFileDescriptor;\n                import android.provider.DocumentsContract.Document;\n                import android.provider.DocumentsContract.Root;\n                import android.provider.DocumentsProvider;\n                import android.webkit.MimeTypeMap;\n\n                import com.termux.R;\n                import com.termux.shared.termux.TermuxConstants;\n\n                import java.io.File;\n                import java.io.FileNotFoundException;\n                import java.io.IOException;\n                import java.util.Collections;\n                import java.util.LinkedList;\n\n                /**\n                 * A document provider for the Storage Access Framework which exposes the files in the\n                 * HOME directory to other apps.\n                 * <p/>\n                 * Note that this replaces providing an activity matching the ACTION_GET_CONTENT intent:\n                 * <p/>\n                 * \"A document provider and ACTION_GET_CONTENT should be considered mutually exclusive. If you\n                 * support both of them simultaneously, your app will appear twice in the system picker UI,\n                 * offering two different ways of accessing your stored data. This would be confusing for users.\"\n                 * - http://developer.android.com/guide/topics/providers/document-provider.html#43\n                 */\n                public class TermuxDocumentsProvider extends DocumentsProvider {\n\n                    private static final String ALL_MIME_TYPES = \"*/*\";\n\n                    private static final File BASE_DIR = TermuxConstants.TERMUX_HOME_DIR;\n\n\n                    // The default columns to return information about a root if no specific\n                    // columns are requested in a query.\n                    private static final String[] DEFAULT_ROOT_PROJECTION = new String[]{\n                        Root.COLUMN_ROOT_ID,\n                        Root.COLUMN_MIME_TYPES,\n                        Root.COLUMN_FLAGS,\n                        Root.COLUMN_ICON,\n                        Root.COLUMN_TITLE,\n                        Root.COLUMN_SUMMARY,\n                        Root.COLUMN_DOCUMENT_ID,\n                        Root.COLUMN_AVAILABLE_BYTES\n                    };\n\n                    // The default columns to return information about a document if no specific\n                    // columns are requested in a query.\n                    private static final String[] DEFAULT_DOCUMENT_PROJECTION = new String[]{\n                        Document.COLUMN_DOCUMENT_ID,\n                        Document.COLUMN_MIME_TYPE,\n                        Document.COLUMN_DISPLAY_NAME,\n                        Document.COLUMN_LAST_MODIFIED,\n                        Document.COLUMN_FLAGS,\n                        Document.COLUMN_SIZE\n                    };\n\n                    @Override\n                    public Cursor queryRoots(String[] projection) {\n                        final MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_ROOT_PROJECTION);\n                        final String applicationName = getContext().getString(R.string.application_name);\n\n                        final MatrixCursor.RowBuilder row = result.newRow();\n                        row.add(Root.COLUMN_ROOT_ID, getDocIdForFile(BASE_DIR));\n                        row.add(Root.COLUMN_DOCUMENT_ID, getDocIdForFile(BASE_DIR));\n                        row.add(Root.COLUMN_SUMMARY, null);\n                        row.add(Root.COLUMN_FLAGS, Root.FLAG_SUPPORTS_CREATE | Root.FLAG_SUPPORTS_SEARCH | Root.FLAG_SUPPORTS_IS_CHILD);\n                        row.add(Root.COLUMN_TITLE, applicationName);\n                        row.add(Root.COLUMN_MIME_TYPES, ALL_MIME_TYPES);\n                        row.add(Root.COLUMN_AVAILABLE_BYTES, BASE_DIR.getFreeSpace());\n                        row.add(Root.COLUMN_ICON, R.mipmap.ic_launcher);\n                        return result;\n                    }\n\n                    @Override\n                    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {\n                        final MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION);\n                        includeFile(result, documentId, null);\n                        return result;\n                    }\n\n                    @Override\n                    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {\n                        final MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION);\n                        final File parent = getFileForDocId(parentDocumentId);\n                        for (File file : parent.listFiles()) {\n                            includeFile(result, null, file);\n                        }\n                        return result;\n                    }\n\n                    @Override\n                    public ParcelFileDescriptor openDocument(final String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {\n                        final File file = getFileForDocId(documentId);\n                        final int accessMode = ParcelFileDescriptor.parseMode(mode);\n                        return ParcelFileDescriptor.open(file, accessMode);\n                    }\n\n                    @Override\n                    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {\n                        final File file = getFileForDocId(documentId);\n                        final ParcelFileDescriptor pfd = ParcelFileDescriptor.open(file, ParcelFileDescriptor.MODE_READ_ONLY);\n                        return new AssetFileDescriptor(pfd, 0, file.length());\n                    }\n\n                    @Override\n                    public boolean onCreate() {\n                        return true;\n                    }\n\n                    @Override\n                    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {\n                        File newFile = new File(parentDocumentId, displayName);\n                        int noConflictId = 2;\n                        while (newFile.exists()) {\n                            newFile = new File(parentDocumentId, displayName + \" (\" + noConflictId++ + \")\");\n                        }\n                        try {\n                            boolean succeeded;\n                            if (Document.MIME_TYPE_DIR.equals(mimeType)) {\n                                succeeded = newFile.mkdir();\n                            } else {\n                                succeeded = newFile.createNewFile();\n                            }\n                            if (!succeeded) {\n                                throw new FileNotFoundException(\"Failed to create document with id \" + newFile.getPath());\n                            }\n                        } catch (IOException e) {\n                            throw new FileNotFoundException(\"Failed to create document with id \" + newFile.getPath());\n                        }\n                        return newFile.getPath();\n                    }\n\n                    @Override\n                    public void deleteDocument(String documentId) throws FileNotFoundException {\n                        File file = getFileForDocId(documentId);\n                        if (!file.delete()) {\n                            throw new FileNotFoundException(\"Failed to delete document with id \" + documentId);\n                        }\n                    }\n\n                    @Override\n                    public String getDocumentType(String documentId) throws FileNotFoundException {\n                        File file = getFileForDocId(documentId);\n                        return getMimeType(file);\n                    }\n\n                    @Override\n                    public Cursor querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {\n                        final MatrixCursor result = new MatrixCursor(projection != null ? projection : DEFAULT_DOCUMENT_PROJECTION);\n                        final File parent = getFileForDocId(rootId);\n\n                        // This example implementation searches file names for the query and doesn't rank search\n                        // results, so we can stop as soon as we find a sufficient number of matches.  Other\n                        // implementations might rank results and use other data about files, rather than the file\n                        // name, to produce a match.\n                        final LinkedList<File> pending = new LinkedList<>();\n                        pending.add(parent);\n\n                        final int MAX_SEARCH_RESULTS = 50;\n                        while (!pending.isEmpty() && result.getCount() < MAX_SEARCH_RESULTS) {\n                            final File file = pending.removeFirst();\n                            // Avoid directories outside the HOME directory linked with symlinks (to avoid e.g. search\n                            // through the whole SD card).\n                            boolean isInsideHome;\n                            try {\n                                isInsideHome = file.getCanonicalPath().startsWith(TermuxConstants.TERMUX_HOME_DIR_PATH);\n                            } catch (IOException e) {\n                                isInsideHome = true;\n                            }\n                            if (isInsideHome) {\n                                if (file.isDirectory()) {\n                                    Collections.addAll(pending, file.listFiles());\n                                } else {\n                                    if (file.getName().toLowerCase().contains(query)) {\n                                        includeFile(result, null, file);\n                                    }\n                                }\n                            }\n                        }\n\n                        return result;\n                    }\n\n                    @Override\n                    public boolean isChildDocument(String parentDocumentId, String documentId) {\n                        return documentId.startsWith(parentDocumentId);\n                    }\n\n                    /**\n                     * Get the document id given a file. This document id must be consistent across time as other\n                     * applications may save the ID and use it to reference documents later.\n                     * <p/>\n                     * The reverse of @{link #getFileForDocId}.\n                     */\n                    private static String getDocIdForFile(File file) {\n                        return file.getAbsolutePath();\n                    }\n\n                    /**\n                     * Get the file given a document id (the reverse of {@link #getDocIdForFile(File)}).\n                     */\n                    private static File getFileForDocId(String docId) throws FileNotFoundException {\n                        final File f = new File(docId);\n                        if (!f.exists()) throw new FileNotFoundException(f.getAbsolutePath() + \" not found\");\n                        return f;\n                    }\n\n                    private static String getMimeType(File file) {\n                        if (file.isDirectory()) {\n                            return Document.MIME_TYPE_DIR;\n                        } else {\n                            final String name = file.getName();\n                            final int lastDot = name.lastIndexOf('.');\n                            if (lastDot >= 0) {\n                                final String extension = name.substring(lastDot + 1).toLowerCase();\n                                final String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);\n                                if (mime != null) return mime;\n                            }\n                            return \"application/octet-stream\";\n                        }\n                    }\n\n                    /**\n                     * Add a representation of a file to a cursor.\n                     *\n                     * @param result the cursor to modify\n                     * @param docId  the document ID representing the desired file (may be null if given file)\n                     * @param file   the File object representing the desired file (may be null if given docID)\n                     */\n                    private void includeFile(MatrixCursor result, String docId, File file)\n                        throws FileNotFoundException {\n                        if (docId == null) {\n                            docId = getDocIdForFile(file);\n                        } else {\n                            file = getFileForDocId(docId);\n                        }\n\n                        int flags = 0;\n                        if (file.isDirectory()) {\n                            if (file.canWrite()) flags |= Document.FLAG_DIR_SUPPORTS_CREATE;\n                        } else if (file.canWrite()) {\n                            flags |= Document.FLAG_SUPPORTS_WRITE;\n                        }\n                        if (file.getParentFile().canWrite()) flags |= Document.FLAG_SUPPORTS_DELETE;\n\n                        final String displayName = file.getName();\n                        final String mimeType = getMimeType(file);\n                        if (mimeType.startsWith(\"image/\")) flags |= Document.FLAG_SUPPORTS_THUMBNAIL;\n\n                        final MatrixCursor.RowBuilder row = result.newRow();\n                        row.add(Document.COLUMN_DOCUMENT_ID, docId);\n                        row.add(Document.COLUMN_DISPLAY_NAME, displayName);\n                        row.add(Document.COLUMN_SIZE, file.length());\n                        row.add(Document.COLUMN_MIME_TYPE, mimeType);\n                        row.add(Document.COLUMN_LAST_MODIFIED, file.lastModified());\n                        row.add(Document.COLUMN_FLAGS, flags);\n                        row.add(Document.COLUMN_ICON, R.mipmap.ic_launcher);\n                    }\n\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void commons-io if test (@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n\n            public class Hello {\n                public static void copyDirectory(final File srcDir, final File destDir, final FileFilter fileFilter, final boolean preserveFileDate,\n                    final CopyOption... copyOptions) throws IOException {\n                    requireFileCopy(srcDir, destDir);\n                    requireDirectory(srcDir, \"srcDir\");\n                    requireCanonicalPathsNotEquals(srcDir, destDir);\n\n                    // Cater for destination being directory within the source directory (see IO-141)\n                    List<String> exclusionList = null;\n                    final String srcDirCanonicalPath = srcDir.getCanonicalPath();\n                    final String destDirCanonicalPath = destDir.getCanonicalPath();\n                    if (destDirCanonicalPath.startsWith(srcDirCanonicalPath)) {\n                        final File[] srcFiles = listFiles(srcDir, fileFilter);\n                        if (srcFiles.length > 0) {\n                            exclusionList = new ArrayList<>(srcFiles.length);\n                            for (final File srcFile : srcFiles) {\n                                final File copiedFile = new File(destDir, srcFile.getName());\n                                exclusionList.add(copiedFile.getCanonicalPath());\n                            }\n                        }\n                    }\n                    doCopyDirectory(srcDir, destDir, fileFilter, exclusionList, preserveFileDate, preserveFileDate ? addCopyAttributes(copyOptions) : copyOptions);\n                }\n            }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void commons-io (@NotNull DataflowInsanityTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)new StringBuilder(164823).append("\n                /*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\npackage org.apache.commons.io;\n\nimport java.io.BufferedInputStream;\nimport java.io.BufferedOutputStream;\nimport java.io.File;\nimport java.io.FileFilter;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.io.OutputStream;\nimport java.io.Reader;\nimport java.io.UncheckedIOException;\nimport java.math.BigInteger;\nimport java.net.URL;\nimport java.nio.ByteBuffer;\nimport java.nio.charset.Charset;\nimport java.nio.charset.StandardCharsets;\nimport java.nio.charset.UnsupportedCharsetException;\nimport java.nio.file.CopyOption;\nimport java.nio.file.FileVisitOption;\nimport java.nio.file.FileVisitResult;\nimport java.nio.file.Files;\nimport java.nio.file.LinkOption;\nimport java.nio.file.NotDirectoryException;\nimport java.nio.file.Path;\nimport java.nio.file.StandardCopyOption;\nimport java.nio.file.attribute.FileTime;\nimport java.time.Duration;\nimport java.time.Instant;\nimport java.time.LocalTime;\nimport java.time.OffsetDateTime;\nimport java.time.OffsetTime;\nimport java.time.ZoneId;\nimport java.time.chrono.ChronoLocalDate;\nimport java.time.chrono.ChronoLocalDateTime;\nimport java.time.chrono.ChronoZonedDateTime;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.Collections;\nimport java.util.Date;\nimport java.util.HashSet;\nimport java.util.Iterator;\nimport java.util.List;\nimport java.util.Objects;\nimport java.util.Set;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport java.util.zip.CRC32;\nimport java.util.zip.CheckedInputStream;\nimport java.util.zip.Checksum;\n\nimport org.apache.commons.io.file.AccumulatorPathVisitor;\nimport org.apache.commons.io.file.Counters;\nimport org.apache.commons.io.file.PathFilter;\nimport org.apache.commons.io.file.PathUtils;\nimport org.apache.commons.io.file.StandardDeleteOption;\nimport org.apache.commons.io.filefilter.FileEqualsFileFilter;\nimport org.apache.commons.io.filefilter.FileFileFilter;\nimport org.apache.commons.io.filefilter.IOFileFilter;\nimport org.apache.commons.io.filefilter.SuffixFileFilter;\nimport org.apache.commons.io.filefilter.TrueFileFilter;\nimport org.apache.commons.io.function.IOConsumer;\n\n/**\n * General file manipulation utilities.\n * <p>\n * Facilities are provided in the following areas:\n * </p>\n * <ul>\n * <li>writing to a file\n * <li>reading from a file\n * <li>make a directory including parent directories\n * <li>copying files and directories\n * <li>deleting files and directories\n * <li>converting to and from a URL\n * <li>listing files and directories by filter and extension\n * <li>comparing file content\n * <li>file last changed date\n * <li>calculating a checksum\n * </ul>\n * <p>\n * Note that a specific charset should be specified whenever possible. Relying on the platform default means that the\n * code is Locale-dependent. Only use the default if the files are known to always use the platform default.\n * </p>\n * <p>\n * {@link SecurityException} are not documented in the Javadoc.\n * </p>\n * <p>\n * Origin of code: Excalibur, Alexandria, Commons-Utils\n * </p>\n */\npublic class FileUtils {\n    /**\n     * The number of bytes in a kilobyte.\n     */\n    public static final long ONE_KB = 1024;\n\n    /**\n     * The number of bytes in a kilobyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(ONE_KB);\n\n    /**\n     * The number of bytes in a megabyte.\n     */\n    public static final long ONE_MB = ONE_KB * ONE_KB;\n\n    /**\n     * The number of bytes in a megabyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);\n\n    /**\n     * The number of bytes in a gigabyte.\n     */\n    public static final long ONE_GB = ONE_KB * ONE_MB;\n\n    /**\n     * The number of bytes in a gigabyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);\n\n    /**\n     * The number of bytes in a terabyte.\n     */\n    public static final long ONE_TB = ONE_KB * ONE_GB;\n\n    /**\n     * The number of bytes in a terabyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);\n\n    /**\n     * The number of bytes in a petabyte.\n     */\n    public static final long ONE_PB = ONE_KB * ONE_TB;\n\n    /**\n     * The number of bytes in a petabyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);\n\n    /**\n     * The number of bytes in an exabyte.\n     */\n    public static final long ONE_EB = ONE_KB * ONE_PB;\n\n    /**\n     * The number of bytes in an exabyte.\n     *\n     * @since 2.4\n     */\n    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);\n\n    /**\n     * The number of bytes in a zettabyte.\n     */\n    public static final BigInteger ONE_ZB = BigInteger.valueOf(ONE_KB).multiply(BigInteger.valueOf(ONE_EB));\n\n    /**\n     * The number of bytes in a yottabyte.\n     */\n    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);\n\n    /**\n     * An empty array of type {@link File}.\n     */\n    public static final File[] EMPTY_FILE_ARRAY = {};\n\n    /**\n     * Copies the given array and adds StandardCopyOption.COPY_ATTRIBUTES.\n     *\n     * @param copyOptions sorted copy options.\n     * @return a new array.\n     */\n    private static CopyOption[] addCopyAttributes(final CopyOption... copyOptions) {\n        // Make a copy first since we don't want to sort the call site's version.\n        final CopyOption[] actual = Arrays.copyOf(copyOptions, copyOptions.length + 1);\n        Arrays.sort(actual, 0, copyOptions.length);\n        if (Arrays.binarySearch(copyOptions, 0, copyOptions.length, StandardCopyOption.COPY_ATTRIBUTES) >= 0) {\n            return copyOptions;\n        }\n        actual[actual.length - 1] = StandardCopyOption.COPY_ATTRIBUTES;\n        return actual;\n    }\n\n    /**\n     * Returns a human-readable version of the file size, where the input represents a specific number of bytes.\n     * <p>\n     * If the size is over 1GB, the size is returned as the number of whole GB, i.e. the size is rounded down to the\n     * nearest GB boundary.\n     * </p>\n     * <p>\n     * Similarly for the 1MB and 1KB boundaries.\n     * </p>\n     *\n     * @param size the number of bytes\n     * @return a human-readable display value (includes units - EB, PB, TB, GB, MB, KB or bytes)\n     * @throws NullPointerException if the given {@link BigInteger} is {@code null}.\n     * @see <a href=\"https://issues.apache.org/jira/browse/IO-226\">IO-226 - should the rounding be changed?</a>\n     * @since 2.4\n     */\n    // See https://issues.apache.org/jira/browse/IO-226 - should the rounding be changed?\n    public static String byteCountToDisplaySize(final BigInteger size) {\n        Objects.requireNonNull(size, \"size\");\n        final String displaySize;\n\n        if (size.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_EB_BI) + \" EB\";\n        } else if (size.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_PB_BI) + \" PB\";\n        } else if (size.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_TB_BI) + \" TB\";\n        } else if (size.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_GB_BI) + \" GB\";\n        } else if (size.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_MB_BI) + \" MB\";\n        } else if (size.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0) {\n            displaySize = size.divide(ONE_KB_BI) + \" KB\";\n        } else {\n            displaySize = size + \" bytes\";\n        }\n        return displaySize;\n    }\n\n    /**\n     * Returns a human-readable version of the file size, where the input represents a specific number of bytes.\n     * <p>\n     * If the size is over 1GB, the size is returned as the number of whole GB, i.e. the size is rounded down to the\n     * nearest GB boundary.\n     * </p>\n     * <p>\n     * Similarly for the 1MB and 1KB boundaries.\n     * </p>\n     *\n     * @param size the number of bytes\n     * @return a human-readable display value (includes units - EB, PB, TB, GB, MB, KB or bytes)\n     * @see <a href=\"https://issues.apache.org/jira/browse/IO-226\">IO-226 - should the rounding be changed?</a>\n     */\n    // See https://issues.apache.org/jira/browse/IO-226 - should the rounding be changed?\n    public static String byteCountToDisplaySize(final long size) {\n        return byteCountToDisplaySize(BigInteger.valueOf(size));\n    }\n\n    /**\n     * Returns a human-readable version of the file size, where the input represents a specific number of bytes.\n     * <p>\n     * If the size is over 1GB, the size is returned as the number of whole GB, i.e. the size is rounded down to the\n     * nearest GB boundary.\n     * </p>\n     * <p>\n     * Similarly for the 1MB and 1KB boundaries.\n     * </p>\n     *\n     * @param size the number of bytes\n     * @return a human-readable display value (includes units - EB, PB, TB, GB, MB, KB or bytes)\n     * @see <a href=\"https://issues.apache.org/jira/browse/IO-226\">IO-226 - should the rounding be changed?</a>\n     * @since 2.12.0\n     */\n    // See https://issues.apache.org/jira/browse/IO-226 - should the rounding be changed?\n    public static String byteCountToDisplaySize(final Number size) {\n        return byteCountToDisplaySize(size.longValue());\n    }\n\n    /**\n     * Computes the checksum of a file using the specified checksum object. Multiple files may be checked using one\n     * {@link Checksum} instance if desired simply by reusing the same checksum object. For example:\n     *\n     * <pre>\n     * long checksum = FileUtils.checksum(file, new CRC32()).getValue();\n     * </pre>\n     *\n     * @param file the file to checksum, must not be {@code null}\n     * @param checksum the checksum object to be used, must not be {@code null}\n     * @return the checksum specified, updated with the content of the file\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws NullPointerException if the given {@link Checksum} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a file.\n     * @throws IOException if an IO error occurs reading the file.\n     * @since 1.3\n     */\n    public static Checksum checksum(final File file, final Checksum checksum) throws IOException {\n        requireExistsChecked(file, \"file\");\n        requireFile(file, \"file\");\n        Objects.requireNonNull(checksum, \"checksum\");\n        try (InputStream inputStream = new CheckedInputStream(Files.newInputStream(file.toPath()), checksum)) {\n            IOUtils.consume(inputStream);\n        }\n        return checksum;\n    }\n\n    /**\n     * Computes the checksum of a file using the CRC32 checksum routine.\n     * The value of the checksum is returned.\n     *\n     * @param file the file to checksum, must not be {@code null}\n     * @return the checksum value\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a file.\n     * @throws IOException              if an IO error occurs reading the file.\n     * @since 1.3\n     */\n    public static long checksumCRC32(final File file) throws IOException {\n        return checksum(file, new CRC32()).getValue();\n    }\n\n    /**\n     * Cleans a directory without deleting it.\n     *\n     * @param directory directory to clean\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if directory does not exist or is not a directory.\n     * @throws IOException if an I/O error occurs.\n     * @see #forceDelete(File)\n     */\n    public static void cleanDirectory(final File directory) throws IOException {\n        IOConsumer.forEach(listFiles(directory, null), FileUtils::forceDelete);\n    }\n\n    /**\n     * Cleans a directory without deleting it.\n     *\n     * @param directory directory to clean, must not be {@code null}\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if directory does not exist or is not a directory.\n     * @throws IOException if an I/O error occurs.\n     * @see #forceDeleteOnExit(File)\n     */\n    private static void cleanDirectoryOnExit(final File directory) throws IOException {\n        IOConsumer.forEach(listFiles(directory, null), FileUtils::forceDeleteOnExit);\n    }\n\n    /**\n     * Tests whether the contents of two files are equal.\n     * <p>\n     * This method checks to see if the two files are different lengths or if they point to the same file, before\n     * resorting to byte-by-byte comparison of the contents.\n     * </p>\n     * <p>\n     * Code origin: Avalon\n     * </p>\n     *\n     * @param file1 the first file\n     * @param file2 the second file\n     * @return true if the content of the files are equal or they both don't exist, false otherwise\n     * @throws IllegalArgumentException when an input is not a file.\n     * @throws IOException If an I/O error occurs.\n     * @see org.apache.commons.io.file.PathUtils#fileContentEquals(Path,Path,java.nio.file.LinkOption[],java.nio.file.OpenOption...)\n     */\n    public static boolean contentEquals(final File file1, final File file2) throws IOException {\n        if (file1 == null && file2 == null) {\n            return true;\n        }\n        if (file1 == null || file2 == null) {\n            return false;\n        }\n        final boolean file1Exists = file1.exists();\n        if (file1Exists != file2.exists()) {\n            return false;\n        }\n\n        if (!file1Exists) {\n            // two not existing files are equal\n            return true;\n        }\n\n        requireFile(file1, \"file1\");\n        requireFile(file2, \"file2\");\n\n        if (file1.length() != file2.length()) {\n            // lengths differ, cannot be equal\n            return false;\n        }\n\n        if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {\n            // same file\n            return true;\n        }\n\n        try (InputStream input1 = Files.newInputStream(file1.toPath()); InputStream input2 = Files.newInputStream(file2.toPath())) {\n            return IOUtils.contentEquals(input1, input2);\n        }\n    }\n\n    /**\n     * Compares the contents of two files to determine if they are equal or not.\n     * <p>\n     * This method checks to see if the two files point to the same file,\n     * before resorting to line-by-line comparison of the contents.\n     * </p>\n     *\n     * @param file1       the first file\n     * @param file2       the second file\n     * @param charsetName the name of the requested charset.\n     *                    May be null, in which case the platform default is used\n     * @return true if the content of the files are equal or neither exists,\n     * false otherwise\n     * @throws IllegalArgumentException when an input is not a file.\n     * @throws IOException in case of an I/O error.\n     * @throws UnsupportedCharsetException If the named charset is unavailable (unchecked exception).\n     * @see IOUtils#contentEqualsIgnoreEOL(Reader, Reader)\n     * @since 2.2\n     */\n    public static boolean contentEqualsIgnoreEOL(final File file1, final File file2, final String charsetName)\n            throws IOException {\n        if (file1 == null && file2 == null) {\n            return true;\n        }\n        if (file1 == null || file2 == null) {\n            return false;\n        }\n        final boolean file1Exists = file1.exists();\n        if (file1Exists != file2.exists()) {\n            return false;\n        }\n\n        if (!file1Exists) {\n            // two not existing files are equal\n            return true;\n        }\n\n        requireFile(file1, \"file1\");\n        requireFile(file2, \"file2\");\n\n        if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {\n            // same file\n            return true;\n        }\n\n        final Charset charset = Charsets.toCharset(charsetName);\n        try (Reader input1 = new InputStreamReader(Files.newInputStream(file1.toPath()), charset);\n             Reader input2 = new InputStreamReader(Files.newInputStream(file2.toPath()), charset)) {\n            return IOUtils.contentEqualsIgnoreEOL(input1, input2);\n        }\n    }\n\n    /**\n     * Converts a Collection containing java.io.File instances into array\n     * representation. This is to account for the difference between\n     * File.listFiles() and FileUtils.listFiles().\n     *\n     * @param files a Collection containing java.io.File instances\n     * @return an array of java.io.File\n     */\n    public static File[] convertFileCollectionToFileArray(final Collection<File> files) {\n        return files.toArray(EMPTY_FILE_ARRAY);\n    }\n\n    /**\n     * Copies a whole directory to a new location preserving the file dates.\n     * <p>\n     * This method copies the specified directory and all its child directories and files to the specified destination.\n     * The destination is the new location and name of the directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the files' last modified date/times using\n     * {@link File#setLastModified(long)}, however it is not guaranteed that those operations will succeed. If the\n     * modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcDir an existing directory to copy, must not be {@code null}.\n     * @param destDir the new directory, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.1\n     */\n    public static void copyDirectory(final File srcDir, final File destDir) throws IOException {\n        copyDirectory(srcDir, destDir, true);\n    }\n\n    /**\n     * Copies a whole directory to a new location.\n     * <p>\n     * This method copies the contents of the specified source directory to within the specified destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the files' last\n     * modified date/times using {@link File#setLastModified(long)}, however it is not guaranteed that those operations\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcDir an existing directory to copy, must not be {@code null}.\n     * @param destDir the new directory, must not be {@code null}.\n     * @param preserveFileDate true if the file date of the copy should be the same as the original.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.1\n     */\n    public static void copyDirectory(final File srcDir, final File destDir, final boolean preserveFileDate)\n        throws IOException {\n        copyDirectory(srcDir, destDir, null, preserveFileDate);\n    }\n\n    /**\n     * Copies a filtered directory to a new location preserving the file dates.\n     * <p>\n     * This method copies the contents of the specified source directory to within the specified destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the files' last modified date/times using\n     * {@link File#setLastModified(long)}, however it is not guaranteed that those operations will succeed. If the\n     * modification operation fails, the methods throws IOException.\n     * </p>\n     * <b>Example: Copy directories only</b>\n     *\n     * <pre>\n     * // only copy the directory structure\n     * FileUtils.copyDirectory(srcDir, destDir, DirectoryFileFilter.DIRECTORY);\n     * </pre>\n     *\n     * <b>Example: Copy directories and txt files</b>\n     *\n     * <pre>\n     * // Create a filter for \".txt\" files\n     * IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter(\".txt\");\n     * IOFileFilter txtFiles = FileFilterUtils.andFileFilter(FileFileFilter.FILE, txtSuffixFilter);\n     *\n     * // Create a filter for either directories or \".txt\" files\n     * FileFilter filter = FileFilterUtils.orFileFilter(DirectoryFileFilter.DIRECTORY, txtFiles);\n     *\n     * // Copy using the filter\n     * FileUtils.copyDirectory(srcDir, destDir, filter);\n     * </pre>\n     *\n     * @param srcDir an existing directory to copy, must not be {@code null}.\n     * @param destDir the new directory, must not be {@code null}.\n     * @param filter the filter to apply, null means copy all directories and files should be the same as the original.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void copyDirectory(final File srcDir, final File destDir, final FileFilter filter)\n        throws IOException {\n        copyDirectory(srcDir, destDir, filter, true);\n    }\n\n    /**\n     * Copies a filtered directory to a new location.\n     * <p>\n     * This method copies the contents of the specified source directory to within the specified destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the files' last\n     * modified date/times using {@link File#setLastModified(long)}, however it is not guaranteed that those operations\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     * <b>Example: Copy directories only</b>\n     *\n     * <pre>\n     * // only copy the directory structure\n     * FileUtils.copyDirectory(srcDir, destDir, DirectoryFileFilter.DIRECTORY, false);\n     * </pre>\n     *\n     * <b>Example: Copy directories and txt files</b>\n     *\n     * <pre>\n     * // Create a filter for \".txt\" files\n     * IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter(\".txt\");\n     * IOFileFilter txtFiles = FileFilterUtils.andFileFilter(FileFileFilter.FILE, txtSuffixFilter);\n     *\n     * // Create a filter for either directories or \".txt\" files\n     * FileFilter filter = FileFilterUtils.orFileFilter(DirectoryFileFilter.DIRECTORY, txtFiles);\n     *\n     * // Copy using the filter\n     * FileUtils.copyDirectory(srcDir, destDir, filter, false);\n     * </pre>\n     *\n     * @param srcDir an existing directory to copy, must not be {@code null}.\n     * @param destDir the new directory, must not be {@code null}.\n     * @param filter the filter to apply, null means copy all directories and files.\n     * @param preserveFileDate true if the file date of the copy should be the same as the original.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void copyDirectory(final File srcDir, final File destDir, final FileFilter filter, final boolean preserveFileDate) throws IOException {\n        copyDirectory(srcDir, destDir, filter, preserveFileDate, StandardCopyOption.REPLACE_EXISTING);\n    }\n\n    /**\n     * Copies a filtered directory to a new location.\n     * <p>\n     * This method copies the contents of the specified source directory to within the specified destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the files' last\n     * modified date/times using {@link File#setLastModified(long)}, however it is not guaranteed that those operations\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     * <b>Example: Copy directories only</b>\n     *\n     * <pre>\n     * // only copy the directory structure\n     * FileUtils.copyDirectory(srcDir, destDir, DirectoryFileFilter.DIRECTORY, false);\n     * </pre>\n     *\n     * <b>Example: Copy directories and txt files</b>\n     *\n     * <pre>\n     * // Create a filter for \".txt\" files\n     * IOFileFilter txtSuffixFilter = FileFilterUtils.suffixFileFilter(\".txt\");\n     * IOFileFilter txtFiles = FileFilterUtils.andFileFilter(FileFileFilter.FILE, txtSuffixFilter);\n     *\n     * // Create a filter for either directories or \".txt\" files\n     * FileFilter filter = FileFilterUtils.orFileFilter(DirectoryFileFilter.DIRECTORY, txtFiles);\n     *\n     * // Copy using the filter\n     * FileUtils.copyDirectory(srcDir, destDir, filter, false);\n     * </pre>\n     *\n     * @param srcDir an existing directory to copy, must not be {@code null}\n     * @param destDir the new directory, must not be {@code null}\n     * @param fileFilter the filter to apply, null means copy all directories and files\n     * @param preserveFileDate true if the file date of the copy should be the same as the original\n     * @param copyOptions options specifying how the copy should be done, for example {@link StandardCopyOption}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 2.8.0\n     */\n    public static void copyDirectory(final File srcDir, final File destDir, final FileFilter fileFilter, final boolean preserveFileDate,\n        final CopyOption... copyOptions) throws IOException {\n        requireFileCopy(srcDir, destDir);\n        requireDirectory(srcDir, \"srcDir\");\n        requireCanonicalPathsNotEquals(srcDir, destDir);\n\n        // Cater for destination being directory within the source directory (see IO-141)\n        List<String> exclusionList = null;\n        final String srcDirCanonicalPath = srcDir.getCanonicalPath();\n        final String destDirCanonicalPath = destDir.getCanonicalPath();\n        if (destDirCanonicalPath.startsWith(srcDirCanonicalPath)) {\n            final File[] srcFiles = listFiles(srcDir, fileFilter);\n            if (srcFiles.length > 0) {\n                exclusionList = new ArrayList<>(srcFiles.length);\n                for (final File srcFile : srcFiles) {\n                    final File copiedFile = new File(destDir, srcFile.getName());\n                    exclusionList.add(copiedFile.getCanonicalPath());\n                }\n            }\n        }\n        doCopyDirectory(srcDir, destDir, fileFilter, exclusionList, preserveFileDate, preserveFileDate ? addCopyAttributes(copyOptions) : copyOptions);\n    }\n\n    /**\n     * Copies a directory to within another directory preserving the file dates.\n     * <p>\n     * This method copies the source directory and all its contents to a directory of the same name in the specified\n     * destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this\n     * method merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the files' last modified date/times using\n     * {@link File#setLastModified(long)}, however it is not guaranteed that those operations will succeed. If the\n     * modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param sourceDir an existing directory to copy, must not be {@code null}.\n     * @param destinationDir the directory to place the copy in, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.2\n     */\n    public static void copyDirectoryToDirectory(final File sourceDir, final File destinationDir) throws IOException {\n        requireDirectoryIfExists(sourceDir, \"sourceDir\");\n        requireDirectoryIfExists(destinationDir, \"destinationDir\");\n        copyDirectory(sourceDir, new File(destinationDir, sourceDir.getName()), true);\n    }\n\n    /**\n     * Copies a file to a new location preserving the file date.\n     * <p>\n     * This method copies the contents of the specified source file to the specified destination file. The directory\n     * holding the destination file is created if it does not exist. If the destination file exists, then this method\n     * will overwrite it.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the file's last modified date/times using\n     * {@link StandardCopyOption#COPY_ATTRIBUTES}, however it is not guaranteed that the operation will succeed. If the\n     * modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcFile an existing file to copy, must not be {@code null}.\n     * @param destFile the new file, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @throws IOException if the output file length is not the same as the input file length after the copy completes.\n     * @see #copyFileToDirectory(File, File)\n     * @see #copyFile(File, File, boolean)\n     */\n    public static void copyFile(final File srcFile, final File destFile) throws IOException {\n        copyFile(srcFile, destFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);\n    }\n\n    /**\n     * Copies an existing file to a new file location.\n     * <p>\n     * This method copies the contents of the specified source file to the specified destination file. The directory\n     * holding the destination file is created if it does not exist. If the destination file exists, then this method\n     * will overwrite it.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the file's last\n     * modified date/times using {@link StandardCopyOption#COPY_ATTRIBUTES}, however it is not guaranteed that the operation\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcFile an existing file to copy, must not be {@code null}.\n     * @param destFile the new file, must not be {@code null}.\n     * @param preserveFileDate true if the file date of the copy should be the same as the original.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @throws IOException if the output file length is not the same as the input file length after the copy completes\n     * @see #copyFile(File, File, boolean, CopyOption...)\n     */\n    public static void copyFile(final File srcFile, final File destFile, final boolean preserveFileDate) throws IOException {\n        // @formatter:off\n        copyFile(srcFile, destFile, preserveFileDate\n                ? new CopyOption[] {StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING}\n                : new CopyOption[] {StandardCopyOption.REPLACE_EXISTING});\n        // @formatter:on\n    }\n\n    /**\n     * Copies a file to a new location.\n     * <p>\n     * This method copies the contents of the specified source file to the specified destination file. The directory\n     * holding the destination file is created if it does not exist. If the destination file exists, you can overwrite\n     * it with {@link StandardCopyOption#REPLACE_EXISTING}.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the file's last\n     * modified date/times using {@link StandardCopyOption#COPY_ATTRIBUTES}, however it is not guaranteed that the operation\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcFile an existing file to copy, must not be {@code null}.\n     * @param destFile the new file, must not be {@code null}.\n     * @param preserveFileDate true if the file date of the copy should be the same as the original.\n     * @param copyOptions options specifying how the copy should be done, for example {@link StandardCopyOption}..\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IllegalArgumentException if source is not a file.\n     * @throws IOException if the output file length is not the same as the input file length after the copy completes.\n     * @throws IOException if an I/O error occurs, or setting the last-modified time didn't succeeded.\n     * @see #copyFileToDirectory(File, File, boolean)\n     * @since 2.8.0\n     */\n    public static void copyFile(final File srcFile, final File destFile, final boolean preserveFileDate, final CopyOption... copyOptions) throws IOException {\n        copyFile(srcFile, destFile, preserveFileDate ? addCopyAttributes(copyOptions) : copyOptions);\n    }\n\n    /**\n     * Copies a file to a new location.\n     * <p>\n     * This method copies the contents of the specified source file to the specified destination file. The directory\n     * holding the destination file is created if it does not exist. If the destination file exists, you can overwrite\n     * it if you use {@link StandardCopyOption#REPLACE_EXISTING}.\n     * </p>\n     *\n     * @param srcFile an existing file to copy, must not be {@code null}.\n     * @param destFile the new file, must not be {@code null}.\n     * @param copyOptions options specifying how the copy should be done, for example {@link StandardCopyOption}..\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IllegalArgumentException if source is not a file.\n     * @throws IOException if the output file length is not the same as the input file length after the copy completes.\n     * @throws IOException if an I/O error occurs.\n     * @see StandardCopyOption\n     * @since 2.9.0\n     */\n    public static void copyFile(final File srcFile, final File destFile, final CopyOption... copyOptions) throws IOException {\n        requireFileCopy(srcFile, destFile);\n        requireFile(srcFile, \"srcFile\");\n        requireCanonicalPathsNotEquals(srcFile, destFile);\n        createParentDirectories(destFile);\n        requireFileIfExists(destFile, \"destFile\");\n        if (destFile.exists()) {\n            requireCanWrite(destFile, \"destFile\");\n        }\n\n        // On Windows, the last modified time is copied by default.\n        Files.copy(srcFile.toPath(), destFile.toPath(), copyOptions);\n\n        // TODO IO-386: Do we still need this check?\n        requireEqualSizes(srcFile, destFile, srcFile.length(), destFile.length());\n    }\n\n    /**\n     * Copies bytes from a {@link File} to an {@link OutputStream}.\n     * <p>\n     * This method buffers the input internally, so there is no need to use a {@link BufferedInputStream}.\n     * </p>\n     *\n     * @param input  the {@link File} to read.\n     * @param output the {@link OutputStream} to write.\n     * @return the number of bytes copied\n     * @throws NullPointerException if the File is {@code null}.\n     * @throws NullPointerException if the OutputStream is {@code null}.\n     * @throws IOException          if an I/O error occurs.\n     * @since 2.1\n     */\n    public static long copyFile(final File input, final OutputStream output) throws IOException {\n        try (InputStream fis = Files.newInputStream(input.toPath())) {\n            return IOUtils.copyLarge(fis, output);\n        }\n    }\n\n    /**\n     * Copies a file to a directory preserving the file date.\n     * <p>\n     * This method copies the contents of the specified source file to a file of the same name in the specified\n     * destination directory. The destination directory is created if it does not exist. If the destination file exists,\n     * then this method will overwrite it.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the file's last modified date/times using\n     * {@link StandardCopyOption#COPY_ATTRIBUTES}, however it is not guaranteed that the operation will succeed. If the\n     * modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param srcFile an existing file to copy, must not be {@code null}.\n     * @param destDir the directory to place the copy in, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @see #copyFile(File, File, boolean)\n     */\n    public static void copyFileToDirectory(final File srcFile, final File destDir) throws IOException {\n        copyFileToDirectory(srcFile, destDir, true);\n    }\n\n    /**\n     * Copies a file to a directory optionally preserving the file date.\n     * <p>\n     * This method copies the contents of the specified source file to a file of the same name in the specified\n     * destination directory. The destination directory is created if it does not exist. If the destination file exists,\n     * then this method will overwrite it.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> Setting {@code preserveFileDate} to {@code true} tries to preserve the file's last\n     * modified date/times using {@link StandardCopyOption#COPY_ATTRIBUTES}, however it is not guaranteed that the operation\n     * will succeed. If the modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param sourceFile an existing file to copy, must not be {@code null}.\n     * @param destinationDir the directory to place the copy in, must not be {@code null}.\n     * @param preserveFileDate true if the file date of the copy should be the same as the original.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @throws IOException if the output file length is not the same as the input file length after the copy completes.\n     * @see #copyFile(File, File, CopyOption...)\n     * @since 1.3\n     */\n    public static void copyFileToDirectory(final File sourceFile, final File destinationDir, final boolean preserveFileDate) throws IOException {\n        Objects.requireNonNull(sourceFile, \"sourceFile\");\n        requireDirectoryIfExists(destinationDir, \"destinationDir\");\n        copyFile(sourceFile, new File(destinationDir, sourceFile.getName()), preserveFileDate);\n    }\n\n    /**\n     * Copies bytes from an {@link InputStream} {@code source} to a file\n     * {@code destination}. The directories up to {@code destination}\n     * will be created if they don't already exist. {@code destination}\n     * will be overwritten if it already exists.\n     * <p>\n     * <em>The {@code source} stream is closed.</em>\n     * </p>\n     * <p>\n     * See {@link #copyToFile(InputStream, File)} for a method that does not close the input stream.\n     * </p>\n     *\n     * @param source      the {@link InputStream} to copy bytes from, must not be {@code null}, will be closed\n     * @param destination the non-directory {@link File} to write bytes to\n     *                    (possibly overwriting), must not be {@code null}\n     * @throws IOException if {@code destination} is a directory\n     * @throws IOException if {@code destination} cannot be written\n     * @throws IOException if {@code destination} needs creating but can't be\n     * @throws IOException if an IO error occurs during copying\n     * @since 2.0\n     */\n    public static void copyInputStreamToFile(final InputStream source, final File destination) throws IOException {\n        try (InputStream inputStream = source) {\n            copyToFile(inputStream, destination);\n        }\n    }\n\n    /**\n     * Copies a file or directory to within another directory preserving the file dates.\n     * <p>\n     * This method copies the source file or directory, along all its contents, to a directory of the same name in the\n     * specified destination directory.\n     * </p>\n     * <p>\n     * The destination directory is created if it does not exist. If the destination directory did exist, then this method\n     * merges the source with the destination, with the source taking precedence.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the files' last modified date/times using\n     * {@link StandardCopyOption#COPY_ATTRIBUTES} or {@link File#setLastModified(long)} depending on the input, however it\n     * is not guaranteed that those operations will succeed. If the modification operation fails, the methods throws\n     * IOException.\n     * </p>\n     *\n     * @param sourceFile an existing file or directory to copy, must not be {@code null}.\n     * @param destinationDir the directory to place the copy in, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @see #copyDirectoryToDirectory(File, File)\n     * @see #copyFileToDirectory(File, File)\n     * @since 2.6\n     */\n    public static void copyToDirectory(final File sourceFile, final File destinationDir) throws IOException {\n        Objects.requireNonNull(sourceFile, \"sourceFile\");\n        if (sourceFile.isFile()) {\n            copyFileToDirectory(sourceFile, destinationDir);\n        } else if (sourceFile.isDirectory()) {\n            copyDirectoryToDirectory(sourceFile, destinationDir);\n        } else {\n            throw new FileNotFoundException(\"The source \" + sourceFile + \" does not exist\");\n        }\n    }\n\n    /**\n     * Copies a files to a directory preserving each file's date.\n     * <p>\n     * This method copies the contents of the specified source files\n     * to a file of the same name in the specified destination directory.\n     * The destination directory is created if it does not exist.\n     * If the destination file exists, then this method will overwrite it.\n     * </p>\n     * <p>\n     * <strong>Note:</strong> This method tries to preserve the file's last\n     * modified date/times using {@link File#setLastModified(long)}, however\n     * it is not guaranteed that the operation will succeed.\n     * If the modification operation fails, the methods throws IOException.\n     * </p>\n     *\n     * @param sourceIterable     a existing files to copy, must not be {@code null}.\n     * @param destinationDir  the directory to place the copy in, must not be {@code null}.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @see #copyFileToDirectory(File, File)\n     * @since 2.6\n     */\n    public static void copyToDirectory(final Iterable<File> sourceIterable, final File destinationDir) throws IOException {\n        Objects.requireNonNull(sourceIterable, \"sourceIterable\");\n        for (final File src : sourceIterable) {\n            copyFileToDirectory(src, destinationDir);\n        }\n    }\n\n    /**\n     * Copies bytes from an {@link InputStream} source to a {@link File} destination. The directories\n     * up to {@code destination} will be created if they don't already exist. {@code destination} will be\n     * overwritten if it already exists. The {@code source} stream is left open, e.g. for use with\n     * {@link java.util.zip.ZipInputStream ZipInputStream}. See {@link #copyInputStreamToFile(InputStream, File)} for a\n     * method that closes the input stream.\n     *\n     * @param inputStream the {@link InputStream} to copy bytes from, must not be {@code null}\n     * @param file the non-directory {@link File} to write bytes to (possibly overwriting), must not be\n     *        {@code null}\n     * @throws NullPointerException if the InputStream is {@code null}.\n     * @throws NullPointerException if the File is {@code null}.\n     * @throws IllegalArgumentException if the file object is a directory.\n     * @throws IllegalArgumentException if the file is not writable.\n     * @throws IOException if the directories could not be created.\n     * @throws IOException if an IO error occurs during copying.\n     * @since 2.5\n     */\n    public static void copyToFile(final InputStream inputStream, final File file) throws IOException {\n        try (OutputStream out = newOutputStream(file, false)) {\n            IOUtils.copy(inputStream, out);\n        }\n    }\n\n    /**\n     * Copies bytes from the URL {@code source} to a file\n     * {@code destination}. The directories up to {@code destination}\n     * will be created if they don't already exist. {@code destination}\n     * will be overwritten if it already exists.\n     * <p>\n     * Warning: this method does not set a connection or read timeout and thus\n     * might block forever. Use {@link #copyURLToFile(URL, File, int, int)}\n     * with reasonable timeouts to prevent this.\n     * </p>\n     *\n     * @param source      the {@link URL} to copy bytes from, must not be {@code null}\n     * @param destination the non-directory {@link File} to write bytes to\n     *                    (possibly overwriting), must not be {@code null}\n     * @throws IOException if {@code source} URL cannot be opened\n     * @throws IOException if {@code destination} is a directory\n     * @throws IOException if {@code destination} cannot be written\n     * @throws IOException if {@code destination} needs creating but can't be\n     * @throws IOException if an IO error occurs during copying\n     */\n    public static void copyURLToFile(final URL source, final File destination) throws IOException {\n        try (InputStream stream = source.openStream()) {\n            final Path path = destination.toPath();\n            PathUtils.createParentDirectories(path);\n            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);\n        }\n    }\n\n    /**\n     * Copies bytes from the URL {@code source} to a file {@code destination}. The directories up to\n     * {@code destination} will be created if they don't already exist. {@code destination} will be\n     * overwritten if it already exists.\n     *\n     * @param source the {@link URL} to copy bytes from, must not be {@code null}\n     * @param destination the non-directory {@link File} to write bytes to (possibly overwriting), must not be\n     *        {@code null}\n     * @param connectionTimeoutMillis the number of milliseconds until this method will timeout if no connection could\n     *        be established to the {@code source}\n     * @param readTimeoutMillis the number of milliseconds until this method will timeout if no data could be read from\n     *        the {@code source}\n     * @throws IOException if {@code source} URL cannot be opened\n     * @throws IOException if {@code destination} is a directory\n     * @throws IOException if {@code destination} cannot be written\n     * @throws IOException if {@code destination} needs creating but can't be\n     * @throws IOException if an IO error occurs during copying\n     * @since 2.0\n     */\n    public static void copyURLToFile(final URL source, final File destination, final int connectionTimeoutMillis, final int readTimeoutMillis)\n        throws IOException {\n        try (CloseableURLConnection urlConnection = CloseableURLConnection.open(source)) {\n            urlConnection.setConnectTimeout(connectionTimeoutMillis);\n            urlConnection.setReadTimeout(readTimeoutMillis);\n            try (InputStream stream = urlConnection.getInputStream()) {\n                copyInputStreamToFile(stream, destination);\n            }\n        }\n    }\n\n    /**\n     * Creates all parent directories for a File object.\n     *\n     * @param file the File that may need parents, may be null.\n     * @return The parent directory, or {@code null} if the given file does not name a parent\n     * @throws IOException if the directory was not created along with all its parent directories.\n     * @throws IOException if the given file object is not null and not a directory.\n     * @since 2.9.0\n     */\n    public static File createParentDirectories(final File file) throws IOException {\n        return mkdirs(getParentFile(file));\n    }\n\n    /**\n     * Gets the current directory.\n     *\n     * @return the current directory.\n     * @since 2.12.0\n     */\n    public static File current() {\n        return PathUtils.current().toFile();\n    }\n\n    /**\n     * Decodes the specified URL as per RFC 3986, i.e. transforms\n     * percent-encoded octets to characters by decoding with the UTF-8 character\n     * set. This function is primarily intended for usage with\n     * {@link java.net.URL} which unfortunately does not enforce proper URLs. As\n     * such, this method will leniently accept invalid characters or malformed\n     * percent-encoded octets and simply pass them literally through to the\n     * result string. Except for rare edge cases, this will make unencoded URLs\n     * pass through unaltered.\n     *\n     * @param url The URL to decode, may be {@code null}.\n     * @return The decoded URL or {@code null} if the input was\n     * {@code null}.\n     */\n    static String decodeUrl(final String url) {\n        String decoded = url;\n        if (url != null && url.indexOf('%') >= 0) {\n            final int n = url.length();\n            final StringBuilder builder = new StringBuilder();\n            final ByteBuffer byteBuffer = ByteBuffer.allocate(n);\n            for (int i = 0; i < n; ) {\n                if (url.charAt(i) == '%') {\n                    try {\n                        do {\n                            final byte octet = (byte) Integer.parseInt(url.substring(i + 1, i + 3), 16);\n                            byteBuffer.put(octet);\n                            i += 3;\n                        } while (i < n && url.charAt(i) == '%');\n                        continue;\n                    } catch (final RuntimeException ignored) {\n                        // malformed percent-encoded octet, fall through and\n                        // append characters literally\n                    } finally {\n                        if (byteBuffer.position() > 0) {\n                            byteBuffer.flip();\n                            builder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());\n                            byteBuffer.clear();\n                        }\n                    }\n                }\n                builder.append(url.charAt(i++));\n            }\n            decoded = builder.toString();\n        }\n        return decoded;\n    }\n\n    /**\n     * Deletes the given File but throws an IOException if it cannot, unlike {@link File#delete()} which returns a\n     * boolean.\n     *\n     * @param file The file to delete.\n     * @return the given file.\n     * @throws NullPointerException     if the parameter is {@code null}\n     * @throws IOException              if the file cannot be deleted.\n     * @see File#delete()\n     * @since 2.9.0\n     */\n    public static File delete(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        Files.delete(file.toPath());\n        return file;\n    }\n\n    /**\n     * Deletes a directory recursively.\n     *\n     * @param directory directory to delete\n     * @throws IOException              in case deletion is unsuccessful\n     * @throws NullPointerException     if the parameter is {@code null}\n     * @throws IllegalArgumentException if {@code directory} is not a directory\n     */\n    public static void deleteDirectory(final File directory) throws IOException {\n        Objects.requireNonNull(directory, \"directory\");\n        if (!directory.exists()) {\n            return;\n        }\n        if (!isSymlink(directory)) {\n            cleanDirectory(directory);\n        }\n        delete(directory);\n    }\n\n    /**\n     * Schedules a directory recursively for deletion on JVM exit.\n     *\n     * @param directory directory to delete, must not be {@code null}\n     * @throws NullPointerException if the directory is {@code null}\n     * @throws IOException          in case deletion is unsuccessful\n     */\n    private static void deleteDirectoryOnExit(final File directory) throws IOException {\n        if (!directory.exists()) {\n            return;\n        }\n        directory.deleteOnExit();\n        if (!isSymlink(directory)) {\n            cleanDirectoryOnExit(directory);\n        }\n    }\n\n    /**\n     * Deletes a file, never throwing an exception. If file is a directory, delete it and all sub-directories.\n     * <p>\n     * The difference between File.delete() and this method are:\n     * </p>\n     * <ul>\n     * <li>A directory to be deleted does not have to be empty.</li>\n     * <li>No exceptions are thrown when a file or directory cannot be deleted.</li>\n     * </ul>\n     *\n     * @param file file or directory to delete, can be {@code null}\n     * @return {@code true} if the file or directory was deleted, otherwise\n     * {@code false}\n     *\n     * @since 1.4\n     */\n    public static boolean deleteQuietly(final File file) {\n        if (file == null) {\n            return false;\n        }\n        try {\n            if (file.isDirectory()) {\n                cleanDirectory(file);\n            }\n        } catch (final Exception ignored) {\n            // ignore\n        }\n\n        try {\n            return file.delete();\n        } catch (final Exception ignored) {\n            return false;\n        }\n    }\n\n    /**\n     * Determines whether the {@code parent} directory contains the {@code child} element (a file or directory).\n     * <p>\n     * Files are normalized before comparison.\n     * </p>\n     *\n     * Edge cases:\n     * <ul>\n     * <li>A {@code directory} must not be null: if null, throw IllegalArgumentException</li>\n     * <li>A {@code directory} must be a directory: if not a directory, throw IllegalArgumentException</li>\n     * <li>A directory does not contain itself: return false</li>\n     * <li>A null child file is not contained in any parent: return false</li>\n     * </ul>\n     *\n     * @param directory the file to consider as the parent.\n     * @param child     the file to consider as the child.\n     * @return true is the candidate leaf is under by the specified composite. False otherwise.\n     * @throws IOException              if an IO error occurs while checking the files.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a directory.\n     * @see FilenameUtils#directoryContains(String, String)\n     * @since 2.2\n     */\n    public static boolean directoryContains(final File directory, final File child) throws IOException {\n        requireDirectoryExists(directory, \"directory\");\n\n        if (child == null || !directory.exists() || !child.exists()) {\n            return false;\n        }\n\n        // Canonicalize paths (normalizes relative paths)\n        return FilenameUtils.directoryContains(directory.getCanonicalPath(), child.getCanonicalPath());\n    }\n\n    /**\n     * Internal copy directory method.\n     *\n     * @param srcDir the validated source directory, must not be {@code null}.\n     * @param destDir the validated destination directory, must not be {@code null}.\n     * @param fileFilter the filter to apply, null means copy all directories and files.\n     * @param exclusionList List of files and directories to exclude from the copy, may be null.\n     * @param preserveDirDate preserve the directories last modified dates.\n     * @param copyOptions options specifying how the copy should be done, see {@link StandardCopyOption}.\n     * @throws IOException if the directory was not created along with all its parent directories.\n     * @throws IOException if the given file object is not a directory.\n     */\n    private static void doCopyDirectory(final File srcDir, final File destDir, final FileFilter fileFilter, final List<String> exclusionList,\n        final boolean preserveDirDate, final CopyOption... copyOptions) throws IOException {\n        // recurse dirs, copy files.\n        final File[] srcFiles = listFiles(srcDir, fileFilter);\n        requireDirectoryIfExists(destDir, \"destDir\");\n        mkdirs(destDir);\n        requireCanWrite(destDir, \"destDir\");\n        for (final File srcFile : srcFiles) {\n            final File dstFile = new File(destDir, srcFile.getName());\n            if (exclusionList == null || !exclusionList.contains(srcFile.getCanonicalPath())) {\n                if (srcFile.isDirectory()) {\n                    doCopyDirectory(srcFile, dstFile, fileFilter, exclusionList, preserveDirDate, copyOptions);\n                } else {\n                    copyFile(srcFile, dstFile, copyOptions);\n                }\n            }\n        }\n        // Do this last, as the above has probably affected directory metadata\n        if (preserveDirDate) {\n            setLastModified(srcDir, destDir);\n        }\n    }\n\n    /**\n     * Deletes a file or directory. For a directory, delete it and all sub-directories.\n     * <p>\n     * The difference between File.delete() and this method are:\n     * </p>\n     * <ul>\n     * <li>The directory does not have to be empty.</li>\n     * <li>You get an exception when a file or directory cannot be deleted.</li>\n     * </ul>\n     *\n     * @param file file or directory to delete, must not be {@code null}.\n     * @throws NullPointerException  if the file is {@code null}.\n     * @throws FileNotFoundException if the file was not found.\n     * @throws IOException           in case deletion is unsuccessful.\n     */\n    public static void forceDelete(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        final Counters.PathCounters deleteCounters;\n        try {\n            deleteCounters = PathUtils.delete(file.toPath(), PathUtils.EMPTY_LINK_OPTION_ARRAY,\n                StandardDeleteOption.OVERRIDE_READ_ONLY);\n        } catch (final IOException e) {\n            throw new IOException(\"Cannot delete file: \" + file, e);\n        }\n\n        if (deleteCounters.getFileCounter().get() < 1 && deleteCounters.getDirectoryCounter().get() < 1) {\n            // didn't find a file to delete.\n            throw new FileNotFoundException(\"File does not exist: \" + file);\n        }\n    }\n\n    /**\n     * Schedules a file to be deleted when JVM exits.\n     * If file is directory delete it and all sub-directories.\n     *\n     * @param file file or directory to delete, must not be {@code null}.\n     * @throws NullPointerException if the file is {@code null}.\n     * @throws IOException          in case deletion is unsuccessful.\n     */\n    public static void forceDeleteOnExit(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        if (file.isDirectory()) {\n            deleteDirectoryOnExit(file);\n        } else {\n            file.deleteOnExit();\n        }\n    }\n\n    /**\n     * Makes a directory, including any necessary but nonexistent parent\n     * directories. If a file already exists with specified name but it is\n     * not a directory then an IOException is thrown.\n     * If the directory cannot be created (or the file already exists but is not a directory)\n     * then an IOException is thrown.\n     *\n     * @param directory directory to create, may be {@code null}.\n     * @throws IOException if the directory was not created along with all its parent directories.\n     * @throws IOException if the given file object is not a directory.\n     * @throws SecurityException See {@link File#mkdirs()}.\n     */\n    public static void forceMkdir(final File directory) throws IOException {\n        mkdirs(directory);\n    }\n\n    /**\n     * Makes any necessary but nonexistent parent directories for a given File. If the parent directory cannot be\n     * created then an IOException is thrown.\n     *\n     * @param file file with parent to create, must not be {@code null}.\n     * @throws NullPointerException if the file is {@code null}.\n     * @throws IOException          if the parent directory cannot be created.\n     * @since 2.5\n     */\n    public static void forceMkdirParent(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        forceMkdir(getParentFile(file));\n    }\n\n    /**\n     * Constructs a file from the set of name elements.\n     *\n     * @param directory the parent directory.\n     * @param names the name elements.\n     * @return the new file.\n     * @since 2.1\n     */\n    public static File getFile(final File directory, final String... names) {\n        Objects.requireNonNull(directory, \"directory\");\n        Objects.requireNonNull(names, \"names\");\n        File file = directory;\n        for (final String name : names) {\n            file = new File(file, name);\n        }\n        return file;\n    }\n\n    /**\n     * Constructs a file from the set of name elements.\n     *\n     * @param names the name elements.\n     * @return the file.\n     * @since 2.1\n     */\n    public static File getFile(final String... names) {\n        Objects.requireNonNull(names, \"names\");\n        File file = null;\n        for (final String name : names) {\n            if (file == null) {\n                file = new File(name);\n            } else {\n                file = new File(file, name);\n            }\n        }\n        return file;\n    }\n\n    /**\n     * Gets the parent of the given file. The given file may be bull and a file's parent may as well be null.\n     *\n     * @param file The file to query.\n     * @return The parent file or {@code null}.\n     */\n    private static File getParentFile(final File file) {\n        return file == null ? null : file.getParentFile();\n    }\n\n    /**\n     * Returns a {@link File} representing the system temporary directory.\n     *\n     * @return the system temporary directory.\n ").append("    *\n     * @since 2.0\n     */\n    public static File getTempDirectory() {\n        return new File(getTempDirectoryPath());\n    }\n\n    /**\n     * Returns the path to the system temporary directory.\n     *\n     * @return the path to the system temporary directory.\n     *\n     * @since 2.0\n     */\n    public static String getTempDirectoryPath() {\n        return System.getProperty(\"java.io.tmpdir\");\n    }\n\n    /**\n     * Returns a {@link File} representing the user's home directory.\n     *\n     * @return the user's home directory.\n     *\n     * @since 2.0\n     */\n    public static File getUserDirectory() {\n        return new File(getUserDirectoryPath());\n    }\n\n    /**\n     * Returns the path to the user's home directory.\n     *\n     * @return the path to the user's home directory.\n     *\n     * @since 2.0\n     */\n    public static String getUserDirectoryPath() {\n        return System.getProperty(\"user.home\");\n    }\n\n    /**\n     * Tests whether the specified {@link File} is a directory or not. Implemented as a\n     * null-safe delegate to {@link Files#isDirectory(Path path, LinkOption... options)}.\n     *\n     * @param   file the path to the file.\n     * @param   options options indicating how symbolic links are handled\n     * @return  {@code true} if the file is a directory; {@code false} if\n     *          the path is null, the file does not exist, is not a directory, or it cannot\n     *          be determined if the file is a directory or not.\n     * @throws SecurityException     In the case of the default provider, and a security manager is installed, the\n     *                               {@link SecurityManager#checkRead(String) checkRead} method is invoked to check read\n     *                               access to the directory.\n     * @since 2.9.0\n     */\n    public static boolean isDirectory(final File file, final LinkOption... options) {\n        return file != null && Files.isDirectory(file.toPath(), options);\n    }\n\n    /**\n     * Tests whether the directory is empty.\n     *\n     * @param directory the directory to query.\n     * @return whether the directory is empty.\n     * @throws IOException if an I/O error occurs.\n     * @throws NotDirectoryException if the file could not otherwise be opened because it is not a directory\n     *                               <i>(optional specific exception)</i>.\n     * @since 2.9.0\n     */\n    public static boolean isEmptyDirectory(final File directory) throws IOException {\n        return PathUtils.isEmptyDirectory(directory.toPath());\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoLocalDate}\n     * at the current time.\n     *\n     * <p>Note: The input date is assumed to be in the system default time-zone with the time\n     * part set to the current time. To use a non-default time-zone use the method\n     * {@link #isFileNewer(File, ChronoLocalDateTime, ZoneId)\n     * isFileNewer(file, chronoLocalDate.atTime(LocalTime.now(zoneId)), zoneId)} where\n     * {@code zoneId} is a valid {@link ZoneId}.\n     *\n     * @param file            the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDate the date reference.\n     * @return true if the {@link File} exists and has been modified after the given\n     * {@link ChronoLocalDate} at the current time.\n     * @throws NullPointerException if the file or local date is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoLocalDate chronoLocalDate) {\n        return isFileNewer(file, chronoLocalDate, LocalTime.now());\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoLocalDate}\n     * at the specified time.\n     *\n     * <p>Note: The input date and time are assumed to be in the system default time-zone. To use a\n     * non-default time-zone use the method {@link #isFileNewer(File, ChronoLocalDateTime, ZoneId)\n     * isFileNewer(file, chronoLocalDate.atTime(localTime), zoneId)} where {@code zoneId} is a valid\n     * {@link ZoneId}.\n     *\n     * @param file            the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDate the date reference.\n     * @param localTime       the time reference.\n     * @return true if the {@link File} exists and has been modified after the given\n     * {@link ChronoLocalDate} at the given time.\n     * @throws NullPointerException if the file, local date or zone ID is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoLocalDate chronoLocalDate, final LocalTime localTime) {\n        Objects.requireNonNull(chronoLocalDate, \"chronoLocalDate\");\n        Objects.requireNonNull(localTime, \"localTime\");\n        return isFileNewer(file, chronoLocalDate.atTime(localTime));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoLocalDate} at the specified\n     * {@link OffsetTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared\n     * @param chronoLocalDate the date reference\n     * @param offsetTime the time reference\n     * @return true if the {@link File} exists and has been modified after the given {@link ChronoLocalDate} at the given\n     *         {@link OffsetTime}.\n     * @throws NullPointerException if the file, local date or zone ID is {@code null}\n     * @since 2.12.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoLocalDate chronoLocalDate, final OffsetTime offsetTime) {\n        Objects.requireNonNull(chronoLocalDate, \"chronoLocalDate\");\n        Objects.requireNonNull(offsetTime, \"offsetTime\");\n        return isFileNewer(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoLocalDateTime}\n     * at the system-default time zone.\n     *\n     * <p>Note: The input date and time is assumed to be in the system default time-zone. To use a\n     * non-default time-zone use the method {@link #isFileNewer(File, ChronoLocalDateTime, ZoneId)\n     * isFileNewer(file, chronoLocalDateTime, zoneId)} where {@code zoneId} is a valid\n     * {@link ZoneId}.\n     *\n     * @param file                the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDateTime the date reference.\n     * @return true if the {@link File} exists and has been modified after the given\n     * {@link ChronoLocalDateTime} at the system-default time zone.\n     * @throws NullPointerException if the file or local date time is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoLocalDateTime<?> chronoLocalDateTime) {\n        return isFileNewer(file, chronoLocalDateTime, ZoneId.systemDefault());\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoLocalDateTime}\n     * at the specified {@link ZoneId}.\n     *\n     * @param file                the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDateTime the date reference.\n     * @param zoneId              the time zone.\n     * @return true if the {@link File} exists and has been modified after the given\n     * {@link ChronoLocalDateTime} at the given {@link ZoneId}.\n     * @throws NullPointerException if the file, local date time or zone ID is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoLocalDateTime<?> chronoLocalDateTime, final ZoneId zoneId) {\n        Objects.requireNonNull(chronoLocalDateTime, \"chronoLocalDateTime\");\n        Objects.requireNonNull(zoneId, \"zoneId\");\n        return isFileNewer(file, chronoLocalDateTime.atZone(zoneId));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link ChronoZonedDateTime}.\n     *\n     * @param file                the {@link File} of which the modification date must be compared.\n     * @param chronoZonedDateTime the date reference.\n     * @return true if the {@link File} exists and has been modified after the given\n     * {@link ChronoZonedDateTime}.\n     * @throws NullPointerException if the file or zoned date time is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final ChronoZonedDateTime<?> chronoZonedDateTime) {\n        Objects.requireNonNull(file, \"file\");\n        Objects.requireNonNull(chronoZonedDateTime, \"chronoZonedDateTime\");\n        return UncheckedIO.get(() -> PathUtils.isNewer(file.toPath(), chronoZonedDateTime));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link Date}.\n     *\n     * @param file the {@link File} of which the modification date must be compared.\n     * @param date the date reference.\n     * @return true if the {@link File} exists and has been modified\n     * after the given {@link Date}.\n     * @throws NullPointerException if the file or date is {@code null}.\n     */\n    public static boolean isFileNewer(final File file, final Date date) {\n        Objects.requireNonNull(date, \"date\");\n        return isFileNewer(file, date.getTime());\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the reference {@link File}.\n     *\n     * @param file      the {@link File} of which the modification date must be compared.\n     * @param reference the {@link File} of which the modification date is used.\n     * @return true if the {@link File} exists and has been modified more\n     * recently than the reference {@link File}.\n     * @throws NullPointerException if the file or reference file is {@code null}.\n     * @throws IllegalArgumentException if the reference file doesn't exist.\n     */\n    public static boolean isFileNewer(final File file, final File reference) {\n        requireExists(reference, \"reference\");\n        return UncheckedIO.get(() -> PathUtils.isNewer(file.toPath(), reference.toPath()));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link FileTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared.\n     * @param fileTime the file time reference.\n     * @return true if the {@link File} exists and has been modified after the given {@link FileTime}.\n     * @throws IOException if an I/O error occurs.\n     * @throws NullPointerException if the file or local date is {@code null}.\n     * @since 2.12.0\n     */\n    public static boolean isFileNewer(final File file, final FileTime fileTime) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        return PathUtils.isNewer(file.toPath(), fileTime);\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link Instant}.\n     *\n     * @param file the {@link File} of which the modification date must be compared.\n     * @param instant the date reference.\n     * @return true if the {@link File} exists and has been modified after the given {@link Instant}.\n     * @throws NullPointerException if the file or instant is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileNewer(final File file, final Instant instant) {\n        Objects.requireNonNull(instant, \"instant\");\n        return UncheckedIO.get(() -> PathUtils.isNewer(file.toPath(), instant));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified time reference.\n     *\n     * @param file       the {@link File} of which the modification date must be compared.\n     * @param timeMillis the time reference measured in milliseconds since the\n     *                   epoch (00:00:00 GMT, January 1, 1970).\n     * @return true if the {@link File} exists and has been modified after the given time reference.\n     * @throws NullPointerException if the file is {@code null}.\n     */\n    public static boolean isFileNewer(final File file, final long timeMillis) {\n        Objects.requireNonNull(file, \"file\");\n        return UncheckedIO.get(() -> PathUtils.isNewer(file.toPath(), timeMillis));\n    }\n\n    /**\n     * Tests if the specified {@link File} is newer than the specified {@link OffsetDateTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared\n     * @param offsetDateTime the date reference\n     * @return true if the {@link File} exists and has been modified before the given {@link OffsetDateTime}.\n     * @throws NullPointerException if the file or zoned date time is {@code null}\n     * @since 2.12.0\n     */\n    public static boolean isFileNewer(final File file, final OffsetDateTime offsetDateTime) {\n        Objects.requireNonNull(offsetDateTime, \"offsetDateTime\");\n        return isFileNewer(file, offsetDateTime.toInstant());\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoLocalDate}\n     * at the current time.\n     *\n     * <p>Note: The input date is assumed to be in the system default time-zone with the time\n     * part set to the current time. To use a non-default time-zone use the method\n     * {@link #isFileOlder(File, ChronoLocalDateTime, ZoneId)\n     * isFileOlder(file, chronoLocalDate.atTime(LocalTime.now(zoneId)), zoneId)} where\n     * {@code zoneId} is a valid {@link ZoneId}.\n     *\n     * @param file            the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDate the date reference.\n     * @return true if the {@link File} exists and has been modified before the given\n     * {@link ChronoLocalDate} at the current time.\n     * @throws NullPointerException if the file or local date is {@code null}.\n     * @see ZoneId#systemDefault()\n     * @see LocalTime#now()\n     *\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoLocalDate chronoLocalDate) {\n        return isFileOlder(file, chronoLocalDate, LocalTime.now());\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoLocalDate}\n     * at the specified {@link LocalTime}.\n     *\n     * <p>Note: The input date and time are assumed to be in the system default time-zone. To use a\n     * non-default time-zone use the method {@link #isFileOlder(File, ChronoLocalDateTime, ZoneId)\n     * isFileOlder(file, chronoLocalDate.atTime(localTime), zoneId)} where {@code zoneId} is a valid\n     * {@link ZoneId}.\n     *\n     * @param file            the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDate the date reference.\n     * @param localTime       the time reference.\n     * @return true if the {@link File} exists and has been modified before the\n     * given {@link ChronoLocalDate} at the specified time.\n     * @throws NullPointerException if the file, local date or local time is {@code null}.\n     * @see ZoneId#systemDefault()\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoLocalDate chronoLocalDate, final LocalTime localTime) {\n        Objects.requireNonNull(chronoLocalDate, \"chronoLocalDate\");\n        Objects.requireNonNull(localTime, \"localTime\");\n        return isFileOlder(file, chronoLocalDate.atTime(localTime));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoLocalDate} at the specified\n     * {@link OffsetTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared\n     * @param chronoLocalDate the date reference\n     * @param offsetTime the time reference\n     * @return true if the {@link File} exists and has been modified after the given {@link ChronoLocalDate} at the given\n     *         {@link OffsetTime}.\n     * @throws NullPointerException if the file, local date or zone ID is {@code null}\n     * @since 2.12.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoLocalDate chronoLocalDate, final OffsetTime offsetTime) {\n        Objects.requireNonNull(chronoLocalDate, \"chronoLocalDate\");\n        Objects.requireNonNull(offsetTime, \"offsetTime\");\n        return isFileOlder(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoLocalDateTime}\n     * at the system-default time zone.\n     *\n     * <p>Note: The input date and time is assumed to be in the system default time-zone. To use a\n     * non-default time-zone use the method {@link #isFileOlder(File, ChronoLocalDateTime, ZoneId)\n     * isFileOlder(file, chronoLocalDateTime, zoneId)} where {@code zoneId} is a valid\n     * {@link ZoneId}.\n     *\n     * @param file                the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDateTime the date reference.\n     * @return true if the {@link File} exists and has been modified before the given\n     * {@link ChronoLocalDateTime} at the system-default time zone.\n     * @throws NullPointerException if the file or local date time is {@code null}.\n     * @see ZoneId#systemDefault()\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoLocalDateTime<?> chronoLocalDateTime) {\n        return isFileOlder(file, chronoLocalDateTime, ZoneId.systemDefault());\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoLocalDateTime}\n     * at the specified {@link ZoneId}.\n     *\n     * @param file          the {@link File} of which the modification date must be compared.\n     * @param chronoLocalDateTime the date reference.\n     * @param zoneId        the time zone.\n     * @return true if the {@link File} exists and has been modified before the given\n     * {@link ChronoLocalDateTime} at the given {@link ZoneId}.\n     * @throws NullPointerException if the file, local date time or zone ID is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoLocalDateTime<?> chronoLocalDateTime, final ZoneId zoneId) {\n        Objects.requireNonNull(chronoLocalDateTime, \"chronoLocalDateTime\");\n        Objects.requireNonNull(zoneId, \"zoneId\");\n        return isFileOlder(file, chronoLocalDateTime.atZone(zoneId));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link ChronoZonedDateTime}.\n     *\n     * @param file                the {@link File} of which the modification date must be compared.\n     * @param chronoZonedDateTime the date reference.\n     * @return true if the {@link File} exists and has been modified before the given\n     * {@link ChronoZonedDateTime}.\n     * @throws NullPointerException if the file or zoned date time is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final ChronoZonedDateTime<?> chronoZonedDateTime) {\n        Objects.requireNonNull(chronoZonedDateTime, \"chronoZonedDateTime\");\n        return isFileOlder(file, chronoZonedDateTime.toInstant());\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link Date}.\n     *\n     * @param file the {@link File} of which the modification date must be compared.\n     * @param date the date reference.\n     * @return true if the {@link File} exists and has been modified before the given {@link Date}.\n     * @throws NullPointerException if the file or date is {@code null}.\n     */\n    public static boolean isFileOlder(final File file, final Date date) {\n        Objects.requireNonNull(date, \"date\");\n        return isFileOlder(file, date.getTime());\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the reference {@link File}.\n     *\n     * @param file      the {@link File} of which the modification date must be compared.\n     * @param reference the {@link File} of which the modification date is used.\n     * @return true if the {@link File} exists and has been modified before the reference {@link File}.\n     * @throws NullPointerException if the file or reference file is {@code null}.\n     * @throws IllegalArgumentException if the reference file doesn't exist.\n     */\n    public static boolean isFileOlder(final File file, final File reference) {\n        requireExists(reference, \"reference\");\n        return UncheckedIO.get(() -> PathUtils.isOlder(file.toPath(), reference.toPath()));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link FileTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared.\n     * @param fileTime the file time reference.\n     * @return true if the {@link File} exists and has been modified before the given {@link FileTime}.\n     * @throws IOException if an I/O error occurs.\n     * @throws NullPointerException if the file or local date is {@code null}.\n     * @since 2.12.0\n     */\n    public static boolean isFileOlder(final File file, final FileTime fileTime) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        return PathUtils.isOlder(file.toPath(), fileTime);\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link Instant}.\n     *\n     * @param file    the {@link File} of which the modification date must be compared.\n     * @param instant the date reference.\n     * @return true if the {@link File} exists and has been modified before the given {@link Instant}.\n     * @throws NullPointerException if the file or instant is {@code null}.\n     * @since 2.8.0\n     */\n    public static boolean isFileOlder(final File file, final Instant instant) {\n        Objects.requireNonNull(instant, \"instant\");\n        return UncheckedIO.get(() -> PathUtils.isOlder(file.toPath(), instant));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified time reference.\n     *\n     * @param file       the {@link File} of which the modification date must be compared.\n     * @param timeMillis the time reference measured in milliseconds since the\n     *                   epoch (00:00:00 GMT, January 1, 1970).\n     * @return true if the {@link File} exists and has been modified before the given time reference.\n     * @throws NullPointerException if the file is {@code null}.\n     */\n    public static boolean isFileOlder(final File file, final long timeMillis) {\n        Objects.requireNonNull(file, \"file\");\n        return UncheckedIO.get(() -> PathUtils.isOlder(file.toPath(), timeMillis));\n    }\n\n    /**\n     * Tests if the specified {@link File} is older than the specified {@link OffsetDateTime}.\n     *\n     * @param file the {@link File} of which the modification date must be compared\n     * @param offsetDateTime the date reference\n     * @return true if the {@link File} exists and has been modified before the given {@link OffsetDateTime}.\n     * @throws NullPointerException if the file or zoned date time is {@code null}\n     * @since 2.12.0\n     */\n    public static boolean isFileOlder(final File file, final OffsetDateTime offsetDateTime) {\n        Objects.requireNonNull(offsetDateTime, \"offsetDateTime\");\n        return isFileOlder(file, offsetDateTime.toInstant());\n    }\n\n    /**\n     * Tests whether the specified {@link File} is a regular file or not. Implemented as a\n     * null-safe delegate to {@link Files#isRegularFile(Path path, LinkOption... options)}.\n     *\n     * @param   file the path to the file.\n     * @param   options options indicating how symbolic links are handled\n     * @return  {@code true} if the file is a regular file; {@code false} if\n     *          the path is null, the file does not exist, is not a regular file, or it cannot\n     *          be determined if the file is a regular file or not.\n     * @throws SecurityException     In the case of the default provider, and a security manager is installed, the\n     *                               {@link SecurityManager#checkRead(String) checkRead} method is invoked to check read\n     *                               access to the directory.\n     * @since 2.9.0\n     */\n    public static boolean isRegularFile(final File file, final LinkOption... options) {\n        return file != null && Files.isRegularFile(file.toPath(), options);\n    }\n\n    /**\n     * Tests whether the specified file is a symbolic link rather than an actual file.\n     * <p>\n     * This method delegates to {@link Files#isSymbolicLink(Path path)}\n     * </p>\n     *\n     * @param file the file to test.\n     * @return true if the file is a symbolic link, see {@link Files#isSymbolicLink(Path path)}.\n     * @since 2.0\n     * @see Files#isSymbolicLink(Path)\n     */\n    public static boolean isSymlink(final File file) {\n        return file != null && Files.isSymbolicLink(file.toPath());\n    }\n\n    /**\n     * Iterates over the files in given directory (and optionally\n     * its subdirectories).\n     * <p>\n     * The resulting iterator MUST be consumed in its entirety in order to close its underlying stream.\n     * </p>\n     * <p>\n     * All files found are filtered by an IOFileFilter.\n     * </p>\n     *\n     * @param directory  the directory to search in\n     * @param fileFilter filter to apply when finding files.\n     * @param dirFilter  optional filter to apply when finding subdirectories.\n     *                   If this parameter is {@code null}, subdirectories will not be included in the\n     *                   search. Use TrueFileFilter.INSTANCE to match all directories.\n     * @return an iterator of java.io.File for the matching files\n     * @see org.apache.commons.io.filefilter.FileFilterUtils\n     * @see org.apache.commons.io.filefilter.NameFileFilter\n     * @since 1.2\n     */\n    public static Iterator<File> iterateFiles(final File directory, final IOFileFilter fileFilter, final IOFileFilter dirFilter) {\n        return listFiles(directory, fileFilter, dirFilter).iterator();\n    }\n\n    /**\n     * Iterates over the files in a given directory (and optionally\n     * its subdirectories) which match an array of extensions.\n     * <p>\n     * The resulting iterator MUST be consumed in its entirety in order to close its underlying stream.\n     * </p>\n     *\n     * @param directory  the directory to search in\n     * @param extensions an array of extensions, ex. {\"java\",\"xml\"}. If this\n     *                   parameter is {@code null}, all files are returned.\n     * @param recursive  if true all subdirectories are searched as well\n     * @return an iterator of java.io.File with the matching files\n     * @since 1.2\n     */\n    public static Iterator<File> iterateFiles(final File directory, final String[] extensions, final boolean recursive) {\n        return UncheckedIO.apply(d -> StreamIterator.iterator(streamFiles(d, recursive, extensions)), directory);\n    }\n\n    /**\n     * Iterates over the files in given directory (and optionally\n     * its subdirectories).\n     * <p>\n     * The resulting iterator MUST be consumed in its entirety in order to close its underlying stream.\n     * </p>\n     * <p>\n     * All files found are filtered by an IOFileFilter.\n     * </p>\n     * <p>\n     * The resulting iterator includes the subdirectories themselves.\n     * </p>\n     *\n     * @param directory  the directory to search in\n     * @param fileFilter filter to apply when finding files.\n     * @param dirFilter  optional filter to apply when finding subdirectories.\n     *                   If this parameter is {@code null}, subdirectories will not be included in the\n     *                   search. Use TrueFileFilter.INSTANCE to match all directories.\n     * @return an iterator of java.io.File for the matching files\n     * @see org.apache.commons.io.filefilter.FileFilterUtils\n     * @see org.apache.commons.io.filefilter.NameFileFilter\n     * @since 2.2\n     */\n    public static Iterator<File> iterateFilesAndDirs(final File directory, final IOFileFilter fileFilter, final IOFileFilter dirFilter) {\n        return listFilesAndDirs(directory, fileFilter, dirFilter).iterator();\n    }\n\n    /**\n     * Returns the last modification time in milliseconds via\n     * {@link java.nio.file.Files#getLastModifiedTime(Path, LinkOption...)}.\n     * <p>\n     * For the best precision, use {@link #lastModifiedFileTime(File)}.\n     * </p>\n     * <p>\n     * Use this method to avoid issues with {@link File#lastModified()} like\n     * <a href=\"https://bugs.openjdk.java.net/browse/JDK-8177809\">JDK-8177809</a> where {@link File#lastModified()} is\n     * losing milliseconds (always ends in 000). This bug exists in OpenJDK 8 and 9, and is fixed in 10.\n     * </p>\n     *\n     * @param file The File to query.\n     * @return See {@link java.nio.file.attribute.FileTime#toMillis()}.\n     * @throws IOException if an I/O error occurs.\n     * @since 2.9.0\n     */\n    public static long lastModified(final File file) throws IOException {\n        // https://bugs.openjdk.java.net/browse/JDK-8177809\n        // File.lastModified() is losing milliseconds (always ends in 000)\n        // This bug is in OpenJDK 8 and 9, and fixed in 10.\n        return lastModifiedFileTime(file).toMillis();\n    }\n\n    /**\n     * Returns the last modification {@link FileTime} via\n     * {@link java.nio.file.Files#getLastModifiedTime(Path, LinkOption...)}.\n     * <p>\n     * Use this method to avoid issues with {@link File#lastModified()} like\n     * <a href=\"https://bugs.openjdk.java.net/browse/JDK-8177809\">JDK-8177809</a> where {@link File#lastModified()} is\n     * losing milliseconds (always ends in 000). This bug exists in OpenJDK 8 and 9, and is fixed in 10.\n     * </p>\n     *\n     * @param file The File to query.\n     * @return See {@link java.nio.file.Files#getLastModifiedTime(Path, LinkOption...)}.\n     * @throws IOException if an I/O error occurs.\n     * @since 2.12.0\n     */\n    public static FileTime lastModifiedFileTime(final File file) throws IOException {\n        // https://bugs.openjdk.java.net/browse/JDK-8177809\n        // File.lastModified() is losing milliseconds (always ends in 000)\n        // This bug is in OpenJDK 8 and 9, and fixed in 10.\n        return Files.getLastModifiedTime(Objects.requireNonNull(file.toPath(), \"file\"));\n    }\n\n    /**\n     * Returns the last modification time in milliseconds via\n     * {@link java.nio.file.Files#getLastModifiedTime(Path, LinkOption...)}.\n     * <p>\n     * For the best precision, use {@link #lastModifiedFileTime(File)}.\n     * </p>\n     * <p>\n     * Use this method to avoid issues with {@link File#lastModified()} like\n     * <a href=\"https://bugs.openjdk.java.net/browse/JDK-8177809\">JDK-8177809</a> where {@link File#lastModified()} is\n     * losing milliseconds (always ends in 000). This bug exists in OpenJDK 8 and 9, and is fixed in 10.\n     * </p>\n     *\n     * @param file The File to query.\n     * @return See {@link java.nio.file.attribute.FileTime#toMillis()}.\n     * @throws UncheckedIOException if an I/O error occurs.\n     * @since 2.9.0\n     */\n    public static long lastModifiedUnchecked(final File file) {\n        // https://bugs.openjdk.java.net/browse/JDK-8177809\n        // File.lastModified() is losing milliseconds (always ends in 000)\n        // This bug is in OpenJDK 8 and 9, and fixed in 10.\n        return UncheckedIO.apply(FileUtils::lastModified, file);\n    }\n\n    /**\n     * Returns an Iterator for the lines in a {@link File} using the default encoding for the VM.\n     *\n     * @param file the file to open for input, must not be {@code null}\n     * @return an Iterator of the lines in the file, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @see #lineIterator(File, String)\n     * @since 1.3\n     */\n    public static LineIterator lineIterator(final File file) throws IOException {\n        return lineIterator(file, null);\n    }\n\n    /**\n     * Returns an Iterator for the lines in a {@link File}.\n     * <p>\n     * This method opens an {@link InputStream} for the file.\n     * When you have finished with the iterator you should close the stream\n     * to free internal resources. This can be done by using a try-with-resources block or calling the\n     * {@link LineIterator#close()} method.\n     * </p>\n     * <p>\n     * The recommended usage pattern is:\n     * </p>\n     * <pre>\n     * LineIterator it = FileUtils.lineIterator(file, StandardCharsets.UTF_8.name());\n     * try {\n     *   while (it.hasNext()) {\n     *     String line = it.nextLine();\n     *     /// do something with line\n     *   }\n     * } finally {\n     *   LineIterator.closeQuietly(iterator);\n     * }\n     * </pre>\n     * <p>\n     * If an exception occurs during the creation of the iterator, the\n     * underlying stream is closed.\n     * </p>\n     *\n     * @param file     the file to open for input, must not be {@code null}\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @return a LineIterator for lines in the file, never {@code null}; MUST be closed by the caller.\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 1.2\n     */\n    @SuppressWarnings(\"resource\") // Caller closes the result LineIterator.\n    public static LineIterator lineIterator(final File file, final String charsetName) throws IOException {\n        InputStream inputStream = null;\n        try {\n            inputStream = Files.newInputStream(file.toPath());\n            return IOUtils.lineIterator(inputStream, charsetName);\n        } catch (final IOException | RuntimeException ex) {\n            IOUtils.closeQuietly(inputStream, ex::addSuppressed);\n            throw ex;\n        }\n    }\n\n    private static AccumulatorPathVisitor listAccumulate(final File directory, final IOFileFilter fileFilter, final IOFileFilter dirFilter,\n        final FileVisitOption... options) throws IOException {\n        final boolean isDirFilterSet = dirFilter != null;\n        final FileEqualsFileFilter rootDirFilter = new FileEqualsFileFilter(directory);\n        final PathFilter dirPathFilter = isDirFilterSet ? rootDirFilter.or(dirFilter) : rootDirFilter;\n        final AccumulatorPathVisitor visitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), fileFilter, dirPathFilter,\n            (p, e) -> FileVisitResult.CONTINUE);\n        final Set<FileVisitOption> optionSet = new HashSet<>();\n        Collections.addAll(optionSet, options);\n        Files.walkFileTree(directory.toPath(), optionSet, toMaxDepth(isDirFilterSet), visitor);\n        return visitor;\n    }\n\n    /**\n     * Lists files in a directory, asserting that the supplied directory exists and is a directory.\n     *\n     * @param directory The directory to list\n     * @param fileFilter Optional file filter, may be null.\n     * @return The files in the directory, never {@code null}.\n     * @throws NullPointerException if directory is {@code null}.\n     * @throws IllegalArgumentException if directory does not exist or is not a directory.\n     * @throws IOException if an I/O error occurs.\n     */\n    private static File[] listFiles(final File directory, final FileFilter fileFilter) throws IOException {\n        requireDirectoryExists(directory, \"directory\");\n        final File[] files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);\n        if (files == null) {\n            // null if the directory does not denote a directory, or if an I/O error occurs.\n            throw new IOException(\"Unknown I/O error listing contents of directory: \" + directory);\n        }\n        return files;\n    }\n\n    /**\n     * Finds files within a given directory (and optionally its\n     * subdirectories). All files found are filtered by an IOFileFilter.\n     * <p>\n     * If your search should recurse into subdirectories you can pass in\n     * an IOFileFilter for directories. You don't need to bind a\n     * DirectoryFileFilter (via logical AND) to this filter. This method does\n     * that for you.\n     * </p>\n     * <p>\n     * An example: If you want to search through all directories called\n     * \"temp\" you pass in {@code FileFilterUtils.NameFileFilter(\"temp\")}\n     * </p>\n     * <p>\n     * Another common usage of this method is find files in a directory\n     * tree but ignoring the directories generated CVS. You can simply pass\n     * in {@code FileFilterUtils.makeCVSAware(null)}.\n     * </p>\n     *\n     * @param directory  the directory to search in\n     * @param fileFilter filter to apply when finding files. Must not be {@code null},\n     *                   use {@link TrueFileFilter#INSTANCE} to match all files in selected directories.\n     * @param dirFilter  optional filter to apply when finding subdirectories.\n     *                   If this parameter is {@code null}, subdirectories will not be included in the\n     *                   search. Use {@link TrueFileFilter#INSTANCE} to match all directories.\n     * @return a collection of java.io.File with the matching files\n     * @see org.apache.commons.io.filefilter.FileFilterUtils\n     * @see org.apache.commons.io.filefilter.NameFileFilter\n     */\n    public static Collection<File> listFiles(final File directory, final IOFileFilter fileFilter, final IOFileFilter dirFilter) {\n        final AccumulatorPathVisitor visitor = UncheckedIO\n            .apply(d -> listAccumulate(d, FileFileFilter.INSTANCE.and(fileFilter), dirFilter, FileVisitOption.FOLLOW_LINKS), directory);\n        return visitor.getFileList().stream().map(Path::toFile).collect(Collectors.toList());\n    }\n\n    /**\n     * Finds files within a given directory (and optionally its subdirectories)\n     * which match an array of extensions.\n     *\n     * @param directory  the directory to search in\n     * @param extensions an array of extensions, ex. {\"java\",\"xml\"}. If this\n     *                   parameter is {@code null}, all files are returned.\n     * @param recursive  if true all subdirectories are searched as well\n     * @return a collection of java.io.File with the matching files\n     */\n    public static Collection<File> listFiles(final File directory, final String[] extensions, final boolean recursive) {\n        return UncheckedIO.apply(d -> toList(streamFiles(d, recursive, extensions)), directory);\n    }\n\n    /**\n     * Finds files within a given directory (and optionally its\n     * subdirectories). All files found are filtered by an IOFileFilter.\n     * <p>\n     * The resulting collection includes the starting directory and\n     * any subdirectories that match the directory filter.\n     * </p>\n     *\n     * @param directory  the directory to search in\n     * @param fileFilter filter to apply when finding files.\n     * @param dirFilter  optional filter to apply when finding subdirectories.\n     *                   If this parameter is {@code null}, subdirectories will not be included in the\n     *                   search. Use TrueFileFilter.INSTANCE to match all directories.\n     * @return a collection of java.io.File with the matching files\n     * @see org.apache.commons.io.FileUtils#listFiles\n     * @see org.apache.commons.io.filefilter.FileFilterUtils\n     * @see org.apache.commons.io.filefilter.NameFileFilter\n     * @since 2.2\n     */\n    public static Collection<File> listFilesAndDirs(final File directory, final IOFileFilter fileFilter, final IOFileFilter dirFilter) {\n        final AccumulatorPathVisitor visitor = UncheckedIO.apply(d -> listAccumulate(d, fileFilter, dirFilter, FileVisitOption.FOLLOW_LINKS),\n            directory);\n        final List<Path> list = visitor.getFileList();\n        list.addAll(visitor.getDirList());\n        return list.stream().map(Path::toFile).collect(Collectors.toList());\n    }\n\n    /**\n     * Calls {@link File#mkdirs()} and throws an exception on failure.\n     *\n     * @param directory the receiver for {@code mkdirs()}, may be null.\n     * @return the given file, may be null.\n     * @throws IOException if the directory was not created along with all its parent directories.\n     * @throws IOException if the given file object is not a directory.\n     * @throws SecurityException See {@link File#mkdirs()}.\n     * @see File#mkdirs()\n     */\n    private static File mkdirs(final File directory) throws IOException {\n        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {\n            throw new IOException(\"Cannot create directory '\" + directory + \"'.\");\n        }\n        return directory;\n    }\n\n    /**\n     * Moves a directory.\n     * <p>\n     * When the destination directory is on another file system, do a \"copy and delete\".\n     * </p>\n     *\n     * @param srcDir the directory to be moved.\n     * @param destDir the destination directory.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void moveDirectory(final File srcDir, final File destDir) throws IOException {\n        validateMoveParameters(srcDir, destDir);\n        requireDirectory(srcDir, \"srcDir\");\n        requireAbsent(destDir, \"destDir\");\n        if (!srcDir.renameTo(destDir)) {\n            if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath() + File.separator)) {\n                throw new IOException(\"Cannot move directory: \" + srcDir + \" to a subdirectory of itself: \" + destDir);\n            }\n            copyDirectory(srcDir, destDir);\n            deleteDirectory(srcDir);\n            if (srcDir.exists()) {\n                throw new IOException(\"Failed to delete original directory '\" + srcDir +\n                        \"' after copy to '\" + destDir + \"'\");\n            }\n        }\n    }\n\n    /**\n     * Moves a directory to another directory.\n     *\n     * @param source the file to be moved.\n     * @param destDir the destination file.\n     * @param createDestDir If {@code true} create the destination directory, otherwise if {@code false} throw an\n     *        IOException.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws IllegalArgumentException if the source or destination is invalid.\n     * @throws FileNotFoundException if the source does not exist.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void moveDirectoryToDirectory(final File source, final File destDir, final boolean createDestDir) throws IOException {\n        validateMoveParameters(source, destDir);\n        if (!destDir.isDirectory()) {\n            if (destDir.exists()) {\n                throw new IOException(\"Destination '\" + destDir + \"' is not a directory\");\n            }\n            if (!createDestDir) {\n                throw new FileNotFoundException(\"Destination directory '\" + destDir + \"' does not exist [createDestDir=\" + false + \"]\");\n            }\n            mkdirs(destDir);\n        }\n        moveDirectory(source, new File(destDir, source.getName()));\n    }\n\n    /**\n     * Moves a file preserving attributes.\n     * <p>\n     * Shorthand for {@code moveFile(srcFile, destFile, StandardCopyOption.COPY_ATTRIBUTES)}.\n     * </p>\n     * <p>\n     * When the destination file is on another file system, do a \"copy and delete\".\n     * </p>\n     *\n     * @param srcFile the file to be moved.\n     * @param destFile the destination file.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileExistsException if the destination file exists.\n     * @throws FileNotFoundException if the source file does not exist.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs.\n     * @since 1.4\n     */\n    public static void moveFile(final File srcFile, final File destFile) throws IOException {\n        moveFile(srcFile, destFile, StandardCopyOption.COPY_ATTRIBUTES);\n    }\n\n    /**\n     * Moves a file.\n     * <p>\n     * When the destination file is on another file system, do a \"copy and delete\".\n     * </p>\n     *\n     * @param srcFile the file to be moved.\n     * @param destFile the destination file.\n     * @param copyOptions Copy options.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileExistsException if the destination file exists.\n     * @throws FileNotFoundException if the source file does not exist.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 2.9.0\n     */\n    public static void moveFile(final File srcFile, final File destFile, final CopyOption... copyOptions) throws IOException {\n        validateMoveParameters(srcFile, destFile);\n        requireFile(srcFile, \"srcFile\");\n        requireAbsent(destFile, \"destFile\");\n        final boolean rename = srcFile.renameTo(destFile);\n        if (!rename) {\n            copyFile(srcFile, destFile, copyOptions);\n            if (!srcFile.delete()) {\n                FileUtils.deleteQuietly(destFile);\n                throw new IOException(\"Failed to delete original file '\" + srcFile + \"' after copy to '\" + destFile + \"'\");\n            }\n        }\n    }\n\n    /**\n     * Moves a file to a directory.\n     *\n     * @param srcFile the file to be moved.\n     * @param destDir the destination file.\n     * @param createDestDir If {@code true} create the destination directory, otherwise if {@code false} throw an\n     *        IOException.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileExistsException if the destination file exists.\n     * @throws FileNotFoundException if the source file does not exist.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void moveFileToDirectory(final File srcFile, final File destDir, final boolean createDestDir) throws IOException {\n        validateMoveParameters(srcFile, destDir);\n        if (!destDir.exists() && createDestDir) {\n            mkdirs(destDir);\n        }\n        requireExistsChecked(destDir, \"destDir\");\n        requireDirectory(destDir, \"destDir\");\n        moveFile(srcFile, new File(destDir, srcFile.getName()));\n    }\n\n    /**\n     * Moves a file or directory to the destination directory.\n     * <p>\n     * When the destination is on another file system, do a \"copy and delete\".\n     * </p>\n     *\n     * @param src the file or directory to be moved.\n     * @param destDir the destination directory.\n     * @param createDestDir If {@code true} create the destination directory, otherwise if {@code false} throw an\n     *        IOException.\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileExistsException if the directory or file exists in the destination directory.\n     * @throws FileNotFoundException if the source file does not exist.\n     * @throws IOException if source or destination is invalid.\n     * @throws IOException if an error occurs or setting the last-modified time didn't succeeded.\n     * @since 1.4\n     */\n    public static void moveToDirectory(final File src, final File destDir, final boolean createDestDir) throws IOException {\n        validateMoveParameters(src, destDir);\n        if (src.isDirectory()) {\n            moveDirectoryToDirectory(src, destDir, createDestDir);\n        } else {\n            moveFileToDirectory(src, destDir, createDestDir);\n        }\n    }\n\n    /**\n     * Creates a new OutputStream by opening or creating a file, returning an output stream that may be used to write bytes\n     * to the file.\n     *\n     * @param append Whether or not to append.\n     * @param file the File.\n     * @return a new OutputStream.\n     * @throws IOException if an I/O error occurs.\n     * @see PathUtils#newOutputStream(Path, boolean)\n     * @since 2.12.0\n     */\n    public static OutputStream newOutputStream(final File file, final boolean append) throws IOException {\n        return PathUtils.newOutputStream(Objects.requireNonNull(file, \"file\").toPath(), append);\n    }\n\n    /**\n     * Opens a {@link FileInputStream} for the specified file, providing better error messages than simply calling\n     * {@code new FileInputStream(file)}.\n     * <p>\n     * At the end of the method either the stream will be successfully opened, or an exception will have been thrown.\n     * </p>\n     * <p>\n     * An exception is thrown if the file does not exist. An exception is thrown if the file object exists but is a\n     * directory. An exception is thrown if the file exists but cannot be read.\n     * </p>\n     *\n     * @param file the file to open for input, must not be {@code null}\n     * @return a new {@link FileInputStream} for the specified file\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException See FileNotFoundException above, FileNotFoundException is a subclass of IOException.\n     * @since 1.3\n     */\n    public static FileInputStream openInputStream(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        return new FileInputStream(file);\n    }\n\n    /**\n     * Opens a {@link FileOutputStream} for the specified file, checking and\n     * creating the parent directory if it does not exist.\n     * <p>\n     * At the end of the method either the stream will be successfully opened,\n     * or an exception will have been thrown.\n     * </p>\n     * <p>\n     * The parent directory will be created if it does not exist.\n     * The file will be created if it does not exist.\n     * An exception is thrown if the file object exists but is a directory.\n     * An exception is thrown if the file exists but cannot be written to.\n     * An exception is thrown if the parent directory cannot be created.\n     * </p>\n     *\n     * @param file the file to open for output, must not be {@code null}\n     * @return a new {@link FileOutputStream} for the specified file\n     * @throws NullPointerException if the file object is {@code null}.\n     * @throws IllegalArgumentException if the file object is a directory\n     * @throws IllegalArgumentException if the file is not writable.\n     * @throws IOException if the directories could not be created.\n     * @since 1.3\n     */\n    public static FileOutputStream openOutputStream(final File file) throws IOException {\n        return openOutputStream(file, false);\n    }\n\n    /**\n     * Opens a {@link FileOutputStream} for the specified file, checking and\n     * creating the parent directory if it does not exist.\n     * <p>\n     * At the end of the method either the stream will be successfully opened,\n     * or an exception will have been thrown.\n     * </p>\n     * <p>\n     * The parent directory will be created if it does not exist.\n     * The file will be created if it does not exist.\n     * An exception is thrown if the file object exists but is a directory.\n     * An exception is thrown if the file exists but cannot be written to.\n     * An exception is thrown if the parent directory cannot be created.\n     * </p>\n     *\n     * @param file   the file to open for output, must not be {@code null}\n     * @param append if {@code true}, then bytes will be added to the\n     *               end of the file rather than overwriting\n     * @return a new {@link FileOutputStream} for the specified file\n     * @throws NullPointerException if the file object is {@code null}.\n     * @throws IllegalArgumentException if the file object is a directory\n     * @throws IllegalArgumentException if the file is not writable.\n     * @throws IOException if the directories could not be created.\n     * @since 2.1\n     */\n    public static FileOutputStream openOutputStream(final File file, final boolean append) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        if (file.exists()) {\n            requireFile(file, \"file\");\n            requireCanWrite(file, \"file\");\n        } else {\n            createParentDirectories(file);\n        }\n        return new FileOutputStream(file, append);\n    }\n\n    /**\n     * Reads the contents of a file into a byte array.\n     * The file is always closed.\n     *\n     * @param file the file to read, must not be {@code null}\n     * @return the file contents, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 1.1\n     */\n    public static byte[] readFileToByteArray(final File file) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        return Files.readAllBytes(file.toPath());\n    }\n\n    /**\n     * Reads the contents of a file into a String using the default encoding for the VM.\n     * The file is always closed.\n     *\n     * @param file the file to read, must not be {@code null}\n     * @return the file contents, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 1.3.1\n     * @deprecated 2.5 use {@link #readFileToString(File, Charset)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static String readFileToString(final File file) throws IOException {\n        return readFileToString(file, Charset.defaultCharset());\n    }\n\n    /**\n     * Reads the contents of a file into a String.\n     * The file is always closed.\n     *\n     * @param file     the file to read, must not be {@code null}\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @return the file contents, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 2.3\n     */\n    public static String readFileToString(final File file, final Charset charsetName) throws IOException {\n        try (InputStream inputStream = Files.newInputStream(file.toPath())) {\n            return IOUtils.toString(inputStream, Charsets.toCharset(charsetName));\n        }\n    }\n\n    /**\n     * Reads the contents of a file into a String. The file is always closed.\n     *\n     * @param file     the file to read, must not be {@code null}\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @return the file contents, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @throws java.nio.charset.UnsupportedCharsetException thrown instead of {@link java.io\n     * .UnsupportedEncodingException} in version 2.2 if the named charset is unavailable.\n     * @since 2.3\n     */\n    public static String readFileToString(final File file, final String charsetName) throws IOException {\n        return readFileToString(file, Charsets.toCharset(charsetName));\n    }\n\n    /**\n     * Reads the contents of a file line by line to a List of Strings using the default encoding for the VM.\n     * The file is always closed.\n     *\n     * @param file the file to read, must not be {@code null}\n     * @return the list of Strings representing each line in the file, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 1.3\n     * @deprecated 2.5 use {@link #readLines(File, Charset)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static List<String> readLines(final File file) throws IOException {\n        return readLines(file, Charset.defaultCharset());\n    }\n\n    /**\n     * Reads the contents of a file line by line to a List of Strings.\n     * The file is always closed.\n     *\n     * @param file     the file to read, must not be {@code null}\n     * @param charset the charset to use, {@code null} means platform default\n     * @return the list of Strings representing each line in the file, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @since 2.3\n     */\n    public static List<String> readLines(final File file, final Charset charset) throws IOException {\n        return Files.readAllLines(file.toPath(), charset);\n    }\n\n    /**\n     * Reads the contents of a file line by line to a List of Strings. The file is always closed.\n     *\n     * @param file     the file to read, must not be {@code null}\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @return the list of Strings representing each line in the file, never {@code null}\n     * @throws NullPointerException if file is {@code null}.\n     * @throws FileNotFoundException if the file does not exist, is a directory rather than a regular file, or for some\n     *         other reason cannot be opened for reading.\n     * @throws IOException if an I/O error occurs.\n     * @throws java.nio.charset.UnsupportedCharsetException thrown instead of {@link java.io\n     * .UnsupportedEncodingException} in version 2.2 if the named charset is unavailable.\n     * @since 1.1\n     */\n    public static List<String> readLines(final File file, final String charsetName) throws IOException {\n        return readLines(file, Charsets.toCharset(charsetName));\n    }\n\n\n    private static void requireAbsent(final File file, final String name) throws FileExistsException {\n        if (file.exists()) {\n            throw new FileExistsException(String.format(\"File element in parameter '%s' already exists: '%s'\", name, file));\n        }\n    }\n\n    /**\n     * Throws IllegalArgumentException if the given files' canonical representations are equal.\n     *\n     * @param file1 The first file to compare.\n     * @param file2 The second file to compare.\n     * @throws IOException if an I/O error occurs.\n     * @throws IllegalArgumentException if the given files' canonical representations are equal.\n     */\n    private static void requireCanonicalPathsNotEquals(final File file1, final File file2) throws IOException {\n        final String canonicalPath = file1.getCanonicalPath();\n        if (canonicalPath.equals(file2.getCanonicalPath())) {\n            throw new IllegalArgumentException(String\n                .format(\"File canonical paths are equal: '%s' (file1='%s', file2='%s')\", canonicalPath, file1, file2));\n        }\n    }\n\n    /**\n     * Throws an {@link IllegalArgumentException} if the file is not writable. This provides a more precise exception\n     * message than a plain access denied.\n     *\n     * @param file The file to test.\n     * @param name The parameter name to use in the exception message.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the file is not writable.\n     */\n    private static void requireCanWrite(final File file, final String name) {\n        Objects.requireNonNull(file, \"file\");\n        if (!file.canWrite()) {\n            throw new IllegalArgumentException(\"File parameter '\" + name + \" is not writable: '\" + file + \"'\");\n        }\n    }\n\n    /**\n     * Requires that the given {@link File} is a directory.\n     *\n     * @param directory The {@link File} to check.\n     * @param name The parameter name to use in the exception message in case of null input or if the file is not a directory.\n     * @return the given directory.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a directory.\n     */\n    private static File requireDirectory(final File directory, final String name) {\n        Objects.requireNonNull(directory, name);\n        if (!directory.isDirectory()) {\n            throw new IllegalArgumentException(\"Parameter '\" + name + \"' is not a directory: '\" + directory + \"'\");\n        }\n        return directory;\n    }\n\n    /**\n     * Requires that the given {@link File} exists and is a directory.\n     *\n     * @param directory The {@link File} to check.\n     * @param name The parameter name to use in the exception message in case of null input.\n     * @return the given directory.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a directory.\n     */\n    private static File requireDirectoryExists(final File directory, final String name) {\n        requireExists(directory, name);\n        requireDirectory(directory, name);\n        return directory;\n    }\n\n    /**\n     * Requires that the given {@link File} is a directory if it exists.\n     *\n     * @param directory The {@link File} to check.\n     * @param name The parameter name to use in the exception message in case of null input.\n     * @return the given directory.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} exists but is not a directory.\n     */\n    private static File requireDirectoryIfExists(final File directory, final String name) {\n        Objects.requireNonNull(directory, name);\n        if (directory.exists()) {\n            requireDirectory(directory, name);\n        }\n        return directory;\n    }\n\n    /**\n     * Requires that two file lengths are equal.\n     *\n     * @param srcFile Source file.\n     * @param destFile Destination file.\n     * @param srcLen Source file length.\n     * @param dstLen Destination file length\n     * @throws IOException Thrown when the given sizes are not equal.\n     */\n    private static void requireEqualSizes(final File srcFile, final File destFile, final long srcLen, final long dstLen) throws IOException {\n        if (srcLen != dstLen) {\n            throw new IOException(\n                \"Failed to copy full contents from '\" + srcFile + \"' to '\" + destFile + \"' Expected length: \" + srcLen + \" Actual: \" + dstLen);\n        }\n    }\n\n    /**\n     * Requires that the given {@link File} exists and throws an {@link IllegalArgumentException} if it doesn't.\n     *\n     * @param file The {@link File} to check.\n     * @param fileParamName The parameter name to use in the exception message in case of {@code null} input.\n     * @return the given file.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist.\n     */\n    private static File requireExists(final File file, final String fileParamName) {\n        Objects.requireNonNull(file, fileParamName);\n        if (!file.exists()) {\n            throw new IllegalArgumentException(\"File system element for parameter '\" + fileParamName + \"' does not exist: '\" + file + \"'\");\n        }\n        return file;\n    }\n\n    /**\n     * Requires that the given {@link File} exists and throws an {@link FileNotFoundException} if it doesn't.\n     *\n     * @param file The {@link File} to check.\n     * @param fileParamName The parameter name to use in the exception message in case of {@code null} input.\n     * @return the given file.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws FileNotFoundException if the given {@link File} does not exist.\n     */\n    private static File requireExistsChecked(final File file, final String fileParamName) throws FileNotFoundException {\n        Objects.requireNonNull(file, fileParamName);\n        if (!file.exists()) {\n            throw new FileNotFoundException(\"File system element for parameter '\" + fileParamName + \"' does not exist: '\" + file + \"'\");\n        }\n        return file;\n    }\n\n    /**\n     * Requires that the given {@link File} i").append("s a file.\n     *\n     * @param file The {@link File} to check.\n     * @param name The parameter name to use in the exception message.\n     * @return the given file.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does not exist or is not a file.\n     */\n    private static File requireFile(final File file, final String name) {\n        Objects.requireNonNull(file, name);\n        if (!file.isFile()) {\n            throw new IllegalArgumentException(\"Parameter '\" + name + \"' is not a file: \" + file);\n        }\n        return file;\n    }\n\n    /**\n     * Requires parameter attributes for a file copy operation.\n     *\n     * @param source the source file\n     * @param destination the destination\n     * @throws NullPointerException if any of the given {@link File}s are {@code null}.\n     * @throws FileNotFoundException if the source does not exist.\n     */\n    private static void requireFileCopy(final File source, final File destination) throws FileNotFoundException {\n        requireExistsChecked(source, \"source\");\n        Objects.requireNonNull(destination, \"destination\");\n    }\n\n    /**\n     * Requires that the given {@link File} is a file if it exists.\n     *\n     * @param file The {@link File} to check.\n     * @param name The parameter name to use in the exception message in case of null input.\n     * @return the given directory.\n     * @throws NullPointerException if the given {@link File} is {@code null}.\n     * @throws IllegalArgumentException if the given {@link File} does exists but is not a directory.\n     */\n    private static File requireFileIfExists(final File file, final String name) {\n        Objects.requireNonNull(file, name);\n        return file.exists() ? requireFile(file, name) : file;\n    }\n\n    /**\n     * Sets the given {@code targetFile}'s last modified date to the value from {@code sourceFile}.\n     *\n     * @param sourceFile The source file to query.\n     * @param targetFile The target file or directory to set.\n     * @throws NullPointerException if sourceFile is {@code null}.\n     * @throws NullPointerException if targetFile is {@code null}.\n     * @throws IOException if setting the last-modified time failed.\n     */\n    private static void setLastModified(final File sourceFile, final File targetFile) throws IOException {\n        Objects.requireNonNull(sourceFile, \"sourceFile\");\n        Objects.requireNonNull(targetFile, \"targetFile\");\n        if (targetFile.isFile()) {\n            PathUtils.setLastModifiedTime(targetFile.toPath(), sourceFile.toPath());\n        } else {\n            setLastModified(targetFile, lastModified(sourceFile));\n        }\n    }\n\n    /**\n     * Sets the given {@code targetFile}'s last modified date to the given value.\n     *\n     * @param file The source file to query.\n     * @param timeMillis The new last-modified time, measured in milliseconds since the epoch 01-01-1970 GMT.\n     * @throws NullPointerException if file is {@code null}.\n     * @throws IOException if setting the last-modified time failed.\n     */\n    private static void setLastModified(final File file, final long timeMillis) throws IOException {\n        Objects.requireNonNull(file, \"file\");\n        if (!file.setLastModified(timeMillis)) {\n            throw new IOException(String.format(\"Failed setLastModified(%s) on '%s'\", timeMillis, file));\n        }\n    }\n\n    /**\n     * Returns the size of the specified file or directory. If the provided\n     * {@link File} is a regular file, then the file's length is returned.\n     * If the argument is a directory, then the size of the directory is\n     * calculated recursively. If a directory or subdirectory is security\n     * restricted, its size will not be included.\n     * <p>\n     * Note that overflow is not detected, and the return value may be negative if\n     * overflow occurs. See {@link #sizeOfAsBigInteger(File)} for an alternative\n     * method that does not overflow.\n     * </p>\n     *\n     * @param file the regular file or directory to return the size\n     *             of (must not be {@code null}).\n     *\n     * @return the length of the file, or recursive size of the directory,\n     * provided (in bytes).\n     *\n     * @throws NullPointerException     if the file is {@code null}.\n     * @throws IllegalArgumentException if the file does not exist.\n     * @throws UncheckedIOException if an IO error occurs.\n     * @since 2.0\n     */\n    public static long sizeOf(final File file) {\n        requireExists(file, \"file\");\n        return UncheckedIO.get(() -> PathUtils.sizeOf(file.toPath()));\n    }\n\n    /**\n     * Returns the size of the specified file or directory. If the provided\n     * {@link File} is a regular file, then the file's length is returned.\n     * If the argument is a directory, then the size of the directory is\n     * calculated recursively. If a directory or subdirectory is security\n     * restricted, its size will not be included.\n     *\n     * @param file the regular file or directory to return the size\n     *             of (must not be {@code null}).\n     *\n     * @return the length of the file, or recursive size of the directory,\n     * provided (in bytes).\n     *\n     * @throws NullPointerException     if the file is {@code null}.\n     * @throws IllegalArgumentException if the file does not exist.\n     * @throws UncheckedIOException if an IO error occurs.\n     * @since 2.4\n     */\n    public static BigInteger sizeOfAsBigInteger(final File file) {\n        requireExists(file, \"file\");\n        return UncheckedIO.get(() -> PathUtils.sizeOfAsBigInteger(file.toPath()));\n    }\n\n    /**\n     * Counts the size of a directory recursively (sum of the length of all files).\n     * <p>\n     * Note that overflow is not detected, and the return value may be negative if\n     * overflow occurs. See {@link #sizeOfDirectoryAsBigInteger(File)} for an alternative\n     * method that does not overflow.\n     * </p>\n     *\n     * @param directory directory to inspect, must not be {@code null}.\n     * @return size of directory in bytes, 0 if directory is security restricted, a negative number when the real total\n     * is greater than {@link Long#MAX_VALUE}.\n     * @throws NullPointerException if the directory is {@code null}.\n     * @throws UncheckedIOException if an IO error occurs.\n     */\n    public static long sizeOfDirectory(final File directory) {\n        requireDirectoryExists(directory, \"directory\");\n        return UncheckedIO.get(() -> PathUtils.sizeOfDirectory(directory.toPath()));\n    }\n\n    /**\n     * Counts the size of a directory recursively (sum of the length of all files).\n     *\n     * @param directory directory to inspect, must not be {@code null}.\n     * @return size of directory in bytes, 0 if directory is security restricted.\n     * @throws NullPointerException if the directory is {@code null}.\n     * @throws UncheckedIOException if an IO error occurs.\n     * @since 2.4\n     */\n    public static BigInteger sizeOfDirectoryAsBigInteger(final File directory) {\n        requireDirectoryExists(directory, \"directory\");\n        return UncheckedIO.get(() -> PathUtils.sizeOfDirectoryAsBigInteger(directory.toPath()));\n    }\n\n    /**\n     * Streams over the files in a given directory (and optionally\n     * its subdirectories) which match an array of extensions.\n     *\n     * @param directory  the directory to search in\n     * @param recursive  if true all subdirectories are searched as well\n     * @param extensions an array of extensions, ex. {\"java\",\"xml\"}. If this\n     *                   parameter is {@code null}, all files are returned.\n     * @return an iterator of java.io.File with the matching files\n     * @throws IOException if an I/O error is thrown when accessing the starting file.\n     * @since 2.9.0\n     */\n    public static Stream<File> streamFiles(final File directory, final boolean recursive, final String... extensions) throws IOException {\n        // @formatter:off\n        final IOFileFilter filter = extensions == null\n            ? FileFileFilter.INSTANCE\n            : FileFileFilter.INSTANCE.and(new SuffixFileFilter(toSuffixes(extensions)));\n        // @formatter:on\n        return PathUtils.walk(directory.toPath(), filter, toMaxDepth(recursive), false, FileVisitOption.FOLLOW_LINKS).map(Path::toFile);\n    }\n\n    /**\n     * Converts from a {@link URL} to a {@link File}.\n     * <p>\n     * From version 1.1 this method will decode the URL.\n     * Syntax such as {@code file:///my%20docs/file.txt} will be\n     * correctly decoded to {@code /my docs/file.txt}. Starting with version\n     * 1.5, this method uses UTF-8 to decode percent-encoded octets to characters.\n     * Additionally, malformed percent-encoded octets are handled leniently by\n     * passing them through literally.\n     * </p>\n     *\n     * @param url the file URL to convert, {@code null} returns {@code null}\n     * @return the equivalent {@link File} object, or {@code null}\n     * if the URL's protocol is not {@code file}\n     */\n    public static File toFile(final URL url) {\n        if (url == null || !\"file\".equalsIgnoreCase(url.getProtocol())) {\n            return null;\n        }\n        final String filename = url.getFile().replace('/', File.separatorChar);\n        return new File(decodeUrl(filename));\n    }\n\n    /**\n     * Converts each of an array of {@link URL} to a {@link File}.\n     * <p>\n     * Returns an array of the same size as the input.\n     * If the input is {@code null}, an empty array is returned.\n     * If the input contains {@code null}, the output array contains {@code null} at the same\n     * index.\n     * </p>\n     * <p>\n     * This method will decode the URL.\n     * Syntax such as {@code file:///my%20docs/file.txt} will be\n     * correctly decoded to {@code /my docs/file.txt}.\n     * </p>\n     *\n     * @param urls the file URLs to convert, {@code null} returns empty array\n     * @return a non-{@code null} array of Files matching the input, with a {@code null} item\n     * if there was a {@code null} at that index in the input array\n     * @throws IllegalArgumentException if any file is not a URL file\n     * @throws IllegalArgumentException if any file is incorrectly encoded\n     * @since 1.1\n     */\n    public static File[] toFiles(final URL... urls) {\n        if (IOUtils.length(urls) == 0) {\n            return EMPTY_FILE_ARRAY;\n        }\n        final File[] files = new File[urls.length];\n        for (int i = 0; i < urls.length; i++) {\n            final URL url = urls[i];\n            if (url != null) {\n                if (!\"file\".equalsIgnoreCase(url.getProtocol())) {\n                    throw new IllegalArgumentException(\"Can only convert file URL to a File: \" + url);\n                }\n                files[i] = toFile(url);\n            }\n        }\n        return files;\n    }\n\n    private static List<File> toList(final Stream<File> stream) {\n        return stream.collect(Collectors.toList());\n    }\n\n    /**\n     * Converts whether or not to recurse into a recursion max depth.\n     *\n     * @param recursive whether or not to recurse\n     * @return the recursion depth\n     */\n    private static int toMaxDepth(final boolean recursive) {\n        return recursive ? Integer.MAX_VALUE : 1;\n    }\n\n    /**\n     * Converts an array of file extensions to suffixes.\n     *\n     * @param extensions an array of extensions. Format: {\"java\", \"xml\"}\n     * @return an array of suffixes. Format: {\".java\", \".xml\"}\n     * @throws NullPointerException if the parameter is null\n     */\n    private static String[] toSuffixes(final String... extensions) {\n        Objects.requireNonNull(extensions, \"extensions\");\n        final String[] suffixes = new String[extensions.length];\n        for (int i = 0; i < extensions.length; i++) {\n            suffixes[i] = \".\" + extensions[i];\n        }\n        return suffixes;\n    }\n\n    /**\n     * Implements behavior similar to the Unix \"touch\" utility. Creates a new file with size 0, or, if the file exists, just\n     * updates the file's modified time.\n     * <p>\n     * NOTE: As from v1.3, this method throws an IOException if the last modified date of the file cannot be set. Also, as\n     * from v1.3 this method creates parent directories if they do not exist.\n     * </p>\n     *\n     * @param file the File to touch.\n     * @throws NullPointerException if the parameter is {@code null}.\n     * @throws IOException if setting the last-modified time failed or an I/O problem occurs.\n     */\n    public static void touch(final File file) throws IOException {\n        PathUtils.touch(Objects.requireNonNull(file, \"file\").toPath());\n    }\n\n    /**\n     * Converts each of an array of {@link File} to a {@link URL}.\n     * <p>\n     * Returns an array of the same size as the input.\n     * </p>\n     *\n     * @param files the files to convert, must not be {@code null}\n     * @return an array of URLs matching the input\n     * @throws IOException          if a file cannot be converted\n     * @throws NullPointerException if the parameter is null\n     */\n    public static URL[] toURLs(final File... files) throws IOException {\n        Objects.requireNonNull(files, \"files\");\n        final URL[] urls = new URL[files.length];\n        for (int i = 0; i < urls.length; i++) {\n            urls[i] = files[i].toURI().toURL();\n        }\n        return urls;\n    }\n\n    /**\n     * Validates the given arguments.\n     * <ul>\n     * <li>Throws {@link NullPointerException} if {@code source} is null</li>\n     * <li>Throws {@link NullPointerException} if {@code destination} is null</li>\n     * <li>Throws {@link FileNotFoundException} if {@code source} does not exist</li>\n     * </ul>\n     *\n     * @param source      the file or directory to be moved.\n     * @param destination the destination file or directory.\n     * @throws FileNotFoundException if the source file does not exist.\n     */\n    private static void validateMoveParameters(final File source, final File destination) throws FileNotFoundException {\n        Objects.requireNonNull(source, \"source\");\n        Objects.requireNonNull(destination, \"destination\");\n        if (!source.exists()) {\n            throw new FileNotFoundException(\"Source '\" + source + \"' does not exist\");\n        }\n    }\n\n    /**\n     * Waits for the file system to propagate a file creation, with a timeout.\n     * <p>\n     * This method repeatedly tests {@link Files#exists(Path, LinkOption...)} until it returns\n     * true up to the maximum time specified in seconds.\n     * </p>\n     *\n     * @param file    the file to check, must not be {@code null}\n     * @param seconds the maximum time in seconds to wait\n     * @return true if file exists\n     * @throws NullPointerException if the file is {@code null}\n     */\n    public static boolean waitFor(final File file, final int seconds) {\n        Objects.requireNonNull(file, \"file\");\n        return PathUtils.waitFor(file.toPath(), Duration.ofSeconds(seconds), PathUtils.EMPTY_LINK_OPTION_ARRAY);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist using the default encoding for the VM.\n     *\n     * @param file the file to write\n     * @param data the content to write to the file\n     * @throws IOException in case of an I/O error\n     * @since 2.0\n     * @deprecated 2.5 use {@link #write(File, CharSequence, Charset)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static void write(final File file, final CharSequence data) throws IOException {\n        write(file, data, Charset.defaultCharset(), false);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist using the default encoding for the VM.\n     *\n     * @param file   the file to write\n     * @param data   the content to write to the file\n     * @param append if {@code true}, then the data will be added to the\n     *               end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.1\n     * @deprecated 2.5 use {@link #write(File, CharSequence, Charset, boolean)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static void write(final File file, final CharSequence data, final boolean append) throws IOException {\n        write(file, data, Charset.defaultCharset(), append);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charset the name of the requested charset, {@code null} means platform default\n     * @throws IOException in case of an I/O error\n     * @since 2.3\n     */\n    public static void write(final File file, final CharSequence data, final Charset charset) throws IOException {\n        write(file, data, charset, false);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charset the charset to use, {@code null} means platform default\n     * @param append   if {@code true}, then the data will be added to the\n     *                 end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.3\n     */\n    public static void write(final File file, final CharSequence data, final Charset charset, final boolean append) throws IOException {\n        writeStringToFile(file, Objects.toString(data, null), charset, append);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 2.0\n     */\n    public static void write(final File file, final CharSequence data, final String charsetName) throws IOException {\n        write(file, data, charsetName, false);\n    }\n\n    /**\n     * Writes a CharSequence to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @param append   if {@code true}, then the data will be added to the\n     *                 end of the file rather than overwriting\n     * @throws IOException                 in case of an I/O error\n     * @throws java.nio.charset.UnsupportedCharsetException thrown instead of {@link java.io\n     * .UnsupportedEncodingException} in version 2.2 if the encoding is not supported by the VM\n     * @since 2.1\n     */\n    public static void write(final File file, final CharSequence data, final String charsetName, final boolean append) throws IOException {\n        write(file, data, Charsets.toCharset(charsetName), append);\n    }\n\n    // Must be called with a directory\n\n    /**\n     * Writes a byte array to a file creating the file if it does not exist.\n     * <p>\n     * NOTE: As from v1.3, the parent directories of the file will be created\n     * if they do not exist.\n     * </p>\n     *\n     * @param file the file to write to\n     * @param data the content to write to the file\n     * @throws IOException in case of an I/O error\n     * @since 1.1\n     */\n    public static void writeByteArrayToFile(final File file, final byte[] data) throws IOException {\n        writeByteArrayToFile(file, data, false);\n    }\n\n    /**\n     * Writes a byte array to a file creating the file if it does not exist.\n     *\n     * @param file   the file to write to\n     * @param data   the content to write to the file\n     * @param append if {@code true}, then bytes will be added to the\n     *               end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.1\n     */\n    public static void writeByteArrayToFile(final File file, final byte[] data, final boolean append) throws IOException {\n        writeByteArrayToFile(file, data, 0, data.length, append);\n    }\n\n    /**\n     * Writes {@code len} bytes from the specified byte array starting\n     * at offset {@code off} to a file, creating the file if it does\n     * not exist.\n     *\n     * @param file the file to write to\n     * @param data the content to write to the file\n     * @param off  the start offset in the data\n     * @param len  the number of bytes to write\n     * @throws IOException in case of an I/O error\n     * @since 2.5\n     */\n    public static void writeByteArrayToFile(final File file, final byte[] data, final int off, final int len) throws IOException {\n        writeByteArrayToFile(file, data, off, len, false);\n    }\n\n    /**\n     * Writes {@code len} bytes from the specified byte array starting\n     * at offset {@code off} to a file, creating the file if it does\n     * not exist.\n     *\n     * @param file   the file to write to\n     * @param data   the content to write to the file\n     * @param off    the start offset in the data\n     * @param len    the number of bytes to write\n     * @param append if {@code true}, then bytes will be added to the\n     *               end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.5\n     */\n    public static void writeByteArrayToFile(final File file, final byte[] data, final int off, final int len, final boolean append) throws IOException {\n        try (OutputStream out = newOutputStream(file, append)) {\n            out.write(data, off, len);\n        }\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The default VM encoding and the default line ending will be used.\n     *\n     * @param file  the file to write to\n     * @param lines the lines to write, {@code null} entries produce blank lines\n     * @throws IOException in case of an I/O error\n     * @since 1.3\n     */\n    public static void writeLines(final File file, final Collection<?> lines) throws IOException {\n        writeLines(file, null, lines, null, false);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The default VM encoding and the default line ending will be used.\n     *\n     * @param file   the file to write to\n     * @param lines  the lines to write, {@code null} entries produce blank lines\n     * @param append if {@code true}, then the lines will be added to the\n     *               end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.1\n     */\n    public static void writeLines(final File file, final Collection<?> lines, final boolean append) throws IOException {\n        writeLines(file, null, lines, null, append);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The default VM encoding and the specified line ending will be used.\n     *\n     * @param file       the file to write to\n     * @param lines      the lines to write, {@code null} entries produce blank lines\n     * @param lineEnding the line separator to use, {@code null} is system default\n     * @throws IOException in case of an I/O error\n     * @since 1.3\n     */\n    public static void writeLines(final File file, final Collection<?> lines, final String lineEnding) throws IOException {\n        writeLines(file, null, lines, lineEnding, false);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The default VM encoding and the specified line ending will be used.\n     *\n     * @param file       the file to write to\n     * @param lines      the lines to write, {@code null} entries produce blank lines\n     * @param lineEnding the line separator to use, {@code null} is system default\n     * @param append     if {@code true}, then the lines will be added to the\n     *                   end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.1\n     */\n    public static void writeLines(final File file, final Collection<?> lines, final String lineEnding, final boolean append) throws IOException {\n        writeLines(file, null, lines, lineEnding, append);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The specified character encoding and the default line ending will be used.\n     * <p>\n     * NOTE: As from v1.3, the parent directories of the file will be created\n     * if they do not exist.\n     * </p>\n     *\n     * @param file     the file to write to\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @param lines    the lines to write, {@code null} entries produce blank lines\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 1.1\n     */\n    public static void writeLines(final File file, final String charsetName, final Collection<?> lines) throws IOException {\n        writeLines(file, charsetName, lines, null, false);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line, optionally appending.\n     * The specified character encoding and the default line ending will be used.\n     *\n     * @param file     the file to write to\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @param lines    the lines to write, {@code null} entries produce blank lines\n     * @param append   if {@code true}, then the lines will be added to the\n     *                 end of the file rather than overwriting\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 2.1\n     */\n    public static void writeLines(final File file, final String charsetName, final Collection<?> lines, final boolean append) throws IOException {\n        writeLines(file, charsetName, lines, null, append);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The specified character encoding and the line ending will be used.\n     * <p>\n     * NOTE: As from v1.3, the parent directories of the file will be created\n     * if they do not exist.\n     * </p>\n     *\n     * @param file       the file to write to\n     * @param charsetName   the name of the requested charset, {@code null} means platform default\n     * @param lines      the lines to write, {@code null} entries produce blank lines\n     * @param lineEnding the line separator to use, {@code null} is system default\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 1.1\n     */\n    public static void writeLines(final File file, final String charsetName, final Collection<?> lines, final String lineEnding) throws IOException {\n        writeLines(file, charsetName, lines, lineEnding, false);\n    }\n\n    /**\n     * Writes the {@code toString()} value of each item in a collection to\n     * the specified {@link File} line by line.\n     * The specified character encoding and the line ending will be used.\n     *\n     * @param file       the file to write to\n     * @param charsetName   the name of the requested charset, {@code null} means platform default\n     * @param lines      the lines to write, {@code null} entries produce blank lines\n     * @param lineEnding the line separator to use, {@code null} is system default\n     * @param append     if {@code true}, then the lines will be added to the\n     *                   end of the file rather than overwriting\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 2.1\n     */\n    public static void writeLines(final File file, final String charsetName, final Collection<?> lines, final String lineEnding, final boolean append)\n        throws IOException {\n        try (OutputStream out = new BufferedOutputStream(newOutputStream(file, append))) {\n            IOUtils.writeLines(lines, lineEnding, out, charsetName);\n        }\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist using the default encoding for the VM.\n     *\n     * @param file the file to write\n     * @param data the content to write to the file\n     * @throws IOException in case of an I/O error\n     * @deprecated 2.5 use {@link #writeStringToFile(File, String, Charset)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static void writeStringToFile(final File file, final String data) throws IOException {\n        writeStringToFile(file, data, Charset.defaultCharset(), false);\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist using the default encoding for the VM.\n     *\n     * @param file   the file to write\n     * @param data   the content to write to the file\n     * @param append if {@code true}, then the String will be added to the\n     *               end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.1\n     * @deprecated 2.5 use {@link #writeStringToFile(File, String, Charset, boolean)} instead (and specify the appropriate encoding)\n     */\n    @Deprecated\n    public static void writeStringToFile(final File file, final String data, final boolean append) throws IOException {\n        writeStringToFile(file, data, Charset.defaultCharset(), append);\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist.\n     * <p>\n     * NOTE: As from v1.3, the parent directories of the file will be created\n     * if they do not exist.\n     * </p>\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charset the charset to use, {@code null} means platform default\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     * @since 2.4\n     */\n    public static void writeStringToFile(final File file, final String data, final Charset charset) throws IOException {\n        writeStringToFile(file, data, charset, false);\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charset the charset to use, {@code null} means platform default\n     * @param append   if {@code true}, then the String will be added to the\n     *                 end of the file rather than overwriting\n     * @throws IOException in case of an I/O error\n     * @since 2.3\n     */\n    public static void writeStringToFile(final File file, final String data, final Charset charset, final boolean append) throws IOException {\n        try (OutputStream out = newOutputStream(file, append)) {\n            IOUtils.write(data, out, charset);\n        }\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist.\n     * <p>\n     * NOTE: As from v1.3, the parent directories of the file will be created\n     * if they do not exist.\n     * </p>\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @throws IOException                          in case of an I/O error\n     * @throws java.io.UnsupportedEncodingException if the encoding is not supported by the VM\n     */\n    public static void writeStringToFile(final File file, final String data, final String charsetName) throws IOException {\n        writeStringToFile(file, data, charsetName, false);\n    }\n\n    /**\n     * Writes a String to a file creating the file if it does not exist.\n     *\n     * @param file     the file to write\n     * @param data     the content to write to the file\n     * @param charsetName the name of the requested charset, {@code null} means platform default\n     * @param append   if {@code true}, then the String will be added to the\n     *                 end of the file rather than overwriting\n     * @throws IOException                 in case of an I/O error\n     * @throws java.nio.charset.UnsupportedCharsetException thrown instead of {@link java.io\n     * .UnsupportedEncodingException} in version 2.2 if the encoding is not supported by the VM\n     * @since 2.1\n     */\n    public static void writeStringToFile(final File file, final String data, final String charsetName, final boolean append) throws IOException {\n        writeStringToFile(file, data, Charsets.toCharset(charsetName), append);\n    }\n\n    /**\n     * Instances should NOT be constructed in standard programming.\n     * @deprecated Will be private in 3.0.\n     */\n    @Deprecated\n    public FileUtils() { //NOSONAR\n\n    }\n\n}\n            ").toString())};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda-0(DataflowInsanityTest this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(this$0){
                final /* synthetic */ DataflowInsanityTest this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl2, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    new JavaIsoVisitor<ExecutionContext>(this.this$0){
                        final /* synthetic */ DataflowInsanityTest this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        @NotNull
                        public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method2, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(this.this$0){
                                final /* synthetic */ DataflowInsanityTest this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                @NotNull
                                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method2, @NotNull ExecutionContext p) {
                                    Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                                    this.this$0.doRunDataFlow((JavaIsoVisitor<ExecutionContext>)((JavaIsoVisitor)this));
                                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method2, (Object)p);
                                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, p)");
                                    return methodInvocation2;
                                }
                            });
                            return method2;
                        }
                    }.visitNonNull((Tree)classDecl2, (Object)p, this.getCursor());
                    return classDecl2;
                }

                @NotNull
                public Expression visitExpression(@NotNull Expression expression, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.this$0.doRunDataFlow((JavaIsoVisitor<ExecutionContext>)((JavaIsoVisitor)this));
                    Expression expression2 = super.visitExpression(expression, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"super.visitExpression(expression, p)");
                    return expression2;
                }
            };
        }
    }
}

