/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.MinimumSwitchCases;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/MinimumSwitchCasesTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "importsOnEnum", "jp", "Lorg/openrewrite/java/JavaParser;", "noCases", "onePrimitive", "oneString", "primitiveAndDefault", "removeBreaksFromCaseBody", "stringAndDefault", "twoPrimitives", "twoStrings", "rewrite-java-tck"})
public interface MinimumSwitchCasesTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void primitiveAndDefault(@NotNull JavaParser var1);

    @Test
    public void twoPrimitives(@NotNull JavaParser var1);

    @Test
    public void stringAndDefault(@NotNull JavaParser var1);

    @Test
    public void twoStrings(@NotNull JavaParser var1);

    @Test
    public void onePrimitive(@NotNull JavaParser var1);

    @Test
    public void oneString(@NotNull JavaParser var1);

    @Test
    public void noCases(@NotNull JavaParser var1);

    @Test
    public void importsOnEnum(@NotNull JavaParser var1);

    @Test
    public void removeBreaksFromCaseBody(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull MinimumSwitchCasesTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new MinimumSwitchCases());
        }

        @Test
        public static void primitiveAndDefault(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    int variable;\n                    void test() {\n                        switch (variable) {\n                          case 0:\n                              doSomething();\n                              break;\n                          default:\n                              doSomethingElse();\n                              break;\n                        }\n                    }\n                }\n            ", (String)"\n                class Test {\n                    int variable;\n                    void test() {\n                        if (variable == 0) {\n                            doSomething();\n                        } else {\n                            doSomethingElse();\n                        }\n                    }\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.primitiveAndDefault$lambda-0(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void twoPrimitives(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                      case 0:\n                          doSomething();\n                          break;\n                      case 1:\n                          doSomethingElse();\n                          break;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                int variable;\n                void test() {\n                    if (variable == 0) {\n                        doSomething();\n                    } else if (variable == 1) {\n                        doSomethingElse();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.twoPrimitives$lambda-1(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void stringAndDefault(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                      default:\n                          doSomethingElse();\n                          break;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    } else {\n                        doSomethingElse();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.stringAndDefault$lambda-2(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void twoStrings(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                      case \"jon\":\n                          doSomethingElse();\n                          break;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    } else if (\"jon\".equals(name)) {\n                        doSomethingElse();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.twoStrings$lambda-3(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void onePrimitive(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                      case 0:\n                          doSomething();\n                          break;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                int variable;\n                void test() {\n                    if (variable == 0) {\n                        doSomething();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.onePrimitive$lambda-4(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void oneString(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.oneString$lambda-5(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void noCases(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.noCases$lambda-6(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void importsOnEnum(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.time.DayOfWeek;\n\n            class Test {\n                DayOfWeek day;\n\n                void test() {\n                    switch(day) {\n                        case MONDAY:\n                            someMethod();\n                            break;\n                    }\n                    switch(day) {\n                        case MONDAY:\n                            someMethod();\n                        default:\n                            someMethod();\n                            break;\n                    }\n                    switch (day) {\n                        case MONDAY:\n                            someMethod();\n                            break;\n                        case TUESDAY:\n                            someMethod();\n                            break;\n                    }\n                }\n\n                void someMethod() {\n                }\n            }\n        ", (String)"\n            import java.time.DayOfWeek;\n\n            class Test {\n                DayOfWeek day;\n\n                void test() {\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    }\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    } else {\n                        someMethod();\n                    }\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    } else if (day == DayOfWeek.TUESDAY) {\n                        someMethod();\n                    }\n                }\n\n                void someMethod() {\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.importsOnEnum$lambda-7(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void removeBreaksFromCaseBody(@NotNull MinimumSwitchCasesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\": {\n                          doSomething();\n                          break;\n                      }\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.removeBreaksFromCaseBody$lambda-8(jp, arg_0), sourceSpecsArray);
        }

        private static void primitiveAndDefault$lambda-0(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void twoPrimitives$lambda-1(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void stringAndDefault$lambda-2(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void twoStrings$lambda-3(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void onePrimitive$lambda-4(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void oneString$lambda-5(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }

        private static void noCases$lambda-6(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
        }

        private static void importsOnEnum$lambda-7(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
        }

        private static void removeBreaksFromCaseBody$lambda-8(JavaParser $jp, RecipeSpec s) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            s.parser((Parser)$jp);
            s.typeValidationOptions(new TypeValidation().methodInvocations(false));
        }
    }
}

