/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.Java8ParserInputFileObject;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.ReloadableJava8ParserVisitor;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.lombok.LombokSupport;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

class ReloadableJava8Parser
implements JavaParser {
    private final JavaTypeCache typeCache;
    private @Nullable Collection<Path> classpath;
    private final @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
    Parser.Input> dependsOn;
    private final JavacFileManager pfm;
    private final Context context;
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog;
    private final Collection<NamedStyles> styles;
    private final java.util.List<Processor> annotationProcessors;

    ReloadableJava8Parser(@Nullable Collection<Path> classpath, Collection<byte[]> classBytesClasspath, @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
    Parser.Input> dependsOn, Charset charset, final boolean logCompilationWarningsAndErrors, Collection<NamedStyles> styles, JavaTypeCache typeCache) {
        this.classpath = classpath;
        this.dependsOn = dependsOn;
        this.styles = styles;
        this.typeCache = typeCache;
        this.context = new Context();
        this.compilerLog = new ResettableLog(this.context);
        this.pfm = new ByteArrayCapableJavacFileManager(this.context, true, charset, classBytesClasspath);
        this.context.put(JavaFileManager.class, this.pfm);
        Options.instance(this.context).put("allowStringFolding", "false");
        Options.instance(this.context).put("compilePolicy", "attr");
        Options.instance(this.context).put("-implicit", "none");
        Options.instance(this.context).put("-g", "-g");
        Options.instance(this.context).put("-proc", "none");
        Options.instance(this.context).put("should-stop.ifError", "GENERATE");
        this.annotationProcessors = new ArrayList<Processor>(1);
        if (System.getenv().getOrDefault("REWRITE_LOMBOK", System.getProperty("rewrite.lombok")) != null && classpath != null && classpath.stream().anyMatch(it -> it.toString().contains("lombok"))) {
            try {
                Processor lombokProcessor = LombokSupport.createLombokProcessor((ClassLoader)this.getClass().getClassLoader());
                if (lombokProcessor != null) {
                    Options.instance(this.context).put(Option.PROCESSOR, "lombok.launch.AnnotationProcessorHider$AnnotationProcessor");
                    this.annotationProcessors.add(lombokProcessor);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compiler.lineDebugInfo = false;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log;
                if (logCompilationWarningsAndErrors && !StringUtils.isBlank((String)(log = new String(Arrays.copyOfRange(cbuf, off, len))))) {
                    LoggerFactory.getLogger(ReloadableJava8Parser.class).warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
        this.compileDependencies();
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> cus = this.parseInputsToCompilerAst(sourceFiles, ctx);
        return cus.entrySet().stream().map(cuByPath -> {
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            parsingListener.startedParsing(input);
            try {
                ReloadableJava8ParserVisitor parser = new ReloadableJava8ParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), input.getSource(ctx), this.styles, this.typeCache, ctx, this.context);
                J.CompilationUnit cu = (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Space.EMPTY);
                cuByPath.setValue(null);
                parsingListener.parsed(input, (SourceFile)cu);
                return this.requirePrintEqualsInput((SourceFile)cu, input, relativeTo, ctx);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> parseInputsToCompilerAst(Iterable<Parser.Input> sourceFiles, ExecutionContext ctx) {
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocation(StandardLocation.CLASS_PATH, this.classpath.stream().map(Path::toFile).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> cus = new LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit>();
        java.util.List inputFileObjects = this.acceptedInputs(sourceFiles).map(input -> new Java8ParserInputFileObject((Parser.Input)input, ctx)).collect(Collectors.toList());
        if (!this.annotationProcessors.isEmpty()) {
            this.compiler.initProcessAnnotations(this.annotationProcessors);
        }
        try {
            List jcCompilationUnits = List.from(inputFileObjects.stream().map(input -> this.compiler.parse((JavaFileObject)input)).toArray(JCTree.JCCompilationUnit[]::new));
            for (int i = 0; i < inputFileObjects.size(); ++i) {
                cus.put(((Java8ParserInputFileObject)inputFileObjects.get(i)).getInput(), (JCTree.JCCompilationUnit)jcCompilationUnits.get(i));
            }
            try {
                this.enterAll(cus.values());
                JavaCompiler delegate = this.annotationProcessors.isEmpty() ? this.compiler : this.compiler.processAnnotations(jcCompilationUnits, List.nil());
                delegate.attribute(delegate.todo);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(new JavaParsingException("Failed symbol entering or attribution", t));
            }
        }
        catch (IllegalStateException e) {
            if ("endPosTable already set".equals(e.getMessage())) {
                throw new IllegalStateException("Call reset() on JavaParser before parsing another set of source files that have some of the same fully qualified names.", e);
            }
            throw e;
        }
        return cus;
    }

    public ReloadableJava8Parser reset() {
        this.typeCache.clear();
        this.compilerLog.reset();
        this.pfm.flush();
        this.compileDependencies();
        return this;
    }

    public JavaParser reset(Collection<URI> uris) {
        if (!uris.isEmpty()) {
            this.compilerLog.reset(uris);
        }
        this.pfm.flush();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.classpath = classpath;
    }

    private void compileDependencies() {
        if (this.dependsOn != null) {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext();
            ctx.putMessage("org.openrewrite.java.skipSourceSetMarker", (Object)true);
            this.parseInputs(this.dependsOn, null, (ExecutionContext)ctx);
        }
        Check.instance((Context)this.context).compiled.clear();
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from(cus.toArray(new JCTree.JCCompilationUnit[0]));
        enter.main(compilationUnits);
    }

    private static class PackageAwareJavaFileObject
    extends SimpleJavaFileObject {
        private final String pkg;
        private final String className;
        private final byte[] classBytes;

        private PackageAwareJavaFileObject(byte[] classBytes) {
            super(URI.create("file:///.byteArray"), JavaFileObject.Kind.CLASS);
            final AtomicReference pkgRef = new AtomicReference();
            final AtomicReference nameRef = new AtomicReference();
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept(new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (name.contains("/")) {
                        pkgRef.set(name.substring(0, name.lastIndexOf(47)).replace('/', '.'));
                        nameRef.set(name.substring(name.lastIndexOf(47) + 1));
                    } else {
                        pkgRef.set(name);
                        nameRef.set(name);
                    }
                }
            }, 7);
            this.pkg = (String)pkgRef.get();
            this.className = (String)nameRef.get();
            this.classBytes = classBytes;
        }

        public String getPackage() {
            return this.pkg;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.classBytes);
        }

        @Generated
        public String getClassName() {
            return this.className;
        }
    }

    private static class ByteArrayCapableJavacFileManager
    extends JavacFileManager {
        private final java.util.List<PackageAwareJavaFileObject> classByteClasspath;

        public ByteArrayCapableJavacFileManager(Context context, boolean register, Charset charset, Collection<byte[]> classByteClasspath) {
            super(context, register, charset);
            this.classByteClasspath = classByteClasspath.stream().map(x$0 -> new PackageAwareJavaFileObject((byte[])x$0)).collect(Collectors.toList());
        }

        @Override
        public boolean isSameFile(FileObject fileObject, FileObject fileObject1) {
            return fileObject.equals(fileObject1);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof PackageAwareJavaFileObject) {
                return ((PackageAwareJavaFileObject)file).getClassName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (StandardLocation.CLASS_PATH == location) {
                Iterable<JavaFileObject> listed = super.list(location, packageName, kinds, recurse);
                return Stream.concat(this.classByteClasspath.stream().filter(jfo -> jfo.getPackage().equals(packageName)), StreamSupport.stream(listed.spliterator(), false)).collect(Collectors.toList());
            }
            return super.list(location, packageName, kinds, recurse);
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }

        public void reset(Collection<URI> uris) {
            Iterator itr = this.sourceMap.keySet().iterator();
            while (itr.hasNext()) {
                JavaFileObject f = (JavaFileObject)itr.next();
                if (!uris.contains(f.toUri())) continue;
                itr.remove();
            }
        }
    }
}

