/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.LoggingHandler;
import org.openrewrite.java.tree.J;

public class Java8Parser
implements JavaParser {
    private final JavaParser delegate;

    Java8Parser(JavaParser delegate) {
        this.delegate = delegate;
    }

    public List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.delegate.parseInputs(sourceFiles, relativeTo, ctx);
    }

    public JavaParser reset() {
        return this.delegate.reset();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JavaParser.Builder<Java8Parser, Builder> {
        @Nullable
        private static ClassLoader toolsClassLoader;
        @Nullable
        private static ClassLoader toolsAwareClassLoader;
        @Nullable
        private LoggingHandler loggingHandler;

        static synchronized void lazyInitClassLoaders() {
            if (toolsClassLoader != null && toolsAwareClassLoader != null) {
                return;
            }
            try {
                File tools = Paths.get(System.getProperty("java.home"), new String[0]).resolve("../lib/tools.jar").toFile();
                if (!tools.exists()) {
                    throw new IllegalStateException("To use Java8Parser, you must run the process with a JDK and not a JRE.");
                }
                toolsClassLoader = new URLClassLoader(new URL[]{tools.toURI().toURL()}, Java8Parser.class.getClassLoader());
                URLClassLoader appClassLoader = (URLClassLoader)Java8Parser.class.getClassLoader();
                toolsAwareClassLoader = new URLClassLoader(appClassLoader.getURLs(), toolsClassLoader){

                    @Override
                    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        if (!(name.contains("ReloadableJava8Parser") || name.startsWith("com.sun.tools") || name.startsWith("com.sun.source"))) {
                            return toolsClassLoader.loadClass(name);
                        }
                        Class<?> loadedClass = this.findLoadedClass(name);
                        if (loadedClass == null) {
                            try {
                                loadedClass = this.findClass(name);
                            }
                            catch (ClassNotFoundException e) {
                                loadedClass = super.loadClass(name, resolve);
                            }
                        }
                        if (resolve) {
                            this.resolveClass(loadedClass);
                        }
                        return loadedClass;
                    }
                };
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("To use Java8Parser, you must run the process with a JDK and not a JRE.", e);
            }
        }

        public Builder loggingHandler(LoggingHandler loggingHandler) {
            this.loggingHandler = loggingHandler;
            return this;
        }

        public Java8Parser build() {
            Builder.lazyInitClassLoaders();
            try {
                Class<?> reloadableParser = Class.forName("org.openrewrite.java.ReloadableJava8Parser", true, toolsAwareClassLoader);
                Constructor<?> delegateParserConstructor = reloadableParser.getDeclaredConstructor(Collection.class, Charset.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Collection.class, LoggingHandler.class);
                delegateParserConstructor.setAccessible(true);
                JavaParser delegate = (JavaParser)delegateParserConstructor.newInstance(this.classpath, this.charset, this.relaxedClassTypeMatching, this.suppressMappingErrors, this.logCompilationWarningsAndErrors, this.styles, this.loggingHandler);
                return new Java8Parser(delegate);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to construct Java8Parser.", e);
            }
        }
    }
}

