/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.hcl.internal.grammar.JsonPathLexer;
import org.openrewrite.hcl.internal.grammar.JsonPathParser;
import org.openrewrite.hcl.internal.grammar.JsonPathParserBaseVisitor;
import org.openrewrite.hcl.tree.Hcl;

public class JsonPathMatcher {
    private final String jsonPath;
    private @Nullable JsonPathParser.JsonPathContext parsed;

    public JsonPathMatcher(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public <T> Optional<T> find(Cursor cursor) {
        return this.find0(cursor, JsonPathMatcher.resolvedAncestors(cursor));
    }

    private <T> Optional<T> find0(Cursor cursor, List<Tree> cursorPath) {
        if (cursorPath.isEmpty()) {
            return Optional.empty();
        }
        Tree start = this.jsonPath.startsWith(".") && !this.jsonPath.startsWith("..") ? (Tree)cursor.getValue() : cursorPath.get(0);
        JsonPathParser.JsonPathContext ctx = this.parse();
        JsonPathParser.ExpressionContext stop = (JsonPathParser.ExpressionContext)((Object)ctx.children.get(ctx.children.size() - 1));
        JsonPathParserHclVisitor v = new JsonPathParserHclVisitor(cursorPath, start, stop, false);
        Object result = v.visit((ParseTree)ctx);
        return Optional.ofNullable(result);
    }

    public boolean matches(Cursor cursor) {
        List<Tree> cursorPath = JsonPathMatcher.resolvedAncestors(cursor);
        return this.find0(cursor, cursorPath).map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return !Collections.disjoint(l, cursorPath) && l.contains(cursor.getValue());
            }
            return Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    private static List<Tree> resolvedAncestors(Cursor cursor) {
        ArrayDeque<Tree> deque = new ArrayDeque<Tree>();
        Iterator it = cursor.getPath(Tree.class::isInstance);
        while (it.hasNext()) {
            Tree tree = (Tree)it.next();
            deque.addFirst(tree);
        }
        return new ArrayList<Tree>(deque);
    }

    private JsonPathParser.JsonPathContext parse() {
        if (this.parsed == null) {
            this.parsed = this.jsonPath().jsonPath();
        }
        return this.parsed;
    }

    private JsonPathParser jsonPath() {
        return new JsonPathParser((TokenStream)new CommonTokenStream((TokenSource)new JsonPathLexer((CharStream)CharStreams.fromString((String)this.jsonPath))));
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonPathMatcher)) {
            return false;
        }
        JsonPathMatcher other = (JsonPathMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jsonPath = this.jsonPath;
        String other$jsonPath = other.jsonPath;
        if (this$jsonPath == null ? other$jsonPath != null : !this$jsonPath.equals(other$jsonPath)) {
            return false;
        }
        JsonPathParser.JsonPathContext this$parsed = this.parsed;
        JsonPathParser.JsonPathContext other$parsed = other.parsed;
        return !(this$parsed == null ? other$parsed != null : !((Object)((Object)this$parsed)).equals((Object)other$parsed));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof JsonPathMatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jsonPath = this.jsonPath;
        result = result * 59 + ($jsonPath == null ? 43 : $jsonPath.hashCode());
        JsonPathParser.JsonPathContext $parsed = this.parsed;
        result = result * 59 + ($parsed == null ? 43 : ((Object)((Object)$parsed)).hashCode());
        return result;
    }

    private static class JsonPathParserHclVisitor
    extends JsonPathParserBaseVisitor<Object> {
        private final List<Tree> cursorPath;
        protected Object scope;
        private final JsonPathParser.ExpressionContext stop;
        private final boolean isRecursiveDescent;

        public JsonPathParserHclVisitor(List<Tree> cursorPath, Object scope, JsonPathParser.ExpressionContext stop, boolean isRecursiveDescent) {
            this.cursorPath = cursorPath;
            this.scope = scope;
            this.stop = stop;
            this.isRecursiveDescent = isRecursiveDescent;
        }

        protected Object defaultResult() {
            return this.scope;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            this.scope = nextResult;
            return this.scope;
        }

        protected boolean shouldVisitNextChild(RuleNode node, Object currentResult) {
            return this.scope != null;
        }

        @Override
        public Object visitJsonPath(JsonPathParser.JsonPathContext ctx) {
            if (ctx.ROOT() != null || "[".equals(ctx.start.getText())) {
                this.scope = this.cursorPath.stream().filter(t -> t instanceof Hcl.Block).findFirst().orElseGet(() -> this.cursorPath.stream().filter(t -> t instanceof Hcl.ConfigFile).findFirst().orElse(null));
            }
            return super.visitJsonPath(ctx);
        }

        @Override
        public @Nullable Object visitRecursiveDecent(JsonPathParser.RecursiveDecentContext ctx) {
            if (this.scope == null) {
                return null;
            }
            Object result = null;
            List previous = ctx.getParent().getParent().children;
            ParserRuleContext current = ctx.getParent();
            if (previous.indexOf(current) < 1 || "$".equals(((ParseTree)previous.get(previous.indexOf(current) - 1)).getText())) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Tree path : this.cursorPath) {
                    JsonPathParserHclVisitor v = new JsonPathParserHclVisitor(this.cursorPath, path, null, false);
                    for (int i = 1; i < ctx.getChildCount(); ++i) {
                        result = v.visit(ctx.getChild(i));
                        if (result == null) continue;
                        results.add(result);
                    }
                }
                return results;
            }
            JsonPathParserHclVisitor v = new JsonPathParserHclVisitor(this.cursorPath, this.scope, null, true);
            for (int i = 1; i < ctx.getChildCount() && (result = v.visit(ctx.getChild(i))) == null; ++i) {
            }
            return result;
        }

        @Override
        public @Nullable Object visitBracketOperator(JsonPathParser.BracketOperatorContext ctx) {
            if (!ctx.property().isEmpty()) {
                if (ctx.property().size() == 1) {
                    return this.visitProperty(ctx.property(0));
                }
                return ctx.property().stream().map(this::visitProperty).collect(Collectors.toList());
            }
            if (ctx.slice() != null) {
                return this.visitSlice(ctx.slice());
            }
            if (ctx.indexes() != null) {
                return this.visitIndexes(ctx.indexes());
            }
            if (ctx.filter() != null) {
                return this.visitFilter(ctx.filter());
            }
            return null;
        }

        @Override
        public Object visitSlice(JsonPathParser.SliceContext ctx) {
            ArrayList results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else {
                if (this.scope instanceof Hcl.Attribute) {
                    this.scope = ((Hcl.Attribute)this.scope).getValue();
                    return this.visitSlice(ctx);
                }
                results = new ArrayList();
            }
            int start = 0;
            int limit = Integer.MAX_VALUE;
            if (ctx.PositiveNumber() != null) {
                limit = Integer.parseInt(ctx.PositiveNumber().getText());
            } else if (ctx.NegativeNumber() != null) {
                start = results.size() + Integer.parseInt(ctx.NegativeNumber().getText());
            } else if (ctx.start() != null) {
                start = ctx.start() != null ? Integer.parseInt(ctx.start().getText()) : 0;
                limit = ctx.end() != null ? Integer.parseInt(ctx.end().getText()) + 1 : limit;
            }
            return results.stream().skip(start).limit(limit).collect(Collectors.toList());
        }

        @Override
        public Object visitIndexes(JsonPathParser.IndexesContext ctx) {
            ArrayList results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else {
                if (this.scope instanceof Hcl.Attribute) {
                    this.scope = ((Hcl.Attribute)this.scope).getValue();
                    return this.visitIndexes(ctx);
                }
                results = new ArrayList();
            }
            ArrayList indexes = new ArrayList();
            for (TerminalNode terminalNode : ctx.PositiveNumber()) {
                for (int i = 0; i < results.size(); ++i) {
                    if (!terminalNode.getText().equals(String.valueOf(i))) continue;
                    indexes.add(results.get(i));
                }
            }
            return this.getResultFromList(indexes);
        }

        @Override
        public @Nullable Object visitProperty(JsonPathParser.PropertyContext ctx) {
            if (this.scope instanceof Hcl.Block) {
                String name;
                Hcl.Block block = (Hcl.Block)this.scope;
                ArrayList<Object> matches = new ArrayList<Object>();
                String key = block.getType().getName();
                String string = name = ctx.StringLiteral() != null ? JsonPathParserHclVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                if (this.isRecursiveDescent) {
                    if (key.equals(name)) {
                        matches.add(block);
                    }
                    this.scope = block.getBody();
                    Object result = this.getResultFromList(this.visitProperty(ctx));
                    if (result != null) {
                        matches.add(result);
                    }
                    return this.getResultFromList(matches);
                }
                if (key.equals(name)) {
                    if (this.stop != null && this.getExpressionContext(ctx) == this.stop) {
                        return block;
                    }
                    this.scope = block.getBody();
                    return block.getBody();
                }
            } else if (this.scope instanceof Hcl.Attribute) {
                String name;
                Hcl.Attribute attribute = (Hcl.Attribute)this.scope;
                String key = attribute.getSimpleName();
                String string = name = ctx.StringLiteral() != null ? JsonPathParserHclVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                if (key.equals(name)) {
                    return attribute;
                }
            } else if (this.scope instanceof List) {
                List results = ((List)this.scope).stream().map(o -> {
                    this.scope = o;
                    return this.visitProperty(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                ArrayList matches = new ArrayList();
                for (Object result : results) {
                    if (result instanceof List) {
                        matches.addAll((List)result);
                        continue;
                    }
                    matches.add(result);
                }
                return this.getResultFromList(matches);
            }
            return null;
        }

        private JsonPathParser.ExpressionContext getExpressionContext(ParserRuleContext ctx) {
            if (ctx == null || ctx instanceof JsonPathParser.ExpressionContext) {
                return (JsonPathParser.ExpressionContext)ctx;
            }
            return this.getExpressionContext(ctx.getParent());
        }

        @Override
        public @Nullable Object visitWildcard(JsonPathParser.WildcardContext ctx) {
            if (this.scope instanceof Hcl.Attribute) {
                Hcl.Attribute attr = (Hcl.Attribute)this.scope;
                return attr.getValue();
            }
            if (this.scope instanceof List) {
                List<Object> results = ((List)this.scope).stream().map(o -> {
                    this.scope = o;
                    return this.visitWildcard(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                ArrayList matches = new ArrayList();
                if (this.stop != null && this.stop == this.getExpressionContext(ctx)) {
                    results.forEach(o -> matches.add(this.getValue(o)));
                } else {
                    for (Object t : results) {
                        if (t instanceof List) {
                            matches.addAll((List)t);
                            continue;
                        }
                        matches.add(t);
                    }
                }
                return this.getResultFromList(matches);
            }
            if (this.scope instanceof Hcl.Block) {
                Hcl.Block block = (Hcl.Block)this.scope;
                if (this.stop != null && this.getExpressionContext(ctx) == this.stop) {
                    return block;
                }
                this.scope = block.getBody();
                return block.getBody();
            }
            return null;
        }

        @Override
        public @Nullable Object visitLiteralExpression(JsonPathParser.LiteralExpressionContext ctx) {
            String s = null;
            if (ctx.StringLiteral() != null) {
                s = ctx.StringLiteral().getText();
            } else {
                if (ctx.TRUE() != null || ctx.FALSE() != null) {
                    return Boolean.valueOf(ctx.getText());
                }
                if (!ctx.children.isEmpty()) {
                    s = ((ParseTree)ctx.children.get(0)).getText();
                }
            }
            if (s != null && (s.startsWith("'") || s.startsWith("\""))) {
                return s.substring(1, s.length() - 1);
            }
            return "null".equals(s) ? null : s;
        }

        @Override
        public @Nullable Object visitUnaryExpression(JsonPathParser.UnaryExpressionContext ctx) {
            if (ctx.AT() != null) {
                if (this.scope instanceof Hcl.Literal) {
                    if (ctx.Identifier() == null && ctx.StringLiteral() == null) {
                        return this.scope;
                    }
                } else {
                    if (this.scope instanceof Hcl.Attribute) {
                        Hcl.Attribute attr = (Hcl.Attribute)this.scope;
                        if (ctx.Identifier() != null || ctx.StringLiteral() != null) {
                            String string;
                            String key = attr.getSimpleName();
                            String string2 = string = ctx.StringLiteral() != null ? JsonPathParserHclVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                            if (key.equals(string)) {
                                return attr;
                            }
                        }
                        this.scope = attr.getValue();
                        return this.getResultFromList(this.visitUnaryExpression(ctx));
                    }
                    if (this.scope instanceof Hcl.Block) {
                        Hcl.Block block = (Hcl.Block)this.scope;
                        for (Hcl hcl : block.getBody()) {
                            String key;
                            String name;
                            String string = name = ctx.StringLiteral() != null ? JsonPathParserHclVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                            if (block.getType() instanceof Hcl.Identifier && block.getType().getName().equals(name)) {
                                return block;
                            }
                            if (!(hcl instanceof Hcl.Attribute)) continue;
                            Hcl.Attribute attr = (Hcl.Attribute)hcl;
                            if (ctx.Identifier() == null && ctx.StringLiteral() == null || !(key = attr.getSimpleName()).equals(name)) continue;
                            return block;
                        }
                    } else if (this.scope instanceof List) {
                        List results = ((List)this.scope).stream().map(o -> {
                            this.scope = o;
                            return this.visitUnaryExpression(ctx);
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                        ArrayList matches = new ArrayList();
                        for (Object result : results) {
                            if (result instanceof List) {
                                matches.addAll((List)result);
                                continue;
                            }
                            matches.add(result);
                        }
                        return this.getResultFromList(matches);
                    }
                }
            } else if (ctx.jsonPath() != null) {
                Object result = this.visit((ParseTree)ctx.jsonPath());
                return this.getResultByKey(result, ctx.stop.getText());
            }
            return null;
        }

        @Override
        public @Nullable Object visitRegexExpression(JsonPathParser.RegexExpressionContext ctx) {
            if (this.scope == null || this.scope instanceof List && ((List)this.scope).isEmpty()) {
                return null;
            }
            String rhs = ctx.REGEX().getText();
            Object lhs = this.visitUnaryExpression(ctx.unaryExpression());
            String operator = "=~";
            if (lhs instanceof List) {
                ArrayList matches = new ArrayList();
                for (Object match : (List)lhs) {
                    Hcl result = this.getOperatorResult(match, operator, rhs);
                    if (result == null) continue;
                    matches.add(match);
                }
                return matches;
            }
            return this.getOperatorResult(lhs, operator, rhs);
        }

        @Override
        public @Nullable Object visitContainsExpression(JsonPathParser.ContainsExpressionContext ctx) {
            Object originalScope = this.scope;
            if (ctx.children.get(0) instanceof JsonPathParser.UnaryExpressionContext) {
                Hcl.Literal literal;
                Hcl.Attribute attr;
                String key;
                Hcl.Block block;
                Object lhs = this.visitUnaryExpression(ctx.unaryExpression());
                Object rhs = this.visitLiteralExpression(ctx.literalExpression());
                if (lhs instanceof Hcl.Block && rhs != null && (lhs = this.getResultByKey(block = (Hcl.Block)lhs, key = ((ParseTree)ctx.children.get(0)).getChild(2).getText())) instanceof Hcl.Attribute && (attr = (Hcl.Attribute)lhs).getValue() instanceof Hcl.Literal && (literal = (Hcl.Literal)attr.getValue()).getValue().toString().contains(String.valueOf(rhs))) {
                    return originalScope;
                }
            } else {
                Hcl.Literal literal;
                Hcl.Attribute attr;
                String key;
                Hcl.Block block;
                Object lhs = this.visitLiteralExpression(ctx.literalExpression());
                Object rhs = this.visitUnaryExpression(ctx.unaryExpression());
                if (rhs instanceof Hcl.Block && lhs != null && (rhs = this.getResultByKey(block = (Hcl.Block)rhs, key = ((ParseTree)ctx.children.get(2)).getChild(2).getText())) instanceof Hcl.Attribute && (attr = (Hcl.Attribute)rhs).getValue() instanceof Hcl.Literal && (literal = (Hcl.Literal)attr.getValue()).getValue().toString().contains(String.valueOf(lhs))) {
                    return originalScope;
                }
            }
            return null;
        }

        @Override
        public @Nullable Object visitBinaryExpression(JsonPathParser.BinaryExpressionContext ctx) {
            Object lhs = ctx.children.get(0);
            Object rhs = ctx.children.get(2);
            if (ctx.LOGICAL_OPERATOR() != null) {
                String operator;
                switch (ctx.LOGICAL_OPERATOR().getText()) {
                    case "&&": {
                        operator = "&&";
                        break;
                    }
                    case "||": {
                        operator = "||";
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Object scopeOfLogicalOp = this.scope;
                lhs = this.getBinaryExpressionResult(lhs);
                this.scope = scopeOfLogicalOp;
                rhs = this.getBinaryExpressionResult(rhs);
                if (!(!"&&".equals(operator) || lhs == null || lhs instanceof List && ((List)lhs).isEmpty() || rhs == null || rhs instanceof List && ((List)rhs).isEmpty())) {
                    return scopeOfLogicalOp;
                }
                if (!(!"||".equals(operator) || (lhs == null || lhs instanceof List && ((List)lhs).isEmpty()) && (rhs == null || rhs instanceof List && ((List)rhs).isEmpty()))) {
                    return scopeOfLogicalOp;
                }
            } else if (ctx.EQUALITY_OPERATOR() != null) {
                String operator;
                Object originalScope = this.scope;
                lhs = this.getBinaryExpressionResult(lhs);
                rhs = this.getBinaryExpressionResult(rhs);
                switch (ctx.EQUALITY_OPERATOR().getText()) {
                    case "==": {
                        operator = "==";
                        break;
                    }
                    case "!=": {
                        operator = "!=";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (lhs instanceof List) {
                    ArrayList matches = new ArrayList();
                    for (Object match : (List)lhs) {
                        Hcl result = this.getOperatorResult(match, operator, rhs);
                        if (result == null) continue;
                        matches.add(match);
                    }
                    return matches;
                }
                if (originalScope instanceof Hcl.Attribute) {
                    if (this.getOperatorResult(lhs, operator, rhs) != null) {
                        return originalScope;
                    }
                } else {
                    return this.getOperatorResult(lhs, operator, rhs);
                }
            }
            return null;
        }

        private @Nullable Object getBinaryExpressionResult(Object ctx) {
            if (ctx instanceof JsonPathParser.BinaryExpressionContext) {
                ctx = this.visitBinaryExpression((JsonPathParser.BinaryExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.RegexExpressionContext) {
                ctx = this.visitRegexExpression((JsonPathParser.RegexExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.ContainsExpressionContext) {
                ctx = this.visitContainsExpression((JsonPathParser.ContainsExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.UnaryExpressionContext) {
                ctx = this.visitUnaryExpression((JsonPathParser.UnaryExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.LiteralExpressionContext) {
                ctx = this.visitLiteralExpression((JsonPathParser.LiteralExpressionContext)((Object)ctx));
            }
            return ctx;
        }

        private @Nullable Hcl getOperatorResult(Object lhs, String operator, Object rhs) {
            Hcl.Literal literal;
            if (lhs instanceof Hcl.Attribute) {
                Hcl.VariableExpression variable;
                Hcl.Literal literal2;
                Hcl.Attribute attr = (Hcl.Attribute)lhs;
                if (attr.getValue() instanceof Hcl.Literal ? this.checkObjectEquality((literal2 = (Hcl.Literal)attr.getValue()).getValue(), operator, rhs) : attr.getValue() instanceof Hcl.VariableExpression && this.checkObjectEquality((variable = (Hcl.VariableExpression)attr.getValue()).getName().getName(), operator, rhs)) {
                    return attr;
                }
            } else if (lhs instanceof Hcl.Block) {
                Hcl.Block block = (Hcl.Block)lhs;
                for (Hcl hcl : block.getBody()) {
                    Hcl.Attribute attr;
                    if (!(hcl instanceof Hcl.Attribute) || !((attr = (Hcl.Attribute)hcl).getValue() instanceof Hcl.Literal) || !this.checkObjectEquality(((Hcl.Literal)attr.getValue()).getValue(), operator, rhs)) continue;
                    return block;
                }
            } else if (lhs instanceof Hcl.Literal && this.checkObjectEquality((literal = (Hcl.Literal)lhs).getValue(), operator, rhs)) {
                return literal;
            }
            return null;
        }

        private boolean checkObjectEquality(Object lhs, String operator, Object rhs) {
            BiPredicate<Object, Object> predicate = (lh, rh) -> {
                switch (operator) {
                    case "==": {
                        return Objects.equals(lh, rh);
                    }
                    case "!=": {
                        return !Objects.equals(lh, rh);
                    }
                    case "=~": {
                        return Pattern.compile(rh.toString()).matcher(lh.toString()).matches();
                    }
                }
                return false;
            };
            return predicate.test(lhs, rhs);
        }

        public @Nullable Object getResultByKey(Object result, String key) {
            block4: {
                block5: {
                    block3: {
                        if (!(result instanceof Hcl.Block)) break block3;
                        Hcl.Block block = (Hcl.Block)result;
                        for (Hcl hcl : block.getBody()) {
                            Hcl.Attribute attr;
                            if (!(hcl instanceof Hcl.Attribute) || !(attr = (Hcl.Attribute)hcl).getSimpleName().equals(key)) continue;
                            return attr;
                        }
                        break block4;
                    }
                    if (!(result instanceof Hcl.Attribute)) break block5;
                    Hcl.Attribute attr = (Hcl.Attribute)result;
                    if (attr.getValue() instanceof Hcl.Literal) {
                        return attr.getSimpleName().equals(key) ? attr : null;
                    }
                    break block4;
                }
                if (!(result instanceof List)) break block4;
                for (Object o : (List)result) {
                    Object object = this.getResultByKey(o, key);
                    if (object == null) continue;
                    return object;
                }
            }
            return null;
        }

        private Object getResultFromList(Object results) {
            if (results instanceof List) {
                List matches = (List)results;
                if (matches.isEmpty()) {
                    return null;
                }
                if (matches.size() == 1) {
                    return matches.get(0);
                }
            }
            return results;
        }

        private @Nullable Object getValue(Object result) {
            if (result instanceof Hcl.Attribute) {
                return this.getValue(((Hcl.Attribute)result).getValue());
            }
            if (result instanceof Hcl.Block) {
                return ((Hcl.Block)result).getBody();
            }
            if (result instanceof List) {
                return ((List)result).stream().map(this::getValue).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (result instanceof Hcl.Literal) {
                return ((Hcl.Literal)result).getValue();
            }
            if (result instanceof String) {
                return result;
            }
            return null;
        }

        private static String unquoteStringLiteral(String literal) {
            if (literal != null && (literal.startsWith("'") || literal.startsWith("\""))) {
                return literal.substring(1, literal.length() - 1);
            }
            return "null".equals(literal) ? null : literal;
        }
    }
}

