/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.style.BracketsStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;

public class BracketsVisitor<P>
extends HclIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final BracketsStyle style;

    public BracketsVisitor(BracketsStyle style) {
        this(style, null);
    }

    public BracketsVisitor(BracketsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        if (loc.equals((Object)Space.Location.BLOCK_CLOSE) && !space.getLastWhitespace().contains("\n")) {
            return space.withLastWhitespace("\n");
        }
        if (loc.equals((Object)Space.Location.BLOCK_OPEN) && !space.getWhitespace().equals(" ")) {
            return space.withWhitespace(" ");
        }
        return space;
    }

    @Override
    public <T extends Hcl> HclContainer<T> visitContainer(HclContainer<T> container, HclContainer.Location loc, P p) {
        if (loc == HclContainer.Location.OBJECT_VALUE_ATTRIBUTES) {
            Hcl.ObjectValue ov = (Hcl.ObjectValue)this.getCursor().firstEnclosingOrThrow(Hcl.ObjectValue.class);
            Space lastSpace = container.getLastSpace();
            if (this.isMultiline(ov)) {
                if (!lastSpace.getLastWhitespace().contains("\n")) {
                    return container.withLastSpace(lastSpace.withLastWhitespace("\n"));
                }
            } else {
                return container.withLastSpace(lastSpace.withLastWhitespace(" "));
            }
        }
        return super.visitContainer(container, loc, p);
    }

    @Override
    public Hcl.ObjectValue visitObjectValue(Hcl.ObjectValue ov, P p) {
        boolean multiLine = this.isMultiline(ov);
        if (multiLine) {
            List newAttributes = ListUtils.map(ov.getAttributes(), (i, attr) -> {
                if (!attr.getPrefix().getLastWhitespace().contains("\n")) {
                    return (Expression)attr.withPrefix(attr.getPrefix().withLastWhitespace("\n"));
                }
                return attr;
            });
            return super.visitObjectValue(ov.withArguments(newAttributes), (Object)p);
        }
        List newAttributes = ListUtils.map(ov.getAttributes(), (i, attr) -> (Expression)attr.withPrefix(attr.getPrefix().withWhitespace(" ")));
        return super.visitObjectValue(ov.withArguments(newAttributes), (Object)p);
    }

    private boolean isMultiline(Hcl.ObjectValue ov) {
        boolean multiLine = false;
        for (Expression attribute : ov.getAttributes()) {
            if (!attribute.getPrefix().getLastWhitespace().contains("\n")) continue;
            multiLine = true;
        }
        return multiLine;
    }

    @Override
    public Hcl.Block visitBlock(Hcl.Block block, P p) {
        BodyContent first;
        List<BodyContent> body = block.getBody();
        if (!body.isEmpty() && !(first = body.get(0)).getPrefix().getLastWhitespace().contains("\n")) {
            ArrayList<BodyContent> newBody = new ArrayList<BodyContent>(body);
            newBody.set(0, first.withPrefix(first.getPrefix().withWhitespace("\n")));
            return super.visitBlock(block.withBody(newBody), (Object)p);
        }
        return super.visitBlock(block, (Object)p);
    }

    @Nullable
    public Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

