/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public final class UpdateJavaCompatibility
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    @Option(displayName="Compatibility Type", description="The compatibility type to change", valid={"source", "target"}, required=false)
    @Nullable
    private final CompatibilityType compatibilityType;
    @Option(displayName="Declaration Style", description="The desired style to write the new version as when being written to the `sourceCompatibility` or `targetCompatibility` variables. Default, match current source style. (ex. Enum: `JavaVersion.VERSION_11`, Number: 11, or String: \"11\")", valid={"Enum", "Number", "String"}, required=false)
    @Nullable
    private final DeclarationStyle declarationStyle;

    public String getDisplayName() {
        return "Update Gradle project Java compatibility";
    }

    public String getDescription() {
        return "Find and updates the Java compatibility for the Gradle project.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"version", (String)"Version must be > 0.", (Object)this.version, v -> v > 0));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            final MethodMatcher sourceCompatibilityDsl = new MethodMatcher("RewriteGradleProject setSourceCompatibility(..)");
            final MethodMatcher targetCompatibilityDsl = new MethodMatcher("RewriteGradleProject setTargetCompatibility(..)");
            final MethodMatcher javaLanguageVersionMatcher = new MethodMatcher("org.gradle.jvm.toolchain.JavaLanguageVersion of(int)");
            final MethodMatcher javaVersionToVersionMatcher = new MethodMatcher("org.gradle.api.JavaVersion toVersion(..)");

            public J visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
                J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)executionContext);
                if (a.getVariable() instanceof J.Identifier) {
                    J.Identifier variable = (J.Identifier)a.getVariable();
                    if (UpdateJavaCompatibility.this.compatibilityType == null ? !"sourceCompatibility".equals(variable.getSimpleName()) && !"targetCompatibility".equals(variable.getSimpleName()) : !(UpdateJavaCompatibility.this.compatibilityType.toString().toLowerCase() + "Compatibility").equals(variable.getSimpleName())) {
                        return a;
                    }
                } else if (a.getVariable() instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)a.getVariable();
                    if (UpdateJavaCompatibility.this.compatibilityType == null ? !"sourceCompatibility".equals(fieldAccess.getSimpleName()) && !"targetCompatibility".equals(fieldAccess.getSimpleName()) : !(UpdateJavaCompatibility.this.compatibilityType.toString().toLowerCase() + "Compatibility").equals(fieldAccess.getSimpleName())) {
                        return a;
                    }
                } else {
                    return a;
                }
                DeclarationStyle currentStyle = this.getCurrentStyle(a.getAssignment());
                int currentMajor = this.getMajorVersion(a.getAssignment());
                if (currentMajor != UpdateJavaCompatibility.this.version || UpdateJavaCompatibility.this.declarationStyle != null && UpdateJavaCompatibility.this.declarationStyle != currentStyle) {
                    DeclarationStyle actualStyle = UpdateJavaCompatibility.this.declarationStyle == null ? currentStyle : UpdateJavaCompatibility.this.declarationStyle;
                    return a.withAssignment(this.changeExpression(a.getAssignment(), actualStyle));
                }
                return a;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.javaLanguageVersionMatcher.matches((MethodCall)m)) {
                    J.Literal versionArg;
                    List args = m.getArguments();
                    if (args.size() == 1 && args.get(0) instanceof J.Literal && (versionArg = (J.Literal)args.get(0)).getValue() instanceof Integer) {
                        Integer versionNumber = (Integer)versionArg.getValue();
                        if (!UpdateJavaCompatibility.this.version.equals(versionNumber)) {
                            return m.withArguments(Collections.singletonList(versionArg.withValue((Object)UpdateJavaCompatibility.this.version).withValueSource(UpdateJavaCompatibility.this.version.toString())));
                        }
                        return m;
                    }
                    return (J)SearchResult.found((Tree)m, (String)("Attempted to update to Java version to " + UpdateJavaCompatibility.this.version + "  but was unsuccessful, please update manually"));
                }
                if (this.sourceCompatibilityDsl.matches((MethodCall)m) || this.targetCompatibilityDsl.matches((MethodCall)m)) {
                    if (UpdateJavaCompatibility.this.compatibilityType != null && (UpdateJavaCompatibility.this.compatibilityType == CompatibilityType.source && !this.sourceCompatibilityDsl.matches((MethodCall)m) || UpdateJavaCompatibility.this.compatibilityType == CompatibilityType.target && !this.targetCompatibilityDsl.matches((MethodCall)m))) {
                        return m;
                    }
                    if (m.getArguments().size() == 1 && (m.getArguments().get(0) instanceof J.Literal || m.getArguments().get(0) instanceof J.FieldAccess)) {
                        DeclarationStyle currentStyle = this.getCurrentStyle((Expression)m.getArguments().get(0));
                        int currentMajor = this.getMajorVersion((Expression)m.getArguments().get(0));
                        if (currentMajor != UpdateJavaCompatibility.this.version || UpdateJavaCompatibility.this.declarationStyle != null && UpdateJavaCompatibility.this.declarationStyle != currentStyle) {
                            DeclarationStyle actualStyle = UpdateJavaCompatibility.this.declarationStyle == null ? currentStyle : UpdateJavaCompatibility.this.declarationStyle;
                            return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> this.changeExpression((Expression)arg, actualStyle)));
                        }
                        return m;
                    }
                    return (J)SearchResult.found((Tree)m, (String)("Attempted to update to Java version to " + UpdateJavaCompatibility.this.version + "  but was unsuccessful, please update manually"));
                }
                return m;
            }

            private int getMajorVersion(String version) {
                try {
                    return Integer.parseInt(this.normalize(version));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }

            private int getMajorVersion(Expression expression) {
                if (expression instanceof J.Literal) {
                    J.Literal argument = (J.Literal)expression;
                    JavaType.Primitive type = argument.getType();
                    if (type == JavaType.Primitive.String) {
                        return this.getMajorVersion((String)argument.getValue());
                    }
                    if (type == JavaType.Primitive.Int) {
                        return (Integer)argument.getValue();
                    }
                    if (type == JavaType.Primitive.Double) {
                        return this.getMajorVersion(argument.getValue().toString());
                    }
                } else {
                    J.MethodInvocation method;
                    if (expression instanceof J.FieldAccess) {
                        J.FieldAccess field = (J.FieldAccess)expression;
                        J.Identifier identifier = field.getName();
                        return this.getMajorVersion(identifier.getSimpleName());
                    }
                    if (expression instanceof J.MethodInvocation && this.javaVersionToVersionMatcher.matches((MethodCall)((J.MethodInvocation)expression)) && (method = (J.MethodInvocation)expression).getArguments().get(0) instanceof J.Literal) {
                        return this.getMajorVersion((Expression)method.getArguments().get(0));
                    }
                }
                return -1;
            }

            @Nullable
            private DeclarationStyle getCurrentStyle(Expression expression) {
                if (expression instanceof J.Literal) {
                    J.Literal argument = (J.Literal)expression;
                    JavaType.Primitive type = argument.getType();
                    if (type == JavaType.Primitive.String) {
                        return DeclarationStyle.String;
                    }
                    if (type == JavaType.Primitive.Int) {
                        return DeclarationStyle.Number;
                    }
                    if (type == JavaType.Primitive.Double) {
                        return DeclarationStyle.Number;
                    }
                } else if (expression instanceof J.FieldAccess) {
                    return DeclarationStyle.Enum;
                }
                return null;
            }

            private String normalize(String version) {
                if (version.contains("\"") || version.contains("'")) {
                    version = version.replace("\"", "").replace("'", "");
                }
                if (!version.contains(".") && !version.contains("_")) {
                    return version;
                }
                if (version.contains("_")) {
                    String removePrefix = version.substring(version.indexOf("_") + 1);
                    if (removePrefix.startsWith("1_")) {
                        return removePrefix.substring(removePrefix.indexOf("_") + 1);
                    }
                    return removePrefix;
                }
                return version.substring(version.indexOf(".") + 1);
            }

            private Expression changeExpression(Expression expression, @Nullable DeclarationStyle style) {
                if (expression instanceof J.Literal) {
                    J.Literal literal = (J.Literal)expression;
                    if (style == DeclarationStyle.String) {
                        String newVersion;
                        String string = newVersion = UpdateJavaCompatibility.this.version <= 8 ? "1." + UpdateJavaCompatibility.this.version : String.valueOf(UpdateJavaCompatibility.this.version);
                        expression = literal.getType() == JavaType.Primitive.String ? ChangeStringLiteral.withStringValue(literal, newVersion) : literal.withType((JavaType)JavaType.Primitive.String).withValue((Object)newVersion).withValueSource("'" + newVersion + "'");
                    } else if (style == DeclarationStyle.Enum) {
                        String name = UpdateJavaCompatibility.this.version <= 8 ? "VERSION_1_" + UpdateJavaCompatibility.this.version : "VERSION_" + UpdateJavaCompatibility.this.version;
                        expression = new J.FieldAccess(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "JavaVersion", (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"), null), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), name, null, null), Markers.EMPTY), (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"));
                    } else if (style == DeclarationStyle.Number) {
                        if (UpdateJavaCompatibility.this.version <= 8) {
                            double doubleValue = Double.parseDouble("1." + UpdateJavaCompatibility.this.version);
                            expression = literal.withType((JavaType)JavaType.Primitive.Double).withValue((Object)doubleValue).withValueSource("1." + UpdateJavaCompatibility.this.version);
                        } else {
                            expression = literal.withType((JavaType)JavaType.Primitive.Int).withValue((Object)UpdateJavaCompatibility.this.version).withValueSource(String.valueOf(UpdateJavaCompatibility.this.version));
                        }
                    }
                } else if (expression instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)expression;
                    if (style == DeclarationStyle.String) {
                        String newVersion = UpdateJavaCompatibility.this.version <= 8 ? "1." + UpdateJavaCompatibility.this.version : String.valueOf(UpdateJavaCompatibility.this.version);
                        expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)newVersion, "'" + newVersion + "'", Collections.emptyList(), JavaType.Primitive.String);
                    } else if (style == DeclarationStyle.Enum) {
                        String name = UpdateJavaCompatibility.this.version <= 8 ? "VERSION_1_" + UpdateJavaCompatibility.this.version : "VERSION_" + UpdateJavaCompatibility.this.version;
                        expression = fieldAccess.withName(fieldAccess.getName().withSimpleName(name));
                    } else if (style == DeclarationStyle.Number) {
                        if (UpdateJavaCompatibility.this.version <= 8) {
                            double doubleValue = Double.parseDouble("1." + UpdateJavaCompatibility.this.version);
                            expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)doubleValue, String.valueOf(doubleValue), Collections.emptyList(), JavaType.Primitive.Double);
                        } else {
                            expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)UpdateJavaCompatibility.this.version, String.valueOf(UpdateJavaCompatibility.this.version), Collections.emptyList(), JavaType.Primitive.Int);
                        }
                    }
                } else if (expression instanceof J.MethodInvocation && this.javaVersionToVersionMatcher.matches((MethodCall)((J.MethodInvocation)expression))) {
                    J.MethodInvocation m = (J.MethodInvocation)expression;
                    if (style == null) {
                        expression = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                if (arg.getType() == JavaType.Primitive.String) {
                                    String newVersion = UpdateJavaCompatibility.this.version <= 8 ? "1." + UpdateJavaCompatibility.this.version : String.valueOf(UpdateJavaCompatibility.this.version);
                                    return ChangeStringLiteral.withStringValue((J.Literal)arg, newVersion);
                                }
                                if (arg.getType() == JavaType.Primitive.Int) {
                                    return ((J.Literal)arg).withValue((Object)UpdateJavaCompatibility.this.version).withValueSource(String.valueOf(UpdateJavaCompatibility.this.version));
                                }
                                if (arg.getType() == JavaType.Primitive.Double) {
                                    if (UpdateJavaCompatibility.this.version <= 8) {
                                        double doubleValue = Double.parseDouble("1." + UpdateJavaCompatibility.this.version);
                                        return ((J.Literal)arg).withValue((Object)doubleValue).withValueSource(String.valueOf(doubleValue));
                                    }
                                    return ((J.Literal)arg).withType((JavaType)JavaType.Primitive.Int).withValue((Object)UpdateJavaCompatibility.this.version).withValueSource(String.valueOf(UpdateJavaCompatibility.this.version));
                                }
                            }
                            return arg;
                        }));
                    } else if (style == DeclarationStyle.String) {
                        String newVersion = UpdateJavaCompatibility.this.version <= 8 ? "1." + UpdateJavaCompatibility.this.version : String.valueOf(UpdateJavaCompatibility.this.version);
                        expression = new J.Literal(Tree.randomId(), m.getPrefix(), m.getMarkers(), (Object)newVersion, "'" + newVersion + "'", Collections.emptyList(), JavaType.Primitive.String);
                    } else if (style == DeclarationStyle.Enum) {
                        String name = UpdateJavaCompatibility.this.version <= 8 ? "VERSION_1_" + UpdateJavaCompatibility.this.version : "VERSION_" + UpdateJavaCompatibility.this.version;
                        expression = new J.FieldAccess(Tree.randomId(), m.getPrefix(), m.getMarkers(), (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "JavaVersion", (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"), null), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), name, null, null), Markers.EMPTY), (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"));
                    } else if (style == DeclarationStyle.Number) {
                        if (UpdateJavaCompatibility.this.version <= 8) {
                            double doubleValue = Double.parseDouble("1." + UpdateJavaCompatibility.this.version);
                            expression = new J.Literal(Tree.randomId(), m.getPrefix(), m.getMarkers(), (Object)doubleValue, String.valueOf(doubleValue), Collections.emptyList(), JavaType.Primitive.Double);
                        } else {
                            expression = new J.Literal(Tree.randomId(), m.getPrefix(), m.getMarkers(), (Object)UpdateJavaCompatibility.this.version, String.valueOf(UpdateJavaCompatibility.this.version), Collections.emptyList(), JavaType.Primitive.Int);
                        }
                    }
                }
                return expression;
            }
        });
    }

    public UpdateJavaCompatibility(Integer version, @Nullable CompatibilityType compatibilityType, @Nullable DeclarationStyle declarationStyle) {
        this.version = version;
        this.compatibilityType = compatibilityType;
        this.declarationStyle = declarationStyle;
    }

    public Integer getVersion() {
        return this.version;
    }

    @Nullable
    public CompatibilityType getCompatibilityType() {
        return this.compatibilityType;
    }

    @Nullable
    public DeclarationStyle getDeclarationStyle() {
        return this.declarationStyle;
    }

    @NonNull
    public String toString() {
        return "UpdateJavaCompatibility(version=" + this.getVersion() + ", compatibilityType=" + (Object)((Object)this.getCompatibilityType()) + ", declarationStyle=" + (Object)((Object)this.getDeclarationStyle()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateJavaCompatibility)) {
            return false;
        }
        UpdateJavaCompatibility other = (UpdateJavaCompatibility)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        CompatibilityType this$compatibilityType = this.getCompatibilityType();
        CompatibilityType other$compatibilityType = other.getCompatibilityType();
        if (this$compatibilityType == null ? other$compatibilityType != null : !((Object)((Object)this$compatibilityType)).equals((Object)other$compatibilityType)) {
            return false;
        }
        DeclarationStyle this$declarationStyle = this.getDeclarationStyle();
        DeclarationStyle other$declarationStyle = other.getDeclarationStyle();
        return !(this$declarationStyle == null ? other$declarationStyle != null : !((Object)((Object)this$declarationStyle)).equals((Object)other$declarationStyle));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateJavaCompatibility;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        CompatibilityType $compatibilityType = this.getCompatibilityType();
        result = result * 59 + ($compatibilityType == null ? 43 : ((Object)((Object)$compatibilityType)).hashCode());
        DeclarationStyle $declarationStyle = this.getDeclarationStyle();
        result = result * 59 + ($declarationStyle == null ? 43 : ((Object)((Object)$declarationStyle)).hashCode());
        return result;
    }

    public static enum DeclarationStyle {
        Enum,
        Number,
        String;

    }

    public static enum CompatibilityType {
        source,
        target;

    }
}

