/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.GradleConfigurationFilter;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindJVMTestSuites;
import org.openrewrite.gradle.trait.JvmTestSuite;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.semver.Semver;

public final class AddDependency
extends ScanningRecipe<Scanned> {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Configuration", description="A configuration to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a new as of yet unused dependency.", example="implementation", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*", required=false)
    private final @Nullable String onlyIfUsing;
    @Option(displayName="Classifier", description="A classifier to add. Commonly used to select variants of a library.", example="test", required=false)
    private final @Nullable String classifier;
    @Option(displayName="Extension", description="The extension of the dependency to add. If omitted Gradle defaults to assuming the type is \"jar\".", example="jar", required=false)
    private final @Nullable String extension;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    private final @Nullable String familyPattern;
    @Option(displayName="Accept transitive", description="Default false. If enabled, the dependency will not be added if it is already on the classpath as a transitive dependency.", example="true", required=false)
    private final @Nullable Boolean acceptTransitive;

    public String getDisplayName() {
        return "Add Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.version);
    }

    public String getDescription() {
        return "Add a gradle dependency to a `build.gradle` file in the correct configuration based on where it is used.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            @Nullable UsesType<ExecutionContext> usesType = null;

            private boolean usesType(SourceFile sourceFile, ExecutionContext ctx) {
                if (AddDependency.this.onlyIfUsing == null) {
                    return true;
                }
                if (this.usesType == null) {
                    this.usesType = new UsesType(AddDependency.this.onlyIfUsing, Boolean.valueOf(true));
                }
                return this.usesType.isAcceptable(sourceFile, (Object)ctx) && this.usesType.visit((Tree)sourceFile, (Object)ctx) != sourceFile;
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                sourceFile.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> {
                    acc2.usingType.compute((JavaProject)javaProject, (jp, usingType) -> Boolean.TRUE.equals(usingType) || this.usesType(sourceFile, ctx));
                    Set configurations = acc2.configurationsByProject.computeIfAbsent((JavaProject)javaProject, ignored -> new HashSet());
                    sourceFile.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> configurations.add("main".equals(sourceSet.getName()) ? "implementation" : sourceSet.getName() + "Implementation"));
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check((!acc.configurationsByProject.isEmpty() ? 1 : 0) != 0, (TreeVisitor)Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                Set<String> resolvedConfigurations;
                if (!(tree instanceof JavaSourceFile)) {
                    return (J)tree;
                }
                JavaSourceFile s = (JavaSourceFile)tree;
                Optional maybeJp = s.getMarkers().findFirst(JavaProject.class);
                Optional maybeGp = s.getMarkers().findFirst(GradleProject.class);
                if (!maybeJp.isPresent() || AddDependency.this.onlyIfUsing != null && !acc.usingType.getOrDefault(maybeJp.get(), false).booleanValue() || !acc.configurationsByProject.containsKey(maybeJp.get()) || !maybeGp.isPresent()) {
                    return s;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                GradleProject gp = (GradleProject)maybeGp.get();
                Set<String> set = resolvedConfigurations = StringUtils.isBlank((String)AddDependency.this.configuration) ? (Set)acc.configurationsByProject.getOrDefault(jp, new HashSet()) : new HashSet<String>(Collections.singletonList(AddDependency.this.configuration));
                if (resolvedConfigurations.isEmpty()) {
                    resolvedConfigurations.add("implementation");
                }
                GradleConfigurationFilter gradleConfigurationFilter = new GradleConfigurationFilter(gp, resolvedConfigurations);
                gradleConfigurationFilter.removeTransitiveConfigurations();
                gradleConfigurationFilter.removeConfigurationsContainingDependency(new GroupArtifact(AddDependency.this.groupId, AddDependency.this.artifactId));
                gradleConfigurationFilter.removeConfigurationsContainingTransitiveDependency(new GroupArtifact(AddDependency.this.groupId, AddDependency.this.artifactId));
                resolvedConfigurations = gradleConfigurationFilter.getFilteredConfigurations();
                if (resolvedConfigurations.isEmpty()) {
                    return s;
                }
                Set<JvmTestSuite> jvmTestSuites = FindJVMTestSuites.jvmTestSuites((SourceFile)s);
                for (String resolvedConfiguration : resolvedConfigurations) {
                    JvmTestSuite jvmTestSuite = this.maybeJvmTestSuite(resolvedConfiguration, jvmTestSuites);
                    if (jvmTestSuite != null) {
                        s = (JavaSourceFile)jvmTestSuite.addDependency(resolvedConfiguration, AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, AddDependency.this.versionPattern, AddDependency.this.classifier, AddDependency.this.extension, AddDependency.this.metadataFailures, null, ctx).visitNonNull((Tree)s, (Object)ctx);
                        continue;
                    }
                    s = (JavaSourceFile)new AddDependencyVisitor(AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, AddDependency.this.versionPattern, resolvedConfiguration, AddDependency.this.classifier, AddDependency.this.extension, AddDependency.this.metadataFailures, this::isTopLevel, null).visitNonNull((Tree)s, ctx);
                }
                return s;
            }

            private boolean isTopLevel(Cursor cursor) {
                if (cursor.getValue() instanceof J.Block) {
                    return cursor.getParentOrThrow().getValue() instanceof JavaSourceFile;
                }
                return cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class) == null;
            }

            private @Nullable JvmTestSuite maybeJvmTestSuite(String configuration, Set<JvmTestSuite> jvmTestSuites) {
                for (JvmTestSuite jvmTestSuite : jvmTestSuites) {
                    if (!jvmTestSuite.isAcceptable(configuration)) continue;
                    return jvmTestSuite;
                }
                return null;
            }
        }));
    }

    @Generated
    public AddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String configuration, @Nullable String onlyIfUsing, @Nullable String classifier, @Nullable String extension, @Nullable String familyPattern, @Nullable Boolean acceptTransitive) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.onlyIfUsing = onlyIfUsing;
        this.classifier = classifier;
        this.extension = extension;
        this.familyPattern = familyPattern;
        this.acceptTransitive = acceptTransitive;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable String getExtension() {
        return this.extension;
    }

    @Generated
    public @Nullable String getFamilyPattern() {
        return this.familyPattern;
    }

    @Generated
    public @Nullable Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddDependency(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", configuration=" + this.getConfiguration() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", classifier=" + this.getClassifier() + ", extension=" + this.getExtension() + ", familyPattern=" + this.getFamilyPattern() + ", acceptTransitive=" + this.getAcceptTransitive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        return !(this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        return result;
    }

    public static class Scanned {
        Map<JavaProject, Boolean> usingType = new HashMap<JavaProject, Boolean>();
        Map<JavaProject, Set<String>> configurationsByProject = new HashMap<JavaProject, Set<String>>();
    }
}

