/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.maven.tree.GroupArtifact;

class GradleConfigurationFilter {
    private final GradleProject gradleProject;
    private final Set<String> filteredConfigurations;

    public void removeTransitiveConfigurations() {
        HashSet<String> tmpConfigurations = new HashSet<String>(this.filteredConfigurations);
        for (String tmpConfiguration : tmpConfigurations) {
            GradleDependencyConfiguration gdc = Objects.requireNonNull(this.gradleProject.getConfiguration(tmpConfiguration));
            for (GradleDependencyConfiguration transitive : this.gradleProject.configurationsExtendingFrom(gdc, true)) {
                this.filteredConfigurations.remove(transitive.getName());
            }
        }
    }

    public void removeConfigurationsContainingDependency(GroupArtifact dependency) {
        HashSet<String> tmpConfigurations = new HashSet<String>(this.filteredConfigurations);
        for (String tmpConfiguration : tmpConfigurations) {
            GradleDependencyConfiguration gdc = this.gradleProject.getConfiguration(tmpConfiguration);
            if (gdc != null && gdc.findRequestedDependency(dependency.getGroupId(), dependency.getArtifactId()) == null) continue;
            this.filteredConfigurations.remove(tmpConfiguration);
        }
    }

    public void removeConfigurationsContainingTransitiveDependency(GroupArtifact dependency) {
        HashSet<String> tmpConfigurations = new HashSet<String>(this.filteredConfigurations);
        for (String tmpConfiguration : tmpConfigurations) {
            GradleDependencyConfiguration gdc = Objects.requireNonNull(this.gradleProject.getConfiguration(tmpConfiguration));
            for (GradleDependencyConfiguration transitive : this.gradleProject.configurationsExtendingFrom(gdc, true)) {
                if (transitive.findResolvedDependency(dependency.getGroupId(), dependency.getArtifactId()) == null) continue;
                this.filteredConfigurations.remove(tmpConfiguration);
            }
        }
    }

    @Generated
    public GradleConfigurationFilter(GradleProject gradleProject, Set<String> filteredConfigurations) {
        this.gradleProject = gradleProject;
        this.filteredConfigurations = filteredConfigurations;
    }

    @Generated
    public Set<String> getFilteredConfigurations() {
        return this.filteredConfigurations;
    }
}

