/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.csharp.CSharpVisitor;
import org.openrewrite.csharp.marker.OmitBraces;
import org.openrewrite.csharp.marker.SingleExpressionBlock;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.csharp.tree.CsContainer;
import org.openrewrite.csharp.tree.CsLeftPadded;
import org.openrewrite.csharp.tree.CsRightPadded;
import org.openrewrite.csharp.tree.CsSpace;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class CSharpPrinter<P>
extends CSharpVisitor<PrintOutputCapture<P>> {
    private final CSharpJavaPrinter delegate = new CSharpJavaPrinter();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof Cs)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    public Cs visitCompilationUnit(Cs.CompilationUnit compilationUnit, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)compilationUnit, Space.Location.COMPILATION_UNIT_PREFIX, p);
        for (JRightPadded<Cs.ExternAlias> jRightPadded : compilationUnit.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : compilationUnit.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_USINGS, p);
            p.append(';');
        }
        for (Cs.AttributeList attributeList : compilationUnit.getAttributeLists()) {
            this.visit((Tree)attributeList, p);
        }
        this.visitStatements(compilationUnit.getPadding().getMembers(), CsRightPadded.Location.COMPILATION_UNIT_MEMBERS, p);
        this.visitSpace(compilationUnit.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(compilationUnit, p);
        return compilationUnit;
    }

    @Override
    public J visitAnnotatedStatement(Cs.AnnotatedStatement annotatedStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)annotatedStatement, CsSpace.Location.ANNOTATED_STATEMENT_PREFIX, p);
        for (Cs.AttributeList attributeList : annotatedStatement.getAttributeLists()) {
            this.visit((Tree)attributeList, p);
        }
        this.visit((Tree)annotatedStatement.getStatement(), p);
        this.afterSyntax(annotatedStatement, p);
        return annotatedStatement;
    }

    @Override
    public J visitAttributeList(Cs.AttributeList attributeList, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)attributeList, CsSpace.Location.ATTRIBUTE_LIST_PREFIX, p);
        p.append('[');
        Cs.AttributeList.Padding padding = attributeList.getPadding();
        if (padding.getTarget() != null) {
            this.visitRightPadded(padding.getTarget(), CsRightPadded.Location.ATTRIBUTE_LIST_TARGET, p);
            p.append(':');
        }
        this.visitRightPadded(padding.getAttributes(), CsRightPadded.Location.ATTRIBUTE_LIST_ATTRIBUTES, ",", p);
        p.append(']');
        this.afterSyntax(attributeList, p);
        return attributeList;
    }

    @Override
    public J visitArrayRankSpecifier(Cs.ArrayRankSpecifier arrayRankSpecifier, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)arrayRankSpecifier, CsSpace.Location.ARRAY_RANK_SPECIFIER_PREFIX, p);
        this.visitContainer("", arrayRankSpecifier.getPadding().getSizes(), CsContainer.Location.ARRAY_RANK_SPECIFIER_SIZES, ",", "", p);
        this.afterSyntax(arrayRankSpecifier, p);
        return arrayRankSpecifier;
    }

    @Override
    public J visitAssignmentOperation(Cs.AssignmentOperation assignmentOperation, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)assignmentOperation, CsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visit((Tree)assignmentOperation.getVariable(), p);
        this.visitLeftPadded(assignmentOperation.getPadding().getOperator(), CsLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        if (assignmentOperation.getOperator() == Cs.AssignmentOperation.OperatorType.NullCoalescing) {
            p.append("??=");
        }
        this.visit((Tree)assignmentOperation.getAssignment(), p);
        this.afterSyntax(assignmentOperation, p);
        return assignmentOperation;
    }

    @Override
    public J visitAwaitExpression(Cs.AwaitExpression awaitExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)awaitExpression, CsSpace.Location.AWAIT_EXPRESSION_PREFIX, p);
        p.append("await");
        this.visit((Tree)awaitExpression.getExpression(), p);
        this.afterSyntax(awaitExpression, p);
        return awaitExpression;
    }

    @Override
    public J visitBinary(Cs.Binary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)binary, CsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        if (binary.getOperator() == Cs.Binary.OperatorType.As) {
            p.append("as");
        } else if (binary.getOperator() == Cs.Binary.OperatorType.NullCoalescing) {
            p.append("??");
        }
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    public Cs visitBlockScopeNamespaceDeclaration(Cs.BlockScopeNamespaceDeclaration namespaceDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)namespaceDeclaration, CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_PREFIX, p);
        p.append("namespace");
        this.visitRightPadded(namespaceDeclaration.getPadding().getName(), CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_NAME, p);
        p.append('{');
        for (JRightPadded<Cs.ExternAlias> jRightPadded : namespaceDeclaration.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : namespaceDeclaration.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_USINGS, p);
            p.append(';');
        }
        this.visitStatements(namespaceDeclaration.getPadding().getMembers(), CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p);
        this.visitSpace(namespaceDeclaration.getEnd(), CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_END, p);
        p.append('}');
        this.afterSyntax(namespaceDeclaration, p);
        return namespaceDeclaration;
    }

    @Override
    public J visitCollectionExpression(Cs.CollectionExpression collectionExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)collectionExpression, CsSpace.Location.COLLECTION_EXPRESSION_PREFIX, p);
        p.append('[');
        this.visitRightPadded(collectionExpression.getPadding().getElements(), CsRightPadded.Location.COLLECTION_EXPRESSION_ELEMENTS, ",", p);
        p.append(']');
        this.afterSyntax(collectionExpression, p);
        return collectionExpression;
    }

    @Override
    public J visitExpressionStatement(Cs.ExpressionStatement expressionStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)expressionStatement, CsSpace.Location.AWAIT_EXPRESSION_PREFIX, p);
        this.visit((Tree)expressionStatement.getExpression(), p);
        this.afterSyntax(expressionStatement, p);
        return expressionStatement;
    }

    @Override
    public J visitExternAlias(Cs.ExternAlias externAlias, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)externAlias, CsSpace.Location.EXTERN_ALIAS_PREFIX, p);
        p.append("extern");
        this.visitLeftPadded("alias", externAlias.getPadding().getIdentifier(), CsLeftPadded.Location.EXTERN_ALIAS_IDENTIFIER, p);
        this.afterSyntax(externAlias, p);
        return externAlias;
    }

    public Cs visitFileScopeNamespaceDeclaration(Cs.FileScopeNamespaceDeclaration namespaceDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)namespaceDeclaration, CsSpace.Location.FILE_SCOPE_NAMESPACE_DECLARATION_PREFIX, p);
        p.append("namespace");
        this.visitRightPadded(namespaceDeclaration.getPadding().getName(), CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_NAME, p);
        p.append(";");
        for (JRightPadded<Cs.ExternAlias> jRightPadded : namespaceDeclaration.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : namespaceDeclaration.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_USINGS, p);
            p.append(';');
        }
        this.visitStatements(namespaceDeclaration.getPadding().getMembers(), CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p);
        return namespaceDeclaration;
    }

    @Override
    public J visitInterpolatedString(Cs.InterpolatedString interpolatedString, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)interpolatedString, CsSpace.Location.INTERPOLATED_STRING_PREFIX, p);
        p.append(interpolatedString.getStart());
        this.visitRightPadded(interpolatedString.getPadding().getParts(), CsRightPadded.Location.INTERPOLATED_STRING_PARTS, "", p);
        p.append(interpolatedString.getEnd());
        this.afterSyntax(interpolatedString, p);
        return interpolatedString;
    }

    @Override
    public J visitInterpolation(Cs.Interpolation interpolation, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)interpolation, CsSpace.Location.INTERPOLATION_PREFIX, p);
        p.append('{');
        this.visitRightPadded(interpolation.getPadding().getExpression(), CsRightPadded.Location.INTERPOLATION_EXPRESSION, p);
        if (interpolation.getAlignment() != null) {
            p.append(',');
            this.visitRightPadded(interpolation.getPadding().getAlignment(), CsRightPadded.Location.INTERPOLATION_ALIGNMENT, p);
        }
        if (interpolation.getFormat() != null) {
            p.append(':');
            this.visitRightPadded(interpolation.getPadding().getFormat(), CsRightPadded.Location.INTERPOLATION_FORMAT, p);
        }
        p.append('}');
        this.afterSyntax(interpolation, p);
        return interpolation;
    }

    @Override
    public J visitNullSafeExpression(Cs.NullSafeExpression nullSafeExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)nullSafeExpression, CsSpace.Location.NULL_SAFE_EXPRESSION_PREFIX, p);
        this.visitRightPadded(nullSafeExpression.getPadding().getExpression(), CsRightPadded.Location.NULL_SAFE_EXPRESSION_EXPRESSION, p);
        p.append("?");
        this.afterSyntax(nullSafeExpression, p);
        return nullSafeExpression;
    }

    @Override
    public J visitPropertyDeclaration(Cs.PropertyDeclaration propertyDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)propertyDeclaration, CsSpace.Location.PROPERTY_DECLARATION_PREFIX, p);
        this.visit(propertyDeclaration.getAttributeLists(), p);
        for (J.Modifier m : propertyDeclaration.getModifiers()) {
            this.delegate.visitModifier(m, p);
        }
        this.visit((Tree)propertyDeclaration.getTypeExpression(), p);
        if (propertyDeclaration.getPadding().getInterfaceSpecifier() != null) {
            this.visitRightPadded(propertyDeclaration.getPadding().getInterfaceSpecifier(), CsRightPadded.Location.PROPERTY_DECLARATION_INTERFACE_SPECIFIER, p);
            p.append('.');
        }
        this.visit((Tree)propertyDeclaration.getName(), p);
        this.visit((Tree)propertyDeclaration.getAccessors(), p);
        if (propertyDeclaration.getInitializer() != null) {
            this.visitLeftPadded("=", propertyDeclaration.getPadding().getInitializer(), CsLeftPadded.Location.PROPERTY_DECLARATION_INITIALIZER, p);
        }
        this.afterSyntax(propertyDeclaration, p);
        return propertyDeclaration;
    }

    @Override
    public J visitUsingDirective(Cs.UsingDirective usingDirective, PrintOutputCapture<P> p) {
        this.beforeSyntax((Cs)usingDirective, CsSpace.Location.USING_DIRECTIVE_PREFIX, p);
        if (usingDirective.isGlobal()) {
            p.append("global");
            this.visitRightPadded(usingDirective.getPadding().getGlobal(), CsRightPadded.Location.USING_DIRECTIVE_GLOBAL, p);
        }
        p.append("using");
        if (usingDirective.isStatic()) {
            this.visitLeftPadded(usingDirective.getPadding().getStatic(), CsLeftPadded.Location.USING_DIRECTIVE_STATIC, p);
            p.append("static");
        } else if (usingDirective.getAlias() != null) {
            if (usingDirective.isUnsafe()) {
                this.visitLeftPadded(usingDirective.getPadding().getUnsafe(), CsLeftPadded.Location.USING_DIRECTIVE_UNSAFE, p);
                p.append("unsafe");
            }
            this.visitRightPadded(usingDirective.getPadding().getAlias(), CsRightPadded.Location.USING_DIRECTIVE_ALIAS, p);
            p.append('=');
        }
        this.visit((Tree)usingDirective.getNamespaceOrType(), p);
        this.afterSyntax(usingDirective, p);
        return usingDirective;
    }

    @Override
    public Space visitSpace(Space space, CsSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, CsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitContainer(@Nullable String before, @Nullable JContainer<? extends J> container, CsContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, CsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitStatements(@Nullable String before, @Nullable JContainer<Statement> container, CsContainer.Location location, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitStatements(container.getPadding().getElements(), location.getElementLocation(), p);
        p.append(after);
    }

    protected void visitStatements(List<JRightPadded<Statement>> statements, CsRightPadded.Location location, PrintOutputCapture<P> p) {
        for (JRightPadded<Statement> paddedStat : statements) {
            this.visitStatement(paddedStat, location, p);
        }
    }

    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, CsRightPadded.Location location, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.visit((Tree)paddedStat.getElement(), p);
        this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
        this.visitMarkers(paddedStat.getMarkers(), p);
        if (this.getCursor().getParent().getValue() instanceof J.Block && this.getCursor().getParent().getParent().getValue() instanceof J.NewClass) {
            p.append(',');
            return;
        }
        this.delegate.printStatementTerminator((Statement)paddedStat.getElement(), p);
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(Cs cs, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(cs.getPrefix(), cs.getMarkers(), loc, p);
    }

    private void beforeSyntax(Cs cs, CsSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(cs.getPrefix(), cs.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable CsSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Cs g, PrintOutputCapture<P> p) {
        this.afterSyntax(g.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private class CSharpJavaPrinter
    extends JavaPrinter<P> {
        private CSharpJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof Cs) {
                return CSharpPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
            String kind = "";
            switch (classDecl.getPadding().getKind().getType()) {
                case Class: 
                case Annotation: {
                    kind = "class";
                    break;
                }
                case Enum: {
                    kind = "enum";
                    break;
                }
                case Interface: {
                    kind = "interface";
                    break;
                }
                case Record: {
                    kind = "record";
                    break;
                }
                case Value: {
                    kind = "struct";
                }
            }
            this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(classDecl.getLeadingAnnotations(), p);
            for (J.Modifier m : classDecl.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit(classDecl.getPadding().getKind().getAnnotations(), p);
            this.visitSpace(classDecl.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
            p.append(kind);
            this.visit((Tree)classDecl.getName(), p);
            this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visitContainer("(", classDecl.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, ",", ")", p);
            this.visitLeftPadded(":", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p);
            this.visitContainer(classDecl.getPadding().getExtends() == null ? ":" : ",", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, p);
            this.visitContainer("permits", classDecl.getPadding().getPermits(), JContainer.Location.PERMITS, ",", null, p);
            this.visit((Tree)classDecl.getBody(), p);
            this.afterSyntax((J)classDecl, p);
            return classDecl;
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            this.visit((Tree)annotation.getAnnotationType(), p);
            this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)block, Space.Location.BLOCK_PREFIX, p);
            if (block.isStatic()) {
                p.append("static");
                this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
            }
            if (block.getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                p.append("=>");
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            } else if (!block.getMarkers().findFirst(OmitBraces.class).isPresent()) {
                p.append('{');
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
                p.append('}');
            } else {
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            }
            this.afterSyntax((J)block, p);
            return block;
        }

        protected void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, PrintOutputCapture<P> p) {
            for (int i = 0; i < statements.size(); ++i) {
                JRightPadded<Statement> paddedStat = statements.get(i);
                this.visitStatement(paddedStat, location, p);
                if (i >= statements.size() - 1 || (this.getCursor().getParent() == null || !(this.getCursor().getParent().getValue() instanceof J.NewClass)) && (this.getCursor().getParent() == null || !(this.getCursor().getParent().getValue() instanceof J.Block) || this.getCursor().getParent(2) == null || !(this.getCursor().getParent(2).getValue() instanceof J.NewClass))) continue;
                p.append(',');
            }
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit((Tree)method.getReturnTypeExpression(), p);
            this.visit(method.getAnnotations().getName().getAnnotations(), p);
            this.visit((Tree)method.getName(), p);
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append('<');
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append('>');
            }
            if (!method.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
                this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            }
            this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, p);
            this.visit((Tree)method.getBody(), p);
            this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", p);
            this.visit((Tree)method.getName(), p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitCatch(J.Try.Catch catch_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)catch_, Space.Location.CATCH_PREFIX, p);
            p.append("catch");
            if (((J.VariableDeclarations)catch_.getParameter().getTree()).getTypeExpression() != null) {
                this.visit((Tree)catch_.getParameter(), p);
            }
            this.visit((Tree)catch_.getBody(), p);
            this.afterSyntax((J)catch_, p);
            return catch_;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("foreach");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, "in", p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement(forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)instanceOf, Space.Location.INSTANCEOF_PREFIX, p);
            this.visitRightPadded(instanceOf.getPadding().getExpression(), JRightPadded.Location.INSTANCEOF, "is", p);
            this.visit((Tree)instanceOf.getClazz(), p);
            this.visit((Tree)instanceOf.getPattern(), p);
            this.afterSyntax((J)instanceOf, p);
            return instanceOf;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            this.visitMarkers(lambda.getParameters().getMarkers(), p);
            if (lambda.getParameters().isParenthesized()) {
                p.append('(');
                this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
                p.append(')');
            } else {
                this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            }
            this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
            p.append("=>");
            this.visit((Tree)lambda.getBody(), p);
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        public J visitPrimitive(J.Primitive primitive, PrintOutputCapture<P> p) {
            String keyword;
            switch (primitive.getType()) {
                case Boolean: {
                    keyword = "bool";
                    break;
                }
                case Byte: {
                    keyword = "byte";
                    break;
                }
                case Char: {
                    keyword = "char";
                    break;
                }
                case Double: {
                    keyword = "double";
                    break;
                }
                case Float: {
                    keyword = "float";
                    break;
                }
                case Int: {
                    keyword = "int";
                    break;
                }
                case Long: {
                    keyword = "long";
                    break;
                }
                case Short: {
                    keyword = "short";
                    break;
                }
                case Void: {
                    keyword = "void";
                    break;
                }
                case String: {
                    keyword = "string";
                    break;
                }
                case None: {
                    throw new IllegalStateException("Unable to print None primitive");
                }
                case Null: {
                    throw new IllegalStateException("Unable to print Null primitive");
                }
                default: {
                    throw new IllegalStateException("Unable to print non-primitive type");
                }
            }
            this.beforeSyntax((J)primitive, Space.Location.PRIMITIVE_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)primitive, p);
            return primitive;
        }

        public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
            if (tryable.getPadding().getResources() != null) {
                this.beforeSyntax((J)tryable, Space.Location.TRY_PREFIX, p);
                p.append("using");
                this.visitSpace(tryable.getPadding().getResources().getBefore(), Space.Location.TRY_RESOURCES, p);
                p.append('(');
                List resources = tryable.getPadding().getResources().getPadding().getElements();
                for (JRightPadded resource : resources) {
                    this.visitSpace(((J.Try.Resource)resource.getElement()).getPrefix(), Space.Location.TRY_RESOURCE, p);
                    this.visitMarkers(((J.Try.Resource)resource.getElement()).getMarkers(), p);
                    this.visit((Tree)((J.Try.Resource)resource.getElement()).getVariableDeclarations(), p);
                    if (((J.Try.Resource)resource.getElement()).isTerminatedWithSemicolon()) {
                        p.append(';');
                    }
                    this.visitSpace(resource.getAfter(), Space.Location.TRY_RESOURCE_SUFFIX, p);
                }
                p.append(')');
                this.visit((Tree)tryable.getBody(), p);
                this.afterSyntax((J)tryable, p);
                return tryable;
            }
            return super.visitTry(tryable, p);
        }

        public void visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
            super.visitModifier(mod, p);
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.append(';');
            } else if (marker instanceof TrailingComma) {
                p.append(',');
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            }
            return (M)marker;
        }

        protected void printStatementTerminator(Statement s, PrintOutputCapture<P> p) {
            if (!(this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.NewClass || this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.Block && this.getCursor().getParent(2) != null && this.getCursor().getParent(2).getValue() instanceof J.NewClass)) {
                if (s instanceof Cs.ExpressionStatement || s instanceof Cs.AssignmentOperation) {
                    p.append(';');
                } else if (s instanceof Cs.PropertyDeclaration && (((Cs.PropertyDeclaration)s).getInitializer() != null || ((Cs.PropertyDeclaration)s).getAccessors().getMarkers().findFirst(SingleExpressionBlock.class).isPresent())) {
                    p.append(';');
                } else if (s instanceof J.ClassDeclaration && ((J.ClassDeclaration)s).getBody().getMarkers().findFirst(OmitBraces.class).isPresent()) {
                    p.append(';');
                } else if (s instanceof Cs.AnnotatedStatement && ((Cs.AnnotatedStatement)s).getStatement() instanceof J.ClassDeclaration && ((J.ClassDeclaration)((Cs.AnnotatedStatement)s).getStatement()).getBody().getMarkers().findFirst(OmitBraces.class).isPresent()) {
                    p.append(';');
                } else {
                    super.printStatementTerminator(s, p);
                }
            }
        }
    }
}

