/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.openrewrite.gradle.RecipeDependenciesExtension;
import org.openrewrite.gradle.RecipeDependenciesTypeTableTask;
import org.openrewrite.gradle.RewriteBuildInputLoggingPlugin;
import org.openrewrite.gradle.RewriteDependencyRepositoriesPlugin;
import org.openrewrite.gradle.RewriteJavaPlugin;
import org.openrewrite.gradle.RewriteLicensePlugin;
import org.openrewrite.gradle.RewriteMetadataPlugin;
import org.openrewrite.gradle.RewritePublishPlugin;

public class RewriteLanguageLibraryPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(RewriteDependencyRepositoriesPlugin.class);
        project.getPlugins().apply(RewriteJavaPlugin.class);
        project.getPlugins().apply(RewriteLicensePlugin.class);
        project.getPlugins().apply(RewriteMetadataPlugin.class);
        project.getPlugins().apply(RewriteBuildInputLoggingPlugin.class);
        project.getExtensions().create("recipeDependencies", RecipeDependenciesExtension.class, new Object[0]);
        project.getTasks().register("createTypeTable", RecipeDependenciesTypeTableTask.class, task -> task.getSourceSetName().convention((Object)"main"));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginExtension javaExt = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaExt.getSourceSets().all(sourceSet -> {
                String taskName;
                String sourceSetName = sourceSet.getName();
                String string = taskName = "main".equals(sourceSetName) ? "createTypeTable" : "create" + RewriteLanguageLibraryPlugin.capitalize(sourceSetName) + "TypeTable";
                if (!"main".equals(sourceSetName)) {
                    project.getTasks().register(taskName, RecipeDependenciesTypeTableTask.class, task -> {
                        task.getSourceSetName().convention((Object)sourceSetName);
                        task.getTargetDir().convention(project.getLayout().getProjectDirectory().dir("src/" + sourceSetName + "/resources"));
                    });
                }
            });
        });
        project.getPlugins().apply(RewritePublishPlugin.class);
    }

    private static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

