/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import nebula.plugin.publishing.maven.MavenPublishPlugin;
import nebula.plugin.publishing.maven.MavenResolvedDependenciesPlugin;
import nebula.plugin.publishing.maven.MavenShadowPublishPlugin;
import nebula.plugin.publishing.maven.license.MavenApacheLicensePlugin;
import nebula.plugin.publishing.publications.JavadocJarPlugin;
import nebula.plugin.publishing.publications.SourceJarPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RewritePublishPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Configuration testImplementation;
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().apply(SourceJarPlugin.class);
        project.getPlugins().apply(JavadocJarPlugin.class);
        project.getPlugins().apply(SigningPlugin.class);
        project.getPlugins().apply(MavenPublishPlugin.class);
        project.getPlugins().apply(MavenResolvedDependenciesPlugin.class);
        project.getPlugins().apply(MavenApacheLicensePlugin.class);
        project.getPlugins().apply(MavenShadowPublishPlugin.class);
        project.getTasks().withType(GenerateModuleMetadata.class).configureEach(task -> task.setEnabled(false));
        project.getExtensions().configure(SigningExtension.class, ext -> {
            ext.setRequired(!project.getVersion().toString().endsWith("SNAPSHOT") || project.hasProperty("forceSigning"));
            ext.useInMemoryPgpKeys((String)project.findProperty("signingKey"), (String)project.findProperty("signingPassword"));
            ext.sign(new Publication[]{(Publication)((PublishingExtension)project.getExtensions().getByType(PublishingExtension.class)).getPublications().findByName("nebula")});
        });
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration provided = (Configuration)configurations.create("provided");
        Configuration compileOnly = (Configuration)configurations.findByName("compileOnly");
        if (compileOnly != null) {
            compileOnly.extendsFrom(new Configuration[]{provided});
        }
        if ((testImplementation = (Configuration)configurations.findByName("testImplementation")) != null) {
            testImplementation.extendsFrom(new Configuration[]{provided});
        }
        project.getExtensions().configure(PublishingExtension.class, ext -> ext.getPublications().named("nebula", MavenPublication.class, pub -> {
            pub.suppressPomMetadataWarningsFor("runtimeElements");
            pub.pom(pom -> pom.withXml(xml -> {
                for (int i = 0; i < xml.asElement().getChildNodes().getLength(); ++i) {
                    Node node = xml.asElement().getChildNodes().item(i);
                    if (node.getNodeType() != 1 || !"dependencies".equals(node.getNodeName())) continue;
                    Element dependencies = (Element)node;
                    Document owner = dependencies.getOwnerDocument();
                    for (ResolvedDependency providedDep : provided.getResolvedConfiguration().getFirstLevelModuleDependencies()) {
                        Element dependencyElement = dependencies.getOwnerDocument().createElement("dependency");
                        Element groupId = owner.createElement("groupId");
                        groupId.setTextContent(providedDep.getModuleGroup());
                        dependencyElement.appendChild(groupId);
                        Element artifactId = owner.createElement("artifactId");
                        artifactId.setTextContent(providedDep.getModuleName());
                        dependencyElement.appendChild(artifactId);
                        Element version = owner.createElement("version");
                        version.setTextContent(providedDep.getModuleVersion());
                        dependencyElement.appendChild(version);
                        Element scope = owner.createElement("scope");
                        scope.setTextContent("provided");
                        dependencyElement.appendChild(scope);
                        dependencies.appendChild(dependencyElement);
                    }
                    break;
                }
            }));
        }));
    }
}

