/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class HamcrestMatcherToAssertJ
extends Recipe {
    @Option(displayName="Hamcrest matcher", description="The Hamcrest `Matcher` to migrate to JUnit5.", example="equalTo", required=false)
    @Nullable String matcher;
    @Option(displayName="AssertJ assertion", description="The AssertJ method to migrate to.", example="isEqualTo", required=false)
    @Nullable String assertion;
    @Option(displayName="Argument type", description="The type of the argument to the Hamcrest `Matcher`.", example="java.math.BigDecimal", required=false)
    @Nullable String argumentType;

    public String getDisplayName() {
        return "Migrate from Hamcrest `Matcher` to AssertJ";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `Matcher` to AssertJ assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.hamcrest.*Matchers " + this.matcher + "(..)"), (TreeVisitor)new MigrateToAssertJVisitor());
    }

    @Generated
    public HamcrestMatcherToAssertJ() {
    }

    @ConstructorProperties(value={"matcher", "assertion", "argumentType"})
    @Generated
    public HamcrestMatcherToAssertJ(@Nullable String matcher, @Nullable String assertion, @Nullable String argumentType) {
        this.matcher = matcher;
        this.assertion = assertion;
        this.argumentType = argumentType;
    }

    private class MigrateToAssertJVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher assertThatMatcher = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
        private final MethodMatcher matchersMatcher;
        private final MethodMatcher subMatcher;
        private final Set<String> noArgAssertions;
        private final MethodMatcher CLOSE_TO_MATCHER;

        private MigrateToAssertJVisitor() {
            this.matchersMatcher = new MethodMatcher("org.hamcrest.*Matchers " + HamcrestMatcherToAssertJ.this.matcher + "(..)");
            this.subMatcher = new MethodMatcher("org.hamcrest.*Matchers *(org.hamcrest.Matcher)");
            this.noArgAssertions = new HashSet<String>(Arrays.asList("isNotNull", "isNull"));
            this.CLOSE_TO_MATCHER = new MethodMatcher("org.hamcrest.Matchers closeTo(..)");
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.assertThatMatcher.matches((MethodCall)mi)) {
                return this.replace(mi, ctx);
            }
            return mi;
        }

        private J.MethodInvocation replace(J.MethodInvocation mi, ExecutionContext ctx) {
            List mia = mi.getArguments();
            Expression reasonArgument = mia.size() == 3 ? (Expression)mia.get(0) : null;
            Expression actualArgument = (Expression)mia.get(mia.size() - 2);
            Expression matcherArgument = (Expression)mia.get(mia.size() - 1);
            if (!this.matchersMatcher.matches(matcherArgument) || this.subMatcher.matches(matcherArgument)) {
                return mi;
            }
            if (HamcrestMatcherToAssertJ.this.argumentType != null && !TypeUtils.isOfClassType((JavaType)actualArgument.getType(), (String)HamcrestMatcherToAssertJ.this.argumentType)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            J.MethodInvocation matcherArgumentMethod = (J.MethodInvocation)matcherArgument;
            boolean isNoArgAssertion = this.noArgAssertions.contains(HamcrestMatcherToAssertJ.this.assertion);
            String argsTemplate = isNoArgAssertion ? "" : this.getArgumentsTemplate(matcherArgumentMethod);
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s)" + (reasonArgument != null ? ".as(#{any(String)})" : "") + ".%s(%s)", actual, HamcrestMatcherToAssertJ.this.assertion, argsTemplate)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).build();
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.CoreMatchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert");
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            ArrayList<Expression> templateArguments = new ArrayList<Expression>();
            templateArguments.add(actualArgument);
            if (reasonArgument != null) {
                templateArguments.add(reasonArgument);
            }
            if (!isNoArgAssertion) {
                boolean isCloseTo = this.CLOSE_TO_MATCHER.matches((MethodCall)matcherArgumentMethod);
                List matcherArgs = matcherArgumentMethod.getArguments();
                for (int i = 0; i < matcherArgs.size(); ++i) {
                    Expression originalArgument = (Expression)matcherArgs.get(i);
                    if (originalArgument instanceof J.Empty) continue;
                    if (isCloseTo && i == 1) {
                        templateArguments.add(this.ensureMatchingNumericType(originalArgument, actualArgument.getType()));
                        continue;
                    }
                    templateArguments.add(originalArgument);
                }
            }
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private Expression ensureMatchingNumericType(Expression toleranceExpr, @Nullable JavaType actualType) {
            JavaType toleranceType = toleranceExpr.getType();
            if (!(actualType != JavaType.Primitive.Double && !TypeUtils.isOfClassType((JavaType)actualType, (String)"java.lang.Double") || toleranceType != JavaType.Primitive.Int && toleranceType != JavaType.Primitive.Long)) {
                return new J.TypeCast(Tree.randomId(), toleranceExpr.getPrefix(), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaType.Primitive.Double))), (Expression)toleranceExpr.withPrefix(Space.SINGLE_SPACE));
            }
            return toleranceExpr;
        }

        private String getArgumentsTemplate(J.MethodInvocation matcherArgument) {
            List methodArguments = matcherArgument.getArguments();
            if (this.CLOSE_TO_MATCHER.matches((MethodCall)matcherArgument)) {
                return String.format("%s, within(%s)", this.typeToIndicator(((Expression)methodArguments.get(0)).getType()), this.typeToIndicator(((Expression)methodArguments.get(1)).getType()));
            }
            return methodArguments.stream().filter(a -> !(a instanceof J.Empty)).map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
        }

        private String typeToIndicator(@Nullable JavaType type) {
            if (type instanceof JavaType.Array) {
                String str = (type = ((JavaType.Array)type).getElemType()) instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
                return String.format("#{anyArray(%s)}", str);
            }
            if (type instanceof JavaType.Primitive || type != null && type.toString().startsWith("java.")) {
                return "#{any()}";
            }
            return "#{any(java.lang.Object)}";
        }
    }
}

