/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class HamcrestIsMatcherToAssertJ
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
    private static final MethodMatcher IS_MATCHER = new MethodMatcher("org.hamcrest.*Matchers is(..)");
    private static final MethodMatcher IS_WITH_NESTED_MATCHER = new MethodMatcher("org.hamcrest.*Matchers is(org.hamcrest.Matcher)");

    public String getDisplayName() {
        return "Migrate Hamcrest `is(Object)` to AssertJ";
    }

    public String getDescription() {
        return "Migrate Hamcrest `is(Object)` to AssertJ `Assertions.assertThat(..)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(IS_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Object[] objectArray;
                String template;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                List args = mi.getArguments();
                Expression reasonArgument = args.size() == 3 ? (Expression)args.get(0) : null;
                Expression actualArgument = (Expression)args.get(args.size() - 2);
                Expression matcherArgument = (Expression)args.get(args.size() - 1);
                if (!IS_MATCHER.matches(matcherArgument) || IS_WITH_NESTED_MATCHER.matches(matcherArgument)) {
                    return mi;
                }
                boolean isArray = TypeUtils.asArray((JavaType)actualArgument.getType()) != null;
                J.MethodInvocation isInvocation = (J.MethodInvocation)matcherArgument;
                Expression expectedArgument = (Expression)isInvocation.getArguments().get(0);
                this.maybeRemoveImport("org.hamcrest.Matchers.is");
                this.maybeRemoveImport("org.hamcrest.CoreMatchers.is");
                this.maybeRemoveImport("org.hamcrest.MatcherAssert");
                this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
                this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
                String reason = reasonArgument != null ? ".as(#{any(String)})" : "";
                String string = template = isArray ? "assertThat(#{any(Object[])})" + reason + ".containsExactly(#{any(Object[])})" : "assertThat(#{any(Object)})" + reason + ".isEqualTo(#{any(Object)})";
                if (reasonArgument != null) {
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = actualArgument;
                    objectArray2[1] = reasonArgument;
                    objectArray = objectArray2;
                    objectArray2[2] = expectedArgument;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = actualArgument;
                    objectArray = objectArray3;
                    objectArray3[1] = expectedArgument;
                }
                Object[] templateArgs = objectArray;
                return (J.MethodInvocation)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), templateArgs);
            }
        });
    }
}

