/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJShortRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Adopt AssertJ Short Assertions";
    }

    public String getDescription() {
        return "Adopt AssertJ Short Assertions. Favor semantically explicit methods (e.g. `myShort.isZero()` over `myShort.isEqualTo(0)`).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractShortAssertIsEqualToRecipe(), new AbstractShortAssertIsNotEqualToRecipe(), new AbstractShortAssertIsZeroRecipe(), new AbstractShortAssertIsNotZeroRecipe(), new AbstractShortAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractShortAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isCloseTo` with `isEqualTo`";
        }

        public String getDescription() {
            return "Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo(#{n:any(short)})").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo(#{n:any(short)})").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractShortAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotCloseTo` with `isNotEqualTo`";
        }

        public String getDescription() {
            return "Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo(#{n:any(short)})").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo(#{n:any(short)})").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractShortAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(0)` with `isZero()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(0)` with `isZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)0)").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractShortAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`";
        }

        public String getDescription() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo((short)0)").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractShortAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(1)` with `isOne()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(1)` with `isOne()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)1)").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractShortAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

