/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class CleanupPowerMockImports
extends Recipe {
    public String getDisplayName() {
        return "Cleanup PowerMock imports";
    }

    public String getDescription() {
        return "Removes unused `org.powermock` import symbols.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.powermock..*", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof JavaSourceFile) {
                    for (J.Import _import : ((JavaSourceFile)tree).getImports()) {
                        if (!_import.getPackageName().startsWith("org.powermock")) continue;
                        this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                    }
                }
                return tree;
            }
        });
    }
}

