/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddMissingNested
extends Recipe {
    private static final String NESTED = "org.junit.jupiter.api.Nested";
    private static final List<String> TEST_ANNOTATIONS = Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.params.ParameterizedTest", "org.junit.jupiter.api.TestFactory");
    private static final TreeVisitor<?, ExecutionContext> PRECONDITION = Preconditions.or((TreeVisitor[])((TreeVisitor[])TEST_ANNOTATIONS.stream().map(r -> new UsesType(r, Boolean.valueOf(false))).toArray(UsesType[]::new)));

    public String getDisplayName() {
        return "JUnit 5 inner test classes should be annotated with `@Nested`";
    }

    public String getDescription() {
        return "Adds `@Nested` to inner classes that contain JUnit 5 tests.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S5790");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(PRECONDITION, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                cd = cd.withBody((J.Block)new AddNestedAnnotationVisitor().visitNonNull((Tree)cd.getBody(), ctx, this.updateCursor((Tree)cd)));
                this.maybeAddImport(AddMissingNested.NESTED);
                return cd;
            }
        });
    }

    @Generated
    public AddMissingNested() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddMissingNested()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingNested)) {
            return false;
        }
        AddMissingNested other = (AddMissingNested)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingNested;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class AddNestedAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.hasModifier(J.Modifier.Type.Abstract) || cd.getKind() == J.ClassDeclaration.Kind.Type.Annotation || classDecl.getLeadingAnnotations().stream().anyMatch(a -> TypeUtils.isOfClassType((JavaType)a.getType(), (String)AddMissingNested.NESTED)) || !AddNestedAnnotationVisitor.hasTestMethods(cd)) {
                return cd;
            }
            cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@Nested").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).imports(new String[]{AddMissingNested.NESTED}).build().apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            cd.getModifiers().removeIf(modifier -> modifier.getType() == J.Modifier.Type.Static);
            return (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)cd, ctx);
        }

        private static boolean hasTestMethods(J.ClassDeclaration cd) {
            return TEST_ANNOTATIONS.stream().anyMatch(ann -> !FindAnnotations.find((J)cd, (String)("@" + ann)).isEmpty());
        }
    }
}

