/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CleanupMockitoImports
extends Recipe {
    public String getDisplayName() {
        return "Cleanup Mockito imports";
    }

    public String getDescription() {
        return "Removes unused `org.mockito` import symbols, unless its possible they are associated with method invocations having null or unknown type information.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.*", Boolean.valueOf(false)), (TreeVisitor)new CleanupMockitoImportsVisitor());
    }

    private static class CleanupMockitoImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final List<String> MOCKITO_METHOD_NAMES = Arrays.asList("after", "atLeast", "atLeastOnce", "atMost", "calls", "clearInvocations", "doAnswer", "doCallRealMethod", "doNothing", "doReturn", "doThrow", "given", "ignoreStubs", "inOrder", "mock", "mockingDetails", "never", "only", "reset", "spy", "stub", "stubVoid", "then", "timeout", "times", "verify", "verifyNoInteractions", "verifyNoMoreInteractions", "verifyZeroInteractions", "when", "will", "willAnswer", "willCallRealMethod", "willDoNothing", "willReturn", "willThrow");

        private CleanupMockitoImportsVisitor() {
        }

        public @Nullable J preVisit(J tree, ExecutionContext ctx) {
            this.stopAfterPreVisit();
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile sf = (JavaSourceFile)tree;
                ArrayList<String> unknownTypeMethodInvocationNames = new ArrayList<String>();
                new WellFormedMockitoMethodTypeVisitor().visit((Tree)sf, unknownTypeMethodInvocationNames);
                ArrayList qualifiedMethodInvocationNames = new ArrayList();
                new QualifiedMockitoMethodTypeVisitor().visit((Tree)sf, qualifiedMethodInvocationNames);
                for (J.Import _import : sf.getImports()) {
                    if (!_import.getPackageName().startsWith("org.mockito")) continue;
                    boolean isMockitoKotlinImport = _import.getPackageName().startsWith("org.mockito.kotlin");
                    if (_import.isStatic() || isMockitoKotlinImport) {
                        String staticName = _import.getQualid().getSimpleName();
                        if ("*".equals(staticName) && !this.possibleMockitoMethod(unknownTypeMethodInvocationNames)) {
                            this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                            continue;
                        }
                        if ("*".equals(staticName) || unknownTypeMethodInvocationNames.contains(staticName)) continue;
                        String fullyQualifiedName = _import.getPackageName();
                        if (!isMockitoKotlinImport) {
                            fullyQualifiedName = fullyQualifiedName + "." + _import.getClassName();
                        }
                        fullyQualifiedName = fullyQualifiedName + "." + staticName;
                        this.maybeRemoveImport(fullyQualifiedName);
                        continue;
                    }
                    if (!qualifiedMethodInvocationNames.isEmpty()) continue;
                    this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                }
            }
            return tree;
        }

        private boolean possibleMockitoMethod(List<String> methodNamesHavingNullType) {
            for (String missingMethod : methodNamesHavingNullType) {
                if (!MOCKITO_METHOD_NAMES.contains(missingMethod)) continue;
                return true;
            }
            return false;
        }

        private static class WellFormedMockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private WellFormedMockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> missingMethods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, missingMethods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && !TypeUtils.isWellFormedType((JavaType)mi.getType())) {
                    missingMethods.add(mi.getSimpleName());
                }
                return mi;
            }
        }

        private static class QualifiedMockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private QualifiedMockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> qualifiedMethods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, qualifiedMethods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && mi.getSelect() != null && TypeUtils.isAssignableTo((String)"org.mockito.Mockito", (JavaType)mi.getSelect().getType())) {
                    qualifiedMethods.add(mi.getSimpleName());
                }
                return mi;
            }
        }
    }
}

