/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseTestMethodOrder
extends Recipe {
    public String getDisplayName() {
        return "Migrate from JUnit 4 `@FixedMethodOrder` to JUnit 5 `@TestMethodOrder`";
    }

    public String getDescription() {
        return "JUnit optionally allows test method execution order to be specified. This replaces JUnit 4 test execution ordering annotations with JUnit 5 replacements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.FixMethodOrder", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaParser.Builder<?, ?> javaParser;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"});
                }
                return this.javaParser;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = classDecl;
                Set methodOrders = FindAnnotations.find((J)cd.withBody(null), (String)"@org.junit.FixMethodOrder");
                if (!methodOrders.isEmpty()) {
                    this.maybeAddImport("org.junit.jupiter.api.TestMethodOrder");
                    this.maybeRemoveImport("org.junit.FixMethodOrder");
                    this.maybeRemoveImport("org.junit.runners.MethodSorters");
                    cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@TestMethodOrder(MethodName.class)").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.TestMethodOrder", "org.junit.jupiter.api.MethodOrderer.*"}).build().apply(this.getCursor(), ((J.Annotation)methodOrders.iterator().next()).getCoordinates().replace(), new Object[0]);
                    this.maybeAddImport("org.junit.jupiter.api.MethodOrderer.MethodName");
                }
                return super.visitClassDeclaration(cd, (Object)ctx);
            }
        });
    }
}

