/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.RemoveUnneededBlock;

class FlattenAllOfVisitor
extends JavaVisitor<ExecutionContext> {
    private final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
    private final MethodMatcher ALL_OF_MATCHER = new MethodMatcher("org.hamcrest.Matchers allOf(..)");

    FlattenAllOfVisitor() {
    }

    public J visitMethodInvocation(J.MethodInvocation invocation, ExecutionContext ctx) {
        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(invocation, (Object)ctx);
        List arguments = mi.getArguments();
        Expression allOf = (Expression)arguments.get(arguments.size() - 1);
        if (!this.ASSERT_THAT_MATCHER.matches((MethodCall)mi) || !this.ALL_OF_MATCHER.matches(allOf)) {
            return mi;
        }
        Expression reason = arguments.size() == 3 ? (Expression)arguments.get(0) : null;
        Expression actual = (Expression)arguments.get(arguments.size() - 2);
        StringBuilder blockTemplate = new StringBuilder();
        blockTemplate.append("{");
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        for (Expression matcher : ((J.MethodInvocation)allOf).getArguments()) {
            if (reason == null) {
                blockTemplate.append("assertThat(#{any(java.lang.Object)}, #{any(org.hamcrest.Matcher)});");
            } else {
                blockTemplate.append("assertThat(#{any(java.lang.String)}, #{any(java.lang.Object)}, #{any(org.hamcrest.Matcher)});");
                parameters.add(reason);
            }
            parameters.add(actual);
            parameters.add(matcher);
        }
        blockTemplate.append("}");
        JavaTemplate template = JavaTemplate.builder((String)blockTemplate.toString()).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"hamcrest-2.2"})).staticImports(new String[]{"org.hamcrest.MatcherAssert.assertThat"}).build();
        this.doAfterVisit(new RemoveUnneededBlock().getVisitor());
        this.maybeRemoveImport("org.hamcrest.Matchers.allOf");
        return template.apply(this.getCursor(), mi.getCoordinates().replace(), parameters.toArray());
    }
}

