/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Collections;
import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.junit5.RunnerToExtension;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MockitoJUnitRunnerSilentToExtension
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 MockitoJUnitRunner.Silent to JUnit Jupiter MockitoExtension with LENIENT settings";
    }

    public String getDescription() {
        return "Replace `@RunWith(MockitoJUnitRunner.Silent.class)` with `@ExtendWith(MockitoExtension.class)` and `@MockitoSettings(strictness = Strictness.LENIENT)`.";
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.mockito.junit.MockitoJUnitRunner$Silent");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaParser parser = JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.mockito.quality;public enum Strictness {    LENIENT,WARN,STRICT_STUBS;    private Strictness() {}}", "package org.mockito.junit.jupiter;import org.mockito.quality.Strictness;public @interface MockitoSettings {    Strictness strictness() default Strictness.STRICT_STUBS;}"}).build();
            final AnnotationMatcher silentRunnerMatcher = new AnnotationMatcher("org.junit.runner.RunWith @RunWith(org.mockito.junit.MockitoJUnitRunner.MockitoJUnitRunner.Silent.class)");

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                if (cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)this.silentRunnerMatcher).matches(arg_0))) {
                    JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"@MockitoSettings(strictness = Strictness.LENIENT)").imports(new String[]{"org.mockito.quality.Strictness", "org.mockito.junit.jupiter.MockitoSettings"}).javaParser(() -> this.parser).build();
                    cd = (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)((J.ClassDeclaration)cd.withTemplate((SourceTemplate)template, cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0])), executionContext);
                    this.doAfterVisit(new RunnerToExtension(Collections.singletonList("org.mockito.junit.MockitoJUnitRunner$Silent"), "org.mockito.junit.jupiter.MockitoExtension"));
                    this.maybeRemoveImport("org.mockito.junit.MockitoJUnitRunner");
                    this.maybeAddImport("org.mockito.quality.Strictness");
                    this.maybeAddImport("org.mockito.junit.jupiter.MockitoSettings");
                }
                return cd;
            }
        };
    }
}

