/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.template.SourceTemplate;

public class AssertTrueComparisonToAssertEquals
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");

    public String getDisplayName() {
        return "Junit `assertTrue(a == b)` to `assertEquals(a,b)`";
    }

    public String getDescription() {
        return "Using `assertEquals(a,b)` is simpler and more clear.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(ASSERT_TRUE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final Supplier<JavaParser> javaParser = () -> JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches(mi) && this.isEqualBinary(mi)) {
                    JavaTemplate t;
                    Object[] args;
                    J.Binary binary = (J.Binary)mi.getArguments().get(0);
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() != null) {
                        sb.append("Assertions.");
                    }
                    sb.append("assertEquals(#{any(java.lang.Object)}, #{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        sb.append(", #{any()}");
                        args = new Object[]{binary.getLeft(), binary.getRight(), mi.getArguments().get(1)};
                    } else {
                        args = new Object[]{binary.getLeft(), binary.getRight()};
                    }
                    sb.append(")");
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertEquals");
                        t = JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).javaParser(this.javaParser).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).build();
                    } else {
                        t = JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).javaParser(this.javaParser).imports(new String[]{"org.junit.jupiter.api.Assertions"}).build();
                    }
                    return mi.withTemplate((SourceTemplate)t, mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isEqualBinary(J.MethodInvocation method) {
                if (method.getArguments().isEmpty()) {
                    return false;
                }
                Expression firstArgument = (Expression)method.getArguments().get(0);
                if (!(firstArgument instanceof J.Binary)) {
                    return false;
                }
                J.Binary binary = (J.Binary)firstArgument;
                J.Binary.Type operator = binary.getOperator();
                if (!operator.equals((Object)J.Binary.Type.Equal)) {
                    return false;
                }
                return binary.getLeft().getType() instanceof JavaType.Primitive && binary.getRight().getType() instanceof JavaType.Primitive && (binary.getLeft().getType() != JavaType.Primitive.String || binary.getRight().getType() != JavaType.Primitive.String);
            }
        };
    }
}

