/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindRepeatableAnnotations;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UnwrapRepeatableAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Unwrap `@Repeatable` annotations";
    }

    public String getDescription() {
        return "Java 8 introduced the concept of `@Repeatable` annotations, making the wrapper annotation unnecessary.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindRepeatableAnnotations(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                List<J.Annotation> ann = this.unwrap(m.getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return m;
                }
                return (J.MethodDeclaration)this.maybeAutoFormat((J)m, (J)m.withLeadingAnnotations(ann), (J)ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)ctx);
                List<J.Annotation> ann = this.unwrap(c.getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return c;
                }
                return (J.ClassDeclaration)this.maybeAutoFormat((J)c, (J)c.withLeadingAnnotations(ann), (J)ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                List<J.Annotation> ann = this.unwrap(v.getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return v;
                }
                return (J.VariableDeclarations)this.maybeAutoFormat((J)v, (J)v.withLeadingAnnotations(ann), (J)ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            private List<J.Annotation> unwrap(List<J.Annotation> annotations) {
                return ListUtils.flatMap(annotations, a -> {
                    final ArrayList unwrapped = new ArrayList(1);
                    new JavaVisitor<Integer>(){

                        public J visitAnnotation(J.Annotation annotation, Integer p) {
                            if (annotation != a && FindRepeatableAnnotations.isRepeatable((JavaType)annotation.getType())) {
                                unwrapped.add(annotation);
                            }
                            return super.visitAnnotation(annotation, (Object)p);
                        }
                    }.visit((Tree)a, (Object)0);
                    return unwrapped.isEmpty() ? a : unwrapped;
                });
            }
        });
    }
}

