/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class URLEqualsHashCodeRecipes
extends Recipe {
    public String getDisplayName() {
        return "URL Equals and Hash Code";
    }

    public String getDescription() {
        return "Uses of `equals()` and `hashCode()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2112");
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new URLEqualsRecipe(), new URLHashCodeRecipe()});
    }

    @NullMarked
    public static class URLEqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "URL Equals";
        }

        public String getDescription() {
            return "Uses of `equals()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-2112");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{a:any(java.net.URL)}.equals(#{b:any(java.net.URL)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.net.URI.create(#{a:any(java.net.URL)}.toString()).equals(java.net.URI.create(#{b:any(java.net.URL)}.toString()))").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URL", Boolean.valueOf(true)), new UsesMethod("java.net.URL equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class URLHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "URL Hash Code";
        }

        public String getDescription() {
            return "Uses of `hashCode()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-2112");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{a:any(java.net.URL)}.hashCode()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.net.URI.create(#{a:any(java.net.URL)}.toString()).hashCode()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URL", Boolean.valueOf(true)), new UsesMethod("java.net.URL hashCode(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

