/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.21.0")
public class RemoveUnneededBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove unneeded block";
    }

    public String getDescription() {
        return "Flatten blocks into inline statements when possible.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnneededBlockStatementVisitor();
    }

    static class RemoveUnneededBlockStatementVisitor
    extends JavaVisitor<ExecutionContext> {
        RemoveUnneededBlockStatementVisitor() {
        }

        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J.Block bl = (J.Block)super.visitBlock(block, (Object)ctx);
            J directParent = (J)this.getCursor().getParentTreeCursor().getValue();
            if (directParent instanceof J.NewClass || directParent instanceof J.ClassDeclaration) {
                return bl;
            }
            return this.maybeInlineBlock(bl, ctx);
        }

        private J.Block maybeInlineBlock(J.Block block, ExecutionContext ctx) {
            List statements = block.getStatements();
            if (statements.isEmpty()) {
                return block;
            }
            Statement lastStatement = (Statement)statements.get(statements.size() - 1);
            J.Block flattened = block.withStatements(ListUtils.flatMap((List)statements, (i, stmt) -> {
                J.Block nested;
                if (stmt instanceof J.Try) {
                    J.Try _try = (J.Try)stmt;
                    if (_try.getResources() != null || !_try.getCatches().isEmpty() || _try.getFinally() == null || !_try.getFinally().getStatements().isEmpty()) {
                        return stmt;
                    }
                    nested = _try.getBody();
                } else if (stmt instanceof J.Block) {
                    nested = (J.Block)stmt;
                } else {
                    return stmt;
                }
                if (i < statements.size() - 1) {
                    if (nested.getStatements().stream().anyMatch(J.VariableDeclarations.class::isInstance)) {
                        return stmt;
                    }
                }
                return ListUtils.map((List)nested.getStatements(), (j, inlinedStmt) -> {
                    if (j == 0) {
                        inlinedStmt = (Statement)inlinedStmt.withPrefix(inlinedStmt.getPrefix().withComments(ListUtils.concatAll((List)nested.getComments(), (List)inlinedStmt.getComments())));
                    }
                    return (Statement)this.autoFormat((J)inlinedStmt, ctx, this.getCursor());
                });
            }));
            if (flattened == block) {
                return block;
            }
            if (lastStatement instanceof J.Block) {
                flattened = flattened.withEnd(flattened.getEnd().withComments(ListUtils.concatAll((List)((J.Block)lastStatement).getEnd().getComments(), (List)flattened.getEnd().getComments())));
            }
            return flattened;
        }
    }
}

