/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class EqualsAvoidsNull
extends Recipe {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcher EQUALS_STRING = new MethodMatcher("java.lang.String equals(java.lang.Object)");
    private static final MethodMatcher EQUALS_OBJECT = new MethodMatcher("java.lang.Object equals(java.lang.Object)");
    private static final MethodMatcher EQUALS_IGNORE_CASE = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
    private static final MethodMatcher CONTENT_EQUALS = new MethodMatcher("java.lang.String contentEquals(java.lang.CharSequence)");

    public String getDisplayName() {
        return "Equals avoids null";
    }

    public String getDescription() {
        return "Checks that any combination of String literals is on the left side of an `equals()` comparison. Also checks for String literals assigned to some field (such as `someString.equals(anotherString = \"text\"))`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1132");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(EQUALS_STRING), new UsesMethod(EQUALS_OBJECT), new UsesMethod(EQUALS_IGNORE_CASE), new UsesMethod(CONTENT_EQUALS)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!this.isStringComparisonMethod(m) || !this.hasCompatibleArgument(m)) {
                    return m;
                }
                this.maybeHandleParentBinary(m, (Tree)this.getCursor().getParentTreeCursor().getValue());
                Expression firstArgument = (Expression)m.getArguments().get(0);
                return firstArgument.getType() == JavaType.Primitive.Null ? this.literalsFirstInComparisonsNull(m, firstArgument) : this.literalsFirstInComparisons(m, firstArgument);
            }

            private boolean hasCompatibleArgument(J.MethodInvocation m) {
                if (m.getArguments().isEmpty()) {
                    return false;
                }
                Expression firstArgument = (Expression)m.getArguments().get(0);
                if (firstArgument instanceof J.Literal) {
                    return true;
                }
                if (firstArgument instanceof J.FieldAccess) {
                    firstArgument = ((J.FieldAccess)firstArgument).getName();
                }
                if (firstArgument instanceof J.Identifier) {
                    JavaType.Variable fieldType = ((J.Identifier)firstArgument).getFieldType();
                    return fieldType != null && fieldType.hasFlags(new Flag[]{Flag.Static, Flag.Final});
                }
                return false;
            }

            private boolean isStringComparisonMethod(J.MethodInvocation methodInvocation) {
                return EQUALS_STRING.matches((MethodCall)methodInvocation) || EQUALS_OBJECT.matches((MethodCall)methodInvocation) || EQUALS_IGNORE_CASE.matches((MethodCall)methodInvocation) || CONTENT_EQUALS.matches((MethodCall)methodInvocation);
            }

            private void maybeHandleParentBinary(J.MethodInvocation m, final Tree parent) {
                J.Binary potentialNullCheck;
                if (parent instanceof J.Binary && ((J.Binary)parent).getOperator() == J.Binary.Type.And && ((J.Binary)parent).getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)((J.Binary)parent).getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), Objects.requireNonNull(m.getSelect())) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), Objects.requireNonNull(m.getSelect())))) {
                    this.doAfterVisit((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                        private final J.Binary scope;
                        private boolean done;
                        {
                            this.scope = (J.Binary)parent;
                        }

                        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                            return this.done ? (J)tree : (J)super.visit(tree, (Object)ctx);
                        }

                        public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                            if (this.scope.isScope((Tree)binary)) {
                                this.done = true;
                                return binary.getRight().withPrefix(binary.getPrefix());
                            }
                            return super.visitBinary(binary, (Object)ctx);
                        }
                    });
                }
            }

            private boolean isNullLiteral(Expression expression) {
                return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
            }

            private boolean matchesSelect(Expression expression, Expression select) {
                return expression.printTrimmed(this.getCursor()).replaceAll("\\s", "").equals(select.printTrimmed(this.getCursor()).replaceAll("\\s", ""));
            }

            private J.Binary literalsFirstInComparisonsNull(J.MethodInvocation m, Expression firstArgument) {
                return new J.Binary(Tree.randomId(), m.getPrefix(), Markers.EMPTY, Objects.requireNonNull(m.getSelect()), JLeftPadded.build((Object)J.Binary.Type.Equal).withBefore(Space.SINGLE_SPACE), (Expression)firstArgument.withPrefix(Space.SINGLE_SPACE), (JavaType)JavaType.Primitive.Boolean);
            }

            private J.MethodInvocation literalsFirstInComparisons(J.MethodInvocation m, Expression firstArgument) {
                return m.withSelect((Expression)firstArgument.withPrefix(Objects.requireNonNull(m.getSelect()).getPrefix())).withArguments(Collections.singletonList((Expression)m.getSelect().withPrefix(Space.EMPTY)));
            }
        });
    }

    @Generated
    public EqualsAvoidsNull() {
    }

    @Generated
    public String toString() {
        return "EqualsAvoidsNull()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsAvoidsNull)) {
            return false;
        }
        EqualsAvoidsNull other = (EqualsAvoidsNull)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EqualsAvoidsNull;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

