/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.RemoveUnneededBlock;

public class TernaryOperatorsShouldNotBeNested
extends Recipe {
    public String getDisplayName() {
        return "Ternary operators should not be nested";
    }

    public String getDescription() {
        return "Nested ternary operators can be hard to read quickly. Prefer simpler constructs for improved readability. If supported, this recipe will try to replace nested ternaries with switch expressions.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S3358");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                if (cu.getMarkers().findFirst(JavaVersion.class).filter(javaVersion -> javaVersion.getMajorVersion() >= 14).isPresent()) {
                    this.doAfterVisit((TreeVisitor)new UseSwitchExpressionVisitor());
                }
                this.doAfterVisit((TreeVisitor)new UseIfVisitor());
                return cu;
            }
        };
    }

    private static J.Return returnOf(Expression expression) {
        return (J.Return)new J.Return(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expression.withPrefix(Space.EMPTY)).withComments(expression.getComments());
    }

    private static J.Block blockOf(Statement ... statements) {
        return TernaryOperatorsShouldNotBeNested.blockOf(Arrays.asList(statements));
    }

    private static J.Block blockOf(List<Statement> statements) {
        return J.Block.createEmptyBlock().withStatements(statements);
    }

    static class UseSwitchExpressionVisitor
    extends JavaVisitor<ExecutionContext> {
        UseSwitchExpressionVisitor() {
        }

        public J visitTernary(J.Ternary ternary, ExecutionContext ctx) {
            return this.findConditionIdentifier(ternary).map(switchVar -> {
                List<J.Ternary> nestList = this.findNestedTernaries(ternary, (J.Identifier)switchVar);
                if (nestList.size() < 2) {
                    return null;
                }
                return (J.SwitchExpression)this.autoFormat((J)this.toSwitch((J.Identifier)switchVar, nestList, ternary.getType()), ctx);
            }).map(J.class::cast).orElseGet(() -> super.visitTernary(ternary, (Object)ctx));
        }

        private List<J.Ternary> findNestedTernaries(J.Ternary ternary, J.Identifier switchVar) {
            ArrayList<J.Ternary> nestList = new ArrayList<J.Ternary>();
            J.Ternary next = ternary;
            while (next.getFalsePart() instanceof J.Ternary) {
                if (next.getTruePart() instanceof J.Ternary) {
                    return Collections.emptyList();
                }
                J.Ternary nested = (J.Ternary)next.getFalsePart();
                if (!this.findConditionIdentifier(nested).filter(found -> UseSwitchExpressionVisitor.isEqualVariable(switchVar, (J)found)).isPresent()) {
                    return Collections.emptyList();
                }
                nestList.add(next);
                next = nested;
            }
            nestList.add(next);
            return nestList;
        }

        private static boolean isEqualVariable(J.Identifier switchVar, @Nullable J found) {
            if (!(found instanceof J.Identifier)) {
                return false;
            }
            J.Identifier foundVar = (J.Identifier)found;
            return Objects.equals(foundVar.getFieldType(), switchVar.getFieldType());
        }

        private J.SwitchExpression toSwitch(J.Identifier switchVar, List<J.Ternary> nestList, @Nullable JavaType type) {
            J.Ternary last = nestList.get(nestList.size() - 1);
            return new J.SwitchExpression(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), switchVar.getPrefix().withWhitespace(" "), switchVar.getMarkers(), JRightPadded.build((Object)switchVar.withPrefix(Space.EMPTY))), TernaryOperatorsShouldNotBeNested.blockOf(Stream.concat(nestList.stream().map(ternary -> this.toCase(switchVar, (J.Ternary)ternary)), Stream.of(this.toDefault(last))).collect(Collectors.toList())).withPrefix(Space.SINGLE_SPACE), type);
        }

        private J.Case toCase(J.Identifier switchVar, J.Ternary ternary) {
            Expression compare;
            if (ternary.getCondition() instanceof J.MethodInvocation) {
                J.MethodInvocation inv = (J.MethodInvocation)ternary.getCondition();
                if (UseSwitchExpressionVisitor.isObjectsEquals(inv)) {
                    this.maybeRemoveImport("java.util.Objects");
                    compare = UseSwitchExpressionVisitor.isVariable((J)inv.getArguments().get(0)) ? (Expression)inv.getArguments().get(1) : (Expression)inv.getArguments().get(0);
                } else {
                    compare = UseSwitchExpressionVisitor.isEqualVariable(switchVar, (J)inv.getSelect()) ? (Expression)inv.getArguments().get(0) : inv.getSelect();
                }
            } else if (UseSwitchExpressionVisitor.isEqualsBinary((J)ternary.getCondition())) {
                J.Binary bin = (J.Binary)ternary.getCondition();
                compare = UseSwitchExpressionVisitor.isEqualVariable(switchVar, (J)bin.getLeft()) ? bin.getRight() : bin.getLeft();
            } else {
                throw new IllegalArgumentException("Only J.Binary or J.MethodInvocation are expected as ternary conditions when creating a switch case");
            }
            return new J.Case(Tree.randomId(), ternary.getPrefix().withWhitespace(" "), ternary.getMarkers(), J.Case.Type.Rule, JContainer.build(Collections.singletonList(JRightPadded.build((Object)compare.withPrefix(Space.SINGLE_SPACE)).withAfter(Space.SINGLE_SPACE))), JContainer.build(Collections.emptyList()), JRightPadded.build((Object)ternary.getTruePart()), null);
        }

        private J.Case toDefault(J.Ternary ternary) {
            return new J.Case(Tree.randomId(), Space.EMPTY, ternary.getMarkers(), J.Case.Type.Rule, JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "default", null, null)).withAfter(Space.SINGLE_SPACE))), JContainer.build(Collections.emptyList()), JRightPadded.build((Object)ternary.getFalsePart()), null);
        }

        private Optional<J.Identifier> findConditionIdentifier(J.Ternary ternary) {
            J.Identifier result = null;
            if (ternary.getCondition() instanceof J.MethodInvocation) {
                J.MethodInvocation inv = (J.MethodInvocation)ternary.getCondition();
                if (!"equals".equals(inv.getSimpleName())) {
                    return Optional.empty();
                }
                if (inv.getArguments().size() == 1) {
                    J other = null;
                    if (UseSwitchExpressionVisitor.isVariable((J)inv.getSelect())) {
                        result = (J.Identifier)inv.getSelect();
                        other = (J)inv.getArguments().get(0);
                    }
                    if (inv.getArguments().get(0) instanceof J.Identifier) {
                        result = (J.Identifier)inv.getArguments().get(0);
                        other = inv.getSelect();
                    }
                    if (!UseSwitchExpressionVisitor.isConstant(other)) {
                        return Optional.empty();
                    }
                }
            } else if (UseSwitchExpressionVisitor.isEqualsBinary((J)ternary.getCondition())) {
                J.Binary bin = (J.Binary)ternary.getCondition();
                result = UseSwitchExpressionVisitor.xorVariable((J)bin.getLeft(), (J)bin.getRight());
            }
            return Optional.ofNullable(result);
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier xorVariable(J first, J second) {
            J.Identifier result = null;
            if (UseSwitchExpressionVisitor.isVariable(first) && UseSwitchExpressionVisitor.isVariable(second)) {
                return null;
            }
            if (UseSwitchExpressionVisitor.isVariable(first)) {
                result = (J.Identifier)first;
            }
            if (UseSwitchExpressionVisitor.isVariable(second)) {
                result = (J.Identifier)second;
            }
            return result;
        }

        private static boolean isVariable(@Nullable J maybeVariable) {
            if (maybeVariable == null) {
                return false;
            }
            if (!(maybeVariable instanceof J.Identifier)) {
                return false;
            }
            J.Identifier identifier = (J.Identifier)maybeVariable;
            if (identifier.getFieldType() == null) {
                return false;
            }
            return !identifier.getFieldType().hasFlags(new Flag[]{Flag.Final}) || !identifier.getFieldType().hasFlags(new Flag[]{Flag.Static});
        }

        private static boolean isConstant(@Nullable J maybeConstant) {
            if (maybeConstant == null) {
                return false;
            }
            if (maybeConstant instanceof J.Literal) {
                return true;
            }
            if (!(maybeConstant instanceof J.Identifier)) {
                return false;
            }
            J.Identifier identifier = (J.Identifier)maybeConstant;
            if (identifier.getFieldType() == null) {
                return false;
            }
            return !identifier.getFieldType().hasFlags(new Flag[]{Flag.Final}) || !identifier.getFieldType().hasFlags(new Flag[]{Flag.Static});
        }

        private static boolean isObjectsEquals(J.MethodInvocation inv) {
            if (inv.getSelect() instanceof J.Identifier) {
                J.Identifier maybeObjects = (J.Identifier)inv.getSelect();
                boolean isObjects = TypeUtils.isOfClassType((JavaType)maybeObjects.getType(), (String)"java.util.Objects");
                return isObjects && "equals".equals(inv.getSimpleName());
            }
            return false;
        }

        private static boolean isEqualsBinary(J maybeEqualsBinary) {
            return maybeEqualsBinary instanceof J.Binary && ((J.Binary)maybeEqualsBinary).getOperator() == J.Binary.Type.Equal;
        }
    }

    private static class UseIfVisitor
    extends JavaVisitor<ExecutionContext> {
        private UseIfVisitor() {
        }

        public J visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            Statement result = this.rewriteNestedTernary((Statement)lambda);
            if (result == lambda) {
                return super.visitLambda(lambda, (Object)ctx);
            }
            this.doAfterVisit(new RemoveUnneededBlock().getVisitor());
            return this.autoFormat((J)lambda.withBody(result.withPrefix(Space.SINGLE_SPACE)), ctx);
        }

        public J visitReturn(J.Return retrn, ExecutionContext ctx) {
            Statement result = this.rewriteNestedTernary((Statement)retrn);
            if (result == retrn) {
                return super.visitReturn(retrn, (Object)ctx);
            }
            this.doAfterVisit(new RemoveUnneededBlock().getVisitor());
            return this.autoFormat((J)result, ctx);
        }

        private Statement rewriteNestedTernary(Statement parent) {
            return UseIfVisitor.findTernary(parent).map(ternary -> {
                if (!UseIfVisitor.isNestedTernary((J)ternary)) {
                    return parent;
                }
                J.If iff = this.ifOf((J.Ternary)ternary);
                J.Return otherwise = TernaryOperatorsShouldNotBeNested.returnOf(ternary.getFalsePart());
                return TernaryOperatorsShouldNotBeNested.blockOf(new Statement[]{iff, this.rewriteNestedTernary((Statement)otherwise)}).withPrefix(parent.getPrefix());
            }).orElse(parent);
        }

        private J.If ifOf(J.Ternary ternary) {
            return new J.If(Tree.randomId(), ternary.getPrefix(), Markers.EMPTY, (J.ControlParentheses)new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)ternary.getCondition())).withComments(ternary.getCondition().getComments()), JRightPadded.build((Object)TernaryOperatorsShouldNotBeNested.blockOf(new Statement[]{this.rewriteNestedTernary((Statement)TernaryOperatorsShouldNotBeNested.returnOf((Expression)ternary.getTruePart().withComments(ternary.getTruePart().getComments())))})), null);
        }

        private static boolean isNestedTernary(J possibleTernary) {
            int result = UseIfVisitor.determineNestingLevels(possibleTernary, 0);
            return result > 1;
        }

        private static int determineNestingLevels(J possibleTernary, int level) {
            if (!(possibleTernary instanceof J.Ternary)) {
                return level;
            }
            J.Ternary ternary = (J.Ternary)possibleTernary;
            int truePath = UseIfVisitor.determineNestingLevels((J)ternary.getTruePart(), level + 1);
            int falsePath = UseIfVisitor.determineNestingLevels((J)ternary.getFalsePart(), level + 1);
            return Math.max(falsePath, truePath);
        }

        private static Optional<J.Ternary> findTernary(Statement parent) {
            Statement possibleTernary = parent;
            if (parent instanceof J.Return) {
                possibleTernary = ((J.Return)parent).getExpression();
            } else if (parent instanceof J.Lambda) {
                possibleTernary = ((J.Lambda)parent).getBody();
            }
            if (possibleTernary instanceof J.Ternary) {
                return Optional.of(possibleTernary).map(J.Ternary.class::cast);
            }
            return Optional.empty();
        }
    }
}

