/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class SimplifyTernaryRecipes
extends Recipe {
    public String getDisplayName() {
        return "Simplify ternary expressions";
    }

    public String getDescription() {
        return "Simplifies various types of ternary expressions to improve code readability.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new SimplifyTernaryTrueFalseRecipe(), new SimplifyTernaryFalseTrueRecipe()});
    }

    @NullMarked
    public static class SimplifyTernaryTrueFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `booleanExpression ? true : false` with `booleanExpression`";
        }

        public String getDescription() {
            return "Replace ternary expressions like `booleanExpression ? true : false` with `booleanExpression`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{expr:any(boolean)} ? true : false").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{expr:any(boolean)}").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class SimplifyTernaryFalseTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `booleanExpression ? false : true` with `!booleanExpression`";
        }

        public String getDescription() {
            return "Replace ternary expressions like `booleanExpression ? false : true` with `!booleanExpression`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{expr:any(boolean)} ? false : true").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"!(#{expr:any(boolean)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.REMOVE_PARENS, AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
        }
    }
}

